/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.flatten;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.flatten.ClassVisitorEnv;
import edu.rice.cs.nextgen.compiler.flatten.StaticPolyMethodVisitorEnv;
import edu.rice.cs.nextgen.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisitorEnv
implements Flags {
    private final SymbolTable syms;
    private final ErrorLog log;
    private final Symbol.ClassSymbol enclClass;
    private final ListBox<Tree> newDefs = new ListBox();
    private final Symbol owner;
    private final Symbol.ClassSymbol template;
    private Hashtable<String, Symbol.MethodSymbol> snippetCache = new Hashtable();
    private final Tree.SnippetableVisitor<Tree> flatten = new Tree.SnippetableVisitor<Tree>(){

        @Override
        public Tree forNewInstance(Tree.NewInstance tree) {
            Symbol constructorSymbol = tree.constructor;
            List<Type> allTypeParams = ((VisitorEnv)VisitorEnv.this).owner.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type flatType = tree.type.flatten(allParamNames);
            Symbol.TypeSymbol flatTypeSymbol = flatType.typeSymbol;
            Tree.Ident flatTypeIdent = new Tree.Ident(tree.sourcePosition, flatType, flatTypeSymbol.name, flatTypeSymbol);
            Symbol.MethodSymbol newConstructorSymbol = new Symbol.MethodSymbol(constructorSymbol.flags(), Names.init, constructorSymbol.type, flatType.typeSymbol);
            Tree.NewInstance newTree = new Tree.NewInstance(tree.sourcePosition, flatType, tree.enclosingClassPrefix, flatTypeIdent, tree.args, tree.anonymousClassDef, newConstructorSymbol);
            return newTree;
        }

        @Override
        public Tree forTypeCast(Tree.TypeCast tree) {
            Tree.TypeCast newTree;
            List<Type> allTypeParams = ((VisitorEnv)VisitorEnv.this).owner.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type castType = tree.castType.type;
            Type flatCastType = castType.genInterface(allParamNames, ((VisitorEnv)VisitorEnv.this).syms.OBJECT_TYPE);
            Symbol.TypeSymbol flatSymbol = flatCastType.typeSymbol;
            Tree.Ident newIdent = new Tree.Ident(tree.sourcePosition, flatCastType, flatSymbol.name, flatSymbol);
            Tree.TypeCast innerTree = new Tree.TypeCast(tree.sourcePosition, flatCastType, newIdent, tree.expression);
            if (castType instanceof Type.TypeVar) {
                Type baseType = ((Type.TypeVar)castType).genBaseType(allParamNames);
                Symbol.TypeSymbol baseSymbol = baseType.typeSymbol;
                Tree.Ident baseIdent = new Tree.Ident(tree.sourcePosition, baseType, baseSymbol.name, baseSymbol);
                newTree = new Tree.TypeCast(tree.sourcePosition, baseType, baseIdent, innerTree);
            } else {
                newTree = new Tree.TypeCast(tree.sourcePosition, tree.type, tree.castType, innerTree);
            }
            return newTree;
        }

        @Override
        public Tree forInstanceofTest(Tree.InstanceofTest tree) {
            List<Type> allTypeParams = ((VisitorEnv)VisitorEnv.this).owner.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type testType = tree.testedType.type;
            Type newTestType = testType.genInterface(allParamNames, ((VisitorEnv)VisitorEnv.this).syms.OBJECT_TYPE);
            Symbol.TypeSymbol newSymbol = newTestType.typeSymbol;
            Tree.Ident newIdent = new Tree.Ident(tree.sourcePosition, newTestType, newSymbol.name, newSymbol);
            Tree.InstanceofTest newTree = new Tree.InstanceofTest(tree.sourcePosition, tree.type, tree.expression, newIdent);
            return newTree;
        }

        @Override
        public Tree.NewArray forNewArray(Tree.NewArray tree) {
            List<Type> allTypeParams = ((VisitorEnv)VisitorEnv.this).owner.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type aType = tree.type;
            Type eType = aType.elementType();
            Type flatEType = eType.flatten(allParamNames);
            Symbol.TypeSymbol flatETypeSymbol = flatEType.typeSymbol;
            Tree.Ident flatETypeIdent = new Tree.Ident(tree.sourcePosition, flatEType, flatETypeSymbol.name, flatETypeSymbol);
            Tree.NewArray newTree = new Tree.NewArray(tree.sourcePosition, new Type.ArrayType(flatEType), flatETypeIdent, tree.dimensions, tree.elements);
            return newTree;
        }

        @Override
        public /* synthetic */ Object forNewArray(Tree.NewArray x0) {
            return this.forNewArray(x0);
        }

        @Override
        public /* synthetic */ Object forInstanceofTest(Tree.InstanceofTest x0) {
            return this.forInstanceofTest(x0);
        }

        @Override
        public /* synthetic */ Object forTypeCast(Tree.TypeCast x0) {
            return this.forTypeCast(x0);
        }

        @Override
        public /* synthetic */ Object forNewInstance(Tree.NewInstance x0) {
            return this.forNewInstance(x0);
        }
    };

    VisitorEnv(SymbolTable syms, ErrorLog log, Symbol.ClassSymbol enclClass, Symbol owner, Symbol.ClassSymbol template) {
        this.syms = syms;
        this.log = log;
        this.enclClass = enclClass;
        this.owner = owner;
        this.template = template;
    }

    public SymbolTable syms() {
        return this.syms;
    }

    public ErrorLog log() {
        return this.log;
    }

    public Symbol.ClassSymbol enclClass() {
        return this.enclClass;
    }

    public ListBox<Tree> newDefs() {
        return this.newDefs;
    }

    public Symbol owner() {
        return this.owner;
    }

    public Symbol.ClassSymbol template() {
        return this.template;
    }

    public Tree.SnippetableVisitor<Tree> getFlattenVisitor() {
        return this.flatten;
    }

    abstract Symbol.MethodSymbol constructSnippet(Tree.Snippetable var1, List<Tree> var2, List<Type> var3, Type var4, Tree var5);

    public Symbol.MethodSymbol getCachedSnippet(Tree.Snippetable expr) {
        return this.snippetCache.get(expr.toSnippetString());
    }

    public void putCachedSnippet(Tree.Snippetable expr, Symbol.MethodSymbol sym) {
        this.snippetCache.put(expr.toSnippetString(), sym);
    }

    public ClassVisitorEnv newClassVisitorEnv(Symbol.ClassSymbol owner, Symbol.ClassSymbol template) {
        return new ClassVisitorEnv(this.syms, this.log, owner, template);
    }

    public StaticPolyMethodVisitorEnv newStaticPolyMethodVisitorEnv(Symbol.ClassSymbol enclClass, Symbol owner, Symbol.ClassSymbol template) {
        return new StaticPolyMethodVisitorEnv(this.syms, this.log, enclClass, owner, template);
    }
}

