/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.code.ClassReader;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.CodeGenerator;
import edu.rice.cs.nextgen.compiler.comp.DataFlowChecker;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.InnerClassFlattener;
import edu.rice.cs.nextgen.compiler.comp.Items;
import edu.rice.cs.nextgen.compiler.comp.NameResolver;
import edu.rice.cs.nextgen.compiler.comp.StaticAnalyzer;
import edu.rice.cs.nextgen.compiler.comp.SymbolEnterer;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.TypeChecker;
import edu.rice.cs.nextgen.compiler.comp.TypeEraser;
import edu.rice.cs.nextgen.compiler.comp.TypeInferrer;
import edu.rice.cs.nextgen.compiler.flatten.ClassVisitorEnv;
import edu.rice.cs.nextgen.compiler.flatten.SnippetPatcher;
import edu.rice.cs.nextgen.compiler.flatten.TargetFixer;
import edu.rice.cs.nextgen.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen.compiler.instrument.DebugLog;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.parser.Parser;
import edu.rice.cs.nextgen.compiler.parser.Scanner;
import edu.rice.cs.nextgen.compiler.tree.PrettyPrinter;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.AbortError;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Set;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    private final ErrorLog errorLog;
    private final CompilerOptions options;
    private final Set<File> inputFiles = Set.make();
    private final SymbolTable symbolTable;
    private final TypeChecker typeChecker;
    private final TypeInferrer typeInferrer;
    private final TreeMaker treeMaker;
    private final NameResolver nameResolver;
    private final SymbolEnterer symbolEnterer;
    private final StaticAnalyzer staticAnalyzer;
    private final Items items;
    private final TypeFlattener typeFlattener;
    private final SnippetPatcher snippetPatcher;
    private final CodeGenerator codeGenerator;

    JavaCompiler(CompilerOptions options) {
        this.options = options;
        this.items = new Items();
        this.errorLog = new ErrorLog();
        this.treeMaker = new TreeMaker();
        this.symbolTable = this.initializeSymbolTable(options);
        this.typeChecker = new TypeChecker(this.errorLog, this.symbolTable, options);
        this.typeInferrer = new TypeInferrer(this.errorLog, this.symbolTable);
        this.nameResolver = new NameResolver(this.errorLog, this.symbolTable, this.typeInferrer);
        this.symbolEnterer = new SymbolEnterer(this.errorLog, this.symbolTable, this.nameResolver, this.typeChecker, this.treeMaker, null, options);
        this.staticAnalyzer = new StaticAnalyzer(this.errorLog, this.symbolTable, this.nameResolver, this.typeChecker, this.typeInferrer, this.treeMaker, this.symbolEnterer);
        this.typeFlattener = new TypeFlattener(this.errorLog, this.symbolTable);
        this.snippetPatcher = new SnippetPatcher(this.errorLog, this.symbolTable, this.typeFlattener);
        this.codeGenerator = new CodeGenerator(this.errorLog, this.symbolTable, this.typeChecker, this.nameResolver, this.treeMaker, this.items, options);
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public List<Symbol.ClassSymbol> compile(List<String> filenames) throws Throwable {
        long msec = System.currentTimeMillis();
        try {
            ListBox<Tree> trees = this.parseFiles(filenames);
            List<Environment<AnalyzerContext>> envs = this.enterClasses(trees);
            this.checkTypes(envs);
            envs = this.flatten(envs);
            this.patchSnippets();
            this.eraseTypes(envs);
            this.flattenGroundedSuperClasses();
            List<Symbol.ClassSymbol> classSyms = this.generateByteCode(envs);
            return classSyms;
        }
        catch (Throwable e) {
            System.out.flush();
            this.options.bugMessage();
            this.errorLog.prompt();
            throw e;
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol c, String filename, InputStream f) throws Symbol.CompletionFailure {
        Tree.TopLevel tree = this.parse(filename, f);
        this.symbolEnterer.enterClasses(new Cons<Tree>(tree));
        if (c.members() == null) {
            ClassReader classReader = this.symbolTable.classReader;
            classReader.getClass();
            throw classReader.new ClassReader.LoadError(c, filename, new StringBuffer().append("file does not contain class ").append(c.fullname).toString());
        }
    }

    private SymbolTable initializeSymbolTable(CompilerOptions options) throws AbortError {
        try {
            SymbolTable result = new SymbolTable(options);
            result.classReader.sourceCompleter = this;
            return result;
        }
        catch (Symbol.CompletionFailure ex) {
            this.errorLog.error(0, ex.getMessage());
            throw new AbortError();
        }
    }

    ListBox<Tree> parseFiles(List<String> filenames) throws Throwable {
        this.inputFiles.reset();
        Symbol.reset();
        ListBox<Tree> trees = new ListBox<Tree>();
        List<String> l = filenames;
        while (l.nonEmpty()) {
            trees.insertEnd(this.parse(l.getFirst()));
            DebugLog.pInfo(new StringBuffer().append("done parsing ").append(l.getFirst()).toString());
            l = l.getRest();
        }
        return trees;
    }

    int errorCount() {
        return this.errorLog.errorCount();
    }

    private void printResults(long time) {
        PrintableObject.flush();
        this.options.printIfVerbose(new StringBuffer().append("[total ").append(time).append("ms]").toString());
        this.printCount("error", this.errorLog.errorCount());
        this.printCount("warning", this.errorLog.nwarnings);
    }

    private InputStream openSourceFile(String filename) {
        try {
            File f = new File(filename);
            this.inputFiles.put(f);
            return new FileInputStream(f);
        }
        catch (IOException e) {
            this.errorLog.error(0, new StringBuffer().append("can't read: ").append(filename).toString());
            return null;
        }
    }

    private Tree.TopLevel parse(String filename, InputStream input) {
        long msec = System.currentTimeMillis();
        Name prev = this.errorLog.useSource(Name.fromString(filename));
        Tree.TopLevel tree = this.treeMaker.newTopLevel(null, Tree.EMPTY_LIST);
        if (input != null) {
            this.options.printIfVerbose(filename);
            try {
                Scanner scanner = new Scanner(input, this.errorLog);
                input.close();
                Parser parser = new Parser(scanner, this.treeMaker, this.errorLog);
                tree = parser.compilationUnit();
                this.options.printIfVerbose(new StringBuffer().append(System.currentTimeMillis() - msec).append("ms]").toString());
            }
            catch (IOException e) {
                this.errorLog.error(0, new StringBuffer().append("error reading ").append(filename).append("; ").append(e).toString());
            }
        }
        this.errorLog.useSource(prev);
        tree.sourcefile = Name.fromString(filename);
        return tree;
    }

    private Tree.TopLevel parse(String filename) {
        return this.parse(filename, this.openSourceFile(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printSource(Environment<AnalyzerContext> env, Tree.ClassDef cdef) throws IOException {
        File outFile = this.symbolTable.classWriter.outputFile(cdef.classSymbol, ".java");
        if (this.inputFiles.contains(outFile)) {
            this.errorLog.error(cdef.sourcePosition, new StringBuffer().append("error writing source; cannot overwrite input file ").append(outFile).toString());
        } else {
            PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            try {
                new PrettyPrinter(out).printUnit(env.topLevel, cdef);
                this.options.printIfVerbose(new StringBuffer().append("[wrote ").append(outFile.getPath()).append("]").toString());
            }
            finally {
                out.close();
            }
        }
    }

    private void genCode(Environment<AnalyzerContext> env, Tree.ClassDef classDef) throws IOException {
        this.codeGenerator.genClass(env, classDef);
        this.writeClass(classDef.classSymbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClass(Symbol.ClassSymbol c) throws IOException {
        File outFile = this.symbolTable.classWriter.outputFile(c, ".class");
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            this.symbolTable.classWriter.writeClassFile(out, c);
            this.options.printIfVerbose(new StringBuffer().append("[wrote ").append(outFile.getPath()).append("]").toString());
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    List<Environment<AnalyzerContext>> enterClasses(ListBox<Tree> trees) {
        List<Environment<AnalyzerContext>> envs = this.symbolEnterer.enterClasses(trees.toList());
        DebugLog.pInfo("done entering symbols");
        this.options.printIfPrintSymbols(this.symbolTable, "Symbol table after entry:");
        return envs;
    }

    void checkTypes(List<Environment<AnalyzerContext>> envs) {
        List<Environment<AnalyzerContext>> tail = envs;
        while (tail.nonEmpty()) {
            Environment<AnalyzerContext> env = tail.getFirst();
            Name prev = this.errorLog.useSource(env.enclosingClass.classSymbol.sourcefile);
            this.options.printIfPrintTree(env.tree, "Abstract Syntax Tree before any processing: ");
            this.options.printIfVerbose(new StringBuffer().append("[checking ").append(env.enclosingClass.classSymbol).append("]").toString());
            DebugLog.pInfo("source before attribution:");
            this.staticAnalyzer.analyzeClass(env.enclosingClass.classSymbol);
            DebugLog.pInfo(new StringBuffer().append("done attributing ").append(env.enclosingClass.classSymbol).toString());
            DebugLog.pInfo("source after attribution:");
            if (this.errorLog.errorCount() == 0) {
                new DataFlowChecker(this.errorLog, this.symbolTable, this.typeChecker).analyze(env.tree);
            }
            DebugLog.pInfo(new StringBuffer().append("done dataflow checks on ").append(env.enclosingClass.classSymbol).toString());
            DebugLog.pInfo("source after dataflow checks:");
            this.errorLog.useSource(prev);
            tail = tail.getRest();
        }
    }

    List<Environment<AnalyzerContext>> flatten(List<Environment<AnalyzerContext>> envs) throws IOException {
        if (this.errorLog.errorCount() == 0) {
            ListBox<Environment<AnalyzerContext>> newEnvs = new ListBox<Environment<AnalyzerContext>>();
            List<Environment<AnalyzerContext>> tail = envs;
            while (tail.nonEmpty()) {
                Tree newTree;
                Environment<AnalyzerContext> env = tail.getFirst();
                Name prev = this.errorLog.useSource(env.enclosingClass.classSymbol.sourcefile);
                this.options.printIfPrintTree(env.tree, "Abstract Syntax Tree after type checking:");
                Symbol.ClassSymbol classSymbol = ((Tree.ClassDef)env.tree).classSymbol;
                ClassVisitorEnv flatEnv = new ClassVisitorEnv(this.symbolTable, this.errorLog, classSymbol.owner);
                env.tree = newTree = env.tree.accept(this.typeFlattener, flatEnv);
                JavaCompiler.appendEnvs(newEnvs, flatEnv.newDefs().toList(), env);
                Environment<Object> fixEnv = new Environment<Object>(newTree, null);
                newTree.accept(TargetFixer.ONLY, fixEnv);
                this.errorLog.useSource(prev);
                this.options.printIfPrintTree(newTree, "Abstract Syntax Tree after name flattening:");
                this.options.printIfPrintSourceCode(env, (Tree.ClassDef)newTree, "Source code after name flattening:");
                tail = tail.getRest();
            }
            envs = envs.append(newEnvs.toList());
        }
        return envs;
    }

    void patchSnippets() {
        if (this.errorLog.errorCount() == 0) {
            this.snippetPatcher.patch();
        }
    }

    void eraseTypes(List<Environment<AnalyzerContext>> envs) {
        if (this.errorLog.errorCount() == 0) {
            List<Environment<AnalyzerContext>> tail = envs;
            while (tail.nonEmpty()) {
                Environment<AnalyzerContext> env = tail.getFirst();
                Name prev = this.errorLog.useSource(env.enclosingClass.classSymbol.sourcefile);
                TreeMaker make = new TreeMaker(env.topLevel);
                if (this.errorLog.errorCount() == 0) {
                    env.tree = new TypeEraser(this.errorLog, this.symbolTable, make).translateTopLevelClass(env.tree);
                }
                this.errorLog.useSource(prev);
                DebugLog.pInfo(new StringBuffer().append("done type translation for ").append(env.enclosingClass.classSymbol).toString());
                DebugLog.pInfo("source after type translation:");
                tail = tail.getRest();
            }
        }
    }

    void flattenGroundedSuperClasses() {
        if (this.errorLog.errorCount() == 0) {
            this.snippetPatcher.flattenSupertypes();
        }
    }

    List<Symbol.ClassSymbol> generateByteCode(List<Environment<AnalyzerContext>> envs) throws IOException {
        ListBox<Symbol.ClassSymbol> classSyms = new ListBox<Symbol.ClassSymbol>();
        if (this.errorLog.errorCount() == 0) {
            List<Environment<AnalyzerContext>> tail = envs;
            while (tail.nonEmpty()) {
                Environment<AnalyzerContext> env = tail.getFirst();
                Name prev = this.errorLog.useSource(env.enclosingClass.classSymbol.sourcefile);
                this.options.printIfPrintSourceCode(env, (Tree.ClassDef)env.tree, "Source code after type erasure: ");
                Tree.ClassDef classDef = null;
                try {
                    if (this.options.outputSource()) {
                        classDef = (Tree.ClassDef)env.tree;
                        this.printSource(env, classDef);
                    } else {
                        List<Tree> classDefs;
                        List<Tree> l = classDefs = new InnerClassFlattener(this.errorLog, this.symbolTable, this.treeMaker).translateTopLevelClass(env.tree);
                        while (this.errorLog.errorCount() == 0 && l.nonEmpty()) {
                            classDef = (Tree.ClassDef)l.getFirst();
                            this.generateOutput(env, classDef);
                            classSyms.insertEnd(classDef.classSymbol);
                            l = l.getRest();
                        }
                    }
                }
                catch (IOException ex) {
                    this.errorLog.error(classDef.sourcePosition, new StringBuffer().append("error while writing ").append(classDef.classSymbol).append(": ").append(ex).toString());
                }
                this.errorLog.useSource(prev);
                if (this.options.printSymbols()) {
                    DebugLog.pAlways(new StringBuffer().append("\nGenerated Symbol for ").append(env.enclosingClass.classSymbol).toString());
                }
                tail = tail.getRest();
            }
        }
        return classSyms.toList();
    }

    private void generateOutput(Environment<AnalyzerContext> env, Tree.ClassDef cdef) throws IOException {
        if (this.options.outputSource()) {
            this.printSource(env, cdef);
        } else {
            this.genCode(env, cdef);
        }
    }

    private static void appendEnvs(ListBox<Environment<AnalyzerContext>> newDefs, List<Tree> classDefs, Environment<AnalyzerContext> env) {
        List<Tree> tail = classDefs;
        while (tail.nonEmpty()) {
            newDefs.insertEnd(env.spawn(tail.getFirst()));
            tail = tail.getRest();
        }
    }

    private void printCount(String kind, int count) {
        if (count != 0) {
            this.errorLog.println(new StringBuffer().append(count).append(" ").append(kind).append(count == 1 ? "" : "s").toString());
        }
    }
}

