/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.main.JavaCompiler;
import edu.rice.cs.nextgen.compiler.util.AbortError;
import edu.rice.cs.nextgen.compiler.util.List;

public class Main {
    public static void main(String[] args) throws Throwable {
        try {
            CompilerOptions options = new CompilerOptions();
            List<String> filenames = options.processArgs(args);
            JavaCompiler compiler = new JavaCompiler(options);
            List<Symbol.ClassSymbol> classSymbols = compiler.compile(filenames);
            options.retrofitIfInstructed(compiler, classSymbols);
            Main.printStatisticsIfInstructed();
            Main.ensureNoErrors(compiler);
        }
        catch (AbortError e) {
            System.exit(-1);
        }
    }

    private static void ensureNoErrors(JavaCompiler compiler) throws AbortError {
        System.err.flush();
        if (compiler.errorCount() != 0) {
            throw new AbortError();
        }
    }

    private static void printStatisticsIfInstructed() {
    }
}

