/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.parser.Parser;
import edu.rice.cs.nextgen.compiler.parser.Scanner;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.Name;
import java.io.ByteArrayInputStream;
import java.util.StringTokenizer;
import junit.framework.TestCase;

public abstract class NextGenTestCase
extends TestCase {
    public static final Symbol.TypeSymbol TYPE_SYMBOL = new Symbol.TypeSymbol(0, Name.fromString("TYPE_SYMBOL"), null, null);
    public static final Symbol.TypeSymbol ANOTHER_TYPE_SYMBOL = new Symbol.TypeSymbol(0, Name.fromString("ANOTHER_TYPE_SYMBOL"), null, null);
    public static final Symbol.PackageSymbol PACKAGE_SYMBOL = new Symbol.PackageSymbol(Name.fromString("PACKAGE_SYMBOL"), null, null);
    public static final Symbol.ClassSymbol CLASS_SYMBOL = new Symbol.ClassSymbol(0, Name.fromString("CLASS_SYMBOL"), null, null);
    public static final Symbol.PackageSymbol OWNED_PACKAGE_SYMBOL = new Symbol.PackageSymbol(Name.fromString("OWNED_PACKAGE_SYMBOL"), null, PACKAGE_SYMBOL);
    public static final Symbol.ClassInstantiationSymbol CLASS_INSTANTIATION_SYMBOL = new Symbol.ClassInstantiationSymbol(0, Name.fromString("CLASS_INSTANTIATION_SYMBOL"), null, null, null);
    public static final Symbol.VarSymbol VAR_SYMBOL = new Symbol.VarSymbol(0, Name.fromString("VAR_SYMBOL"), null, null);
    public static final Symbol.MethodSymbol METHOD_SYMBOL = new Symbol.MethodSymbol(0, Name.fromString("METHOD_SYMBOL"), null, null);
    public static final Symbol.OperatorSymbol OPERATOR_SYMBOL = new Symbol.OperatorSymbol(Name.fromString("OPERATOR_SYMBOL"), null, 0, null);
    public static final Type INT_TYPE = new Type(4, TYPE_SYMBOL);
    public static final Type ZERO_TYPE = INT_TYPE.constType(new Integer(0));
    public static final Type MAX_INT_TYPE = INT_TYPE.constType(new Integer(Integer.MAX_VALUE));
    public static final Type MIN_INT_TYPE = INT_TYPE.constType(new Integer(Integer.MIN_VALUE));
    public static final Type BYTE_TYPE = new Type(1, TYPE_SYMBOL);
    public static final Type.NoType NO_TYPE = Type.NoType.ONLY;
    public static final Type.ClassType CLASS_TYPE = new Type.ClassType(NO_TYPE, new Empty<Type>(), CLASS_SYMBOL);
    public static final Type.ArrayType ARRAY_TYPE = new Type.ArrayType(CLASS_TYPE);
    public static final Type.MethodType METHOD_TYPE = new Type.MethodType(new Empty<Type>(), CLASS_TYPE, new Empty<Symbol.ClassSymbol>());
    public static final Type.TypeVar TYPE_VAR = new Type.TypeVar(CLASS_TYPE, TYPE_SYMBOL);
    public static final Type.TypeVar ANOTHER_TYPE_VAR = new Type.TypeVar(CLASS_TYPE, ANOTHER_TYPE_SYMBOL);
    public static final Type.PackageType PACKAGE_TYPE = new Type.PackageType(TYPE_SYMBOL);
    public static final Type.ForAll FOR_ALL = new Type.ForAll(new Empty<Type>(), METHOD_TYPE);
    public static final Type.ErrorType ERROR_TYPE = new Type.ErrorType(TYPE_SYMBOL);
    public static final Type.ClassType PARAM_CLASS_TYPE = new Type.ClassType(NO_TYPE, List.make(new Type[]{TYPE_VAR}), CLASS_SYMBOL);
    public static final Type.ClassType GROUND_CLASS_TYPE = new Type.ClassType(NO_TYPE, List.make(new Type[]{CLASS_TYPE}), CLASS_SYMBOL);

    public static String removeNewlines(String s) {
        return s.replace('\n', ' ');
    }

    public static String removeWhiteSpace(String text) {
        StringBuffer sb = new StringBuffer(text);
        int index = 0;
        while (index < sb.length()) {
            if (Character.isWhitespace(sb.charAt(index))) {
                sb.replace(index, index + 1, "");
                continue;
            }
            ++index;
        }
        return sb.toString();
    }

    public static String wrapInQuotes(String text) {
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        if (!tokenizer.hasMoreTokens()) {
            return "\"\"";
        }
        StringBuffer result = new StringBuffer("\"" + tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            result.append("\" +\n\"" + tokenizer.nextToken());
        }
        return result.append("\"").toString();
    }

    public static Parser makeParser(String sourceCode) {
        ErrorLog log = new ErrorLog();
        Scanner s = new Scanner(new ByteArrayInputStream(sourceCode.getBytes()), log);
        TreeMaker t = new TreeMaker();
        return new Parser(s, t, log);
    }

    public static Tree.TopLevel makeClassTree(String sourceCode) {
        return NextGenTestCase.makeParser(sourceCode).compilationUnit();
    }

    public static Tree.Import makeImportTree(String sourceCode) {
        return NextGenTestCase.makeParser(sourceCode).importDeclaration();
    }

    public NextGenTestCase(String name) {
        super(name);
        NextGenTestCase.TYPE_SYMBOL.type = CLASS_TYPE;
        NextGenTestCase.ANOTHER_TYPE_SYMBOL.type = CLASS_TYPE;
        NextGenTestCase.PACKAGE_SYMBOL.type = PACKAGE_TYPE;
        NextGenTestCase.CLASS_SYMBOL.type = PARAM_CLASS_TYPE;
        NextGenTestCase.OWNED_PACKAGE_SYMBOL.type = PACKAGE_TYPE;
        NextGenTestCase.CLASS_INSTANTIATION_SYMBOL.type = GROUND_CLASS_TYPE;
        NextGenTestCase.VAR_SYMBOL.type = CLASS_TYPE;
        NextGenTestCase.METHOD_SYMBOL.type = METHOD_TYPE;
        NextGenTestCase.OPERATOR_SYMBOL.type = NO_TYPE;
    }

    public void testRemoveNewlines() {
        NextGenTestCase.assertEquals((String)"    test   test   ", (String)NextGenTestCase.removeNewlines("\n \n test\n \ntest\n\n\n"));
    }

    public void testRemoveWhiteSpace() {
        NextGenTestCase.assertEquals((String)"testtest", (String)NextGenTestCase.removeWhiteSpace("\n \n test\n\ntest\n \n"));
    }

    public void testWrapInQuotes() {
        NextGenTestCase.assertEquals((String)"Single lines should be simply wrapped in quotations.", (String)"\"test\"", (String)NextGenTestCase.wrapInQuotes("test"));
        NextGenTestCase.assertEquals((String)"All lines but the last should be wrapped and appended with \" +\n\"", (String)"\"test\" +\n\"test2\"", (String)NextGenTestCase.wrapInQuotes("test\ntest2"));
        NextGenTestCase.assertEquals((String)"Empty Strings should convert to \"\".", (String)"\"\"", (String)NextGenTestCase.wrapInQuotes(""));
    }
}

