/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.code.ClassReader;
import edu.rice.cs.nextgen.compiler.code.CompleteClassReader;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.main.JavaCompiler;
import edu.rice.cs.nextgen.compiler.util.List;
import java.io.IOException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Retrofitter
implements TypeTags,
Kinds {
    ClassReader classReader;
    JavaCompiler javaCompiler;

    Retrofitter(JavaCompiler comp, CompilerOptions options) {
        this.javaCompiler = comp;
        this.classReader = new CompleteClassReader(options);
    }

    static boolean sameType(Type t1, Type t2) {
        return t1.tag == 10 && t2.tag == 10 && t1.typeSymbol.fullName() == t2.typeSymbol.fullName() || t1.tag == 11 && t2.tag == 11 && Retrofitter.sameType(t1.elementType(), t2.elementType()) || t1.tag == 12 && t2.tag == 12 && Retrofitter.sameType(t1.returnType(), t2.returnType()) && Retrofitter.sameTypes(t1.argTypes(), t2.argTypes()) || t1.isSameType(t2);
    }

    static boolean sameTypes(List<Type> ts1, List<Type> ts2) {
        while (ts1.nonEmpty() && ts2.nonEmpty() && Retrofitter.sameType(ts1.getFirst(), ts2.getFirst())) {
            ts1 = ts1.getRest();
            ts2 = ts2.getRest();
        }
        return ts1.isEmpty() && ts2.isEmpty();
    }

    public void fit(Symbol.ClassSymbol sig) {
        System.out.println(new StringBuffer().append("fitting ").append(sig).append(" ").append(sig.type.getTypeParams()).append(" ").append(sig.type.getSuperType()).append(" ").append(sig.type.getInterfaces()).toString());
        try {
            Symbol.ClassSymbol clazz = this.classReader.loadClass(sig.flatname);
            if (!Retrofitter.sameType(sig.type.getSuperType(), clazz.type.getSuperType())) {
                this.javaCompiler.getErrorLog().error(0, new StringBuffer().append("signature does not match ").append(clazz).append("; incompatible supertype").toString());
                return;
            }
            if (!Retrofitter.sameTypes(sig.type.getInterfaces(), clazz.type.getInterfaces())) {
                this.javaCompiler.getErrorLog().error(0, new StringBuffer().append("signature does not match ").append(clazz).append("; incompatible interfaces").toString());
                return;
            }
            clazz.type = sig.type;
            Scope.Entry e = sig.members().entries;
            while (e != null) {
                Symbol sym = e.symbol;
                switch (sym.kind) {
                    case 2: {
                        this.fit((Symbol.ClassSymbol)sym);
                        break;
                    }
                    case 4: 
                    case 16: {
                        Scope s = clazz.members();
                        Scope.Entry e1 = s.lookup(sym.name);
                        while (!(e1.scope != s || e1.symbol.kind == sym.kind && Retrofitter.sameType(e1.symbol.erasure(), sym.erasure()))) {
                            e1 = e1.next();
                        }
                        if (e1.scope == s) {
                            System.out.println(new StringBuffer().append("fitting ").append(e1.symbol).append(", was ").append(sym.erasure()).toString());
                            e1.symbol.type = sym.type;
                            break;
                        }
                        this.javaCompiler.getErrorLog().error(0, new StringBuffer().append(sym).append(" has no matching entry in ").append(clazz).append("; required: ").append(sym.erasure()).toString());
                    }
                }
                e = e.sibling;
            }
            if (this.javaCompiler.getErrorLog().errorCount() == 0) {
                this.javaCompiler.writeClass(clazz);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.javaCompiler.getErrorLog().error(0, new StringBuffer().append("cannot access ").append(ex.sym).append("; ").append(ex.errmsg).toString());
        }
        catch (IOException ex) {
            this.javaCompiler.getErrorLog().error(0, new StringBuffer().append("error while writing ").append(sig).append(": ").append(ex).toString());
        }
    }
}

