/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Win32 {
    public static boolean runningOnWin32 = File.separatorChar == '\\';

    static boolean hasWildcards(String s) {
        return s.length() > 0 && s.charAt(0) != '-' && (s.indexOf(42) >= 0 || s.indexOf("?") >= 0);
    }

    static boolean matches(String s, int soffset, String p, int poffset) {
        if (poffset >= p.length()) {
            return soffset >= s.length();
        }
        if (p.charAt(poffset) == '*') {
            return Win32.matches(s, soffset, p, poffset + 1) || soffset < s.length() && Win32.matches(s, soffset + 1, p, poffset);
        }
        return soffset < s.length() && (p.charAt(poffset) == '?' || Character.toUpperCase(s.charAt(soffset)) == Character.toUpperCase(p.charAt(poffset))) && Win32.matches(s, soffset + 1, p, poffset + 1);
    }

    static void addExpansion(ListBox<String> expandedArgs, String s) throws IOException {
        File dir;
        File f = new File(s);
        String path = f.getParent();
        String name = f.getName();
        if (path == null) {
            String string = path = s.indexOf("\\") == 0 ? "" : ".";
        }
        if ((dir = new File(new StringBuffer().append(path).append("\\").toString())) == null) {
            expandedArgs.insertEnd(s);
            return;
        }
        String[] files = dir.list();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (!Win32.matches(files[j], 0, name, 0)) continue;
                expandedArgs.insertEnd(new StringBuffer().append(path).append(File.separator).append(files[j]).toString());
            }
        }
    }

    public static void redirectErr(String filename) {
        try {
            System.setErr(new PrintStream(new BufferedOutputStream(new FileOutputStream(filename))));
        }
        catch (IOException e) {
            System.err.println("cannot redirect output stream");
        }
    }

    public static List<String> expand(String[] argv) throws IOException {
        ListBox<String> expandedArgs = new ListBox<String>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("!")) {
                Win32.redirectErr(argv[i].substring(1));
                continue;
            }
            if (Win32.hasWildcards(argv[i])) {
                Win32.addExpansion(expandedArgs, argv[i]);
                continue;
            }
            expandedArgs.insertEnd(argv[i]);
        }
        return expandedArgs.toList();
    }
}

