/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.parser;

import edu.rice.cs.nextgen.compiler.parser.Scanner;
import edu.rice.cs.nextgen.compiler.parser.Tokens;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements Tokens {
    private static final int infixPrecedenceLevels = 10;
    private Scanner scanner;
    private TreeMaker treeMaker;
    private ErrorLog errorLog;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    private int mode = 0;
    private int lastMode = 0;
    private static Tree errorTree = new Tree.Erroneous();
    private ListBox<Tree[]> odStackSupply = new ListBox();
    private ListBox<int[]> opStackSupply = new ListBox();

    public Parser(Scanner S, TreeMaker F, ErrorLog log) {
        this.scanner = S;
        this.treeMaker = F;
        this.errorLog = log;
    }

    private void skip() {
        int nbraces = 0;
        int nparens = 0;
        while (true) {
            switch (this.scanner.currentToken) {
                case 0: 
                case 10: 
                case 28: {
                    return;
                }
                case 66: {
                    if (nbraces != 0 || nparens != 0) break;
                    return;
                }
                case 63: {
                    if (nbraces == 0) {
                        return;
                    }
                    --nbraces;
                    break;
                }
                case 61: {
                    if (nparens <= 0) break;
                    --nparens;
                    break;
                }
                case 62: {
                    ++nbraces;
                    break;
                }
                case 60: {
                    ++nparens;
                    break;
                }
            }
            this.scanner.nextToken();
        }
    }

    private Tree syntaxError(int pos, String msg) {
        if (pos != this.scanner.errorPosition) {
            this.errorLog.error(pos, msg);
        }
        this.skip();
        this.scanner.errorPosition = pos;
        return errorTree;
    }

    private Tree syntaxError(String msg) {
        return this.syntaxError(this.scanner.currentPosition, msg);
    }

    private void accept(int token) {
        if (this.scanner.currentToken == token) {
            this.scanner.nextToken();
        } else {
            int pos = Position.line(this.scanner.currentPosition) > Position.line(this.scanner.prevPosition) ? this.scanner.prevPosition : this.scanner.currentPosition;
            this.syntaxError(pos, new StringBuffer().append(this.scanner.token2string(token)).append(" expected").toString());
            if (this.scanner.currentToken == token) {
                this.scanner.nextToken();
            }
        }
    }

    Tree illegal(int pos) {
        return this.syntaxError(pos, new StringBuffer().append("illegal start of ").append((this.mode & 1) != 0 ? "expression" : "type").toString());
    }

    private Tree illegal() {
        return this.illegal(this.scanner.currentPosition);
    }

    private Name ident() {
        if (this.scanner.currentToken == 2) {
            Name name = this.scanner.name;
            this.scanner.nextToken();
            return name;
        }
        this.accept(2);
        return Names.error;
    }

    private Tree qualident() {
        Tree t = this.treeMaker.at(this.scanner.currentPosition).newIdent(this.ident());
        while (this.scanner.currentToken == 68) {
            int pos = this.scanner.currentPosition;
            this.scanner.nextToken();
            t = this.treeMaker.at(pos).newSelect(t, this.ident());
        }
        return t;
    }

    private Tree literal(Name prefix) {
        int pos = this.scanner.currentPosition;
        Tree t = errorTree;
        switch (this.scanner.currentToken) {
            case 51: {
                try {
                    t = this.treeMaker.at(pos).newLiteral(4, new Integer(Converter.string2int(this.strval(prefix), this.scanner.radix)));
                }
                catch (NumberFormatException ex) {
                    this.errorLog.error(this.scanner.currentPosition, new StringBuffer().append("integer number too large: ").append(this.strval(prefix)).toString());
                }
                break;
            }
            case 52: {
                try {
                    t = this.treeMaker.at(pos).newLiteral(5, new Long(Converter.string2long(this.strval(prefix), this.scanner.radix)));
                }
                catch (NumberFormatException ex) {
                    this.errorLog.error(this.scanner.currentPosition, new StringBuffer().append("integer number too large: ").append(this.strval(prefix)).toString());
                }
                break;
            }
            case 53: {
                Float n = Float.valueOf(this.scanner.stringVal());
                if (n.floatValue() == 0.0f && !this.iszero(this.scanner.stringVal())) {
                    this.errorLog.error(this.scanner.currentPosition, "floating point number too small");
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.errorLog.error(this.scanner.currentPosition, "floating point number too large");
                    break;
                }
                t = this.treeMaker.at(pos).newLiteral(6, n);
                break;
            }
            case 54: {
                Double n = Double.valueOf(this.scanner.stringVal());
                if (n == 0.0 && !this.iszero(this.scanner.stringVal())) {
                    this.errorLog.error(this.scanner.currentPosition, "floating point number too small");
                    break;
                }
                if (n == Double.POSITIVE_INFINITY) {
                    this.errorLog.error(this.scanner.currentPosition, "floating point number too large");
                    break;
                }
                t = this.treeMaker.at(pos).newLiteral(7, n);
                break;
            }
            case 55: {
                t = this.treeMaker.at(pos).newLiteral(2, new Integer(this.scanner.stringVal().charAt(0)));
                break;
            }
            case 56: {
                t = this.treeMaker.at(pos).newLiteral(10, this.scanner.stringVal());
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                t = this.treeMaker.at(pos).newIdent(this.scanner.name);
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.scanner.nextToken();
        return t;
    }

    boolean iszero(String s) {
        int i;
        char[] cs = s.toCharArray();
        for (i = 0; i < cs.length && (cs[i] == '0' || cs[i] == '.'); ++i) {
        }
        return i >= cs.length || '1' > cs[i] || cs[i] > '9';
    }

    private String strval(Name prefix) {
        String s = this.scanner.stringVal();
        return prefix.length == 0 ? s : new StringBuffer().append(prefix).append(s).toString();
    }

    private Tree expression() {
        return this.term(1);
    }

    private Tree type() {
        return this.term(2);
    }

    private Tree term(int newmode) {
        int prevmode = this.mode;
        this.mode = newmode;
        Tree t = this.term();
        this.lastMode = this.mode;
        this.mode = prevmode;
        return t;
    }

    private Tree term() {
        Tree t = this.term1();
        if ((this.mode & 1) != 0 && this.scanner.currentToken == 69 || 95 <= this.scanner.currentToken && this.scanner.currentToken <= 105) {
            return this.termRest(t);
        }
        return t;
    }

    private Tree termRest(Tree t) {
        switch (this.scanner.currentToken) {
            case 69: {
                int pos = this.scanner.currentPosition;
                this.scanner.nextToken();
                this.mode = 1;
                Tree t1 = this.term();
                return this.treeMaker.at(pos).newAssign(t, t1);
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                int pos = this.scanner.currentPosition;
                int token = this.scanner.currentToken;
                this.scanner.nextToken();
                this.mode = 1;
                Tree t1 = this.term();
                return this.treeMaker.at(pos).newAssignOp(Parser.opcode(token), t, t1);
            }
        }
        return t;
    }

    private Tree term1() {
        Tree t = this.term2();
        if ((this.mode & 1) != 0 & this.scanner.currentToken == 74) {
            this.mode = 1;
            return this.term1Rest(t);
        }
        return t;
    }

    private Tree term1Rest(Tree t) {
        if (this.scanner.currentToken == 74) {
            int pos = this.scanner.currentPosition;
            this.scanner.nextToken();
            Tree t1 = this.term();
            this.accept(75);
            Tree t2 = this.term1();
            return this.treeMaker.at(pos).newConditional(16, t, t1, t2);
        }
        return t;
    }

    private Tree term2() {
        Tree t = this.term3();
        if ((this.mode & 1) != 0 && Parser.prec(this.scanner.currentToken) >= 4) {
            this.mode = 1;
            return this.term2Rest(t, 4);
        }
        return t;
    }

    private Tree term2Rest(Tree t, int minprec) {
        List<Tree[]> savedOd = this.odStackSupply.toList();
        Tree[] odStack = this.newOdStack();
        List<int[]> savedOp = this.opStackSupply.toList();
        int[] opStack = this.newOpStack();
        int top = 0;
        odStack[0] = t;
        int topOp = 1;
        while (Parser.prec(this.scanner.currentToken) >= minprec) {
            opStack[top] = topOp;
            topOp = this.scanner.currentToken;
            int pos = this.scanner.currentPosition;
            this.scanner.nextToken();
            Tree tree = odStack[++top] = topOp == 26 ? this.type() : this.term3();
            while (top > 0 && Parser.prec(topOp) >= Parser.prec(this.scanner.currentToken)) {
                odStack[top - 1] = topOp == 26 ? this.treeMaker.at(pos).newInstanceofTest(odStack[top - 1], odStack[top]) : this.treeMaker.at(pos).newOperation(Parser.opcode(topOp), new Cons<Tree>(odStack[top]).cons(odStack[top - 1]));
                topOp = opStack[--top];
            }
        }
        Asserter._assert(top == 0);
        t = odStack[0];
        this.odStackSupply.set(savedOd);
        this.opStackSupply.set(savedOp);
        return t;
    }

    private Tree[] newOdStack() {
        if (this.odStackSupply.isEmpty()) {
            this.odStackSupply.insertEnd(new Tree[11]);
        }
        Tree[] odStack = this.odStackSupply.getFirst();
        this.odStackSupply.remove();
        return odStack;
    }

    private int[] newOpStack() {
        if (this.opStackSupply.isEmpty()) {
            this.opStackSupply.insertEnd(new int[11]);
        }
        int[] opStack = this.opStackSupply.getFirst();
        this.opStackSupply.remove();
        return opStack;
    }

    /*
     * WARNING - void declaration
     */
    private Tree term3() {
        void var2_10;
        Tree t1;
        Tree t;
        int pos = this.scanner.currentPosition;
        switch (this.scanner.currentToken) {
            case 72: 
            case 73: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    int token = this.scanner.currentToken;
                    this.scanner.nextToken();
                    if (token == 85 && (this.scanner.currentToken == 51 || this.scanner.currentToken == 52) && this.scanner.radix == 10) {
                        t = this.literal(Names.hyphen);
                        break;
                    }
                    Tree t2 = this.term3();
                    return this.treeMaker.at(pos).newOperation(Parser.unopcode(token), new Cons<Tree>(t2));
                }
                return this.illegal();
            }
            case 60: {
                if ((this.mode & 1) != 0) {
                    this.scanner.nextToken();
                    this.mode = 7;
                    t = this.term3();
                    if ((this.mode & 2) != 0 && this.scanner.currentToken == 71) {
                        int pos1 = this.scanner.currentPosition;
                        this.scanner.nextToken();
                        this.mode &= 3;
                        t1 = this.term3();
                        if ((this.mode & 2) != 0 && (this.scanner.currentToken == 67 || this.scanner.currentToken == 70)) {
                            this.mode = 2;
                            ListBox<Tree> args = new ListBox<Tree>();
                            args.insertEnd(t1);
                            while (this.scanner.currentToken == 67) {
                                this.scanner.nextToken();
                                args.insertEnd(this.type());
                            }
                            this.accept(70);
                            t = this.treeMaker.at(pos1).newTypeApply(t, args.toList());
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            t = this.termRest(this.term1Rest(this.term2Rest(this.treeMaker.at(pos1).newOperation(53, new Cons<Tree>(this.term2Rest(t1, 11)).cons(t)), 4)));
                        } else {
                            this.accept(70);
                        }
                    } else {
                        t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                    }
                    this.accept(61);
                    this.lastMode = this.mode;
                    this.mode = 1;
                    if ((this.lastMode & 1) == 0) {
                        Tree t12 = this.term3();
                        return this.treeMaker.at(pos).newTypeCast(t, t12);
                    }
                    if ((this.lastMode & 2) == 0) break;
                    switch (this.scanner.currentToken) {
                        case 2: 
                        case 31: 
                        case 40: 
                        case 43: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 72: 
                        case 73: 
                        case 82: 
                        case 83: {
                            Tree t13 = this.term3();
                            return this.treeMaker.at(pos).newTypeCast(t, t13);
                        }
                    }
                    break;
                }
                return this.illegal();
            }
            case 43: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.treeMaker.at(pos).newIdent(Names._this);
                    this.scanner.nextToken();
                    t = this.argumentsOpt(t);
                    break;
                }
                return this.illegal();
            }
            case 40: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.treeMaker.at(pos).newIdent(Names._super);
                    this.scanner.nextToken();
                    if (this.scanner.currentToken == 60) {
                        t = this.arguments(t);
                        break;
                    }
                    int pos1 = this.scanner.currentPosition;
                    this.accept(68);
                    t = this.argumentsOpt(this.treeMaker.at(pos1).newSelect(t, this.ident()));
                    break;
                }
                return this.illegal();
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.literal(Names.empty);
                    break;
                }
                return this.illegal();
            }
            case 31: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.scanner.nextToken();
                    t = this.creator(pos);
                    break;
                }
                return this.illegal();
            }
            case 2: {
                t = this.treeMaker.at(this.scanner.currentPosition).newIdent(this.ident());
                block26: while (true) {
                    pos = this.scanner.currentPosition;
                    switch (this.scanner.currentToken) {
                        case 64: {
                            this.scanner.nextToken();
                            if (this.scanner.currentToken == 65) {
                                this.scanner.nextToken();
                                t = this.bracketsSuffix(this.bracketsOpt(this.treeMaker.at(pos).newArrayTypeExpression(t)));
                                break block26;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                Tree t14 = this.term();
                                t = this.treeMaker.at(pos).newIndexedArrayElement(t, t14);
                            }
                            this.accept(65);
                            break block26;
                        }
                        case 60: {
                            if ((this.mode & 1) == 0) break block26;
                            this.mode = 1;
                            t = this.arguments(t);
                            break block26;
                        }
                        case 68: {
                            this.scanner.nextToken();
                            if ((this.mode & 1) != 0) {
                                switch (this.scanner.currentToken) {
                                    case 10: {
                                        this.mode = 1;
                                        t = this.treeMaker.at(pos).newSelect(t, Names._class);
                                        this.scanner.nextToken();
                                        break block26;
                                    }
                                    case 43: {
                                        this.mode = 1;
                                        t = this.treeMaker.at(pos).newSelect(t, Names._this);
                                        this.scanner.nextToken();
                                        break block26;
                                    }
                                    case 40: {
                                        this.mode = 1;
                                        t = this.treeMaker.at(pos).newSelect(t, Names._super);
                                        this.scanner.nextToken();
                                        t = this.arguments(t);
                                        break block26;
                                    }
                                    case 31: {
                                        this.mode = 1;
                                        int pos1 = this.scanner.currentPosition;
                                        this.scanner.nextToken();
                                        t = this.innerCreator(pos1, t);
                                        break block26;
                                    }
                                }
                            }
                            t = this.treeMaker.at(pos).newSelect(t, this.ident());
                            continue block26;
                        }
                    }
                    break;
                }
                t = this.typeArgumentsOpt(t);
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 37: {
                t = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case 48: {
                if ((this.mode & 1) != 0) {
                    this.scanner.nextToken();
                    if (this.scanner.currentToken == 68) {
                        t = this.bracketsSuffix(this.treeMaker.at(pos).newTypeIdent(9));
                        break;
                    }
                    return this.illegal(pos);
                }
                return this.illegal();
            }
            default: {
                return this.illegal();
            }
        }
        while (true) {
            int pos1 = this.scanner.currentPosition;
            if (this.scanner.currentToken == 64) {
                this.scanner.nextToken();
                if (this.scanner.currentToken == 65 && (this.mode & 2) != 0) {
                    this.mode = 2;
                    this.scanner.nextToken();
                    return this.bracketsOpt(this.treeMaker.at(pos1).newArrayTypeExpression(t));
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t1 = this.term();
                    t = this.treeMaker.at(pos1).newIndexedArrayElement(t, t1);
                }
                this.accept(65);
                continue;
            }
            if (this.scanner.currentToken != 68) break;
            this.scanner.nextToken();
            if (this.scanner.currentToken == 40 && (this.mode & 1) != 0) {
                this.mode = 1;
                t = this.treeMaker.at(pos).newSelect(t, Names._super);
                this.scanner.nextToken();
                t = this.arguments(t);
                continue;
            }
            if (this.scanner.currentToken == 31 && (this.mode & 1) != 0) {
                this.mode = 1;
                int pos2 = this.scanner.currentPosition;
                this.scanner.nextToken();
                t = this.innerCreator(pos2, t);
                continue;
            }
            t = this.argumentsOpt(this.typeArgumentsOpt(this.treeMaker.at(pos).newSelect(t, this.ident())));
        }
        while ((this.scanner.currentToken == 82 || this.scanner.currentToken == 83) && (this.mode & 1) != 0) {
            this.mode = 1;
            t = this.treeMaker.at(this.scanner.currentPosition).newOperation(this.scanner.currentToken == 82 ? 44 : 45, new Cons<Tree>(t));
            this.scanner.nextToken();
        }
        return var2_10;
    }

    private Tree basicType() {
        Tree.TypeIdent t = this.treeMaker.at(this.scanner.currentPosition).newTypeIdent(Parser.typetag(this.scanner.currentToken));
        this.scanner.nextToken();
        return t;
    }

    private Tree argumentsOpt(Tree t) {
        if ((this.mode & 1) != 0 && this.scanner.currentToken == 60) {
            this.mode = 1;
            return this.arguments(t);
        }
        return t;
    }

    private List<Tree> arguments() {
        int pos = this.scanner.currentPosition;
        ListBox<Tree> args = new ListBox<Tree>();
        if (this.scanner.currentToken == 60) {
            this.scanner.nextToken();
            if (this.scanner.currentToken != 61) {
                args.insertEnd(this.expression());
                while (this.scanner.currentToken == 67) {
                    this.scanner.nextToken();
                    args.insertEnd(this.expression());
                }
            }
            this.accept(61);
        } else {
            this.errorLog.error(this.scanner.currentPosition, "'(' expected");
        }
        return args.toList();
    }

    private Tree arguments(Tree t) {
        int pos = this.scanner.currentPosition;
        List<Tree> args = this.arguments();
        return this.treeMaker.at(pos).newApply(t, args);
    }

    private Tree typeArgumentsOpt(Tree t) {
        if (this.scanner.currentToken == 71 && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            return this.typeArguments(t);
        }
        return t;
    }

    private List<Tree> typeArguments() {
        int pos = this.scanner.currentPosition;
        ListBox<Tree> args = new ListBox<Tree>();
        if (this.scanner.currentToken == 71) {
            this.scanner.nextToken();
            args.insertEnd(this.type());
            while (this.scanner.currentToken == 67) {
                this.scanner.nextToken();
                args.insertEnd(this.type());
            }
            switch (this.scanner.currentToken) {
                case 105: {
                    this.scanner.currentToken = 104;
                    break;
                }
                case 104: {
                    this.scanner.currentToken = 78;
                    break;
                }
                case 78: {
                    this.scanner.currentToken = 69;
                    break;
                }
                case 94: {
                    this.scanner.currentToken = 93;
                    break;
                }
                case 93: {
                    this.scanner.currentToken = 70;
                    break;
                }
                default: {
                    this.accept(70);
                    break;
                }
            }
        } else {
            this.errorLog.error(this.scanner.currentPosition, "'<' expected");
        }
        return args.toList();
    }

    private Tree typeArguments(Tree t) {
        int pos = this.scanner.currentPosition;
        List<Tree> args = this.typeArguments();
        return this.treeMaker.at(pos).newTypeApply(t, args);
    }

    private Tree bracketsOpt(Tree t) {
        while (this.scanner.currentToken == 64) {
            int pos = this.scanner.currentPosition;
            this.scanner.nextToken();
            this.accept(65);
            t = this.treeMaker.at(pos).newArrayTypeExpression(t);
        }
        return t;
    }

    private Tree bracketsSuffix(Tree t) {
        if ((this.mode & 1) != 0 && this.scanner.currentToken == 68) {
            this.mode = 1;
            int pos = this.scanner.currentPosition;
            this.scanner.nextToken();
            this.accept(10);
            t = this.treeMaker.at(pos).newSelect(t, Names._class);
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.errorLog.error(this.scanner.currentPosition, "'.class' expected");
        }
        return t;
    }

    private Tree creator(int newpos) {
        switch (this.scanner.currentToken) {
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 37: {
                return this.arrayCreatorRest(newpos, this.basicType());
            }
        }
        Tree t = this.qualident();
        if (this.scanner.currentToken == 71) {
            t = this.typeArguments(t);
        }
        if (this.scanner.currentToken == 64) {
            return this.arrayCreatorRest(newpos, t);
        }
        if (this.scanner.currentToken == 60) {
            return this.classCreatorRest(newpos, null, t);
        }
        return this.syntaxError("'(' or '[' expected");
    }

    private Tree innerCreator(int newpos, Tree encl) {
        Tree t = this.treeMaker.at(this.scanner.currentPosition).newIdent(this.ident());
        if (this.scanner.currentToken == 71) {
            t = this.typeArguments(t);
        }
        return this.classCreatorRest(newpos, encl, t);
    }

    private Tree arrayCreatorRest(int newpos, Tree elemtype) {
        int pos = this.scanner.currentPosition;
        this.accept(64);
        if (this.scanner.currentToken == 65) {
            this.scanner.nextToken();
            elemtype = this.bracketsOpt(elemtype);
            if (this.scanner.currentToken == 62) {
                return this.arrayInitializer(elemtype);
            }
            this.errorLog.error(this.scanner.currentPosition, "'{' expected");
            return errorTree;
        }
        ListBox<Tree> dims = new ListBox<Tree>();
        dims.insertEnd(this.expression());
        this.accept(65);
        while (this.scanner.currentToken == 64) {
            int pos1 = this.scanner.currentPosition;
            this.scanner.nextToken();
            if (this.scanner.currentToken == 65) {
                this.scanner.nextToken();
                elemtype = this.bracketsOpt(this.treeMaker.at(pos1).newArrayTypeExpression(elemtype));
                continue;
            }
            dims.insertEnd(this.expression());
            this.accept(65);
        }
        return this.treeMaker.at(newpos).newNewArray(elemtype, dims.toList(), new Empty<Tree>());
    }

    private Tree classCreatorRest(int newpos, Tree encl, Tree t) {
        List<Tree> args = this.arguments();
        Tree.ClassDef body = null;
        if (this.scanner.currentToken == 62) {
            body = this.treeMaker.at(this.scanner.currentPosition).newClassDef(0, Names.empty, Tree.TypeParameter.emptyList, null, Tree.EMPTY_LIST, this.classOrInterfaceBody(Names.empty, false));
        }
        return this.treeMaker.at(newpos).newNewInstance(encl, t, args, body);
    }

    private Tree arrayInitializer(Tree t) {
        int pos = this.scanner.currentPosition;
        this.accept(62);
        ListBox<Tree> elems = new ListBox<Tree>();
        if (this.scanner.currentToken != 63) {
            elems.insertEnd(this.variableInitializer());
            while (this.scanner.currentToken == 67) {
                this.scanner.nextToken();
                if (this.scanner.currentToken == 63) break;
                elems.insertEnd(this.variableInitializer());
            }
        }
        this.accept(63);
        return this.treeMaker.at(pos).newNewArray(t, Tree.EMPTY_LIST, elems.toList());
    }

    private Tree variableInitializer() {
        return this.scanner.currentToken == 62 ? this.arrayInitializer(null) : this.expression();
    }

    private Tree parExpression() {
        this.accept(60);
        Tree t = this.expression();
        this.accept(61);
        return t;
    }

    private Tree.Block block(int flags) {
        int pos = this.scanner.currentPosition;
        this.accept(62);
        List<Tree> stats = this.blockStatements();
        Tree.Block t = this.treeMaker.at(pos).newBlock(flags, stats);
        while (this.scanner.currentToken == 7 || this.scanner.currentToken == 13) {
            this.syntaxError(new StringBuffer().append("orphaned ").append(this.scanner.token2string(this.scanner.currentToken)).toString());
            this.blockStatements();
        }
        this.accept(63);
        return t;
    }

    private Tree.Block block() {
        return this.block(0);
    }

    private List<Tree> blockStatements() {
        ListBox<Tree> stats = new ListBox<Tree>();
        block7: while (true) {
            int pos = this.scanner.currentPosition;
            switch (this.scanner.currentToken) {
                case 0: 
                case 7: 
                case 13: 
                case 63: {
                    return stats.toList();
                }
                case 5: 
                case 8: 
                case 12: 
                case 14: 
                case 16: 
                case 19: 
                case 21: 
                case 23: 
                case 36: 
                case 41: 
                case 42: 
                case 44: 
                case 47: 
                case 50: 
                case 62: 
                case 66: {
                    stats.insertEnd(this.statement());
                    continue block7;
                }
                case 18: {
                    int flags = this.modifiersOpt();
                    if (this.scanner.currentToken == 28 || this.scanner.currentToken == 10) {
                        stats.insertEnd(this.classOrInterfaceDeclaration(flags));
                        continue block7;
                    }
                    pos = this.scanner.currentPosition;
                    Name name = this.scanner.name;
                    Tree t = this.type();
                    stats.insertEltsEnd(this.variableDeclarators(flags, t));
                    this.accept(66);
                    continue block7;
                }
                case 3: 
                case 39: {
                    int flags = this.modifiersOpt();
                    stats.insertEnd(this.classOrInterfaceDeclaration(flags));
                    continue block7;
                }
                case 10: 
                case 28: {
                    stats.insertEnd(this.classOrInterfaceDeclaration(0));
                    continue block7;
                }
            }
            Name name = this.scanner.name;
            Tree t = this.term(3);
            if (this.scanner.currentToken == 75 && t.tag == 31) {
                this.scanner.nextToken();
                Tree stat = this.statement();
                stats.insertEnd(this.treeMaker.at(pos).newLabelled(name, stat));
                continue;
            }
            if ((this.lastMode & 2) != 0 && this.scanner.currentToken == 2) {
                stats.insertEltsEnd(this.variableDeclarators(0, t));
                this.accept(66);
                continue;
            }
            stats.insertEnd(this.treeMaker.at(pos).newExpressionStatement(this.checkExprStat(t)));
            this.accept(66);
        }
    }

    private Tree statement() {
        int pos = this.scanner.currentPosition;
        switch (this.scanner.currentToken) {
            case 62: {
                return this.block();
            }
            case 23: {
                this.scanner.nextToken();
                Tree cond = this.parExpression();
                Tree thenpart = this.statement();
                Tree elsepart = null;
                if (this.scanner.currentToken == 16) {
                    this.scanner.nextToken();
                    elsepart = this.statement();
                }
                return this.treeMaker.at(pos).newConditional(17, cond, thenpart, elsepart);
            }
            case 21: {
                this.scanner.nextToken();
                this.accept(60);
                List<Tree> inits = this.scanner.currentToken == 66 ? Tree.EMPTY_LIST : this.forInit();
                this.accept(66);
                Tree cond = this.scanner.currentToken == 66 ? null : this.expression();
                this.accept(66);
                List<Tree> steps = this.scanner.currentToken == 61 ? Tree.EMPTY_LIST : this.forUpdate();
                this.accept(61);
                Tree body = this.statement();
                return this.treeMaker.at(pos).newForLoop(inits, cond, steps, body);
            }
            case 50: {
                this.scanner.nextToken();
                Tree cond = this.parExpression();
                Tree body = this.statement();
                return this.treeMaker.at(pos).newWhileLoop(cond, body);
            }
            case 14: {
                this.scanner.nextToken();
                Tree body = this.statement();
                this.accept(50);
                Tree cond = this.parExpression();
                this.accept(66);
                return this.treeMaker.at(pos).newDoLoop(body, cond);
            }
            case 47: {
                this.scanner.nextToken();
                Tree.Block body = this.block();
                ListBox<Tree.Catch> catchers = new ListBox<Tree.Catch>();
                Tree.Block finalizer = null;
                if (this.scanner.currentToken == 8 || this.scanner.currentToken == 19) {
                    while (this.scanner.currentToken == 8) {
                        catchers.insertEnd(this.catchClause());
                    }
                    if (this.scanner.currentToken == 19) {
                        this.scanner.nextToken();
                        finalizer = this.block();
                    }
                } else {
                    this.errorLog.error(pos, "'try' without 'catch' or 'finally'");
                }
                return this.treeMaker.at(pos).newTry(body, catchers.toList(), finalizer);
            }
            case 41: {
                this.scanner.nextToken();
                Tree selector = this.parExpression();
                this.accept(62);
                List<Tree.Case> cases = this.switchBlockStatementGroups();
                this.accept(63);
                return this.treeMaker.at(pos).newSwitch(selector, cases);
            }
            case 42: {
                this.scanner.nextToken();
                Tree lock = this.parExpression();
                Tree.Block body = this.block();
                return this.treeMaker.at(pos).newSynchronized(lock, body);
            }
            case 36: {
                this.scanner.nextToken();
                Tree result = this.scanner.currentToken == 66 ? null : this.expression();
                this.accept(66);
                return this.treeMaker.at(pos).newReturn(result);
            }
            case 44: {
                this.scanner.nextToken();
                Tree exc = this.expression();
                this.accept(66);
                return this.treeMaker.at(pos).newThrow(exc);
            }
            case 5: {
                this.scanner.nextToken();
                Name label = this.scanner.currentToken == 2 ? this.ident() : null;
                this.accept(66);
                return this.treeMaker.at(pos).newBreak(label);
            }
            case 12: {
                this.scanner.nextToken();
                Name label = this.scanner.currentToken == 2 ? this.ident() : null;
                this.accept(66);
                return this.treeMaker.at(pos).newContinue(label);
            }
            case 66: {
                this.scanner.nextToken();
                return this.treeMaker.at(pos).newBlock(0, Tree.EMPTY_LIST);
            }
            case 16: {
                return this.syntaxError("'else' without 'if'");
            }
            case 19: {
                return this.syntaxError("'finally' without 'try'");
            }
            case 8: {
                return this.syntaxError("'catch' without 'try'");
            }
        }
        Name name = this.scanner.name;
        Tree expr = this.expression();
        if (this.scanner.currentToken == 75 && expr.tag == 31) {
            this.scanner.nextToken();
            Tree stat = this.statement();
            return this.treeMaker.at(pos).newLabelled(name, stat);
        }
        Tree.ExpressionStatement stat = this.treeMaker.at(pos).newExpressionStatement(this.checkExprStat(expr));
        this.accept(66);
        return stat;
    }

    private Tree.Catch catchClause() {
        int pos = this.scanner.currentPosition;
        this.accept(8);
        this.accept(60);
        Tree.VarDef formal = this.formalParameter();
        this.accept(61);
        Tree.Block body = this.block();
        return this.treeMaker.at(pos).newCatch(formal, body);
    }

    private List<Tree.Case> switchBlockStatementGroups() {
        ListBox<Tree.Case> cases = new ListBox<Tree.Case>();
        block5: while (true) {
            int pos = this.scanner.currentPosition;
            switch (this.scanner.currentToken) {
                case 7: {
                    this.scanner.nextToken();
                    Tree pat = this.expression();
                    this.accept(75);
                    List<Tree> stats = this.blockStatements();
                    cases.insertEnd(this.treeMaker.at(pos).newCase(pat, stats));
                    continue block5;
                }
                case 13: {
                    this.scanner.nextToken();
                    this.accept(75);
                    List<Tree> stats = this.blockStatements();
                    cases.insertEnd(this.treeMaker.at(pos).newCase(null, stats));
                    continue block5;
                }
                case 0: 
                case 63: {
                    return cases.toList();
                }
            }
            this.scanner.nextToken();
            this.syntaxError(pos, "'case', 'default' or '}' expected");
        }
    }

    private List<Tree> moreStatementExpressions(int pos, Tree first) {
        ListBox<Tree.ExpressionStatement> stats = new ListBox<Tree.ExpressionStatement>();
        stats.insertEnd(this.treeMaker.at(pos).newExpressionStatement(this.checkExprStat(first)));
        while (this.scanner.currentToken == 67) {
            this.scanner.nextToken();
            pos = this.scanner.currentPosition;
            Tree t = this.expression();
            stats.insertEnd(this.treeMaker.at(pos).newExpressionStatement(this.checkExprStat(t)));
        }
        return stats.toList();
    }

    private List<Tree> forInit() {
        int pos = this.scanner.currentPosition;
        if (this.scanner.currentToken == 18) {
            this.scanner.nextToken();
            return this.variableDeclarators(16, this.type());
        }
        Tree t = this.term(3);
        if ((this.lastMode & 2) != 0 && this.scanner.currentToken == 2) {
            return this.variableDeclarators(0, t);
        }
        return this.moreStatementExpressions(pos, t);
    }

    private List<Tree> forUpdate() {
        return this.moreStatementExpressions(this.scanner.currentPosition, this.expression());
    }

    /*
     * WARNING - void declaration
     */
    private int modifiersOpt() {
        int flags = 0;
        if (this.scanner.deprecatedFlag) {
            flags = 131072;
            this.scanner.deprecatedFlag = false;
        }
        while (true) {
            void var2_2;
            switch (this.scanner.currentToken) {
                case 33: {
                    int flag = 2;
                    break;
                }
                case 34: {
                    int flag = 4;
                    break;
                }
                case 35: {
                    int flag = 1;
                    break;
                }
                case 38: {
                    int flag = 8;
                    break;
                }
                case 46: {
                    int flag = 128;
                    break;
                }
                case 18: {
                    int flag = 16;
                    break;
                }
                case 3: {
                    int flag = 1024;
                    break;
                }
                case 30: {
                    int flag = 256;
                    break;
                }
                case 49: {
                    int flag = 64;
                    break;
                }
                case 42: {
                    int flag = 32;
                    break;
                }
                case 39: {
                    int flag = 2048;
                    break;
                }
                default: {
                    return flags;
                }
            }
            if ((flags & var2_2) != 0) {
                this.errorLog.error(this.scanner.currentPosition, "repeated modifier");
            }
            flags |= var2_2;
            this.scanner.nextToken();
        }
    }

    private List<Tree> variableDeclarators(int flags, Tree type) {
        return this.variableDeclaratorsRest(this.scanner.currentPosition, flags, type, this.ident(), false);
    }

    private List<Tree> variableDeclaratorsRest(int pos, int flags, Tree type, Name name, boolean reqInit) {
        ListBox<Tree.VarDef> vdefs = new ListBox<Tree.VarDef>();
        vdefs.insertEnd(this.variableDeclaratorRest(pos, flags, type, name, reqInit));
        while (this.scanner.currentToken == 67) {
            this.scanner.nextToken();
            vdefs.insertEnd(this.variableDeclarator(flags, type));
        }
        return vdefs.toList();
    }

    private Tree.VarDef variableDeclarator(int flags, Tree type) {
        return this.variableDeclaratorRest(this.scanner.currentPosition, flags, type, this.ident(), false);
    }

    private Tree.VarDef variableDeclaratorRest(int pos, int flags, Tree type, Name name, boolean reqInit) {
        type = this.bracketsOpt(type);
        Tree init = null;
        if (this.scanner.currentToken == 69) {
            this.scanner.nextToken();
            init = this.variableInitializer();
        } else if (reqInit) {
            this.errorLog.error(this.scanner.currentPosition, "'=' expected");
        }
        return this.treeMaker.at(pos).newVarDef(flags, name, type, init);
    }

    private Tree.VarDef variableDeclaratorId(int flags, Tree type) {
        int pos = this.scanner.currentPosition;
        Name name = this.ident();
        type = this.bracketsOpt(type);
        return this.treeMaker.at(pos).newVarDef(flags, name, type, null);
    }

    public Tree.TopLevel compilationUnit() {
        int pos = this.scanner.currentPosition;
        Tree pid = null;
        if (this.scanner.currentToken == 32) {
            this.scanner.nextToken();
            pid = this.qualident();
            this.accept(66);
        }
        ListBox<Tree> defs = new ListBox<Tree>();
        while (this.scanner.currentToken == 25) {
            defs.insertEnd(this.importDeclaration());
        }
        while (this.scanner.currentToken != 0) {
            defs.insertEnd(this.typeDeclaration());
        }
        return this.treeMaker.at(pos).newTopLevel(pid, defs.toList());
    }

    public Tree.Import importDeclaration() {
        int pos = this.scanner.currentPosition;
        this.scanner.nextToken();
        Tree pid = this.treeMaker.at(this.scanner.currentPosition).newIdent(this.ident());
        boolean starImport = false;
        while (this.scanner.currentToken == 68 && !starImport) {
            this.scanner.nextToken();
            if (this.scanner.currentToken == 86) {
                pid = this.treeMaker.at(this.scanner.currentPosition).newSelect(pid, Names.star);
                this.scanner.nextToken();
                starImport = true;
                continue;
            }
            pid = this.treeMaker.at(this.scanner.currentPosition).newSelect(pid, this.ident());
        }
        this.accept(66);
        return this.treeMaker.at(pos).newImport(pid);
    }

    private Tree typeDeclaration() {
        int flags = 0;
        if (this.scanner.currentPosition == this.scanner.errorPosition) {
            flags = this.modifiersOpt();
            while (this.scanner.currentToken != 10 && this.scanner.currentToken != 28 && this.scanner.currentToken != 0) {
                this.scanner.nextToken();
                flags = this.modifiersOpt();
            }
        }
        int pos = this.scanner.currentPosition;
        if (this.scanner.currentToken == 66) {
            this.scanner.nextToken();
            return this.treeMaker.at(pos).newBlock(0, Tree.EMPTY_LIST);
        }
        return this.classOrInterfaceDeclaration(flags |= this.modifiersOpt());
    }

    private Tree classOrInterfaceDeclaration(int flags) {
        flags |= this.modifiersOpt();
        if (this.scanner.currentToken == 10) {
            return this.classDeclaration(flags);
        }
        if (this.scanner.currentToken == 28) {
            return this.interfaceDeclaration(flags);
        }
        return this.syntaxError("'class' or 'interface' expected");
    }

    private Tree classDeclaration(int flags) {
        int pos = this.scanner.currentPosition;
        this.accept(10);
        Name name = this.ident();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        Tree extending = null;
        if (this.scanner.currentToken == 17) {
            this.scanner.nextToken();
            extending = this.type();
        }
        List<Tree> implementing = Tree.EMPTY_LIST;
        if (this.scanner.currentToken == 24) {
            this.scanner.nextToken();
            implementing = this.typeList();
        }
        List<Tree> defs = this.classOrInterfaceBody(name, false);
        return this.treeMaker.at(pos).newClassDef(flags, name, typarams, extending, implementing, defs);
    }

    private Tree interfaceDeclaration(int flags) {
        int pos = this.scanner.currentPosition;
        this.accept(28);
        Name name = this.ident();
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        List<Tree> extending = Tree.EMPTY_LIST;
        if (this.scanner.currentToken == 17) {
            this.scanner.nextToken();
            extending = this.typeList();
        }
        List<Tree> defs = this.classOrInterfaceBody(name, true);
        return this.treeMaker.at(pos).newClassDef(flags | 0x200, name, typarams, null, extending, defs);
    }

    private List<Tree> typeList() {
        ListBox<Tree> ts = new ListBox<Tree>();
        ts.insertEnd(this.type());
        while (this.scanner.currentToken == 67) {
            this.scanner.nextToken();
            ts.insertEnd(this.type());
        }
        return ts.toList();
    }

    private List<Tree> classOrInterfaceBody(Name className, boolean isInterface) {
        int pos = this.scanner.currentPosition;
        this.accept(62);
        ListBox<Tree> defs = new ListBox<Tree>();
        while (this.scanner.currentToken != 63 && this.scanner.currentToken != 0) {
            defs.insertEltsEnd(this.classOrInterfaceBodyDeclaration(className, isInterface));
        }
        this.accept(63);
        return defs.toList();
    }

    private List<Tree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
        Tree type;
        boolean isVoid;
        int pos = this.scanner.currentPosition;
        if (this.scanner.currentToken == 66) {
            this.scanner.nextToken();
            return Tree.EMPTY_LIST.cons(this.treeMaker.at(pos).newBlock(0, Tree.EMPTY_LIST));
        }
        int flags = this.modifiersOpt();
        if (this.scanner.currentToken == 10 || this.scanner.currentToken == 28) {
            return Tree.EMPTY_LIST.cons(this.classOrInterfaceDeclaration(flags));
        }
        if (this.scanner.currentToken == 62 && !isInterface && (flags & 0x7FF & 0xFFFFFFF7) == 0) {
            return Tree.EMPTY_LIST.cons(this.block(flags));
        }
        List<Tree.TypeParameter> typarams = this.typeParametersOpt();
        int token = this.scanner.currentToken;
        Name name = this.scanner.name;
        pos = this.scanner.currentPosition;
        boolean bl = isVoid = this.scanner.currentToken == 48;
        if (isVoid) {
            type = this.treeMaker.at(pos).newTypeIdent(9);
            this.scanner.nextToken();
        } else {
            type = this.type();
        }
        if (this.scanner.currentToken == 60 && !isInterface && type.tag == 31) {
            if (isInterface || name != className) {
                this.errorLog.error(pos, "invalid method declaration; return type required");
            }
            return Tree.EMPTY_LIST.cons(this.methodDeclaratorRest(pos, flags, null, Names.init, typarams, isInterface, true));
        }
        pos = this.scanner.currentPosition;
        name = this.ident();
        if (this.scanner.currentToken == 60) {
            return Tree.EMPTY_LIST.cons(this.methodDeclaratorRest(pos, flags, type, name, typarams, isInterface, isVoid));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<Tree> defs = this.variableDeclaratorsRest(pos, flags, type, name, isInterface);
            this.accept(66);
            return defs;
        }
        this.errorLog.error(this.scanner.currentPosition, "'(' expected");
        return Tree.EMPTY_LIST;
    }

    private Tree methodDeclaratorRest(int pos, int flags, Tree type, Name name, List<Tree.TypeParameter> typarams, boolean isInterface, boolean isVoid) {
        Tree.Block body;
        List<Tree.VarDef> params = this.formalParameters();
        if (!isVoid) {
            type = this.bracketsOpt(type);
        }
        List<Tree> thrown = Tree.EMPTY_LIST;
        if (this.scanner.currentToken == 45) {
            this.scanner.nextToken();
            thrown = this.typeList();
        }
        if (this.scanner.currentToken == 62) {
            if (isInterface) {
                this.errorLog.error(this.scanner.currentPosition, "interface methods cannot have body");
            }
            body = this.block();
        } else {
            this.scanner.nextToken();
            body = null;
        }
        return this.treeMaker.at(pos).newMethodDef(flags, name, type, typarams, params, thrown, body);
    }

    private List<Tree.TypeParameter> typeParametersOpt() {
        if (this.scanner.currentToken == 71) {
            ListBox<Tree.TypeParameter> typarams = new ListBox<Tree.TypeParameter>();
            this.scanner.nextToken();
            typarams.insertEnd(this.typeParameter());
            while (this.scanner.currentToken == 67) {
                this.scanner.nextToken();
                typarams.insertEnd(this.typeParameter());
            }
            this.accept(70);
            return typarams.toList();
        }
        return Tree.TypeParameter.emptyList;
    }

    private Tree.TypeParameter typeParameter() {
        int pos = this.scanner.currentPosition;
        Name name = this.ident();
        Tree extBound = null;
        Tree implBound = null;
        if (this.scanner.currentToken == 17) {
            this.scanner.nextToken();
            extBound = this.type();
        } else if (this.scanner.currentToken == 24) {
            this.scanner.nextToken();
            implBound = this.type();
        }
        return this.treeMaker.at(pos).newTypeParameter(name, extBound, implBound);
    }

    private List<Tree.VarDef> formalParameters() {
        ListBox<Tree.VarDef> params = new ListBox<Tree.VarDef>();
        this.accept(60);
        if (this.scanner.currentToken != 61) {
            params.insertEnd(this.formalParameter());
            while (this.scanner.currentToken == 67) {
                this.scanner.nextToken();
                params.insertEnd(this.formalParameter());
            }
        }
        this.accept(61);
        return params.toList();
    }

    private Tree.VarDef formalParameter() {
        int flags = 0;
        if (this.scanner.currentToken == 18) {
            this.scanner.nextToken();
            flags = 16;
        }
        return this.variableDeclaratorId(flags, this.type());
    }

    private Tree checkExprStat(Tree t) {
        switch (t.tag) {
            case 23: 
            case 24: 
            case 26: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return t;
            }
        }
        this.errorLog.error(t.sourcePosition, "not a statement");
        return errorTree;
    }

    private static int prec(int token) {
        int oc = Parser.opcode(token);
        return oc >= 0 ? TreeInspector.opPrec(oc) : -1;
    }

    private static int opcode(int token) {
        switch (token) {
            case 81: {
                return 46;
            }
            case 80: {
                return 47;
            }
            case 89: {
                return 48;
            }
            case 100: {
                return 65;
            }
            case 90: {
                return 49;
            }
            case 101: {
                return 66;
            }
            case 88: {
                return 50;
            }
            case 99: {
                return 67;
            }
            case 76: {
                return 51;
            }
            case 79: {
                return 52;
            }
            case 71: {
                return 53;
            }
            case 70: {
                return 54;
            }
            case 77: {
                return 55;
            }
            case 78: {
                return 56;
            }
            case 92: {
                return 57;
            }
            case 103: {
                return 74;
            }
            case 93: {
                return 58;
            }
            case 104: {
                return 75;
            }
            case 94: {
                return 59;
            }
            case 105: {
                return 76;
            }
            case 84: {
                return 60;
            }
            case 95: {
                return 77;
            }
            case 85: {
                return 61;
            }
            case 96: {
                return 78;
            }
            case 86: {
                return 62;
            }
            case 97: {
                return 79;
            }
            case 87: {
                return 63;
            }
            case 98: {
                return 80;
            }
            case 91: {
                return 64;
            }
            case 102: {
                return 81;
            }
            case 26: {
                return 28;
            }
        }
        return -1;
    }

    private static int unopcode(int token) {
        switch (token) {
            case 84: {
                return 38;
            }
            case 85: {
                return 39;
            }
            case 72: {
                return 40;
            }
            case 73: {
                return 41;
            }
            case 82: {
                return 42;
            }
            case 83: {
                return 43;
            }
        }
        return -1;
    }

    private static int typetag(int token) {
        switch (token) {
            case 6: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 37: {
                return 3;
            }
            case 27: {
                return 4;
            }
            case 29: {
                return 5;
            }
            case 20: {
                return 6;
            }
            case 15: {
                return 7;
            }
            case 4: {
                return 8;
            }
        }
        return -1;
    }
}

