/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.parser;

import edu.rice.cs.nextgen.compiler.parser.Tokens;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.LayoutCharacters;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Position;
import java.io.IOException;
import java.io.InputStream;

public class Scanner
implements Tokens,
LayoutCharacters {
    int currentToken;
    int currentPosition;
    int prevPosition;
    int errorPosition = 0;
    Name name;
    int radix;
    boolean deprecatedFlag = false;
    private char[] literalArray = new char[128];
    private int literalPosition;
    private byte[] inputChars;
    private int inputPosition;
    private int endPosition;
    private char currentChar;
    private int currentLine;
    private int currentColumn;
    private static byte[] keywordArray;
    private static int lastEnteredKeyword;
    private int lastEscape;
    ErrorLog errorLog;
    private static Name[] tokenName;

    public Scanner(InputStream in, ErrorLog log) {
        this.errorLog = log;
        try {
            this.inputChars = new byte[in.available() + 1];
            if (in.read(this.inputChars) != this.inputChars.length - 1) {
                throw new IOException("read error");
            }
        }
        catch (IOException e) {
            this.lexError(e.toString());
            this.inputChars = new byte[1];
        }
        this.endPosition = this.inputChars.length - 1;
        this.inputChars[this.endPosition] = 0;
        this.currentLine = 1;
        this.currentColumn = 0;
        this.inputPosition = -1;
        this.lastEscape = -1;
        this.scanChar();
        this.nextToken();
    }

    private void lexError(int pos, String msg) {
        this.errorLog.error(pos, msg);
        this.currentToken = 1;
        this.errorPosition = pos;
    }

    private void lexError(String msg) {
        this.lexError(this.currentPosition, msg);
    }

    private void convertUnicode() {
        int startcol = this.currentColumn++;
        if (this.currentChar == '\\') {
            this.currentChar = (char)this.inputChars[++this.inputPosition];
            if (this.currentChar == 'u') {
                do {
                    this.currentChar = (char)this.inputChars[++this.inputPosition];
                    ++this.currentColumn;
                } while (this.currentChar == 'u');
                int limit = this.inputPosition + 3;
                if (limit < this.endPosition) {
                    int d;
                    int code = d = Character.digit(this.currentChar, 16);
                    while (this.inputPosition < limit && d >= 0) {
                        this.currentChar = (char)this.inputChars[++this.inputPosition];
                        ++this.currentColumn;
                        d = Character.digit(this.currentChar, 16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.currentChar = (char)code;
                        this.lastEscape = this.inputPosition;
                        return;
                    }
                }
                this.lexError(Position.make(this.currentLine, startcol), "illegal unicode escape");
            } else {
                --this.inputPosition;
                this.currentChar = (char)92;
            }
        }
    }

    private void scanChar() {
        this.currentChar = (char)this.inputChars[++this.inputPosition];
        ++this.currentColumn;
        if (this.currentChar == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        this.currentChar = (char)this.inputChars[++this.inputPosition];
        ++this.currentColumn;
        if (this.currentChar == '\\') {
            if (this.inputChars[this.inputPosition + 1] == 92) {
                ++this.inputPosition;
                ++this.currentColumn;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char ch) {
        if (this.literalPosition == this.literalArray.length) {
            char[] newsbuf = new char[this.literalArray.length * 2];
            System.arraycopy(this.literalArray, 0, newsbuf, 0, this.literalArray.length);
            this.literalArray = newsbuf;
        }
        this.literalArray[this.literalPosition++] = ch;
    }

    private void dch() {
        System.err.print(this.currentChar);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.currentChar == '\\') {
            if (this.inputChars[this.inputPosition + 1] == 92) {
                ++this.inputPosition;
                ++this.currentColumn;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.currentChar) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.currentChar;
                        int oct = Character.digit(this.currentChar, 8);
                        this.scanChar();
                        if ('0' <= this.currentChar && this.currentChar <= '7') {
                            oct = oct * 8 + Character.digit(this.currentChar, 8);
                            this.scanChar();
                            if (leadch <= '3' && '0' <= this.currentChar && this.currentChar <= '7') {
                                oct = oct * 8 + Character.digit(this.currentChar, 8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(Position.make(this.currentLine, this.currentColumn), "illegal escape character");
                        break;
                    }
                }
            }
        } else if (this.inputPosition != this.endPosition) {
            this.putChar(this.currentChar);
            this.scanChar();
        }
    }

    private void scanFraction() {
        while (Character.digit(this.currentChar, 10) >= 0) {
            this.putChar(this.currentChar);
            this.scanChar();
        }
        int sp1 = this.literalPosition;
        if (this.currentChar == 'e' || this.currentChar == 'E') {
            this.putChar(this.currentChar);
            this.scanChar();
            if (this.currentChar == '+' || this.currentChar == '-') {
                this.putChar(this.currentChar);
                this.scanChar();
            }
            if ('0' <= this.currentChar && this.currentChar <= '9') {
                do {
                    this.putChar(this.currentChar);
                    this.scanChar();
                } while ('0' <= this.currentChar && this.currentChar <= '9');
                return;
            }
            this.lexError("malformed floating point literal");
            this.literalPosition = sp1;
        }
    }

    private void scanFractionAndSuffix() {
        this.scanFraction();
        if (this.currentChar == 'f' || this.currentChar == 'F') {
            this.scanChar();
            this.currentToken = 53;
        } else {
            if (this.currentChar == 'd' || this.currentChar == 'D') {
                this.scanChar();
            }
            this.currentToken = 54;
        }
    }

    private void scanNumber(int radix) {
        this.radix = radix;
        while (Character.digit(this.currentChar, radix == 8 ? 10 : radix) >= 0) {
            this.putChar(this.currentChar);
            this.scanChar();
        }
        if (radix <= 10 && this.currentChar == '.') {
            this.putChar(this.currentChar);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (radix <= 10 && (this.currentChar == 'e' || this.currentChar == 'E' || this.currentChar == 'f' || this.currentChar == 'F' || this.currentChar == 'd' || this.currentChar == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.currentChar == 'l' || this.currentChar == 'L') {
            this.scanChar();
            this.currentToken = 52;
        } else {
            this.currentToken = 51;
        }
    }

    private void scanIdent() {
        int start = this.inputPosition;
        boolean escaped = false;
        block3: while (true) {
            if (this.lastEscape >= start) {
                if (!escaped) {
                    for (int i = 0; i < this.literalPosition; ++i) {
                        this.literalArray[i] = (char)this.inputChars[start + i];
                    }
                    escaped = true;
                }
                this.putChar(this.currentChar);
            } else {
                ++this.literalPosition;
            }
            this.currentChar = (char)this.inputChars[++this.inputPosition];
            ++this.currentColumn;
            if (this.currentChar == '\\') {
                this.convertUnicode();
            }
            switch (this.currentChar) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
            }
            if (this.currentChar <= '\u0080' || !Character.isJavaIdentifierPart(this.currentChar)) break;
        }
        this.name = escaped ? Name.fromChars(this.literalArray, 0, this.literalPosition) : Name.fromUtf(this.inputChars, start, this.literalPosition);
        this.currentToken = this.name.index <= lastEnteredKeyword ? keywordArray[this.name.index] : 2;
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.currentChar);
            Name newname = Name.fromChars(this.literalArray, 0, this.literalPosition);
            if (newname.index > lastEnteredKeyword || keywordArray[newname.index] == 2) {
                --this.literalPosition;
                break;
            }
            this.name = newname;
            this.currentToken = keywordArray[newname.index];
            this.scanChar();
        } while (this.isSpecial(this.currentChar));
    }

    private void scanDocCommentTag() {
        int start = this.inputPosition + 1;
        do {
            this.scanCommentChar();
        } while ('a' <= this.currentChar && this.currentChar <= 'z');
        if (Name.fromUtf(this.inputChars, start, this.inputPosition - start) == Names.deprecated) {
            this.deprecatedFlag = true;
        }
    }

    private void skipComment() {
        this.scanCommentChar();
        boolean docComment = this.currentChar == '*';
        boolean linestart = true;
        boolean starseen = true;
        block8: while (true) {
            switch (this.currentChar) {
                case ' ': {
                    this.currentChar = (char)this.inputChars[++this.inputPosition];
                    ++this.currentColumn;
                    if (this.currentChar != '\\') continue block8;
                    if (this.inputChars[this.inputPosition + 1] == 92) {
                        ++this.inputPosition;
                        ++this.currentColumn;
                        continue block8;
                    }
                    this.convertUnicode();
                    continue block8;
                }
                case '\t': {
                    this.currentColumn = (this.currentColumn - 1) / 8 * 8 + 8;
                    this.scanCommentChar();
                    continue block8;
                }
                case '\f': {
                    this.currentColumn = 0;
                    this.scanCommentChar();
                    continue block8;
                }
                case '\r': {
                    ++this.currentLine;
                    this.currentColumn = 0;
                    this.scanCommentChar();
                    if (this.currentChar == '\n') {
                        this.currentColumn = 0;
                        this.scanCommentChar();
                    }
                    linestart = true;
                    starseen = false;
                    continue block8;
                }
                case '\n': {
                    ++this.currentLine;
                    this.currentColumn = 0;
                    this.scanCommentChar();
                    linestart = true;
                    starseen = false;
                    continue block8;
                }
                case '*': {
                    break;
                }
                default: {
                    if (this.currentChar == '@' && linestart && starseen) {
                        this.scanDocCommentTag();
                    } else {
                        if (this.inputPosition >= this.endPosition) break;
                        this.currentChar = (char)this.inputChars[++this.inputPosition];
                        ++this.currentColumn;
                        if (this.currentChar == '\\') {
                            if (this.inputChars[this.inputPosition + 1] == 92) {
                                ++this.inputPosition;
                                ++this.currentColumn;
                            } else {
                                this.convertUnicode();
                            }
                        }
                    }
                    linestart = false;
                    continue block8;
                }
            }
            starseen = true;
            while (this.currentChar == '*') {
                this.scanCommentChar();
            }
            if (this.currentChar == '/' || this.inputPosition >= this.endPosition) break;
        }
    }

    public String stringVal() {
        return new String(this.literalArray, 0, this.literalPosition);
    }

    public void nextToken() {
        this.prevPosition = (this.currentLine << 10) + this.currentColumn;
        this.literalPosition = 0;
        block22: while (true) {
            this.currentPosition = (this.currentLine << 10) + this.currentColumn;
            int start = this.inputPosition++;
            switch (this.currentChar) {
                case ' ': {
                    this.currentChar = (char)this.inputChars[this.inputPosition];
                    ++this.currentColumn;
                    if (this.currentChar != '\\') continue block22;
                    this.convertUnicode();
                    break;
                }
                case '\t': {
                    this.currentColumn = (this.currentColumn - 1) / 8 * 8 + 8;
                    this.scanChar();
                    break;
                }
                case '\f': {
                    this.currentColumn = 0;
                    this.scanChar();
                    break;
                }
                case '\r': {
                    ++this.currentLine;
                    this.currentColumn = 0;
                    this.scanChar();
                    if (this.currentChar != '\n') continue block22;
                    this.currentColumn = 0;
                    this.scanChar();
                    break;
                }
                case '\n': {
                    ++this.currentLine;
                    this.currentColumn = 0;
                    this.scanChar();
                    break;
                }
                case '$': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.scanIdent();
                    return;
                }
                case '0': {
                    this.scanChar();
                    if (this.currentChar == 'x' || this.currentChar == 'X') {
                        this.scanChar();
                        this.scanNumber(16);
                    } else {
                        this.putChar('0');
                        this.scanNumber(8);
                    }
                    return;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber(10);
                    return;
                }
                case '.': {
                    this.scanChar();
                    if ('0' <= this.currentChar && this.currentChar <= '9') {
                        this.putChar('.');
                        this.scanFractionAndSuffix();
                    } else {
                        this.currentToken = 68;
                    }
                    return;
                }
                case ',': {
                    this.scanChar();
                    this.currentToken = 67;
                    return;
                }
                case ';': {
                    this.scanChar();
                    this.currentToken = 66;
                    return;
                }
                case '(': {
                    this.scanChar();
                    this.currentToken = 60;
                    return;
                }
                case ')': {
                    this.scanChar();
                    this.currentToken = 61;
                    return;
                }
                case '[': {
                    this.scanChar();
                    this.currentToken = 64;
                    return;
                }
                case ']': {
                    this.scanChar();
                    this.currentToken = 65;
                    return;
                }
                case '{': {
                    this.scanChar();
                    this.currentToken = 62;
                    return;
                }
                case '}': {
                    this.scanChar();
                    this.currentToken = 63;
                    return;
                }
                case '/': {
                    this.scanChar();
                    if (this.currentChar == '/') {
                        do {
                            this.currentChar = (char)this.inputChars[++this.inputPosition];
                            ++this.currentColumn;
                            if (this.currentChar == '\\') {
                                if (this.inputChars[this.inputPosition + 1] == 92) {
                                    ++this.inputPosition;
                                    ++this.currentColumn;
                                } else {
                                    this.convertUnicode();
                                }
                            }
                            if (this.currentChar == '\r' || this.currentChar == '\n') continue block22;
                        } while (this.inputPosition < this.endPosition);
                        break;
                    }
                    if (this.currentChar == '*') {
                        this.skipComment();
                        if (this.currentChar == '/') {
                            this.scanChar();
                            break;
                        }
                        this.lexError("unclosed comment");
                        return;
                    }
                    if (this.currentChar == '=') {
                        this.name = Names.slashequals;
                        this.currentToken = 98;
                        this.scanChar();
                    } else {
                        this.name = Names.slash;
                        this.currentToken = 87;
                    }
                    return;
                }
                case '\'': {
                    this.scanChar();
                    if (this.currentChar == '\'') {
                        this.lexError("empty character literal");
                    } else {
                        this.scanLitChar();
                        if (this.currentChar == '\'') {
                            this.scanChar();
                            this.currentToken = 55;
                        } else {
                            this.lexError("unclosed character literal");
                        }
                    }
                    return;
                }
                case '\"': {
                    this.scanChar();
                    while (this.currentChar != '\"' && this.currentChar != '\r' && this.currentChar != '\n' && this.inputPosition < this.endPosition) {
                        this.scanLitChar();
                    }
                    if (this.currentChar == '\"') {
                        this.currentToken = 56;
                        this.scanChar();
                    } else {
                        this.lexError(this.currentPosition, "unclosed string literal");
                    }
                    return;
                }
                default: {
                    if (this.isSpecial(this.currentChar)) {
                        this.scanOperator();
                    } else if (Character.isJavaIdentifierStart(this.currentChar)) {
                        this.scanIdent();
                    } else if (this.inputPosition == this.endPosition) {
                        this.currentToken = 0;
                    } else {
                        this.lexError("illegal character");
                        this.scanChar();
                    }
                    return;
                }
            }
        }
    }

    String token2string(int token) {
        switch (token) {
            case 2: {
                return "<identifier>";
            }
            case 55: {
                return "<character>";
            }
            case 56: {
                return "<string>";
            }
            case 51: {
                return "<integer>";
            }
            case 52: {
                return "<long integer>";
            }
            case 53: {
                return "<float>";
            }
            case 54: {
                return "<double>";
            }
            case 68: {
                return "'.'";
            }
            case 67: {
                return "','";
            }
            case 66: {
                return "';'";
            }
            case 60: {
                return "'('";
            }
            case 61: {
                return "')'";
            }
            case 64: {
                return "'['";
            }
            case 65: {
                return "']'";
            }
            case 62: {
                return "'{'";
            }
            case 63: {
                return "'}'";
            }
            case 1: {
                return "<bad symbol>";
            }
            case 0: {
                return "<end of input>";
            }
        }
        return tokenName[token].toString();
    }

    private static void enterKeyword(String s, int token) {
        Name n;
        Scanner.tokenName[token] = n = Name.fromString(s);
        if (n.index > lastEnteredKeyword) {
            lastEnteredKeyword = n.index;
        }
    }

    static {
        int j;
        lastEnteredKeyword = 0;
        tokenName = new Name[106];
        for (j = 0; j < 106; ++j) {
            Scanner.tokenName[j] = null;
        }
        Scanner.enterKeyword("+", 84);
        Scanner.enterKeyword("-", 85);
        Scanner.enterKeyword("!", 72);
        Scanner.enterKeyword("%", 91);
        Scanner.enterKeyword("^", 90);
        Scanner.enterKeyword("&", 88);
        Scanner.enterKeyword("*", 86);
        Scanner.enterKeyword("|", 89);
        Scanner.enterKeyword("~", 73);
        Scanner.enterKeyword("/", 87);
        Scanner.enterKeyword(">", 70);
        Scanner.enterKeyword("<", 71);
        Scanner.enterKeyword("?", 74);
        Scanner.enterKeyword(":", 75);
        Scanner.enterKeyword("=", 69);
        Scanner.enterKeyword("++", 82);
        Scanner.enterKeyword("--", 83);
        Scanner.enterKeyword("==", 76);
        Scanner.enterKeyword("<=", 77);
        Scanner.enterKeyword(">=", 78);
        Scanner.enterKeyword("!=", 79);
        Scanner.enterKeyword("<<", 92);
        Scanner.enterKeyword(">>", 93);
        Scanner.enterKeyword(">>>", 94);
        Scanner.enterKeyword("+=", 95);
        Scanner.enterKeyword("-=", 96);
        Scanner.enterKeyword("*=", 97);
        Scanner.enterKeyword("/=", 98);
        Scanner.enterKeyword("&=", 99);
        Scanner.enterKeyword("|=", 100);
        Scanner.enterKeyword("^=", 101);
        Scanner.enterKeyword("%=", 102);
        Scanner.enterKeyword("<<=", 103);
        Scanner.enterKeyword(">>=", 104);
        Scanner.enterKeyword(">>>=", 105);
        Scanner.enterKeyword("||", 81);
        Scanner.enterKeyword("&&", 80);
        Scanner.enterKeyword("abstract", 3);
        Scanner.enterKeyword("boolean", 4);
        Scanner.enterKeyword("break", 5);
        Scanner.enterKeyword("byte", 6);
        Scanner.enterKeyword("case", 7);
        Scanner.enterKeyword("catch", 8);
        Scanner.enterKeyword("char", 9);
        Scanner.enterKeyword("class", 10);
        Scanner.enterKeyword("const", 11);
        Scanner.enterKeyword("continue", 12);
        Scanner.enterKeyword("default", 13);
        Scanner.enterKeyword("do", 14);
        Scanner.enterKeyword("double", 15);
        Scanner.enterKeyword("else", 16);
        Scanner.enterKeyword("extends", 17);
        Scanner.enterKeyword("final", 18);
        Scanner.enterKeyword("finally", 19);
        Scanner.enterKeyword("float", 20);
        Scanner.enterKeyword("for", 21);
        Scanner.enterKeyword("goto", 22);
        Scanner.enterKeyword("if", 23);
        Scanner.enterKeyword("implements", 24);
        Scanner.enterKeyword("import", 25);
        Scanner.enterKeyword("instanceof", 26);
        Scanner.enterKeyword("int", 27);
        Scanner.enterKeyword("interface", 28);
        Scanner.enterKeyword("long", 29);
        Scanner.enterKeyword("native", 30);
        Scanner.enterKeyword("new", 31);
        Scanner.enterKeyword("package", 32);
        Scanner.enterKeyword("private", 33);
        Scanner.enterKeyword("protected", 34);
        Scanner.enterKeyword("public", 35);
        Scanner.enterKeyword("return", 36);
        Scanner.enterKeyword("short", 37);
        Scanner.enterKeyword("static", 38);
        Scanner.enterKeyword("strictfp", 39);
        Scanner.enterKeyword("super", 40);
        Scanner.enterKeyword("switch", 41);
        Scanner.enterKeyword("synchronized", 42);
        Scanner.enterKeyword("this", 43);
        Scanner.enterKeyword("throw", 44);
        Scanner.enterKeyword("throws", 45);
        Scanner.enterKeyword("transient", 46);
        Scanner.enterKeyword("try", 47);
        Scanner.enterKeyword("void", 48);
        Scanner.enterKeyword("volatile", 49);
        Scanner.enterKeyword("while", 50);
        Scanner.enterKeyword("true", 57);
        Scanner.enterKeyword("false", 58);
        Scanner.enterKeyword("null", 59);
        keywordArray = new byte[lastEnteredKeyword + 1];
        for (int i = 0; i <= lastEnteredKeyword; ++i) {
            Scanner.keywordArray[i] = 2;
        }
        for (j = 0; j < 106; j = (int)((byte)(j + 1))) {
            if (tokenName[j] == null) continue;
            Scanner.keywordArray[Scanner.tokenName[j].index] = j;
        }
    }
}

