/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.tree;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import java.io.PrintStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrettyPrinter
extends Tree.Visitor<Void, Integer>
implements Flags {
    PrintStream outputStream = System.out;
    static Integer[] Precedence = new Integer[16];
    public int width = 3;
    int lmargin = 0;
    Name enclClassName = null;

    public PrettyPrinter(PrintStream out) {
        this.outputStream = out;
    }

    public PrettyPrinter() {
        this(System.out);
    }

    void align() {
        for (int i = 0; i < this.lmargin; ++i) {
            this.outputStream.print(" ");
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(Integer contextPrec, int ownPrec) {
        if (ownPrec < contextPrec) {
            this.outputStream.print("(");
        }
    }

    void close(Integer contextPrec, int ownPrec) {
        if (ownPrec < contextPrec) {
            this.outputStream.print(")");
        }
    }

    public void print(String s) {
        this.outputStream.print(Converter.escapeUnicode(s));
    }

    public void println() {
        this.outputStream.println();
    }

    public void printExpr(Tree tree, int prec) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            tree.accept(this, Precedence[prec]);
        }
    }

    public void printExpr(Tree tree) {
        this.printExpr(tree, 0);
    }

    public void printStat(Tree tree) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            tree.accept(this, null);
        }
    }

    public <T extends Tree> void printExprs(List<T> trees) {
        if (trees.nonEmpty()) {
            this.printExpr((Tree)trees.getFirst());
            List<T> l = trees.getRest();
            while (l.nonEmpty()) {
                this.print(", ");
                this.printExpr((Tree)l.getFirst());
                l = l.getRest();
            }
        }
    }

    public <T extends Tree> void printStats(List<T> trees) {
        List<T> l = trees;
        while (l.nonEmpty()) {
            this.align();
            this.printStat((Tree)l.getFirst());
            this.println();
            l = l.getRest();
        }
    }

    public void printFlags(int flags) {
        if ((flags & 0x10000) != 0) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInspector.flagNames(flags));
        if ((flags & 0x7FF) != 0) {
            this.print(" ");
        }
    }

    public void printTypeParameters(List<Tree.TypeParameter> trees) {
        if (trees.nonEmpty()) {
            this.print("<");
            this.printExprs(trees);
            this.print(">");
        }
    }

    public void printBlock(List<Tree> stats) {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(stats);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printUnit(Tree.TopLevel tree, Tree.ClassDef cdef) {
        if (tree.packageId != null) {
            this.print("package ");
            this.printExpr(tree.packageId);
            this.print(";");
            this.println();
        }
        List<Tree> l = tree.members;
        while (l.nonEmpty() && (cdef == null || l.getFirst().tag == 2)) {
            this.printStat(l.getFirst());
            this.println();
            l = l.getRest();
        }
        if (cdef != null) {
            this.printStat(cdef);
            this.println();
        }
    }

    @Override
    public Void _case(Tree.TopLevel tree, Integer prec) {
        this.printUnit(tree, null);
        return null;
    }

    @Override
    public Void _case(Tree.Import tree, Integer prec) {
        this.print("import ");
        this.printExpr(tree.importedClass);
        this.print(";");
        this.println();
        return null;
    }

    @Override
    public Void _case(Tree.ClassDef tree, Integer prec) {
        this.printFlags(tree.flags & 0xFFFFFDFF);
        Name enclClassNamePrev = this.enclClassName;
        this.enclClassName = tree.name;
        if ((tree.flags & 0x200) != 0) {
            this.print(new StringBuffer().append("interface ").append(tree.name).toString());
            this.printTypeParameters(tree.typeParams);
            if (tree.implementedInterfaces.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(tree.implementedInterfaces);
            }
        } else {
            this.print(new StringBuffer().append("class ").append(tree.name).toString());
            this.printTypeParameters(tree.typeParams);
            if (tree.extendedClass != null) {
                this.print(" extends ");
                this.printExpr(tree.extendedClass);
            }
            if (tree.implementedInterfaces.nonEmpty()) {
                this.print(" implements ");
                this.printExprs(tree.implementedInterfaces);
            }
        }
        this.print(" ");
        this.printBlock(tree.members);
        this.enclClassName = enclClassNamePrev;
        return null;
    }

    @Override
    public Void _case(Tree.MethodDef tree, Integer prec) {
        this.printFlags(tree.flags);
        if (tree.name == Names.init) {
            Name cname = this.enclClassName;
            this.print(cname == null ? "<init>" : cname.toString());
        } else {
            this.printExpr(tree.returnType);
            this.print(new StringBuffer().append(" ").append(tree.name).toString());
        }
        this.printTypeParameters(tree.typeParams);
        this.print("(");
        this.printExprs(tree.params);
        this.print(")");
        if (tree.thrown.nonEmpty()) {
            this.print(" throws ");
            this.printExprs(tree.thrown);
        }
        if (tree.body != null) {
            this.print(" ");
            this.printStat(tree.body);
        } else {
            this.print(";");
        }
        return null;
    }

    @Override
    public Void _case(Tree.VarDef tree, Integer prec) {
        this.printFlags(tree.flags);
        this.printExpr(tree.varType);
        this.print(new StringBuffer().append(" ").append(tree.name).toString());
        if (tree.initialization != null) {
            this.print(" = ");
            this.printExpr(tree.initialization);
        }
        if (prec == null) {
            this.print(";");
        }
        return null;
    }

    @Override
    public Void _case(Tree.Block tree, Integer prec) {
        this.printBlock(tree.statements);
        return null;
    }

    @Override
    public Void _case(Tree.DoLoop tree, Integer prec) {
        this.print("do ");
        this.printStat(tree.body);
        this.align();
        this.print(" while (");
        this.printExpr(tree.cond);
        this.print(");");
        return null;
    }

    @Override
    public Void _case(Tree.WhileLoop tree, Integer prec) {
        this.print("while (");
        this.printExpr(tree.condition);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.ForLoop tree, Integer prec) {
        this.print("for (");
        if (tree.initializations.nonEmpty()) {
            if (tree.initializations.getFirst().tag == 5) {
                this.printExpr(tree.initializations.getFirst());
                List<Tree> l = tree.initializations.getRest();
                while (l.nonEmpty()) {
                    Tree.VarDef vdef = (Tree.VarDef)l.getFirst();
                    this.print(new StringBuffer().append(", ").append(vdef.name).append(" = ").toString());
                    this.printExpr(vdef.initialization);
                    l = l.getRest();
                }
            } else {
                this.printExprs(tree.initializations);
            }
        }
        this.print("; ");
        if (tree.conditions != null) {
            this.printExpr(tree.conditions);
        }
        this.print("; ");
        this.printExprs(tree.incrementations);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Labelled tree, Integer prec) {
        this.print(new StringBuffer().append(tree.label).append(": ").toString());
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Switch tree, Integer prec) {
        this.print("switch (");
        this.printExpr(tree.selector);
        this.print(") {\n");
        this.printStats(tree.cases);
        this.align();
        this.print("}");
        return null;
    }

    @Override
    public Void _case(Tree.Case tree, Integer prec) {
        if (tree.pattern == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printExpr(tree.pattern);
        }
        this.print(": \n");
        this.indent();
        this.printStats(tree.statements);
        this.undent();
        this.align();
        return null;
    }

    @Override
    public Void _case(Tree.Synchronized tree, Integer prec) {
        this.print("synchronized (");
        this.printExpr(tree.lockedObject);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Try tree, Integer prec) {
        this.print("try ");
        this.printStat(tree.body);
        this.print(" ");
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            this.printStat(l.getFirst());
            l = l.getRest();
        }
        if (tree.finalizer != null) {
            this.print(" finally ");
            this.printStat(tree.finalizer);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Catch tree, Integer prec) {
        this.print(" catch (");
        this.printExpr(tree.param);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Conditional tree, Integer prec) {
        if (tree.tag == 17) {
            this.print("if (");
            this.printExpr(tree.condition);
            this.print(") ");
            this.printStat(tree.thenClause);
            if (tree.elseClause != null) {
                this.print(" else ");
                this.printStat(tree.elseClause);
            }
        } else {
            this.open(prec, 3);
            this.printExpr(tree.condition, 3);
            this.print(" ? ");
            this.printExpr(tree.thenClause, 3);
            this.print(" : ");
            this.printExpr(tree.elseClause, 3);
            this.close(prec, 3);
        }
        return null;
    }

    @Override
    public Void _case(Tree.ExpressionStatement tree, Integer prec) {
        this.printExpr(tree.expression);
        if (prec == null) {
            this.print(";");
        }
        return null;
    }

    @Override
    public Void _case(Tree.Break tree, Integer prec) {
        this.print("break");
        if (tree.label != null) {
            this.print(new StringBuffer().append(" ").append(tree.label).toString());
        }
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Continue tree, Integer prec) {
        this.print("continue");
        if (tree.label != null) {
            this.print(new StringBuffer().append(" ").append(tree.label).toString());
        }
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Return tree, Integer prec) {
        this.print("return");
        if (tree.expression != null) {
            this.print(" ");
            this.printExpr(tree.expression);
        }
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Throw tree, Integer prec) {
        this.print("throw ");
        this.printExpr(tree.expression);
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Apply tree, Integer prec) {
        this.printExpr(tree.method);
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
        return null;
    }

    @Override
    public Void _case(Tree.NewInstance tree, Integer prec) {
        if (tree.enclosingClassPrefix != null) {
            this.printExpr(tree.enclosingClassPrefix);
            this.print(".");
        }
        this.print("new ");
        this.printExpr(tree._class);
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
        if (tree.anonymousClassDef != null) {
            this.printBlock(tree.anonymousClassDef.members);
        }
        return null;
    }

    @Override
    public Void _case(Tree.NewArray tree, Integer prec) {
        if (tree.elementType != null) {
            this.print("new ");
            int n = 0;
            Tree elemtype = tree.elementType;
            while (elemtype.tag == 34) {
                ++n;
                elemtype = ((Tree.ArrayTypeExpression)elemtype).elementType;
            }
            this.printExpr(elemtype);
            List<Tree> l = tree.dimensions;
            while (l.nonEmpty()) {
                this.print("[");
                this.printExpr(l.getFirst());
                this.print("]");
                l = l.getRest();
            }
            for (int i = 0; i < n; ++i) {
                this.print("[]");
            }
            if (tree.elements != null) {
                this.print("[]");
            }
        }
        if (tree.elements != null) {
            this.print("{");
            this.printExprs(tree.elements);
            this.print("}");
        }
        return null;
    }

    @Override
    public Void _case(Tree.Assign tree, Integer prec) {
        this.open(prec, 1);
        this.printExpr(tree.lhs, 2);
        this.print(" = ");
        this.printExpr(tree.rhs, 1);
        this.close(prec, 1);
        return null;
    }

    @Override
    public Void _case(Tree.AssignOp tree, Integer prec) {
        this.open(prec, 2);
        this.printExpr(tree.lhs, 3);
        this.print(new StringBuffer().append(" ").append(TreeInspector.operatorName(tree.tag - 17)).append("= ").toString());
        this.printExpr(tree.rhs, 2);
        this.close(prec, 2);
        return null;
    }

    @Override
    public Void _case(Tree.Operation tree, Integer prec) {
        int ownprec = TreeInspector.opPrec(tree.tag);
        String opname = TreeInspector.operatorName(tree.tag).toString();
        this.open(prec, ownprec);
        if (tree.tag <= 43) {
            this.printExpr(tree.args.getFirst(), ownprec);
        } else if (tree.tag <= 45) {
            this.printExpr(tree.args.getFirst(), ownprec);
            this.print(opname);
        } else {
            this.printExpr(tree.args.getFirst(), ownprec);
            this.print(new StringBuffer().append(" ").append(opname).append(" ").toString());
            this.printExpr(tree.args.getRest().getFirst(), ownprec + 1);
        }
        this.close(prec, ownprec);
        return null;
    }

    @Override
    public Void _case(Tree.TypeCast tree, Integer prec) {
        this.open(prec, 14);
        this.print("(");
        this.printExpr(tree.castType);
        this.print(")");
        this.printExpr(tree.expression, 14);
        this.close(prec, 14);
        return null;
    }

    @Override
    public Void _case(Tree.InstanceofTest tree, Integer prec) {
        this.open(prec, 10);
        this.printExpr(tree.expression, 10);
        this.print(" instanceof ");
        this.printExpr(tree.testedType, 11);
        return null;
    }

    @Override
    public Void _case(Tree.IndexedArrayElement tree, Integer prec) {
        this.printExpr(tree.indexedArray, 15);
        this.print("[");
        this.printExpr(tree.index);
        this.print("]");
        return null;
    }

    @Override
    public Void _case(Tree.Select tree, Integer prec) {
        this.printExpr(tree.selected, 15);
        this.print(new StringBuffer().append(".").append(tree.name).toString());
        return null;
    }

    @Override
    public Void _case(Tree.Ident tree, Integer prec) {
        this.print(tree.name.toString());
        return null;
    }

    @Override
    public Void _case(Tree.Literal tree, Integer prec) {
        switch (tree.typeTag) {
            case 4: {
                this.print(tree.value.toString());
                break;
            }
            case 5: {
                this.print(new StringBuffer().append(tree.value.toString()).append("L").toString());
                break;
            }
            case 6: {
                this.print(new StringBuffer().append(tree.value.toString()).append("F").toString());
                break;
            }
            case 7: {
                this.print(tree.value.toString());
                break;
            }
            case 2: {
                this.print(new StringBuffer().append("'").append(Converter.quote(String.valueOf((char)((Number)tree.value).intValue()))).append("'").toString());
                break;
            }
            case 10: {
                this.print(new StringBuffer().append("\"").append(Converter.quote((String)tree.value)).append("\"").toString());
                break;
            }
            default: {
                this.print(tree.value.toString());
            }
        }
        return null;
    }

    @Override
    public Void _case(Tree.TypeIdent tree, Integer prec) {
        this.print(Type.TYPES_OF_TAGS[tree.typeTag].typeSymbol.name.toString());
        return null;
    }

    @Override
    public Void _case(Tree.ArrayTypeExpression tree, Integer prec) {
        this.printExpr(tree.elementType);
        this.print("[]");
        return null;
    }

    @Override
    public Void _case(Tree.TypeApply tree, Integer prec) {
        this.printExpr(tree._class);
        this.print("<");
        this.printExprs(tree.arguments);
        this.print(">");
        return null;
    }

    @Override
    public Void _case(Tree.TypeParameter tree, Integer prec) {
        this.print(tree.name.toString());
        if (tree.extendsBound != null) {
            this.print(" extends ");
            this.printExpr(tree.extendsBound);
        } else if (tree.implementsBound != null) {
            this.print(" implements ");
            this.printExpr(tree.implementsBound);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Erroneous tree, Integer prec) {
        this.print("(ERROR)");
        return null;
    }

    @Override
    public Void _case(Tree tree, Integer prec) {
        this.print(new StringBuffer().append("(UNKNOWN: ").append(tree).append(")").toString());
        this.println();
        return null;
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            PrettyPrinter.Precedence[i] = new Integer(i);
        }
    }
}

