/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Asserter;

public class Bits {
    static final int wordLength = 32;
    static final int wordShiftLength = 5;
    static final int wordMaskLength = 31;
    private int[] bits;

    public Bits() {
        this(new int[1]);
    }

    public Bits(int[] bits) {
        this.bits = bits;
    }

    public Bits(int start, int limit) {
        this();
        this.includeRange(start, limit);
    }

    private void sizeTo(int len) {
        if (this.bits.length < len) {
            int[] newbits = new int[len];
            System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
            this.bits = newbits;
        }
    }

    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public Bits copy() {
        int[] newbits = new int[this.bits.length];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        return new Bits(newbits);
    }

    public void include(int x) {
        Asserter._assert(x >= 0);
        this.sizeTo((x >>> 5) + 1);
        this.bits[x >>> 5] = this.bits[x >>> 5] | 1 << (x & 0x1F);
    }

    public void includeRange(int start, int limit) {
        this.sizeTo((limit >>> 5) + 1);
        for (int x = start; x < limit; ++x) {
            this.bits[x >>> 5] = this.bits[x >>> 5] | 1 << (x & 0x1F);
        }
    }

    public void exclude(int x) {
        Asserter._assert(x >= 0);
        this.sizeTo((x >>> 5) + 1);
        this.bits[x >>> 5] = this.bits[x >>> 5] & ~(1 << (x & 0x1F));
    }

    public boolean isMember(int x) {
        return 0 <= x && x < this.bits.length << 5 && (this.bits[x >>> 5] & 1 << (x & 0x1F)) != 0;
    }

    public Bits andSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        for (int i = 0; i < xs.bits.length; ++i) {
            this.bits[i] = this.bits[i] & xs.bits[i];
        }
        return this;
    }

    public Bits orSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        for (int i = 0; i < xs.bits.length; ++i) {
            this.bits[i] = this.bits[i] | xs.bits[i];
        }
        return this;
    }

    public String toString() {
        char[] digits = new char[this.bits.length * 32];
        for (int i = 0; i < this.bits.length * 32; ++i) {
            digits[i] = this.isMember(i) ? 49 : 48;
        }
        return new String(digits);
    }
}

