/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.ByteBuffer;
import edu.rice.cs.nextgen.compiler.util.Name;
import junit.framework.TestCase;

public class ByteBufferTest
extends TestCase {
    public ByteBufferTest(String name) {
        super(name);
    }

    public void testAppendByte() {
        ByteBuffer b = new ByteBuffer();
        b.appendByte(100);
        ByteBufferTest.assertEquals((String)"Byte not appended properly.", (String)"d", (String)b.toName().toString());
    }

    public void testAppendBytes() {
        byte[] bytes = new byte[]{116, 101, 115, 116};
        ByteBuffer b = new ByteBuffer();
        b.appendBytes(bytes);
        ByteBufferTest.assertEquals((String)"Byte array not appended properly.", (String)"test", (String)b.toName().toString());
    }

    public void testAppendChar() {
        ByteBuffer b = new ByteBuffer();
        b.appendChar(101);
        ByteBufferTest.assertEquals((String)"Char not appended properly.", (String)"\u0000e", (String)b.toName().toString());
    }

    public void testAppendInt() {
        ByteBuffer b = new ByteBuffer();
        b.appendInt(100);
        ByteBufferTest.assertEquals((String)"Int not appended properly.", (String)"\u0000\u0000\u0000d", (String)b.toName().toString());
    }

    public void testAppendLong() {
        ByteBuffer b = new ByteBuffer();
        b.appendLong(100L);
        ByteBufferTest.assertEquals((String)"Long not appended properly.", (String)"\u0000\u0000\u0000\u0000\u0000\u0000\u0000d", (String)b.toName().toString());
    }

    public void testAppendFloat() {
        ByteBuffer b = new ByteBuffer();
        b.appendFloat(100.0f);
        ByteBufferTest.assertEquals((String)"Float not appended properly.", (String)"B\u0200\u0000", (String)b.toName().toString());
    }

    public void testAppendDouble() {
        ByteBuffer b = new ByteBuffer();
        b.appendDouble(100.0);
        ByteBufferTest.assertEquals((String)"Double not appended properly.", (String)"@Y\u0000\u0000\u0000\u0000\u0000\u0000", (String)b.toName().toString());
    }

    public void testAppendName() {
        ByteBuffer b = new ByteBuffer();
        b.appendName(Name.fromString("test"));
        ByteBufferTest.assertEquals((String)"Name not appended properly.", (String)"test", (String)b.toName().toString());
    }

    public void testReset() {
        ByteBuffer b = new ByteBuffer();
        b.appendName(Name.fromString("test"));
        b.reset();
        ByteBufferTest.assertEquals((String)"ByteBuffer not reset properly.", (String)"", (String)b.toName().toString());
    }
}

