/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cons<Item>
extends List<Item> {
    private final Item first;
    private final List<Item> last;
    private final List<Item> rest;

    Cons(Item _first, List<Item> _rest) {
        this.first = _first;
        this.last = _rest.isEmpty() ? this : _rest.getLast();
        this.rest = _rest;
    }

    public Cons(Item f) {
        this.first = f;
        this.last = this;
        this.rest = new Empty();
    }

    @Override
    public Item getFirst() {
        return this.first;
    }

    @Override
    public List<Item> getRest() {
        return this.rest;
    }

    @Override
    public List<Item> getLast() {
        return this.last;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public List<Item> updateFirst(Item o) {
        return this.rest.cons(o);
    }

    @Override
    public List<Item> updateRest(List<Item> r) {
        return r.cons(this.first);
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Cons thatCons = (Cons)that;
        return this.getFirst().equals(thatCons.getFirst()) && this.getRest().equals(thatCons.getRest());
    }

    @Override
    public int length() {
        return 1 + this.rest.length();
    }

    @Override
    public Item eltAt(int i) {
        return i == 0 ? this.first : this.rest.eltAt(i - 1);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this.first).append(this.rest.elementsToString(" ")).append(")").toString();
    }

    @Override
    public List<Item> reverse() {
        return new Cons<Item>(this.first).append(this.rest.reverse());
    }

    @Override
    public int index(Item item) {
        return this.first.equals(item) ? 0 : 1 + this.rest.index(item);
    }

    @Override
    public <Return> Return accept(ListVisitor<Item, Return> v) {
        return v.forCons(this);
    }

    @Override
    public boolean contains(Item item) {
        return this.first.equals(item) || this.rest.contains(item);
    }

    @Override
    public String toString(String separator) {
        return this.toString("(", separator, ")");
    }

    @Override
    public String toString(String prefix, String separator, String suffix) {
        return new StringBuffer().append(prefix).append(this.first).append(this.rest.elementsToString(separator)).append(suffix).toString();
    }

    @Override
    public List<Item> append(List<Item> that) {
        return that.isEmpty() ? this : this.append(that.getRest()).cons(that.getFirst());
    }

    @Override
    String elementsToString(String prefix) {
        return new StringBuffer().append(prefix).append(this.first).append(this.rest.elementsToString(prefix)).toString();
    }
}

