/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.LayoutCharacters;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Pair;
import edu.rice.cs.nextgen.compiler.util.Position;
import edu.rice.cs.nextgen.compiler.util.Set;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ErrorLog
implements LayoutCharacters {
    private static final int MAX_ERRORS = 100;
    private static final int MAX_WARNINGS = 100;
    public boolean promptOnError;
    private PrintStream outputStream;
    private Name sourcename = Names.__input;
    private int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<Name, Integer>> recorded = Set.make();
    private byte[] buf = null;
    private int bp;
    private int lastLine;
    private static final String compilerRB = "com.sun.tools.javac.v8.resources.compiler";
    private static ResourceBundle messageRB;

    public ErrorLog(boolean promptOnError) {
        this.promptOnError = promptOnError;
        this.outputStream = System.err;
    }

    public ErrorLog() {
        this(false);
    }

    ErrorLog(boolean promptOnError, PrintStream out) {
        this.promptOnError = promptOnError;
        this.outputStream = out;
    }

    public Name useSource(Name name) {
        Name prev = this.sourcename;
        this.sourcename = name;
        if (prev != this.sourcename) {
            this.buf = null;
        }
        return prev;
    }

    public int errorCount() {
        return this.nerrors;
    }

    public void print(String s) {
        this.outputStream.print(s);
    }

    public void println(String s) {
        this.print(s + "\n");
    }

    public void prompt() {
        if (this.promptOnError) {
            this.outputStream.println("R)esume, A)bort>");
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new InternalError("user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int line, int col) {
        try {
            int lineEnd;
            if (this.buf == null) {
                FileInputStream in = new FileInputStream(this.sourcename.toString());
                this.buf = new byte[in.available()];
                in.read(this.buf);
                in.close();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > line) {
                this.bp = 0;
                this.lastLine = 1;
            }
            block6: while (this.bp < this.buf.length && this.lastLine < line) {
                switch (this.buf[this.bp]) {
                    case 13: {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == 10) {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        continue block6;
                    }
                    case 10: {
                        ++this.bp;
                        ++this.lastLine;
                        continue block6;
                    }
                }
                ++this.bp;
            }
            for (lineEnd = this.bp; lineEnd < this.buf.length && this.buf[lineEnd] != 13 && this.buf[lineEnd] != 10; ++lineEnd) {
            }
            this.println(new String(this.buf, this.bp, lineEnd - this.bp));
            byte[] ptr = new byte[col];
            for (int i = 0; i < col - 1; ++i) {
                ptr[i] = 32;
            }
            ptr[col - 1] = 94;
            this.println(new String(ptr, 0, col));
        }
        catch (IOException e) {
            this.println("(source unavailable)");
        }
    }

    private static void initResource() {
        try {
            messageRB = ResourceBundle.getBundle(compilerRB);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for compiler is missing");
        }
    }

    public static String getText(String key, String arg0, String arg1, String arg2, String arg3, String arg4, String arg5, String arg6) {
        if (messageRB == null) {
            ErrorLog.initResource();
        }
        try {
            Object[] args = new String[]{arg0, arg1, arg2, arg3, arg4, arg5, arg6};
            return MessageFormat.format(messageRB.getString(key), args);
        }
        catch (MissingResourceException e) {
            if (arg0 == null) {
                arg0 = "null";
            }
            if (arg1 == null) {
                arg1 = "null";
            }
            if (arg2 == null) {
                arg2 = "null";
            }
            if (arg3 == null) {
                arg3 = "null";
            }
            if (arg4 == null) {
                arg4 = "null";
            }
            if (arg5 == null) {
                arg5 = "null";
            }
            if (arg6 == null) {
                arg6 = "null";
            }
            Object[] args = new String[]{key, arg0, arg1, arg2, arg3, arg4, arg5, arg6};
            String msg = "compiler message file broken: key={0} arguments={1}, {2}, {3}, {4}, {5}, {6}, {7}";
            return MessageFormat.format(msg, args);
        }
    }

    private void printError(int pos, String msg) {
        if (pos == 0) {
            this.println("error: " + msg);
        } else {
            int line = Position.line(pos);
            int col = Position.column(pos);
            this.println(this.sourcename + ":" + line + ": " + msg);
            this.printErrLine(line, col);
        }
    }

    public void error(int pos, String msg) {
        Pair<Name, Integer> coords;
        if (this.nerrors < 100 && !this.recorded.contains(coords = new Pair<Name, Integer>(this.sourcename, new Integer(pos)))) {
            this.recorded.put(coords);
            this.printError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void warning(int pos, String msg) {
        if (this.nwarnings < 100) {
            this.printError(pos, "warning: " + msg);
            ++this.nwarnings;
        }
    }

    public static String getLocalizedString(String key) {
        return ErrorLog.getText("compiler.misc." + key, null, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String key, String arg0) {
        return ErrorLog.getText("compiler.misc." + key, arg0, null, null, null, null, null, null);
    }

    public static String getLocalizedString(String key, String arg0, String arg1) {
        return ErrorLog.getText("compiler.misc." + key, arg0, arg1, null, null, null, null, null);
    }

    public static String getLocalizedString(String key, String arg0, String arg1, String arg2) {
        return ErrorLog.getText("compiler.misc." + key, arg0, arg1, arg2, null, null, null, null);
    }

    public static String getLocalizedString(String key, String arg0, String arg1, String arg2, String arg3) {
        return ErrorLog.getText("compiler.misc." + key, arg0, arg1, arg2, arg3, null, null, null);
    }
}

