/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class FileEntry {
    public abstract InputStream open() throws IOException;

    public abstract String getName();

    public abstract String getPath();

    public abstract long length();

    public String toString() {
        return this.getPath();
    }

    public static class Zipped
    extends FileEntry {
        String name;
        ZipFile zdir;
        ZipEntry entry;

        public Zipped(String name, ZipFile zdir, ZipEntry entry) {
            this.name = name;
            this.zdir = zdir;
            this.entry = entry;
        }

        public InputStream open() throws IOException {
            return this.zdir.getInputStream(this.entry);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.zdir.getName() + "(" + this.entry.toString() + ")";
        }

        public long length() {
            return this.entry.getSize();
        }
    }

    public static class Regular
    extends FileEntry {
        String name;
        File f;

        public Regular(String name, File f) {
            this.name = name;
            this.f = f;
        }

        public InputStream open() throws IOException {
            return new FileInputStream(this.f);
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.f.getPath();
        }

        public long length() {
            return this.f.length();
        }
    }
}

