/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Hashtable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import junit.framework.TestCase;

public class HashtableTest
extends TestCase {
    public HashtableTest(String name) {
        super(name);
    }

    public void testPutAndGet() {
        Hashtable test = Hashtable.make();
        test.put("test", new Integer(0));
        HashtableTest.assertEquals((String)"Wrong value retrieved from Hashtable.", (Object)new Integer(0), test.get("test"));
    }

    public void testGetNonKeyReturnsNull() {
        Hashtable test = Hashtable.make();
        HashtableTest.assertEquals((String)"Calling get on an empty Hashtable should return null.", null, test.get("test"));
    }

    public void testRemove() {
        Hashtable test = Hashtable.make();
        test.put("test", new Integer(0));
        test.remove("test");
        HashtableTest.assertEquals((String)"Calling get with a removed key should return null.", null, test.get("test"));
    }

    public void testSize() {
        Hashtable test = Hashtable.make();
        test.put("test0", new Integer(0));
        test.put("test1", new Integer(1));
        test.put("test2", new Integer(2));
        HashtableTest.assertEquals((String)"Wrong size reported for Hashtable.", (int)3, (int)test.size());
    }

    public void testClear() {
        Hashtable test = Hashtable.make();
        test.put("test0", new Integer(0));
        test.put("test1", new Integer(1));
        test.put("test2", new Integer(2));
        test.clear();
        HashtableTest.assertEquals((String)"Cleared tables should have size zero", (int)0, (int)test.size());
    }

    public void testForEach() {
        Hashtable test = Hashtable.make();
        test.put("test0", new Integer(0));
        test.put("test1", new Integer(1));
        test.put("test2", new Integer(2));
        TestPairOp po = new TestPairOp();
        test.forEach(po);
        HashtableTest.assertEquals((String)"Hashtable.forEach didn't iterate over Hashtable elements properly.", (int)3, (int)po.accumulator);
    }

    public void testPrint() throws IOException {
        PipedInputStream inputStream = new PipedInputStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        PipedOutputStream outputStream = new PipedOutputStream(inputStream);
        PrintStream printStream = new PrintStream(outputStream);
        Hashtable test = Hashtable.make();
        test.put("test0", new Integer(0));
        test.put("test1", new Integer(1));
        test.put("test2", new Integer(2));
        test.print(printStream);
        String expectedLine0 = "\"test0\" => 0";
        String expectedLine1 = "\"test1\" => 1";
        String expectedLine2 = "\"test2\" => 2";
        boolean line0Found = false;
        boolean line1Found = false;
        boolean line2Found = false;
        while (bufferedReader.ready()) {
            String next = bufferedReader.readLine();
            if (next.equals(expectedLine0)) {
                if (line0Found) {
                    HashtableTest.fail((String)"Hashtable.print prints entries multiple times");
                    continue;
                }
                line0Found = true;
                continue;
            }
            if (next.equals(expectedLine1)) {
                if (line1Found) {
                    HashtableTest.fail((String)"Hashtable.print prints entries multiple times");
                    continue;
                }
                line1Found = true;
                continue;
            }
            if (next.equals(expectedLine2)) {
                if (line2Found) {
                    HashtableTest.fail((String)"Hashtable.print prints entries multiple times");
                    continue;
                }
                line2Found = true;
                continue;
            }
            HashtableTest.fail((String)("Hashtable.print prints data other than the Hashtable contents.\nPrinted: " + next));
        }
        HashtableTest.assertTrue((String)"Hashtable.print doesn't print entire contents of Hashtable.", (line0Found && line1Found && line2Found ? 1 : 0) != 0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TestPairOp
    implements Hashtable.PairOp<String, Integer> {
        public int accumulator = 0;

        TestPairOp() {
        }

        @Override
        public void invoke(String key, Integer data) {
            this.accumulator += data.intValue();
        }

        @Override
        public /* synthetic */ void invoke(Object x0, Object x1) {
            this.invoke((String)x0, (Integer)x1);
        }
    }
}

