/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.Name;
import junit.framework.TestCase;

public class NameTest
extends TestCase {
    public NameTest(String name) {
        super(name);
    }

    public void testFromUtf() {
        byte[] src = Converter.string2utf("atest");
        Name test = Name.fromUtf(src, 1, 4);
        NameTest.assertEquals((String)"Name.fromUtf did not initialize from byte array properly.", (String)"test", (String)test.toString());
    }

    public void testOneArgFromUtf() {
        byte[] src = Converter.string2utf("test");
        Name test = Name.fromUtf(src);
        NameTest.assertEquals((String)"Name.fromUtf did not initialize from byte array properly.", (String)"test", (String)test.toString());
    }

    public void testFromChars() {
        char[] src = Converter.utf2chars(Converter.string2utf("atest"));
        Name test = Name.fromChars(src, 1, 4);
        NameTest.assertEquals((String)"Name.fromChars did not initialize from byte array properly.", (String)"test", (String)test.toString());
    }

    public void testFromString() {
        String src = "test";
        Name test = Name.fromString("test");
        NameTest.assertEquals((String)"Name.fromString did not initialize from byte array properly.", (String)"test", (String)test.toString());
    }

    public void testToUtf() {
        Name name = Name.fromString("test");
        byte[] result = name.toUtf();
        byte[] expected = new byte[]{116, 101, 115, 116};
        for (int i = 0; i < expected.length; ++i) {
            NameTest.assertEquals((String)"Name.toUtf did not construct byte array properly.", (byte)expected[i], (byte)result[i]);
        }
    }

    public void testGetBytes() {
        byte[] test = new byte[4];
        Name src = Name.fromString("test");
        src.getBytes(test, 0);
        NameTest.assertEquals((String)"Name.getBytes did not copy bytes properly.", (byte)116, (byte)test[0]);
        NameTest.assertEquals((String)"Name.getBytes did not copy bytes properly.", (byte)101, (byte)test[1]);
        NameTest.assertEquals((String)"Name.getBytes did not copy bytes properly.", (byte)115, (byte)test[2]);
        NameTest.assertEquals((String)"Name.getBytes did not copy bytes properly.", (byte)116, (byte)test[3]);
    }

    public void testEquals() {
        NameTest.assertFalse((String)"Non-equal names are reported equal.", (boolean)Name.fromString("test").equals(Name.fromString("testtest")));
        NameTest.assertTrue((String)"Equal names are reported non-equal.", (boolean)Name.fromString("test").equals(Name.fromString("test")));
    }

    public void testLength() {
        NameTest.assertEquals((String)"Name.length not computed properly", (int)0, (int)Name.fromString("").length());
        NameTest.assertEquals((String)"Name.length not computed properly", (int)8, (int)Name.fromString("testtest").length());
    }

    public void testByteAt() {
        Name test = Name.fromString("testtest");
        NameTest.assertEquals((String)"Name.byteAt returns the wrong value.", (byte)116, (byte)test.byteAt(4));
    }

    public void testIndexOf() {
        Name test = Name.fromString("testtest");
        NameTest.assertEquals((String)"Name.indexOf does not retrieve positions properly.", (int)2, (int)test.indexOf((byte)115));
        NameTest.assertEquals((String)"Name.indexOf does not retrieve positions properly.", (int)0, (int)test.indexOf((byte)116));
    }

    public void testIndexOfOnEmptyString() {
        Name test = Name.fromString("");
        NameTest.assertEquals((String)"Name.indexOf does not retrieve positions properly.", (int)0, (int)test.indexOf((byte)115));
    }

    public void testLastIndexOf() {
        Name test = Name.fromString("testtest");
        NameTest.assertEquals((String)"Name.indexOf does not retrieve positions properly.", (int)6, (int)test.lastIndexOf((byte)115));
        NameTest.assertEquals((String)"Name.lastIndexOf does not retrieve positions properly.", (int)7, (int)test.lastIndexOf((byte)116));
    }

    public void testLastIndexOfOnEmptyString() {
        Name test = Name.fromString("");
        NameTest.assertEquals((String)"Name.lastIndexOf does not retrieve positions properly.", (int)-1, (int)test.lastIndexOf((byte)115));
    }

    public void testStartsWith() {
        Name pretest = Name.fromString("pretest");
        Name pre = Name.fromString("pre");
        Name not = Name.fromString("not");
        Name empty = Name.fromString("");
        NameTest.assertTrue((String)"Name.startsWith doesn't identify prefixes properly.", (boolean)pretest.startsWith(pre));
        NameTest.assertFalse((String)"Name.startsWith matches non-prefixes.", (boolean)pretest.startsWith(not));
        NameTest.assertTrue((String)"Name.startsWith doesn't match with empty names.", (boolean)pretest.startsWith(empty));
        NameTest.assertTrue((String)"Name.startsWith doesn't match empty with empty.", (boolean)empty.startsWith(empty));
        NameTest.assertFalse((String)"Name.startsWith matches non-empty prefixes with empty.", (boolean)empty.startsWith(not));
    }

    public void testEndsWith() {
        Name posttest = Name.fromString("testpost");
        Name post = Name.fromString("post");
        Name not = Name.fromString("not");
        Name empty = Name.fromString("");
        NameTest.assertTrue((String)"Name.endsWith doesn't identify postfixes properly.", (boolean)posttest.endsWith(post));
        NameTest.assertFalse((String)"Name.endsWith matches non-postfixes.", (boolean)posttest.endsWith(not));
        NameTest.assertTrue((String)"Name.endsWith doesn't match with empty names.", (boolean)posttest.endsWith(empty));
        NameTest.assertTrue((String)"Name.endsWith doesn't match empty with empty.", (boolean)empty.endsWith(empty));
        NameTest.assertFalse((String)"Name.endsWith matches non-empty names with empty.", (boolean)empty.endsWith(not));
    }

    public void testSubname() {
        Name pretestpost = Name.fromString("pretestpost");
        NameTest.assertEquals((String)"Name.subName not computed properly.", (Object)Name.fromString("test"), (Object)pretestpost.subName(3, 7));
    }

    public void testReplace() {
        Name qesqqesq = Name.fromString("qesqqesq");
        NameTest.assertEquals((String)"Name.replace doesn't replace characters properly.", (Object)Name.fromString("testtest"), (Object)qesqqesq.replace((byte)113, (byte)116));
        NameTest.assertEquals((String)"Name.replace modified the input Name!", (String)"qesqqesq", (String)qesqqesq.toString());
    }

    public void testAppend() {
        Name test = Name.fromString("test");
        NameTest.assertEquals((String)"Name.append doesn't append properly.", (String)"testtest", (String)test.append(test).toString());
        NameTest.assertEquals((String)"Name.append modified the input Name!", (String)"test", (String)test.toString());
    }

    public void testConcatenate() {
        Name[] tests = new Name[]{Name.fromString("pre"), Name.fromString("test"), Name.fromString("post")};
        NameTest.assertEquals((String)"Name.concatenate doesn't concatenate properly.", (String)"pretestpost", (String)Name.concatenate(tests).toString());
    }
}

