/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import edu.rice.cs.nextgen2.util.NGUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeClassLoader
extends ClassLoader {
    String build_dir;
    Collection<String> classpath;

    public ByteCodeClassLoader(ClassLoader p, String bd, Collection<String> cp) {
        super(p);
        this.build_dir = bd;
        this.classpath = cp;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            File f = new File(this.build_dir, name);
            if (f.isFile()) {
                NGUtil.debugPrint(true, "File " + f + " exists");
            }
            return super.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            return this.findClassPackage(name);
        }
    }

    static boolean isZip(String name) {
        return new File(name).isFile();
    }

    public ZipFile openZip(String path) {
        try {
            ZipFile zip = new ZipFile(path);
            return zip;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class findClassPackage(String name) throws ClassNotFoundException {
        InputStream ret = null;
        String cl = name.replace('.', File.separatorChar) + ".class";
        for (String pathname : this.classpath) {
            if (!ByteCodeClassLoader.isZip(pathname)) continue;
            ZipFile zip = this.openZip(pathname);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry next = e.nextElement();
                if (!next.toString().equals(cl)) continue;
                try {
                    ret = zip.getInputStream(next);
                }
                catch (IOException ex) {}
            }
        }
        if (ret != null) {
            try {
                byte[] data = new byte[ret.available()];
                ret.read(data);
                Class<?> clazz = this.defineClass(name, data, 0, data.length);
                return clazz;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name + " not found");
    }

    public InputStream findStreamClassPackage(String name) {
        Object ret = null;
        String cl = name;
        if (cl.endsWith(".class")) {
            cl = cl.substring(0, cl.length() - 6);
        }
        cl = cl.replace('.', File.separatorChar) + ".class";
        for (String pathname : this.classpath) {
            if (!ByteCodeClassLoader.isZip(pathname)) continue;
            ZipFile zip = this.openZip(pathname);
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry next = e.nextElement();
                if (!next.toString().equals(cl)) continue;
                try {
                    return zip.getInputStream(next);
                }
                catch (IOException ex) {
                }
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream ret = super.getResourceAsStream(name);
        if (ret == null) {
            ret = this.findStreamClassPackage(name);
        }
        return ret;
    }

    @Override
    public URL getResource(String name) {
        File f = new File(this.build_dir, name);
        if (f.isFile()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return super.getResource(name);
    }
}

