/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import edu.rice.cs.nextgen2.bytecode.ByteCodeClassLoader;
import java.net.URL;
import java.util.LinkedList;
import junit.framework.TestCase;

public class ByteCodeClassLoaderTest
extends TestCase {
    ClassLoader loader;

    public ByteCodeClassLoaderTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.loader = new ByteCodeClassLoader(Thread.currentThread().getContextClassLoader(), ".", new LinkedList<String>());
    }

    public void test_loadClassBogus() {
        try {
            Class<?> url = this.loader.loadClass("Aboc$$L{0}$$R");
            ByteCodeClassLoaderTest.assertNotNull((String)"Unable to Load java.lang.Object", url);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void test_loadClassObject() {
        try {
            Class<?> url = this.loader.loadClass("java.lang.Object");
        }
        catch (ClassNotFoundException e) {
            ByteCodeClassLoaderTest.fail((String)"Object not found");
        }
    }

    public void test_logClassExternal1() {
        try {
            Class<?> url = ((Object)((Object)this)).getClass().getClassLoader().loadClass("junit.framework.TestCase");
        }
        catch (ClassNotFoundException e) {
            ByteCodeClassLoaderTest.fail((String)"External0 class not found");
        }
    }

    public void test_logClassExternal2() {
        try {
            Class<?> url = this.loader.loadClass("junit.framework.TestCase");
        }
        catch (ClassNotFoundException e) {
            ByteCodeClassLoaderTest.fail((String)"External class not found");
        }
    }

    public void test_getResourceObject() {
        URL url = this.loader.getResource("java.lang.Object");
        ByteCodeClassLoaderTest.assertNull((String)"Custom classloader loaded java.lang.Object", (Object)url);
    }

    public void test_getResourceExternalSuper() {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("junit/framework/TestCase.class");
        ByteCodeClassLoaderTest.assertNotNull((String)"Custom classloader could not load class in package", (Object)url);
    }

    public void test_getResourceExternalDots() {
        URL url = this.loader.getResource("junit.framework.TestCase");
        ByteCodeClassLoaderTest.assertNull((String)"Custom classloader could not load class in package", (Object)url);
    }

    public void test_getResourceExternalValid() {
        URL url = this.loader.getResource("junit/framework/TestCase.class");
        ByteCodeClassLoaderTest.assertNotNull((String)"Custom classloader could not load class in package", (Object)url);
    }
}

