/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import edu.rice.cs.nextgen2.bytecode.GenericSignature;
import junit.framework.TestCase;

public class GenericSignatureTest
extends TestCase {
    public GenericSignatureTest(String n) {
        super(n);
    }

    public void check(String in) {
        GenericSignature.MethodSignature m = GenericSignature.parseMethodSignature("meth", in, false);
        if (!in.equals(m.toSignature())) {
            System.out.println("input :" + in);
            System.out.println("output:" + m.toSignature());
        }
        GenericSignatureTest.assertEquals((String)"GenericSignatureTest", (String)in, (String)m.toSignature());
    }

    public void checkC(String in) {
        GenericSignature.ClassSignature m = GenericSignature.parseClassSignature("A", in, null);
        if (!in.equals(m.toSignature())) {
            System.out.println("input :" + in);
            System.out.println("output:" + m.toSignature());
        }
        GenericSignatureTest.assertEquals((String)"GenericSignatureTest", (String)in, (String)m.toSignature());
    }

    public void testOneTypeVar() {
        this.check("<T:Ljava/lang/Number;>(LWildBox<TT;>;)V");
    }

    public void testSimpleWildCard() {
        this.check("(LWildBox<+Ljava/lang/Number;>;)V");
    }

    public void testComparableWildCard() {
        this.check("<T::Ljava/lang/Comparable<-TT;>;>(Ljava/util/List<TT;>;)V");
    }

    public void testSimple1() {
        this.check("(TA;TB;)V");
    }

    public void testSimple2() {
        this.check("(TS;TT;)LA<TS;TT;>;");
    }

    public void testSimple3() {
        this.check("()V");
    }

    public void testInterface() {
        this.check("<T::LWC<TT;>;>(LWildBox<TT;>;)V");
    }

    public void testNexted() {
        this.check("<T:LWildBox<TT;>;>(LWildBox<TT;>;)V");
    }

    public void testNexted2() {
        this.check("<T::Ljava/lang/Comparable<TT;>;>(Ljava/util/List<TT;>;)V");
    }

    public void testMultipleWildCards() {
        this.check("<A::Ljava/lang/Comparable<-TA;>;B:LWildBox<+TB;>;C::Ljava/lang/Comparable<-TA;>;>(TA;TB;TC;)V");
    }

    public void testAnyWildCard() {
        this.check("(LHostA<TT;>;[LIFactory<*>;)LHostA<TT;>;");
    }

    public void testEnum() {
        this.checkC("Ljava/lang/Enum<LTest$Color;>;");
    }

    public void testBoxClass() {
        this.checkC("Ljava/lang/Enum<LTest$Color;>;");
    }

    public void testAnyWildCardC() {
        this.checkC("<T:Ljava/lang/Object;>Ljava/lang/Object;LIVisitor<TT;LIHost<TT;>;LIFactory<*>;>;");
    }

    public void testMixin1() {
        this.checkC("<T:Ljava/lang/Object;>TT;LTime<TT;>;LEmpty;LI2;");
    }

    public void testLong() {
        this.checkC("<ElemType:Ljava/lang/Object;>Ljava/lang/Object;Ledu/rice/cs/nextgen2/complextests/jam/PureList<TElemType;>;");
    }
}

