/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.bytecode;

import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LDC_W;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

public class VarianceSupporter {
    private InstructionFactory _factory;
    private ConstantPoolGen _cp;
    private ClassGen _cg;
    private int _pn;
    public static final String TypeArgsArrayFieldName = "$$TAA";

    public VarianceSupporter(ClassGen cg, int tParamsNum) {
        this._cg = cg;
        this._cg.setMajor(49);
        this._cg.setMinor(0);
        this._pn = tParamsNum;
        this._cp = this._cg.getConstantPool();
        this._factory = new InstructionFactory(this._cg, this._cp);
    }

    public void support() {
        if (this._pn == 0) {
            throw new ClassNotGenericException("Class " + this._cg.getClassName() + " has no type parameters");
        }
        this.constructField();
        this.constructStaticInitializer();
    }

    private void constructField() {
        FieldGen field = new FieldGen(25, new ArrayType(new ObjectType("edu.rice.cs.nextgen2.bytecode.TypeArgInfo"), 1), TypeArgsArrayFieldName, this._cp);
        this._cg.addField(field.getField());
    }

    private void constructStaticInitializer() {
        InstructionList il = new InstructionList();
        MethodGen method = new MethodGen(8, Type.VOID, Type.NO_ARGS, new String[0], "<clinit>", this._cg.getClassName(), il, this._cp);
        InstructionHandle ih_0 = il.append(new PUSH(this._cp, this._pn));
        il.append(this._factory.createNewArray(new ObjectType("edu.rice.cs.nextgen2.bytecode.TypeArgInfo"), (short)1));
        for (int paramNumber = 0; paramNumber < this._pn; ++paramNumber) {
            il.append(InstructionConstants.DUP);
            il.append(new PUSH(this._cp, paramNumber));
            il.append(this._factory.createNew("edu.rice.cs.nextgen2.bytecode.TypeArgInfo"));
            il.append(InstructionConstants.DUP);
            il.append(new LDC_W(this._cp.addClass("{-" + paramNumber + '}')));
            il.append(new PUSH(this._cp, "{" + paramNumber + '}'));
            il.append(this._factory.createInvoke("edu.rice.cs.nextgen2.bytecode.TypeArgInfo", "<init>", Type.VOID, new Type[]{new ObjectType("java.lang.Class"), Type.STRING}, (short)183));
            il.append(InstructionConstants.AASTORE);
        }
        il.append(this._factory.createFieldAccess(this._cg.getClassName(), TypeArgsArrayFieldName, new ArrayType(new ObjectType("edu.rice.cs.nextgen2.bytecode.TypeArgInfo"), 1), (short)179));
        il.append(InstructionFactory.createReturn(Type.VOID));
        method.setMaxStack();
        method.setMaxLocals();
        this._cg.addMethod(method.getMethod());
        il.dispose();
    }

    public static class ClassNotGenericException
    extends RuntimeException {
        ClassNotGenericException(String msg) {
            super(msg);
        }
    }
}

