/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.classloader;

import edu.rice.cs.nextgen2.classloader.InvalidClassNameException;
import java.util.LinkedList;

public class InstantiationName {
    private LocationAndLength[] _typeParameters;
    private String _parametricPart;
    private String _packageName;
    private String _baseName;

    public InstantiationName(String name) {
        int afterDot = name.lastIndexOf(46);
        afterDot = afterDot == -1 ? 0 : ++afterDot;
        this._packageName = name.substring(0, afterDot);
        String className = name.substring(afterDot);
        int dollarsIndex = className.indexOf("$$L");
        if (dollarsIndex == -1) {
            dollarsIndex = className.indexOf("$$m");
        }
        InstantiationName.assertNameValid(dollarsIndex != -1, name, "No $$L found!");
        this._baseName = className.substring(0, dollarsIndex);
        this._parametricPart = className.substring(dollarsIndex);
        int index = 0;
        int nestingLevel = 0;
        boolean parameterNumber = false;
        LinkedList<LocationAndLength> paramList = new LinkedList<LocationAndLength>();
        while (index < this._parametricPart.length() && (dollarsIndex = this._parametricPart.indexOf("$$", index)) != -1) {
            int nextDollars;
            char afterDollars = this._parametricPart.charAt(dollarsIndex + 2);
            if (afterDollars == 'R' || afterDollars == 'n') {
                InstantiationName.assertNameValid(nestingLevel > 0, name, "nestingLevel <= 0 but $$R encountered");
                index = dollarsIndex + 3;
                if (--nestingLevel < 1) continue;
                LocationAndLength lastParam = (LocationAndLength)paramList.getLast();
                lastParam.length = index - lastParam.location;
                continue;
            }
            if (afterDollars == 'E') {
                index = dollarsIndex + 3;
                continue;
            }
            if (afterDollars == 'l') {
                int nextDollars2 = this._parametricPart.indexOf("$$r", dollarsIndex + 3);
                index = nextDollars2 + 3;
                continue;
            }
            InstantiationName.assertNameValid(afterDollars == 'L' || afterDollars == 'C' || afterDollars == 'm', name, "Character after $$ was " + String.valueOf(afterDollars) + ". Expected L or C.");
            if (afterDollars == 'L' || afterDollars == 'm') {
                ++nestingLevel;
            }
            InstantiationName.assertNameValid(nestingLevel > 0, name, "nestingLevel <= 0?!");
            int location = dollarsIndex + 3;
            if (nestingLevel == 1) {
                nextDollars = InstantiationName._nextSignificantDollars(this._parametricPart, location);
                int length = nextDollars - location;
                if (length > 0) {
                    paramList.addLast(new LocationAndLength(location, length));
                }
                index = nextDollars;
                continue;
            }
            nextDollars = InstantiationName._nextSignificantDollars(this._parametricPart, location);
            LocationAndLength lastParam = (LocationAndLength)paramList.getLast();
            lastParam.length = nextDollars - lastParam.location;
            index = nextDollars;
        }
        InstantiationName.assertNameValid(nestingLevel == 0, name, "Nesting level not zero (" + nestingLevel + ") after processing name!");
        this._typeParameters = paramList.toArray(new LocationAndLength[0]);
    }

    private static int _nextSignificantDollars(String s, int start) {
        char afterNext;
        int nextDollars = start - 3;
        while ((afterNext = s.charAt((nextDollars = s.indexOf("$$", nextDollars + 3)) + 2)) == 'D' || afterNext == 'S' || afterNext == 'A') {
        }
        return nextDollars;
    }

    public String[] getTypeParameters() {
        String[] params = new String[this._typeParameters.length];
        for (int i = 0; i < params.length; ++i) {
            LocationAndLength loclen = this._typeParameters[i];
            String tmp = this._parametricPart.substring(loclen.location, loclen.location + loclen.length);
            params[i] = InstantiationName._unescapeToplevel(tmp);
        }
        return params;
    }

    private static String _unescapeToplevel(String orig) {
        StringBuffer buf = new StringBuffer();
        int nestingLevel = 0;
        int pos = 0;
        while (pos < orig.length()) {
            int dollarsIndex = orig.indexOf("$$", pos);
            if (dollarsIndex == -1) {
                buf.append(orig.substring(pos));
                break;
            }
            buf.append(orig.substring(pos, dollarsIndex));
            char afterDollars = orig.charAt(dollarsIndex + 2);
            int posAfterDollars = dollarsIndex + 3;
            switch (afterDollars) {
                case 'L': {
                    ++nestingLevel;
                    buf.append(orig.substring(dollarsIndex, posAfterDollars));
                    break;
                }
                case 'R': {
                    --nestingLevel;
                    buf.append(orig.substring(dollarsIndex, posAfterDollars));
                    break;
                }
                case 'A': {
                    if (nestingLevel == 0) {
                        buf.append("[");
                        break;
                    }
                    buf.append(orig.substring(dollarsIndex, posAfterDollars));
                    break;
                }
                case 'C': {
                    if (nestingLevel == 0) {
                        buf.append(",");
                        break;
                    }
                    buf.append(orig.substring(dollarsIndex, posAfterDollars));
                    break;
                }
                case 'D': {
                    if (nestingLevel == 0) {
                        buf.append(".");
                        break;
                    }
                    buf.append(orig.substring(dollarsIndex, posAfterDollars));
                    break;
                }
                case 'S': {
                    if (nestingLevel == 0) {
                        buf.append(";");
                        break;
                    }
                    buf.append(orig.substring(dollarsIndex, posAfterDollars));
                }
            }
            pos = posAfterDollars;
        }
        return buf.toString();
    }

    public static String replaceSubstring(String orig, String find, String repl) {
        int foundPos;
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        while (pos < orig.length() && (foundPos = orig.indexOf(find, pos)) != -1) {
            buf.append(orig.substring(pos, foundPos));
            buf.append(repl);
            pos = foundPos + find.length();
        }
        buf.append(orig.substring(pos));
        return buf.toString();
    }

    public String getTemplateName() {
        int positionInOld = 0;
        StringBuffer buf = new StringBuffer();
        buf.append(this._packageName);
        buf.append(this._baseName);
        for (int i = 0; i < this._typeParameters.length; ++i) {
            int paramNumber = i;
            LocationAndLength param = this._typeParameters[i];
            buf.append(this._parametricPart.substring(positionInOld, param.location));
            buf.append('{');
            buf.append(paramNumber);
            buf.append('}');
            positionInOld = param.location + param.length;
        }
        buf.append(this._parametricPart.substring(positionInOld));
        return buf.toString();
    }

    protected static void assertNameValid(boolean expr, String className, String problem) {
        if (!expr) {
            throw new InvalidClassNameException(className, problem);
        }
    }

    private class LocationAndLength {
        public int location;
        public int length;

        public LocationAndLength(int loc, int len) {
            this.location = loc;
            this.length = len;
        }
    }
}

