/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.classloader;

import java.io.FileOutputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MixinFixer {
    public static void process(String tmpl_class, String super_class, String res_class) {
        try {
            ClassReader super_cr = new ClassReader(super_class);
            ClassReader new_cr = new ClassReader(tmpl_class);
            byte[] bytes = MixinFixer.process(super_cr, new_cr, "{0}");
            FileOutputStream fos = new FileOutputStream(res_class);
            fos.write(bytes);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] process(byte[] tmpl, byte[] clazz, String superName) {
        ClassReader super_cr = new ClassReader(clazz);
        ClassReader new_cr = new ClassReader(tmpl);
        byte[] bytes = MixinFixer.process(super_cr, new_cr, superName);
        return bytes;
    }

    public static byte[] process(ClassReader super_cr, ClassReader new_cr, final String superName) {
        boolean computeMax = true;
        LinkedList meths = new LinkedList();
        ClassNode cn = new ClassNode();
        ClassNode new_cn = new ClassNode();
        super_cr.accept(cn, true);
        new_cr.accept(new_cn, true);
        MethodNode init = null;
        List new_methods = new_cn.methods;
        for (int i = 0; i < new_methods.size(); ++i) {
            MethodNode method = (MethodNode)new_methods.get(i);
            if (!method.name.equals("<init>")) continue;
            init = method;
        }
        new_methods.remove(init);
        List methods = cn.methods;
        for (int i = 0; i < methods.size(); ++i) {
            final MethodNode method = (MethodNode)methods.get(i);
            if (!method.name.equals("<init>")) continue;
            init.accept(new ClassAdapter(new_cn){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    return new MyMethodAdapter(super.visitMethod(access, name, method.desc, method.signature, exceptions), method.desc, method.signature, superName);
                }
            });
        }
        MyClassWriter cw = new MyClassWriter(computeMax, init);
        new_cn.accept(cw);
        byte[] bytes = cw.toByteArray();
        return bytes;
    }

    public static void main(String[] argv) {
        long startTime = new Date().getTime();
        String tmpl_class = "TimeStamped$$L{0}$$R";
        String super_class = "A";
        if (argv.length < 3) {
            System.out.println("Usage: MixinFixer tmpl_class super_class output_class");
            System.exit(0);
        }
        MixinFixer.process(argv[0], argv[1], argv[2]);
        long endTime = new Date().getTime();
        System.out.println("time: " + startTime + " => " + endTime + " [" + (endTime - startTime) + "]");
    }

    static class MyClassWriter
    extends ClassWriter {
        MethodNode m;

        public MyClassWriter(boolean b, MethodNode m) {
            super(b);
            this.m = m;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }

        public void visitAttribute(Attribute attr) {
            if (!attr.type.equals("Nextgen")) {
                super.visitAttribute(attr);
            }
        }
    }

    static class MyMethodAdapter
    implements MethodVisitor {
        MethodVisitor v;
        boolean foundSuper;
        String newDesc;
        String newSig;
        String superName;

        public MyMethodAdapter(MethodVisitor v, String d, String s, String superName) {
            this.v = v;
            this.foundSuper = false;
            this.newDesc = d;
            this.newSig = s;
            this.superName = superName;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return this.v.visitAnnotationDefault();
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return this.v.visitParameterAnnotation(parameter, desc, visible);
        }

        public void visitCode() {
            this.v.visitCode();
        }

        public void visitInsn(int opcode) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitIntInsn(opcode, operand);
        }

        public void visitVarInsn(int opcode, int var) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitVarInsn(opcode, var);
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitTypeInsn(opcode, desc);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitFieldInsn(opcode, owner, name, desc);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (!this.foundSuper) {
                if (name.equals("<init>")) {
                    this.foundSuper = true;
                }
                Type[] argtypes = Type.getArgumentTypes(this.newDesc);
                this.v.visitVarInsn(25, 0);
                int idx = 1;
                for (int j = 0; j < argtypes.length; ++j) {
                    this.v.visitVarInsn(argtypes[j].getOpcode(21), idx);
                    idx += argtypes[j].getSize();
                }
                this.v.visitMethodInsn(183, this.superName, "<init>", this.newDesc);
            } else {
                this.v.visitMethodInsn(opcode, owner, name, desc);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitJumpInsn(opcode, label);
        }

        public void visitLabel(Label label) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitLabel(label);
        }

        public void visitLdcInsn(Object cst) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitLdcInsn(cst);
        }

        public void visitIincInsn(int var, int increment) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitIincInsn(var, increment);
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitTableSwitchInsn(min, max, dflt, labels);
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitLookupSwitchInsn(dflt, keys, labels);
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitMultiANewArrayInsn(desc, dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitTryCatchBlock(start, end, handler, type);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public void visitLineNumber(int line, Label start) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitLineNumber(line, start);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            if (!this.foundSuper) {
                return;
            }
            this.v.visitMaxs(maxStack, maxLocals);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return this.v.visitAnnotation(desc, visible);
        }

        public void visitAttribute(Attribute attr) {
            this.v.visitAttribute(attr);
        }

        public void visitEnd() {
            this.v.visitEnd();
        }
    }
}

