/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.code;

import edu.rice.cs.nextgen2.compiler.jvm.Target;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Options;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Source {
    JDK1_2("1.2"),
    JDK1_3("1.3"),
    JDK1_4("1.4"),
    JDK1_5("1.5");

    protected static final Context.Key<Source> sourceKey;
    public final String name;
    private static Map<String, Source> tab;
    public static final Source DEFAULT;

    public static Source instance(Context context) {
        Source instance = context.get(sourceKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String sourceString = (String)options.get("-source");
            if (sourceString != null) {
                instance = Source.lookup(sourceString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(sourceKey, instance);
        }
        return instance;
    }

    private Source(String name) {
        this.name = name;
    }

    public static Source lookup(String name) {
        return tab.get(name);
    }

    public Target requiredTarget() {
        if (this.compareTo(JDK1_5) >= 0) {
            return Target.JDK1_5;
        }
        if (this.compareTo(JDK1_4) >= 0) {
            return Target.JDK1_4;
        }
        return Target.JDK1_1;
    }

    public boolean allowEncodingErrors() {
        return true;
    }

    public boolean allowAsserts() {
        return this.compareTo(JDK1_4) >= 0;
    }

    public boolean allowCovariantReturns() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowGenerics() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowEnums() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowForeach() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowStaticImport() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowBoxing() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowVarargs() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowAnnotations() {
        return this.compareTo(JDK1_5) >= 0;
    }

    public boolean allowHexFloats() {
        return this.compareTo(JDK1_5) >= 0;
    }

    static {
        sourceKey = new Context.Key();
        tab = new HashMap<String, Source>();
        for (Source s : Source.values()) {
            tab.put(s.name, s);
        }
        tab.put("5", JDK1_5);
        DEFAULT = JDK1_5;
    }
}

