/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.comp;

import edu.rice.cs.nextgen2.compiler.code.Attribute;
import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.Annotate;
import edu.rice.cs.nextgen2.compiler.comp.Attr;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.AttrContextEnv;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.comp.Enter;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.Resolve;
import edu.rice.cs.nextgen2.compiler.comp.Todo;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.jvm.Target;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Diagnostic;
import edu.rice.cs.nextgen2.compiler.util.FatalError;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Options;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberEnter
extends Tree.Visitor
implements Symbol.Completer {
    protected static final Context.Key<MemberEnter> memberEnterKey = new Context.Key();
    static final boolean checkClash = true;
    private final Name.Table names;
    private final Enter enter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final TreeMaker make;
    private final ClassReader reader;
    private final Todo todo;
    private final Annotate annotate;
    private final Types types;
    private final Target target;
    private final boolean skipAnnotations;
    ListBuffer<Env<AttrContext>> halfcompleted = new ListBuffer();
    boolean isFirst = true;
    boolean completionEnabled = true;
    protected Env<AttrContext> env;

    public static MemberEnter instance(Context context) {
        MemberEnter instance = context.get(memberEnterKey);
        if (instance == null) {
            instance = new MemberEnter(context);
        }
        return instance;
    }

    protected MemberEnter(Context context) {
        context.put(memberEnterKey, this);
        this.names = Name.Table.instance(context);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.reader = ClassReader.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.target = Target.instance(context);
        this.skipAnnotations = Options.instance(context).get("skipAnnotations") != null;
    }

    private void importAll(int pos, Symbol.TypeSymbol tsym, Env<AttrContext> env) {
        if (tsym.kind == 1 && tsym.members().elems == null && !tsym.exists()) {
            if (((Symbol.PackageSymbol)tsym).fullname.equals(this.names.java_lang)) {
                Diagnostic msg = new Diagnostic("fatal.err.no.java.lang", new Object[0]);
                throw new FatalError(msg);
            }
            this.log.error(pos, "doesnt.exist", tsym);
        }
        Scope fromScope = tsym.members();
        Scope toScope = env.toplevel.starImportScope;
        Scope.Entry e = fromScope.elems;
        while (e != null) {
            if (e.sym.kind == 2 && !toScope.includes(e.sym)) {
                toScope.enter(e.sym, fromScope);
            }
            e = e.sibling;
        }
    }

    private void importStaticAll(int pos, final Symbol.TypeSymbol tsym, Env<AttrContext> env) {
        final Name sourcefile = env.toplevel.sourcefile;
        final Scope toScope = env.toplevel.starImportScope;
        final Symbol.PackageSymbol packge = env.toplevel.packge;
        final Symbol.TypeSymbol origin = tsym;
        new Object(){
            Set<Symbol> processed = new HashSet<Symbol>();

            void importFrom(Symbol.TypeSymbol tsym) {
                if (tsym == null || !this.processed.add(tsym)) {
                    return;
                }
                this.importFrom(((MemberEnter)MemberEnter.this).types.supertype((Type)tsym.type).tsym);
                for (Type t : MemberEnter.this.types.interfaces(tsym.type)) {
                    this.importFrom(t.tsym);
                }
                Scope fromScope = tsym.members();
                Scope.Entry e = fromScope.elems;
                while (e != null) {
                    Symbol sym = e.sym;
                    if (sym.kind == 2 && (sym.flags() & 8L) != 0L && MemberEnter.this.staticImportAccessible(sym, packge) && sym.isMemberOf(origin, MemberEnter.this.types) && !toScope.includes(sym)) {
                        toScope.enter(sym, fromScope);
                    }
                    e = e.sibling;
                }
            }
        }.importFrom(tsym);
        this.annotate.earlier(new Annotate.Annotator(){
            Set<Symbol> processed = new HashSet<Symbol>();

            public String toString() {
                return "import static " + tsym + ".*" + " in " + sourcefile;
            }

            void importFrom(Symbol.TypeSymbol tsym2) {
                if (tsym2 == null || !this.processed.add(tsym2)) {
                    return;
                }
                this.importFrom(((MemberEnter)MemberEnter.this).types.supertype((Type)tsym2.type).tsym);
                for (Type t : MemberEnter.this.types.interfaces(tsym2.type)) {
                    this.importFrom(t.tsym);
                }
                Scope fromScope = tsym2.members();
                Scope.Entry e = fromScope.elems;
                while (e != null) {
                    Symbol sym = e.sym;
                    if (sym.isStatic() && sym.kind != 2 && MemberEnter.this.staticImportAccessible(sym, packge) && !toScope.includes(sym) && sym.isMemberOf(origin, MemberEnter.this.types)) {
                        toScope.enter(sym, fromScope);
                    }
                    e = e.sibling;
                }
            }

            public void enterAnnotation() {
                this.importFrom(tsym);
            }
        });
    }

    boolean staticImportAccessible(Symbol sym, Symbol.PackageSymbol packge) {
        int flags = (int)(sym.flags() & 7L);
        switch (flags) {
            default: {
                return true;
            }
            case 2: {
                return false;
            }
            case 0: 
            case 4: 
        }
        return sym.packge() == packge;
    }

    private void importNamedStatic(final int pos, final Symbol.TypeSymbol tsym, final Name name, final Env<AttrContext> env) {
        if (tsym.kind != 2) {
            this.log.error(pos, "static.imp.only.classes.and.interfaces", new Object[0]);
            return;
        }
        final Scope toScope = env.toplevel.namedImportScope;
        final Symbol.PackageSymbol packge = env.toplevel.packge;
        final Symbol.TypeSymbol origin = tsym;
        new Object(){
            Set<Symbol> processed = new HashSet<Symbol>();

            void importFrom(Symbol.TypeSymbol tsym) {
                if (tsym == null || !this.processed.add(tsym)) {
                    return;
                }
                this.importFrom(((MemberEnter)MemberEnter.this).types.supertype((Type)tsym.type).tsym);
                for (Type t : MemberEnter.this.types.interfaces(tsym.type)) {
                    this.importFrom(t.tsym);
                }
                Scope.Entry e = tsym.members().lookup(name);
                while (e.scope != null) {
                    Symbol sym = e.sym;
                    if (sym.isStatic() && sym.kind == 2 && MemberEnter.this.staticImportAccessible(sym, packge) && sym.isMemberOf(origin, MemberEnter.this.types) && MemberEnter.this.chk.checkUniqueImport(pos, sym, toScope)) {
                        toScope.enter(sym, sym.owner.members());
                    }
                    e = e.next();
                }
            }
        }.importFrom(tsym);
        this.annotate.earlier(new Annotate.Annotator(){
            Set<Symbol> processed = new HashSet<Symbol>();
            boolean found = false;

            public String toString() {
                return "import static " + tsym + "." + name;
            }

            void importFrom(Symbol.TypeSymbol tsym2) {
                if (tsym2 == null || !this.processed.add(tsym2)) {
                    return;
                }
                this.importFrom(((MemberEnter)MemberEnter.this).types.supertype((Type)tsym2.type).tsym);
                for (Type t : MemberEnter.this.types.interfaces(tsym2.type)) {
                    this.importFrom(t.tsym);
                }
                Scope.Entry e = tsym2.members().lookup(name);
                while (e.scope != null) {
                    Symbol sym = e.sym;
                    if (sym.isStatic() && MemberEnter.this.staticImportAccessible(sym, packge) && sym.isMemberOf(origin, MemberEnter.this.types)) {
                        this.found = true;
                        if (sym.kind == 16 || sym.kind != 2 && MemberEnter.this.chk.checkUniqueImport(pos, sym, toScope)) {
                            toScope.enter(sym, sym.owner.members());
                        }
                    }
                    e = e.next();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enterAnnotation() {
                this.importFrom(tsym);
                if (!this.found) {
                    Name prev = MemberEnter.this.log.useSource(env.toplevel.sourcefile);
                    try {
                        MemberEnter.this.log.error(pos, "cant.resolve.location", new Diagnostic("kindname.static", new Object[0]), name, "", "", Resolve.typeKindName(tsym.type), tsym.type);
                    }
                    finally {
                        MemberEnter.this.log.useSource(prev);
                    }
                }
            }
        });
    }

    private void importNamed(int pos, Symbol tsym, Env<AttrContext> env) {
        if (tsym.kind == 2 && this.chk.checkUniqueImport(pos, tsym, env.toplevel.namedImportScope)) {
            env.toplevel.namedImportScope.enter(tsym, tsym.owner.members());
        }
    }

    protected void aliasClass(int pos, Tree.Ident id, List<Tree.TypeParameter> typarams, Symbol tsym, Env<AttrContext> env) {
        if (tsym.kind == 2) {
            env.toplevel.namedImportScope.enter(tsym, tsym.owner.members());
        } else if (tsym.kind == 1) {
            env.toplevel.namedImportScope.enter(tsym, tsym.members());
        }
    }

    Type signature(List<Tree.TypeParameter> typarams, List<Tree.VarDef> params, Tree res, List<Tree> thrown, Env<AttrContext> env) {
        List<Type> tvars = this.enter.classEnter(typarams, env);
        this.attr.attribStats(typarams, env);
        ListBuffer<Type> argbuf = new ListBuffer<Type>();
        List<Tree.VarDef> l = params;
        while (l.nonEmpty()) {
            this.memberEnter((Tree)l.head, env);
            argbuf.append(((Tree.VarDef)l.head).vartype.type);
            l = l.tail;
        }
        Type restype = res == null ? this.syms.voidType : this.attr.attribType(res, env);
        ListBuffer<Type> thrownbuf = new ListBuffer<Type>();
        List<Tree> l2 = thrown;
        while (l2.nonEmpty()) {
            Type exc = this.attr.attribType((Tree)l2.head, env);
            if (exc.tag != 14) {
                exc = this.chk.checkClassType(((Tree)l2.head).pos, exc);
            }
            thrownbuf.append(exc);
            l2 = l2.tail;
        }
        Type.MethodType mtype = new Type.MethodType(argbuf.toList(), restype, thrownbuf.toList(), this.syms.methodClass);
        return tvars.isEmpty() ? mtype : new Type.ForAll(tvars, (Type)mtype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberEnter(Tree tree, Env<AttrContext> env) {
        Env<AttrContext> prevEnv = this.env;
        try {
            this.env = env;
            tree.accept(this);
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos, ex);
        }
        finally {
            this.env = prevEnv;
        }
    }

    void memberEnter(List<? extends Tree> trees, Env<AttrContext> env) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.memberEnter((Tree)l.head, env);
            l = l.tail;
        }
    }

    void finishClass(Tree.ClassDef tree, Env<AttrContext> env) {
        if ((tree.mods.flags & 0x4000L) != 0L && (this.types.supertype((Type)tree.sym.type).tsym.flags() & 0x4000L) == 0L) {
            this.addEnumMembers(tree, env);
        }
        this.memberEnter(tree.defs, env);
    }

    private void addEnumMembers(Tree.ClassDef tree, Env<AttrContext> env) {
        Tree valuesType = this.make.Type(new Type.ArrayType(tree.sym.type, (Symbol.TypeSymbol)this.syms.arrayClass));
        Tree.MethodDef values = this.make.MethodDef(this.make.Modifiers(25L), this.names.values, valuesType, Tree.TypeParameter.emptyList, Tree.VarDef.emptyList, Tree.emptyList, null, null);
        this.memberEnter(values, env);
        Tree.MethodDef valueOf = this.make.MethodDef(this.make.Modifiers(9L), this.names.valueOf, this.make.Type(tree.sym.type), Tree.TypeParameter.emptyList, Tree.VarDef.emptyList.prepend(this.make.VarDef(this.make.Modifiers(0L), this.names.fromString("name"), this.make.Type(this.syms.stringType), null)), Tree.emptyList, null, null);
        this.memberEnter(valueOf, env);
        if (!this.target.compilerBootstrap(tree.sym)) {
            return;
        }
        Tree.MethodDef ordinal = this.make.at(tree.pos).MethodDef(this.make.Modifiers(17L), this.names.ordinal, this.make.Type(this.syms.intType), Tree.TypeParameter.emptyList, Tree.VarDef.emptyList, Tree.emptyList, null, null);
        this.memberEnter(ordinal, env);
        Tree.MethodDef name = this.make.MethodDef(this.make.Modifiers(17L), this.names._name, this.make.Type(this.syms.stringType), Tree.TypeParameter.emptyList, Tree.VarDef.emptyList, Tree.emptyList, null, null);
        this.memberEnter(name, env);
        Symbol.MethodSymbol compareTo = new Symbol.MethodSymbol(1L, this.names.compareTo, new Type.MethodType(Type.emptyList.prepend(tree.sym.type), this.syms.intType, Type.emptyList, this.syms.methodClass), tree.sym);
        this.memberEnter(this.make.MethodDef(compareTo, null), env);
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
        if (tree.starImportScope.elems != null) {
            return;
        }
        if (tree.pid != null) {
            Symbol p = tree.packge;
            while (p.owner != this.syms.rootPackage) {
                p.owner.complete();
                if (this.syms.classes.get(((Symbol)p).fullName()) != null) {
                    this.log.error(tree.pos, "pkg.clashes.with.class.of.same.name", p);
                }
                p = p.owner;
            }
        }
        this.annotateLater(tree.packageAnnotations, this.env, tree.packge);
        this.importAll(tree.pos, this.reader.enterPackage(this.names.java_lang), this.env);
        this.memberEnter(tree.defs, this.env);
    }

    @Override
    public void visitImport(Tree.Import tree) {
        Tree imp = tree.qualid;
        Name name = TreeInfo.name(imp);
        Env<AttrContext> localEnv = this.env.dup(tree);
        Tree.Select s = (Tree.Select)imp;
        Symbol.TypeSymbol p = this.attr.attribTree((Tree)s.selected, localEnv, (int)(tree.staticImport ? 2 : 3), (Type)Type.noType).tsym;
        if (name == this.names.asterisk) {
            this.chk.checkCanonical(s.selected);
            if (tree.staticImport) {
                this.importStaticAll(tree.pos, p, this.env);
            } else {
                this.importAll(tree.pos, p, this.env);
            }
        } else if (tree.staticImport) {
            this.importNamedStatic(tree.pos, p, name, localEnv);
            this.chk.checkCanonical(s.selected);
        } else {
            Symbol.TypeSymbol c = this.attribImportType((Tree)imp, localEnv).tsym;
            this.chk.checkCanonical(imp);
            this.importNamed(tree.pos, c, this.env);
        }
    }

    @Override
    public void visitBind(Tree.Bind tree) {
        Tree imp = tree.qualid;
        Env<AttrContext> localEnv = this.env.dup(tree, ((AttrContext)this.env.info).dup(((AttrContext)this.env.info).scope.dupUnshared()));
        localEnv.outer = this.env;
        Type typ = this.attr.attribTree(tree.typ, localEnv, 1, Type.noType);
        List<Type> tvars = Type.emptyList;
        Type otype = this.attr.attribTree(tree.qualid, localEnv, 1, Type.noType);
        Symbol.TypeSymbol other = otype.tsym;
        this.chk.validateTypeParams(tree.typarams);
        this.chk.checkCanonical(imp);
        Symbol.AliasSymbol pck = this.reader.enterModuleBind((Symbol.PackageSymbol)typ.tsym, tree.alias.name, (Symbol.PackageSymbol)other, tvars);
        pck.type = otype;
        localEnv.toplevel.binds = localEnv.toplevel.binds.append(pck);
        ((AttrContext)localEnv.info).scope.leave();
    }

    @Override
    public void visitAlias(Tree.Alias tree) {
        Tree imp = tree.qualid;
        Env<AttrContext> localEnv = this.env.dup(tree, ((AttrContext)this.env.info).dup(((AttrContext)this.env.info).scope.dupUnshared()));
        localEnv.outer = this.env;
        List<Type> tvars = this.enter.classEnter(tree.typarams, localEnv);
        this.attr.attribStats(tree.typarams, localEnv);
        Symbol.TypeSymbol c = this.attr.attribType((Tree)tree.qualid, localEnv).tsym;
        Symbol.ClassSymbol other = (Symbol.ClassSymbol)TreeInfo.symbol(tree.qualid);
        Symbol.AliasSymbol sym = new Symbol.AliasSymbol(other.flags(), tree.alias.name, this.syms.emptyPackage, other);
        sym.completer = this.reader.moduleCompleter;
        Type.AliasType ret = new Type.AliasType(tvars, sym, tree.qualid.type);
        sym.type = ret;
        tree.alias.sym = sym;
        Scope toScope = this.env.toplevel.namedImportScope;
        this.chk.validateTypeParams(tree.typarams);
        this.chk.checkCanonical(imp);
        this.aliasClass(tree.pos, tree.alias, tree.typarams, TreeInfo.symbol(tree.alias), this.env);
        ((AttrContext)localEnv.info).scope.leave();
    }

    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        Scope enclScope = this.enter.enterScope(this.env);
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(0L, tree.name, null, enclScope.owner);
        m.flags_field = this.chk.checkFlags(tree.pos, tree.mods.flags, m, tree);
        tree.sym = m;
        Env<AttrContext> localEnv = this.methodEnv(tree, this.env);
        m.type = this.signature(tree.typarams, tree.params, tree.restype, tree.thrown, localEnv);
        ListBuffer<Symbol.VarSymbol> params = new ListBuffer<Symbol.VarSymbol>();
        Tree.VarDef lastParam = null;
        List<Tree.VarDef> l = tree.params;
        while (l.nonEmpty()) {
            Tree.VarDef param = lastParam = (Tree.VarDef)l.head;
            assert (param.sym != null);
            params.append(param.sym);
            l = l.tail;
        }
        m.params = params.toList();
        if (lastParam != null && (lastParam.mods.flags & 0x400000000L) != 0L) {
            m.flags_field |= 0x400000000L;
        }
        ((AttrContext)localEnv.info).scope.leave();
        if (this.chk.checkUnique(tree.pos, m, enclScope)) {
            enclScope.enter(m);
        }
        this.annotateLater(tree.mods.annotations, localEnv, m);
        if (tree.defaultValue != null) {
            this.annotateDefaultValueLater(tree.defaultValue, localEnv, m);
        }
    }

    Env<AttrContext> methodEnv(Tree.MethodDef tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared()));
        localEnv.enclMethod = tree;
        ((AttrContext)localEnv.info).scope.owner = tree.sym;
        if ((tree.mods.flags & 8L) != 0L) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        Env<AttrContext> localEnv = this.env;
        if ((tree.mods.flags & 8L) != 0L || (((AttrContext)this.env.info).scope.owner.flags() & 0x200L) != 0L) {
            localEnv = this.env.dup(tree, ((AttrContext)this.env.info).dup());
            ++((AttrContext)localEnv.info).staticLevel;
        }
        this.attr.attribType(tree.vartype, localEnv);
        Scope enclScope = this.enter.enterScope(this.env);
        Symbol.VarSymbol v = new Symbol.VarSymbol(0L, tree.name, tree.vartype.type, enclScope.owner);
        v.flags_field = this.chk.checkFlags(tree.pos, tree.mods.flags, v, tree);
        tree.sym = v;
        if (tree.init != null) {
            v.flags_field |= 0x40000L;
            if ((v.flags_field & 0x10L) != 0L && tree.init.tag != 28) {
                v.constValue = this.initEnv(tree, this.env);
            }
        }
        if (this.chk.checkUnique(tree.pos, v, enclScope)) {
            this.chk.checkTransparentVar(tree.pos, v, enclScope);
            enclScope.enter(v);
        }
        this.annotateLater(tree.mods.annotations, localEnv, v);
        v.pos = tree.pos;
    }

    Env<AttrContext> initEnv(Tree.VarDef tree, Env<AttrContext> env) {
        Env<AttrContext> localEnv = env.dupto(new AttrContextEnv((Tree)tree, ((AttrContext)env.info).dup()));
        if (tree.sym.owner.kind == 2) {
            ((AttrContext)localEnv.info).scope = new Scope.DelegatedScope(((AttrContext)env.info).scope);
            ((AttrContext)localEnv.info).scope.owner = tree.sym;
        }
        if ((tree.mods.flags & 8L) != 0L || (env.enclClass.sym.flags() & 0x200L) != 0L) {
            ++((AttrContext)localEnv.info).staticLevel;
        }
        return localEnv;
    }

    @Override
    public void visitTree(Tree tree) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type attribImportType(Tree tree, Env<AttrContext> env) {
        assert (this.completionEnabled);
        try {
            this.completionEnabled = false;
            Type type = this.attr.attribType(tree, env);
            return type;
        }
        finally {
            this.completionEnabled = true;
        }
    }

    void annotateLater(final List<Tree.Annotation> annotations, final Env<AttrContext> localEnv, final Symbol s) {
        if (annotations.isEmpty()) {
            return;
        }
        if (s.kind != 1) {
            s.attributes_field = null;
        }
        this.annotate.later(new Annotate.Annotator(){

            public String toString() {
                return "annotate " + annotations + " onto " + s + " in " + s.owner;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enterAnnotation() {
                assert (s.kind == 1 || s.attributes_field == null);
                Name prev = MemberEnter.this.log.useSource(localEnv.toplevel.sourcefile);
                try {
                    if (s.attributes_field != null && s.attributes_field.nonEmpty() && annotations.nonEmpty()) {
                        MemberEnter.this.log.error(((Tree.Annotation)annotations.head).pos, "already.annotated", Resolve.kindName(s.kind), s);
                    }
                    MemberEnter.this.enterAnnotations(annotations, localEnv, s);
                }
                finally {
                    MemberEnter.this.log.useSource(prev);
                }
            }
        });
    }

    private void enterAnnotations(List<Tree.Annotation> annotations, Env<AttrContext> env, Symbol s) {
        ListBuffer<Attribute.Compound> buf = new ListBuffer<Attribute.Compound>();
        HashSet<Symbol.TypeSymbol> annotated = new HashSet<Symbol.TypeSymbol>();
        if (!this.skipAnnotations) {
            List<Tree.Annotation> al = annotations;
            while (al.nonEmpty()) {
                Tree.Annotation a = (Tree.Annotation)al.head;
                Attribute.Compound c = this.annotate.enterAnnotation(a, this.syms.annotationType, env);
                if (c != null) {
                    buf.append(c);
                    if (this.types.isSameType(c.type, this.syms.deprecatedType)) {
                        s.flags_field |= 0x20000L;
                    }
                    if (!annotated.add(a.type.tsym)) {
                        this.log.error(a.pos, "duplicate.annotation", new Object[0]);
                    }
                }
                al = al.tail;
            }
        }
        s.attributes_field = buf.toList();
    }

    void annotateDefaultValueLater(final Tree defaultValue, final Env<AttrContext> localEnv, final Symbol.MethodSymbol m) {
        this.annotate.later(new Annotate.Annotator(){

            public String toString() {
                return "annotate " + m.owner + "." + m + " default " + defaultValue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void enterAnnotation() {
                Name prev = MemberEnter.this.log.useSource(localEnv.toplevel.sourcefile);
                try {
                    MemberEnter.this.enterDefaultValue(defaultValue, localEnv, m);
                }
                finally {
                    MemberEnter.this.log.useSource(prev);
                }
            }
        });
    }

    private void enterDefaultValue(Tree defaultValue, Env<AttrContext> localEnv, Symbol.MethodSymbol m) {
        m.defaultValue = this.annotate.enterAttributeValue(m.type.restype(), defaultValue, localEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            assert ((sym.flags() & 0x1000000L) == 0L);
            sym.completer = this;
            return;
        }
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
        Type.ClassType ct = (Type.ClassType)c.type;
        Env<AttrContext> env = this.enter.typeEnvs.get(c);
        Tree.ClassDef tree = (Tree.ClassDef)env.tree;
        boolean wasFirst = this.isFirst;
        this.isFirst = false;
        Name prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            this.halfcompleted.append(env);
            if (c.owner.kind == 1) {
                this.memberEnter(env.toplevel, env.enclosing(1));
                this.todo.append(env);
            }
            c.flags_field |= 0x10000000L;
            if (c.owner.kind == 2) {
                c.owner.complete();
            }
            Env<AttrContext> baseEnv = this.baseEnv(tree, env);
            this.attr.attribStats(tree.typarams, baseEnv);
            Type supertype = tree.extending != null ? this.attr.attribBase(tree.extending, baseEnv, false, false, true) : ((tree.mods.flags & 0x4000L) != 0L && !this.target.compilerBootstrap(c) ? this.attr.attribBase(this.enumBase(tree.pos, c), baseEnv, true, false, false) : (c.fullname == this.names.java_lang_Object ? Type.noType : this.syms.objectType));
            ListBuffer<Type> interfaces = new ListBuffer<Type>();
            HashSet<Type> interfaceSet = new HashSet<Type>();
            List<Tree> interfaceTrees = tree.implementing;
            if ((tree.mods.flags & 0x4000L) != 0L && this.target.compilerBootstrap(c)) {
                interfaceTrees = interfaceTrees.prepend(this.make.Type(new Type.ClassType(this.syms.comparableType.outer(), Type.emptyList.prepend(c.type), this.syms.comparableType.tsym)));
                interfaceTrees = interfaceTrees.prepend(this.make.Type(this.syms.serializableType));
            }
            List<Tree> l = interfaceTrees;
            while (l.nonEmpty()) {
                Type i = this.attr.attribBase((Tree)l.head, baseEnv, false, true, true);
                if (i.tag == 10) {
                    interfaces.append(i);
                    this.chk.checkNotRepeated(((Tree)l.head).pos, i, interfaceSet);
                }
                l = l.tail;
            }
            ct.supertype_field = supertype;
            ct.interfaces_field = (c.flags_field & 0x2000L) != 0L ? Type.emptyList.prepend(this.syms.annotationType) : interfaces.toList();
            if (c.fullname == this.names.java_lang_Object) {
                if (tree.extending != null) {
                    this.chk.checkNonCyclic(tree.extending.pos, supertype);
                    ct.supertype_field = Type.noType;
                } else if (tree.implementing.nonEmpty()) {
                    this.chk.checkNonCyclic(((Tree)tree.implementing.head).pos, (Type)ct.interfaces_field.head);
                    ct.interfaces_field = Type.emptyList;
                }
            }
            this.annotateLater(tree.mods.annotations, baseEnv, c);
            this.chk.checkNonCyclic(tree.pos, c.type);
            if ((c.flags() & 0x200L) == 0L && !TreeInfo.hasConstructors(tree.defs)) {
                List<Type> argtypes = Type.emptyList;
                List<Type> typarams = Type.emptyList;
                List<Type> thrown = Type.emptyList;
                long ctorFlags = 0L;
                boolean based = false;
                if (c.name.len == 0) {
                    Tree.NewClass nc = (Tree.NewClass)env.next.tree;
                    if (nc.constructor != null) {
                        Type superConstrType = this.types.memberType(c.type, nc.constructor);
                        argtypes = superConstrType.argtypes();
                        typarams = superConstrType.typarams();
                        ctorFlags = nc.constructor.flags() & 0x400000000L;
                        if (nc.encl != null) {
                            argtypes = argtypes.prepend(nc.encl.type);
                            based = true;
                        }
                        thrown = superConstrType.thrown();
                    }
                }
                Tree constrDef = this.DefaultConstructor(this.make.at(tree.pos), c, typarams, argtypes, thrown, ctorFlags, based);
                tree.defs = tree.defs.prepend(constrDef);
            }
            if ((c.flags_field & 0x200L) == 0L) {
                Symbol.VarSymbol thisSym = new Symbol.VarSymbol(262160L, this.names._this, c.type, c);
                thisSym.pos = 1025;
                ((AttrContext)env.info).scope.enter(thisSym);
                if (ct.supertype_field.tag == 10) {
                    Symbol.VarSymbol superSym = new Symbol.VarSymbol(262160L, this.names._super, ct.supertype_field, c);
                    superSym.pos = 1025;
                    ((AttrContext)env.info).scope.enter(superSym);
                }
            }
            if (tree.typarams.nonEmpty() && this.types.isSubType(supertype, this.syms.throwableType)) {
                this.log.error(tree.extending.pos, "generic.throwable", new Object[0]);
            }
            if (c.owner.kind == 1 && c.owner != this.syms.emptyPackage && this.reader.packageExists(c.fullname)) {
                this.log.error(tree.pos, "clash.with.pkg.of.same.name", c);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.chk.completionError(tree.pos, ex);
        }
        finally {
            this.log.useSource(prev);
        }
        if (wasFirst) {
            try {
                while (this.halfcompleted.nonEmpty()) {
                    this.finish(this.halfcompleted.next());
                }
            }
            finally {
                this.isFirst = true;
            }
            this.annotate.flush();
        }
    }

    private Env<AttrContext> baseEnv(Tree.ClassDef tree, Env<AttrContext> env) {
        List<Tree.TypeParameter> typarams;
        Scope typaramScope = new Scope(tree.sym);
        if (env.toplevel.module != null && env.toplevel.module.typarams != null) {
            typarams = env.toplevel.module.typarams;
            while (typarams.nonEmpty()) {
                typaramScope.enter(((Tree.TypeParameter)typarams.head).type.tsym);
                typarams = typarams.tail;
            }
        }
        if (tree.typarams != null) {
            typarams = tree.typarams;
            while (typarams.nonEmpty()) {
                typaramScope.enter(((Tree.TypeParameter)typarams.head).type.tsym);
                typarams = typarams.tail;
            }
        }
        Env<AttrContext> outer = env.outer;
        Env<AttrContext> localEnv = outer.dup(tree, ((AttrContext)outer.info).dup(typaramScope));
        localEnv.baseClause = true;
        localEnv.outer = outer;
        ((AttrContext)localEnv.info).isSelfCall = false;
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(Env<AttrContext> env) {
        Name prev = this.log.useSource(env.toplevel.sourcefile);
        try {
            Tree.ClassDef tree = (Tree.ClassDef)env.tree;
            this.finishClass(tree, env);
        }
        finally {
            this.log.useSource(prev);
        }
    }

    private Tree enumBase(int pos, Symbol.ClassSymbol c) {
        Tree.TypeApply result = this.make.at(pos).TypeApply(this.make.QualIdent(this.syms.enumSym), Tree.emptyList.prepend(this.make.Type(c.type)));
        return result;
    }

    Tree DefaultConstructor(TreeMaker make, Symbol.ClassSymbol c, List<Type> typarams, List<Type> argtypes, List<Type> thrown, long flags, boolean based) {
        List<Tree.VarDef> params = make.Params(argtypes, this.syms.noSymbol);
        List<Tree> stats = Tree.emptyList;
        if (c.type != this.syms.objectType) {
            stats = stats.prepend(this.SuperCall(make, typarams, params, based));
        }
        flags = (c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym ? flags & 0xFFFFFFFFFFFFFFF8L | 2L | 0x1000000000L : (flags |= c.flags() & 7L | 0x1000000000L);
        if (c.name.len == 0) {
            flags |= 0x20000000L;
        }
        Tree.MethodDef result = make.MethodDef(make.Modifiers(flags), this.names.init, null, make.TypeParams(typarams), params, make.Types(thrown), make.Block(0L, stats), null);
        return result;
    }

    Tree SuperCall(TreeMaker make, List<Type> typarams, List<Tree.VarDef> params, boolean based) {
        Tree meth;
        if (based) {
            meth = make.Select(make.Ident((Tree.VarDef)params.head), this.names._super);
            params = params.tail;
        } else {
            meth = make.Ident(this.names._super);
        }
        List<Tree> typeargs = typarams.nonEmpty() ? make.Types(typarams) : null;
        return make.Exec(make.Apply(typeargs, meth, make.Idents(params)));
    }
}

