/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.comp;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Source;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Enter;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Warner;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransTypes
extends TreeTranslator {
    protected static final Context.Key<TransTypes> transTypesKey = new Context.Key();
    private Name.Table names;
    private Log log;
    private Symtab syms;
    private TreeMaker make;
    private Enter enter;
    private boolean allowEnums;
    private Types types;
    Map<Symbol.MethodSymbol, Symbol.MethodSymbol> overridden;
    private Type pt;
    Tree.MethodDef currentMethod = null;

    public static TransTypes instance(Context context) {
        TransTypes instance = context.get(transTypesKey);
        if (instance == null) {
            instance = new TransTypes(context);
        }
        return instance;
    }

    protected TransTypes(Context context) {
        context.put(transTypesKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.overridden = new HashMap<Symbol.MethodSymbol, Symbol.MethodSymbol>();
        this.allowEnums = Source.instance(context).allowEnums();
        this.types = Types.instance(context);
        this.make = TreeMaker.instance(context);
    }

    Tree cast(Tree tree, Type target) {
        int oldpos = this.make.pos;
        this.make.at(tree.pos);
        if (!this.types.isSameType(tree.type, target)) {
            tree = this.make.TypeCast(this.make.Type(target), tree).setType(target);
        }
        this.make.pos = oldpos;
        return tree;
    }

    Tree coerce(Tree tree, Type target) {
        Type btarget = target.baseType();
        if (tree.type.isPrimitive() == target.isPrimitive()) {
            return this.types.isAssignable(tree.type, btarget, Warner.noWarnings) ? tree : this.cast(tree, btarget);
        }
        return tree;
    }

    Tree retype(Tree tree, Type erasedType, Type target) {
        if (erasedType.tag > 8) {
            if (target != null && target.isPrimitive()) {
                target = tree.type;
            }
            tree.type = erasedType;
            if (target != null) {
                return this.coerce(tree, target);
            }
        }
        return tree;
    }

    List<Tree> translateArgs(List<Tree> _args, List<Type> parameters, Type varargsElement) {
        if (parameters.isEmpty()) {
            return _args;
        }
        List<Tree> args = _args;
        while (parameters.tail.nonEmpty()) {
            args.head = this.translate((Tree)args.head, (Type)parameters.head);
            args = args.tail;
            parameters = parameters.tail;
        }
        Type parameter = (Type)parameters.head;
        assert (varargsElement != null || args.length() == 1);
        if (varargsElement != null) {
            while (args.nonEmpty()) {
                args.head = this.translate((Tree)args.head, varargsElement);
                args = args.tail;
            }
        } else {
            args.head = this.translate((Tree)args.head, parameter);
        }
        return _args;
    }

    void addBridge(int pos, Symbol.MethodSymbol meth, Symbol.MethodSymbol impl, Symbol.ClassSymbol origin, boolean hypothetical, ListBuffer<Tree> bridges) {
        this.make.at(pos);
        Type origType = this.types.memberType(origin.type, meth);
        Type origErasure = this.erasure(origType);
        Type bridgeType = meth.erasure(this.types);
        long flags = impl.flags() & 7L | 0x1000L | 0x80000000L;
        if (hypothetical) {
            flags |= 0x2000000000L;
        }
        Symbol.MethodSymbol bridge = new Symbol.MethodSymbol(flags, meth.name, bridgeType, origin);
        if (!hypothetical) {
            Tree.MethodDef md = this.make.MethodDef(bridge, null);
            Tree receiver = impl.owner == origin ? this.make.This(origin.erasure(this.types)) : this.make.Super(this.types.supertype((Type)origin.type).tsym.erasure(this.types), origin);
            Type calltype = this.erasure(impl.type.restype());
            Tree call = this.make.Apply(null, this.make.Select(receiver, impl).setType(calltype), this.translateArgs(this.make.Idents(md.params), origErasure.argtypes(), null)).setType(calltype);
            Tree.Exec stat = origErasure.restype().tag == 9 ? this.make.Exec(call) : this.make.Return(this.coerce(call, bridgeType.restype()));
            md.body = this.make.Block(0L, List.make(stat));
            bridges.append(md);
        }
        origin.members().enter(bridge);
        this.overridden.put(bridge, meth);
    }

    void addBridgeIfNeeded(int pos, Symbol sym, Symbol.ClassSymbol origin, ListBuffer<Tree> bridges) {
        if (sym.kind == 16 && sym.name != this.names.init && (sym.flags() & 0x100AL) == 0L && sym.isMemberOf(origin, this.types)) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
            Symbol.MethodSymbol bridge = meth.binaryImplementation(origin, this.types);
            Symbol.MethodSymbol impl = meth.implementation(origin, this.types, true);
            if (bridge == null || bridge == meth || impl != null && !bridge.owner.isSubClass(impl.owner, this.types)) {
                if (!(impl == null || (impl.flags() & 0x10L) != 0L && impl.owner != origin || (impl == meth && (meth.flags() & 0x400L) != 0L || this.types.isSameType(this.erasure(this.types.memberType(origin.type, meth)), meth.erasure(this.types)) && this.types.isSameType(this.erasure(this.types.memberType(origin.type, impl)), impl.erasure(this.types))) && (impl == meth || this.types.isSameType(impl.erasure(this.types).restype(), meth.erasure(this.types).restype())))) {
                    this.addBridge(pos, meth, impl, origin, bridge == impl, bridges);
                }
            } else if ((bridge.flags() & 0x1000L) != 0L) {
                Symbol.MethodSymbol other = this.overridden.get(bridge);
                if (!(other == null || other == meth || impl != null && impl.overrides(other, origin, this.types, true))) {
                    this.log.error(pos, "name.clash.same.erasure.no.override", other, other.location(origin.type, this.types), meth, meth.location(origin.type, this.types));
                }
            } else if (!(bridge.overrides(meth, origin, this.types, true) || bridge.owner != origin && this.types.asSuper(bridge.owner.type, meth.owner) != null)) {
                this.log.error(pos, "name.clash.same.erasure.no.override", bridge, bridge.location(origin.type, this.types), meth, meth.location(origin.type, this.types));
            }
        }
    }

    void addBridges(int pos, Symbol.TypeSymbol i, Symbol.ClassSymbol origin, ListBuffer<Tree> bridges) {
        Scope.Entry e = i.members().elems;
        while (e != null) {
            this.addBridgeIfNeeded(pos, e.sym, origin, bridges);
            e = e.sibling;
        }
        List<Type> l = this.types.interfaces(i.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    void addBridges(int pos, Symbol.ClassSymbol origin, ListBuffer<Tree> bridges) {
        Type st = this.types.supertype(origin.type);
        while (st.tag == 10) {
            this.addBridges(pos, st.tsym, origin, bridges);
            st = this.types.supertype(st);
        }
        List<Type> l = this.types.interfaces(origin.type);
        while (l.nonEmpty()) {
            this.addBridges(pos, ((Type)l.head).tsym, origin, bridges);
            l = l.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tree translate(Tree tree, Type pt) {
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            if (tree == null) {
                this.result = null;
            } else {
                tree.accept(this);
            }
            Object var5_4 = null;
            this.pt = prevPt;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.pt = prevPt;
            throw throwable;
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tree> translate(List<Tree> trees, Type pt) {
        List<Tree> res;
        Type prevPt = this.pt;
        try {
            this.pt = pt;
            res = this.translate(trees);
            Object var6_5 = null;
            this.pt = prevPt;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.pt = prevPt;
            throw throwable;
        }
        return res;
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        this.translateClass(tree.sym);
        this.result = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        Tree.MethodDef previousMethod = this.currentMethod;
        try {
            this.currentMethod = tree;
            tree.restype = this.translate(tree.restype, null);
            tree.typarams = Tree.TypeParameter.emptyList;
            tree.params = this.translateVarDefs(tree.params);
            tree.thrown = this.translate(tree.thrown, null);
            tree.body = (Tree.Block)this.translate(tree.body, tree.sym.erasure(this.types).restype());
            tree.type = this.erasure(tree.type);
            this.result = tree;
            Object var4_3 = null;
            this.currentMethod = previousMethod;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.currentMethod = previousMethod;
            throw throwable;
        }
        Scope.Entry e = tree.sym.owner.members().lookup(tree.name);
        while (e.sym != null) {
            if (e.sym != tree.sym && this.types.isSameType(this.erasure(e.sym.type), tree.type)) {
                this.log.error(tree.pos, "name.clash.same.erasure", tree.sym, e.sym);
                return;
            }
            e = e.next();
        }
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        tree.vartype = this.translate(tree.vartype, null);
        tree.init = this.translate(tree.init, tree.sym.erasure(this.types));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        tree.body = this.translate(tree.body);
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        this.result = tree;
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        tree.init = this.translate(tree.init, null);
        if (tree.cond != null) {
            tree.cond = this.translate(tree.cond, this.syms.booleanType);
        }
        tree.step = this.translate(tree.step, null);
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        tree.var = (Tree.VarDef)this.translate(tree.var, null);
        Type iterableType = tree.expr.type;
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        tree.expr.type = iterableType;
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        Type selsuper = this.types.supertype(tree.selector.type);
        boolean enumSwitch = selsuper != null && selsuper.tsym == this.syms.enumSym;
        Type target = enumSwitch ? this.erasure(tree.selector.type) : this.syms.intType;
        tree.selector = this.translate(tree.selector, target);
        tree.cases = this.translateCases(tree.cases);
        this.result = tree;
    }

    @Override
    public void visitCase(Tree.Case tree) {
        tree.pat = this.translate(tree.pat, null);
        tree.stats = this.translate(tree.stats);
        this.result = tree;
    }

    @Override
    public void visitSynchronized(Tree.Synchronized tree) {
        tree.lock = this.translate(tree.lock, this.erasure(tree.lock.type));
        tree.body = this.translate(tree.body);
        this.result = tree;
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.truepart = this.translate(tree.truepart, this.erasure(tree.type));
        tree.falsepart = this.translate(tree.falsepart, this.erasure(tree.type));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitIf(Tree.If tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        tree.thenpart = this.translate(tree.thenpart);
        tree.elsepart = this.translate(tree.elsepart);
        this.result = tree;
    }

    @Override
    public void visitExec(Tree.Exec tree) {
        tree.expr = this.translate(tree.expr, null);
        this.result = tree;
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        tree.expr = this.translate(tree.expr, this.currentMethod.sym.erasure(this.types).restype());
        this.result = tree;
    }

    @Override
    public void visitThrow(Tree.Throw tree) {
        tree.expr = this.translate(tree.expr, this.erasure(tree.expr.type));
        this.result = tree;
    }

    @Override
    public void visitAssert(Tree.Assert tree) {
        tree.cond = this.translate(tree.cond, this.syms.booleanType);
        if (tree.detail != null) {
            tree.detail = this.translate(tree.detail, this.erasure(tree.detail.type));
        }
        this.result = tree;
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        tree.meth = this.translate(tree.meth, null);
        Symbol meth = TreeInfo.symbol(tree.meth);
        Type mt = meth.erasure(this.types);
        List<Type> argtypes = mt.argtypes();
        if (this.allowEnums && meth.name == this.names.init && meth.owner == this.syms.enumSym) {
            argtypes = argtypes.tail.tail;
        }
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        } else assert (tree.args.length() == argtypes.length());
        tree.args = this.translateArgs(tree.args, argtypes, tree.varargsElement);
        this.result = this.retype(tree, mt.restype(), this.pt);
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        if (tree.encl != null) {
            tree.encl = this.translate(tree.encl, this.erasure(tree.encl.type));
        }
        tree.clazz = this.translate(tree.clazz, null);
        if (tree.varargsElement != null) {
            tree.varargsElement = this.types.erasure(tree.varargsElement);
        }
        tree.args = this.translateArgs(tree.args, tree.constructor.erasure(this.types).argtypes(), tree.varargsElement);
        tree.def = (Tree.ClassDef)this.translate(tree.def, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        this.translate(tree.dims, this.syms.intType);
        tree.elems = this.translate(tree.elems, tree.type == null ? null : this.erasure(this.types.elemtype(tree.type)));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitParens(Tree.Parens tree) {
        tree.expr = this.translate(tree.expr, this.pt);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, this.erasure(tree.lhs.type));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        tree.lhs = this.translate(tree.lhs, null);
        tree.rhs = this.translate(tree.rhs, this.erasure(tree.rhs.type));
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        tree.arg = this.translate(tree.arg, (Type)tree.operator.type.argtypes().head);
        this.result = tree;
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        tree.lhs = this.translate(tree.lhs, (Type)tree.operator.type.argtypes().head);
        tree.rhs = this.translate(tree.rhs, (Type)tree.operator.type.argtypes().tail.head);
        this.result = tree;
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        tree.clazz = this.translate(tree.clazz, null);
        tree.type = this.erasure(tree.type);
        tree.expr = this.translate(tree.expr, tree.type);
        this.result = tree;
    }

    @Override
    public void visitTypeTest(Tree.TypeTest tree) {
        tree.expr = this.translate(tree.expr, null);
        tree.clazz = this.translate(tree.clazz, null);
        this.result = tree;
    }

    @Override
    public void visitIndexed(Tree.Indexed tree) {
        tree.indexed = this.translate(tree.indexed, this.erasure(tree.indexed.type));
        tree.index = this.translate(tree.index, this.syms.intType);
        this.result = this.retype(tree, this.types.elemtype(tree.indexed.type), this.pt);
    }

    @Override
    public void visitAnnotation(Tree.Annotation tree) {
        this.result = tree;
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        Type et = tree.sym.erasure(this.types);
        if (tree.sym.kind == 2 && tree.sym.type.tag == 14) {
            this.result = this.make.at(tree.pos).Type(et);
        } else if (tree.type.constValue != null) {
            this.result = tree;
        } else if (tree.sym.kind == 4) {
            this.result = this.retype(tree, et, this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        Type t = tree.selected.type;
        if (t.tag == 14 && t.bound().isCompound()) {
            if ((tree.sym.flags() & 0x200000L) != 0L) {
                tree.sym = ((Symbol.MethodSymbol)tree.sym).implemented((Symbol.TypeSymbol)tree.sym.owner, this.types);
            }
            tree.selected = this.cast(this.translate(tree.selected, this.erasure(t)), this.erasure(tree.sym.owner.type));
        } else {
            tree.selected = this.translate(tree.selected, this.erasure(t));
        }
        if (tree.type.constValue != null) {
            this.result = tree;
        } else if (tree.sym.kind == 4) {
            this.result = this.retype(tree, tree.sym.erasure(this.types), this.pt);
        } else {
            tree.type = this.erasure(tree.type);
            this.result = tree;
        }
    }

    @Override
    public void visitTypeArray(Tree.TypeArray tree) {
        tree.elemtype = this.translate(tree.elemtype, null);
        tree.type = this.erasure(tree.type);
        this.result = tree;
    }

    @Override
    public void visitTypeApply(Tree.TypeApply tree) {
        this.result = this.translate(tree.clazz, null);
    }

    private Type erasure(Type t) {
        return this.types.erasure(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void translateClass(Symbol.ClassSymbol c) {
        Env<AttrContext> env;
        Type st = this.types.supertype(c.type);
        if (st.tag == 10) {
            this.translateClass((Symbol.ClassSymbol)st.tsym);
        }
        if ((env = this.enter.typeEnvs.remove(c)) != null) {
            TreeMaker savedMake = this.make;
            Type savedPt = this.pt;
            this.make = this.make.forToplevel(env.toplevel);
            this.pt = null;
            try {
                Tree.ClassDef tree = (Tree.ClassDef)env.tree;
                tree.typarams = Tree.TypeParameter.emptyList;
                super.visitClassDef(tree);
                this.make.at(tree.pos);
                ListBuffer<Tree> bridges = new ListBuffer<Tree>();
                if ((tree.sym.flags() & 0x200L) == 0L) {
                    this.addBridges(tree.pos, tree.sym, bridges);
                }
                tree.defs = bridges.toList().prependList(tree.defs);
                tree.type = this.erasure(tree.type);
                Object var9_8 = null;
                this.make = savedMake;
                this.pt = savedPt;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.make = savedMake;
                this.pt = savedPt;
                throw throwable;
            }
        }
    }

    public Tree translateTopLevelClass(Tree cdef, TreeMaker make) {
        this.make = make;
        this.pt = null;
        return this.translate(cdef, null);
    }
}

