/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import java.util.HashMap;

public class ModuleAnalyzer
extends TreeTranslator {
    Symbol.PackageSymbol pck;
    Type.PackageType ptype;
    private Symtab syms;
    private Name.Table names;
    public TypeFlattener tyflat;
    HashMap<Name, Type.ClassType> classMap = new HashMap();

    public void init(Context c, Symbol.PackageSymbol p) {
        this.syms = Symtab.instance(c);
        this.names = Name.Table.instance(c);
        this.tyflat = TypeFlattener.instance(c);
        this.pck = p;
        this.ptype = (Type.PackageType)p.type;
    }

    public void audit(Symbol.ClassSymbol sym) {
        if (this.ptype.typarams_field == null) {
            return;
        }
        Name newname = this.generateImportName(sym);
        if (newname != null) {
            sym.flatname = newname;
        }
    }

    protected Name generateImportName(Symbol.ClassSymbol sym) {
        Symbol s0 = sym;
        while (s0.owner.kind != 1) {
            s0 = s0.owner;
        }
        Symbol.PackageSymbol tvar = (Symbol.PackageSymbol)s0.owner;
        Type ttype = tvar.type;
        if (tvar != this.syms.emptyPackage && ttype == null) {
            return null;
        }
        int i = 0;
        if (this.ptype.typarams_field == null) {
            return null;
        }
        List<Type> l = this.ptype.typarams_field;
        while (l.nonEmpty()) {
            if (!(l.head instanceof Type.TypeVar)) {
                throw new RuntimeException("Unexpected type" + l.head + " in " + this.ptype.typarams_field);
            }
            Type.TypeVar var = (Type.TypeVar)l.head;
            if (ttype == var) {
                Symbol.TypeSymbol bsym = var.bound.tsym;
                Scope.Entry e = bsym.members().lookup(sym.name);
                if (e.scope != null) {
                    return this.names.fromString("{" + i + "-" + sym.name + "}");
                }
            }
            ++i;
            l = l.tail;
        }
        return null;
    }

    public void audit_same_module(Symbol.ClassSymbol sym) {
        Symbol.PackageSymbol mod = this.inModule(sym);
        if (mod != null) {
            if (sym.flatname.toString().indexOf("$$m") > 0) {
                return;
            }
            List<Type> typarams = ((Type.PackageType)mod.type).typarams_field;
            String res = "";
            int idx = 0;
            List<Type> l = typarams;
            while (l.nonEmpty()) {
                if (!res.equals("")) {
                    res = res + "$$C";
                }
                res = res + "{" + idx + "}";
                ++idx;
                l = l.tail;
            }
            if (idx > 0) {
                res = "$$m" + res + "$$n";
            }
            if (sym.owner == null || sym.owner != this.syms.emptyPackage) {
                // empty if block
            }
            if ((idx = sym.flatname.toString().indexOf("$$L")) > -1) {
                String base = sym.flatname.toString().substring(0, idx);
                String rest = sym.flatname.toString().substring(idx);
                sym.flatname = this.names.fromString(base + res + rest);
            } else {
                sym.flatname = this.names.fromString(sym.flatname + res);
            }
        }
    }

    private Symbol.PackageSymbol inModule(Symbol s) {
        if (s == null || s.owner == null) {
            return null;
        }
        Symbol owner = s.owner;
        while (owner.kind != 1) {
            owner = owner.owner;
        }
        if (s.name.equals(s.owner.name) && s.owner == owner) {
            return null;
        }
        if (owner.type.tag == 14) {
            owner = owner.type.bound().tsym;
            return (Symbol.PackageSymbol)owner;
        }
        Type.PackageType ptype = (Type.PackageType)((Symbol.PackageSymbol)owner).type;
        if (ptype.typarams_field != null) {
            return (Symbol.PackageSymbol)owner;
        }
        return null;
    }

    private Type.PackageType ofModule(Type type) {
        Symbol o = type.tsym;
        Type t = o.type;
        while (o.kind != 1) {
            o = o.owner;
        }
        if (o.type.tag == 14) {
            return (Type.PackageType)o.type.bound();
        }
        return null;
    }

    public void visitClassDef(Tree.ClassDef tree) {
        Type.ClassType ct = (Type.ClassType)tree.sym.type;
        if (ct.supertype_field.tag != 14) {
            Symbol.ClassSymbol super_sym = (Symbol.ClassSymbol)ct.supertype_field.tsym;
            this.audit(super_sym);
        }
        super.visitClassDef(tree);
        this.audit_same_module(tree.sym);
        this.result = tree;
    }

    public void visitMethodDef(Tree.MethodDef tree) {
        Symbol.MethodSymbol sym = tree.sym;
        Type type = tree.sym.type;
        switch (type.tag) {
            case 12: {
                Type.MethodType mtype = (Type.MethodType)type;
                List<Type> args = mtype.argtypes;
                while (args.nonEmpty()) {
                    if (((Type)args.head).tsym instanceof Symbol.ClassSymbol) {
                        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)((Type)args.head).tsym;
                        this.audit_same_module(csym);
                    }
                    args = args.tail;
                }
                break;
            }
        }
        super.visitMethodDef(tree);
    }

    public void visitVarDef(Tree.VarDef tree) {
        if (tree.sym.type.tag == 10) {
            this.audit((Symbol.ClassSymbol)tree.sym.type.tsym);
        }
        super.visitVarDef(tree);
    }

    public void visitNewClass(Tree.NewClass tree) {
        if (this.inModule(tree.type.tsym) == null) {
            this.result = tree;
            return;
        }
        Type.ClassType type = this.generateType((Type.ClassType)tree.type, tree.type);
        this.audit((Symbol.ClassSymbol)tree.type.tsym);
        tree.type = type;
        Symbol newConstructor = tree.constructor;
        if (tree.def == null) {
            newConstructor = tree.constructor.clone(type.tsym);
        }
        tree.constructor = newConstructor;
        super.visitNewClass(tree);
    }

    protected Name formFlatName(Symbol.TypeSymbol s, Type type) {
        return this.names.fromString(s.name + "$$m" + this.tyflat.formFlatNameList(type.typarams()) + "$$n");
    }

    public Type.ClassType generateType(Type.ClassType that, Type type) {
        Type.PackageType packageType = this.ofModule(that);
        if (packageType == null) {
            return that;
        }
        Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)packageType.tsym;
        if (packageSymbol == null) {
            return that;
        }
        Name flatname = this.generateImportName((Symbol.ClassSymbol)that.tsym);
        Name flatname0 = this.formFlatName((Symbol.ClassSymbol)that.tsym, packageType);
        Symbol owner = this.syms.emptyPackage;
        if (flatname == null) {
            flatname = flatname0;
            owner = that.tsym.owner;
        }
        Symbol.ClassSymbol flatTsym = null;
        Type.ClassType flatType = null;
        if (this.classMap.containsKey(flatname)) {
            flatType = this.classMap.get(flatname);
            flatTsym = (Symbol.ClassSymbol)flatType.tsym;
        } else {
            flatTsym = new Symbol.ClassSymbol(that.tsym.flags(), flatname, null, owner);
            flatType = new Type.ClassType(that.outer(), Type.emptyList, flatTsym);
            flatTsym.type = flatType;
            flatTsym.is_nextgen = true;
            flatType.interfaces_field = that.interfaces_field;
            flatType.supertype_field = that.supertype_field;
            flatTsym.members_field = ((Symbol.ClassSymbol)that.tsym).members_field;
            this.classMap.put(flatname, flatType);
        }
        return flatType;
    }

    public void visitSelect(Tree.Select tree) {
        if (this.inModule(TreeInfo.symbol(tree.selected)) != null) {
            this.result = tree;
            return;
        }
        if (tree.selected.type.tag == 10) {
            Type.ClassType flatType = this.generateType((Type.ClassType)tree.selected.type, tree.selected.type);
            tree.selected.type = flatType;
        }
        if (tree.type.argtypes() != null && tree.type.argtypes().nonEmpty()) {
            List<Type> l = tree.type.argtypes();
            while (l.nonEmpty()) {
                if (((Type)l.head).tag == 10) {
                    Type.ClassType flatType = this.generateType((Type.ClassType)l.head, (Type)l.head);
                    Symbol.ClassSymbol flatTsym = (Symbol.ClassSymbol)flatType.tsym;
                    l.head = flatType;
                }
                l = l.tail;
            }
        }
        this.result = tree;
        super.visitSelect(tree);
    }

    public void visitIdent(Tree.Ident tree) {
        super.visitIdent(tree);
    }
}

