/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.flatten.Flat;
import edu.rice.cs.nextgen2.compiler.flatten.TreeSnippeter;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import junit.framework.TestCase;

public class TreeSnippeterTest
extends TestCase {
    Name.Table names;
    TreeMaker make;
    Flat flatten;
    TreeSnippeter snippeter;

    public TreeSnippeterTest(String name) {
        super(name);
    }

    protected void setUp() {
        Context context = new Context();
        this.names = Name.Table.instance(context);
        this.make = TreeMaker.instance(context);
        this.flatten = Flat.instance(context);
        TreeSnippeter.init(context);
        this.snippeter = TreeSnippeter.instance();
    }

    protected Symbol.ClassSymbol genSym(String name) {
        Symbol.ClassSymbol sym = new Symbol.ClassSymbol(1L, this.names.fromString(name), null, null);
        Type.ClassType type = new Type.ClassType(Type.noType, Type.emptyList, sym);
        sym.type = type;
        return sym;
    }

    protected Symbol.TypeSymbol genTSym(String name) {
        Symbol.TypeSymbol sym = new Symbol.TypeSymbol(1L, this.names.fromString(name), null, null);
        Type.TypeVar type = new Type.TypeVar(sym, Type.noType);
        sym.type = type;
        return sym;
    }

    public void test_isSnippetable() {
        Tree t = new Tree.TypeTest(null, null);
        TreeSnippeterTest.assertTrue((boolean)TreeSnippeter.isSnippetable(t));
        t = new Tree.TypeCast(null, null);
        TreeSnippeterTest.assertTrue((boolean)TreeSnippeter.isSnippetable(t));
        t = new Tree.NewClass(null, null, null, null, null);
        TreeSnippeterTest.assertTrue((boolean)TreeSnippeter.isSnippetable(t));
        t = new Tree.NewArray(null, null, null);
        TreeSnippeterTest.assertTrue((boolean)TreeSnippeter.isSnippetable(t));
        t = new Tree.Unary(47, null);
        TreeSnippeterTest.assertTrue((!TreeSnippeter.isSnippetable(t) ? 1 : 0) != 0);
        t = new Tree.Apply(null, null, null);
        TreeSnippeterTest.assertTrue((boolean)TreeSnippeter.isSnippetable(t));
        t = new Tree.Parens(null);
        TreeSnippeterTest.assertTrue((!TreeSnippeter.isSnippetable(t) ? 1 : 0) != 0);
        t = new Tree.Erroneous();
        TreeSnippeterTest.assertTrue((!TreeSnippeter.isSnippetable(t) ? 1 : 0) != 0);
    }

    public void testNewClass() {
        Symbol.TypeSymbol _tvar = this.genTSym("Element");
        Tree.Ident tvar = (Tree.Ident)this.make.Ident(_tvar);
        List<Tree> typeargs = Tree.emptyList.append(tvar);
        Symbol.ClassSymbol _clazz = this.genSym("String");
        Tree.Ident clazz = (Tree.Ident)this.make.Ident(_clazz);
        Symbol.ClassSymbol _var = this.genSym("x");
        Tree.Ident var = (Tree.Ident)this.make.Ident(_var);
        List<Tree> args = Tree.emptyList.append(var);
        Tree.ClassDef def = new Tree.ClassDef(this.make.Modifiers(17L), this.names.fromString("MyClass"), Tree.TypeParameter.emptyList, clazz, Tree.emptyList, Tree.emptyList, _clazz);
        Symbol.MethodSymbol sym = new Symbol.MethodSymbol(17L, this.names.fromString("MyClass"), null, null);
        sym.owner = _clazz;
        Type.MethodType type = new Type.MethodType(null, null, null, null);
        sym.type = type;
        Tree.NewClass tree = new Tree.NewClass(null, typeargs, clazz, args, def);
        tree.constructor = sym;
        tree.type = type;
        tree.pos = 5;
        TreeSnippeter.Snippeter _tree = this.snippeter.find(tree);
        TreeSnippeterTest.assertEquals((Object)_tree.getTypeArg(), (Object)tree.type);
        TreeSnippeterTest.assertEquals(_tree.getArgs(), args);
        TreeSnippeterTest.assertEquals((String)("$new$" + tree.type), (String)_tree.snippetString());
        _tree.setArgs(Tree.emptyList);
        TreeSnippeterTest.assertEquals(_tree.getArgs(), Tree.emptyList);
        TreeSnippeterTest.assertTrue((_tree.getArgs() != args ? 1 : 0) != 0);
        Symbol.ClassSymbol _clazz2 = this.genSym("Float");
        _tree.setTypeArg(_clazz2.type);
        TreeSnippeterTest.assertEquals((Object)_tree.getTypeArg(), (Object)_clazz2.type);
        TreeSnippeterTest.assertEquals((Object)_tree.getTypeArg(), (Object)tree.type);
        TreeSnippeterTest.assertTrue((_tree.getTypeArg() != type ? 1 : 0) != 0);
        TreeSnippeterTest.assertEquals((Object)_clazz2, (Object)tree.clazz.type.tsym);
        TreeSnippeterTest.assertEquals((Object)_clazz2.name, (Object)((Tree.Ident)tree.clazz).name);
        Tree _copy = _tree.copy();
        TreeSnippeterTest.assertTrue((tree != _copy ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((boolean)(_copy instanceof Tree.NewClass));
        Tree.NewClass copy = (Tree.NewClass)_copy;
        TreeSnippeterTest.assertEquals((Object)tree.encl, (Object)copy.encl);
        TreeSnippeterTest.assertEquals(tree.typeargs, copy.typeargs);
        TreeSnippeterTest.assertEquals((Object)tree.clazz, (Object)copy.clazz);
        TreeSnippeterTest.assertEquals(tree.args, copy.args);
        TreeSnippeterTest.assertEquals((Object)tree.def, (Object)copy.def);
        TreeSnippeterTest.assertEquals((Object)tree.constructor, (Object)copy.constructor);
        TreeSnippeterTest.assertEquals((int)tree.pos, (int)copy.pos);
        TreeSnippeterTest.assertEquals((Object)tree.type, (Object)copy.type);
    }

    public void testNewArray() {
        System.out.println("TreeSnippeterTest.testNewArray not implemented");
    }

    public void testTypeTest() {
        Symbol.TypeSymbol tvar = this.genTSym("Element");
        Tree.Ident clazz = (Tree.Ident)this.make.Ident(tvar);
        Symbol.ClassSymbol var = this.genSym("x");
        Tree.Ident expr = (Tree.Ident)this.make.Ident(var);
        Symbol.ClassSymbol var2 = this.genSym("y");
        Tree.Ident expr2 = (Tree.Ident)this.make.Ident(var);
        Tree.TypeTest tree = this.make.TypeTest(expr, clazz);
        TreeSnippeter.Snippeter _tree = this.snippeter.find(tree);
        TreeSnippeterTest.assertEquals((Object)_tree.getTypeArg(), (Object)tvar.type);
        TreeSnippeterTest.assertEquals(_tree.getArgs(), List.make(expr));
        TreeSnippeterTest.assertEquals((String)("$instanceOf$" + tvar.type), (String)_tree.snippetString());
        _tree.setArgs(List.make(expr2));
        TreeSnippeterTest.assertEquals(_tree.getArgs(), List.make(expr2));
        Symbol.ClassSymbol sym = this.genSym("Z");
        _tree.setTypeArg(sym.type);
        TreeSnippeterTest.assertEquals((Object)sym.type, (Object)_tree.getTypeArg());
        TreeSnippeterTest.assertEquals((Object)sym.type, (Object)tree.clazz.type);
        TreeSnippeterTest.assertTrue((sym.type != clazz.type ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((sym.type != var.type ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((sym.type != var2.type ? 1 : 0) != 0);
        Tree tree2 = _tree.copy();
        TreeSnippeterTest.assertTrue((boolean)(tree2 instanceof Tree.TypeTest));
        TreeSnippeterTest.assertTrue((tree.expr == ((Tree.TypeTest)tree2).expr ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((tree.clazz == ((Tree.TypeTest)tree2).clazz ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((tree.pos == tree2.pos ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((tree.type == tree2.type ? 1 : 0) != 0);
    }

    public void testTypeCast() {
        Symbol.TypeSymbol tvar = this.genTSym("Element");
        Tree.Ident clazz = (Tree.Ident)this.make.Ident(tvar);
        Symbol.ClassSymbol var = this.genSym("x");
        Tree.Ident expr = (Tree.Ident)this.make.Ident(var);
        Symbol.ClassSymbol var2 = this.genSym("y");
        Tree.Ident expr2 = (Tree.Ident)this.make.Ident(var);
        Tree.TypeCast tree = this.make.TypeCast(clazz, (Tree)expr);
        TreeSnippeter.Snippeter _tree = this.snippeter.find(tree);
        TreeSnippeterTest.assertEquals((Object)_tree.getTypeArg(), (Object)tvar.type);
        TreeSnippeterTest.assertEquals(_tree.getArgs(), List.make(expr));
        TreeSnippeterTest.assertEquals((String)("$castTo$" + tvar.type), (String)_tree.snippetString());
        _tree.setArgs(List.make(expr2));
        TreeSnippeterTest.assertEquals(_tree.getArgs(), List.make(expr2));
        Symbol.ClassSymbol sym = this.genSym("Z");
        _tree.setTypeArg(sym.type);
        TreeSnippeterTest.assertEquals((Object)sym.type, (Object)_tree.getTypeArg());
        TreeSnippeterTest.assertEquals((Object)sym.type, (Object)tree.clazz.type);
        TreeSnippeterTest.assertTrue((sym.type != clazz.type ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((sym.type != var.type ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((sym.type != var2.type ? 1 : 0) != 0);
        Tree tree2 = _tree.copy();
        TreeSnippeterTest.assertTrue((boolean)(tree2 instanceof Tree.TypeCast));
        TreeSnippeterTest.assertTrue((tree.expr == ((Tree.TypeCast)tree2).expr ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((tree.clazz == ((Tree.TypeCast)tree2).clazz ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((tree.pos == tree2.pos ? 1 : 0) != 0);
        TreeSnippeterTest.assertTrue((tree.type == tree2.type ? 1 : 0) != 0);
    }
}

