/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import junit.framework.TestCase;

public class TypeFlattenerTest
extends TestCase {
    Name.Table names;
    TypeFlattener flatten;

    public TypeFlattenerTest(String name) {
        super(name);
    }

    protected void setUp() {
        Context context = new Context();
        this.flatten = TypeFlattener.instance(context);
        this.names = Name.Table.instance(context);
    }

    protected Symbol.ClassSymbol genSym(String name) {
        Symbol.ClassSymbol sym = new Symbol.ClassSymbol(1L, this.names.fromString(name), null, null);
        Type.ClassType type = new Type.ClassType(Type.noType, Type.emptyList, sym);
        sym.type = type;
        return sym;
    }

    protected Symbol.ClassSymbol genSym2(String name) {
        Symbol.PackageSymbol outer = new Symbol.PackageSymbol(this.names.fromString("U"), null, null);
        Symbol.ClassSymbol sym = new Symbol.ClassSymbol(1L, this.names.fromString(name), null, outer);
        Type.ClassType type = new Type.ClassType(Type.noType, Type.emptyList, sym);
        sym.type = type;
        return sym;
    }

    public void test_mangledName() {
        Symbol.ClassSymbol sym = this.genSym("NoTyparams");
        TypeFlattenerTest.assertEquals((String)"NoTyparams", (String)this.flatten.mangledName(sym.type));
    }

    public void test_mangledName2() {
        Symbol.ClassSymbol sym = this.genSym2("NoTyparams");
        TypeFlattenerTest.assertEquals((String)"U$$DNoTyparams", (String)this.flatten.mangledName(sym.type));
    }

    public void test_mangledName3() {
        Symbol.ClassSymbol sym = this.genSym("TestObj");
        Symbol.ClassSymbol sym1 = new Symbol.ClassSymbol(2L, this.names.fromString("InnerObj"), null, sym);
        Type.ClassType type1 = new Type.ClassType(Type.noType, Type.emptyList, sym1);
        TypeFlattenerTest.assertEquals((String)"TestObj$InnerObj", (String)this.flatten.mangledName(type1).toString());
    }

    public void test_formFlatName() {
        Symbol.ClassSymbol sym = this.genSym("TestObj");
        Symbol.ClassSymbol sym1 = new Symbol.ClassSymbol(2L, this.names.fromString("InnerObj"), null, sym);
        Type.ClassType type1 = new Type.ClassType(Type.noType, Type.emptyList, sym1);
        sym1.type = type1;
        List<Type> params = List.make(sym.type);
        params = params.append(sym1.type);
        TypeFlattenerTest.assertEquals((String)"TestObj$$LTestObj$$CTestObj$InnerObj$$R", (String)this.flatten.formFlatName(sym, params).toString());
    }

    public void test_flattenTypeVar() {
        Symbol.ClassSymbol owner = this.genSym("TestObj");
        Type.TypeVar var = new Type.TypeVar(this.names.fromString("Item"), (Symbol)owner);
        Type.TypeVar var2 = new Type.TypeVar(this.names.fromString("Item2"), (Symbol)owner);
        var.bound = this.genSym((String)"super1").type;
        var2.bound = this.genSym((String)"super2").type;
        List<Name> boundVars = List.make(this.names.fromString("Item"));
        Type type = this.flatten.flatten((Type)var, boundVars);
        TypeFlattenerTest.assertEquals((String)"{0}", (String)type.toString());
        boundVars = boundVars.append(this.names.fromString("Item2"));
        type = this.flatten.flatten((Type)var2, boundVars);
        TypeFlattenerTest.assertEquals((String)"{1}", (String)type.toString());
    }
}

