/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.flatten;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.flatten.Flat;
import edu.rice.cs.nextgen2.compiler.flatten.Util;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.util.NGUtil;
import junit.framework.TestCase;

public class UtilTest
extends TestCase {
    Name.Table names;
    Flat flatten;

    public UtilTest(String name) {
        super(name);
    }

    protected void setUp() {
        Context context = new Context();
        this.flatten = Flat.instance(context);
        this.names = Name.Table.instance(context);
    }

    protected Symbol.ClassSymbol genSym(String name) {
        Symbol.ClassSymbol sym = new Symbol.ClassSymbol(1L, this.names.fromString(name), null, null);
        Type.ClassType type = new Type.ClassType(Type.noType, Type.emptyList, sym);
        sym.type = type;
        return sym;
    }

    public void test_isGround() {
        Type.TypeVar type = new Type.TypeVar(this.names.fromString("Element"), null);
        UtilTest.assertFalse((boolean)Util.isGround(type));
        Symbol.ClassSymbol sym = this.genSym("NoParams");
        UtilTest.assertTrue((boolean)Util.isGround(sym.type));
        Type.ArgumentType type2 = new Type.ArgumentType(type, null, null, null);
        UtilTest.assertFalse((boolean)Util.isGround(type2));
        type2 = new Type.ArgumentType(sym.type, null, null, null);
        UtilTest.assertTrue((boolean)Util.isGround(type2));
        sym = this.genSym("Params");
        ((Type.ClassType)sym.type).typarams_field = List.make(type);
        UtilTest.assertFalse((boolean)Util.isGround(sym.type));
    }

    public void test_dotToDOT() {
        String clazz = "java.lang.Object";
        UtilTest.assertEquals((String)"java$$Dlang$$DObject", (String)NGUtil.dotToDOT(clazz));
    }

    public void test_toMethodString() {
        Symbol.ClassSymbol sym = this.genSym("TestObj");
        Symbol.ClassSymbol sym1 = new Symbol.ClassSymbol(2L, this.names.fromString("InnerObj"), null, sym);
        Type.TypeVar type = new Type.TypeVar(this.names.fromString("Element"), null);
        Type.ClassType type1 = new Type.ClassType(Type.noType, List.make(type), sym1);
        UtilTest.assertEquals((String)"TestObj$$DInnerObj$$LElement$$R", (String)Util.toMethodString(type1).toString());
    }
}

