/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.jvm;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Source;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.Resolve;
import edu.rice.cs.nextgen2.compiler.jvm.CRTable;
import edu.rice.cs.nextgen2.compiler.jvm.ClassWriter;
import edu.rice.cs.nextgen2.compiler.jvm.Code;
import edu.rice.cs.nextgen2.compiler.jvm.Items;
import edu.rice.cs.nextgen2.compiler.jvm.Pool;
import edu.rice.cs.nextgen2.compiler.jvm.Target;
import edu.rice.cs.nextgen2.compiler.jvm.UninitializedType;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeScanner;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Options;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gen
extends Tree.Visitor {
    protected static final Context.Key<Gen> genKey = new Context.Key();
    private final Log log;
    private final Symtab syms;
    private final Check chk;
    private final Resolve rs;
    private final TreeMaker make;
    private final ClassWriter writer;
    private final Name.Table names;
    private final Target target;
    private Type stringBufferType;
    private Name accessDollar;
    private final Types types;
    private final boolean allowGenerics;
    private final boolean generateIproxies;
    private final boolean stackMap;
    private final Type methodType;
    private final boolean lineDebugInfo;
    private final boolean varDebugInfo;
    private final boolean genCrt;
    private final boolean debugCode;
    private final int jsrlimit;
    private Pool pool = new Pool();
    private Code code;
    private Items items;
    private Env<AttrContext> attrEnv;
    private Tree.TopLevel toplevel;
    private int nerrs = 0;
    private Map<Tree, Integer> endPositions;
    Env<GenContext> env;
    Type pt;
    Items.Item result;

    public static Gen instance(Context context) {
        Gen instance = context.get(genKey);
        if (instance == null) {
            instance = new Gen(context);
        }
        return instance;
    }

    protected Gen(Context context) {
        context.put(genKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.chk = Check.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.target = Target.instance(context);
        this.types = Types.instance(context);
        this.methodType = new Type.MethodType(null, null, null, this.syms.methodClass);
        this.allowGenerics = Source.instance(context).allowGenerics();
        this.stringBufferType = this.target.useStringBuilder() ? this.syms.stringBuilderType : this.syms.stringBufferType;
        this.accessDollar = this.names.fromString("access" + this.target.syntheticNameChar());
        Options options = Options.instance(context);
        boolean bl = this.lineDebugInfo = options.get("-g:") == null || options.get("-g:lines") != null;
        this.varDebugInfo = options.get("-g:") == null ? options.get("-g") != null : options.get("-g:vars") != null;
        this.genCrt = options.get("-Xjcov") != null;
        this.debugCode = options.get("debugcode") != null;
        this.generateIproxies = this.target.requiresIproxy() || options.get("miranda") != null;
        this.stackMap = this.target.generateStackmap() || options.get("-cldc") != null;
        int setjsrlimit = 50;
        String jsrlimitString = (String)options.get("jsrlimit");
        if (jsrlimitString != null) {
            try {
                setjsrlimit = Integer.parseInt(jsrlimitString);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        this.jsrlimit = setjsrlimit;
    }

    void loadIntConst(int n) {
        this.items.makeImmediateItem(this.syms.intType, n).load();
    }

    public static int zero(int tc) {
        switch (tc) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new AssertionError((Object)"zero");
    }

    public static int one(int tc) {
        return Gen.zero(tc) + 1;
    }

    void emitMinusOne(int tc) {
        if (tc == 1) {
            this.items.makeImmediateItem(this.syms.longType, new Long(-1L)).load();
        } else {
            this.code.emitop0(2);
        }
    }

    Symbol binaryQualifier(Symbol sym, Type site) {
        if (site.tag == 11) {
            if (sym == this.syms.lengthVar || sym.owner != this.syms.arrayClass) {
                return sym;
            }
            Symbol.TypeSymbol qualifier = this.target.arrayBinaryCompatibility() ? new Symbol.ClassSymbol(1L, site.tsym.name, site, this.syms.noSymbol) : this.syms.objectType.tsym;
            return sym.clone(qualifier);
        }
        if (sym.owner == site.tsym || (sym.flags() & 0x1008L) == 4104L) {
            return sym;
        }
        if (!this.target.obeyBinaryCompatibility()) {
            return this.rs.isAccessible(this.attrEnv, (Symbol.TypeSymbol)sym.owner) ? sym : sym.clone(site.tsym);
        }
        if (!this.target.interfaceFieldsBinaryCompatibility() && (sym.owner.flags() & 0x200L) != 0L && sym.kind == 4) {
            return sym;
        }
        if (sym.owner == this.syms.objectType.tsym) {
            return sym;
        }
        if (!this.target.interfaceObjectOverridesBinaryCompatibility() && (sym.owner.flags() & 0x200L) != 0L && this.syms.objectType.tsym.members().lookup((Name)sym.name).scope != null) {
            return sym;
        }
        return sym.clone(site.tsym);
    }

    int makeRef(int pos, Type type) {
        this.checkDimension(pos, type);
        return this.pool.put(type.tag == 10 ? type.tsym : type);
    }

    private void checkDimension(int pos, Type t) {
        switch (t.tag) {
            case 12: {
                this.checkDimension(pos, t.restype());
                List<Type> args = t.argtypes();
                while (args.nonEmpty()) {
                    this.checkDimension(pos, (Type)args.head);
                    args = args.tail;
                }
                break;
            }
            case 11: {
                if (this.types.dimensions(t) <= 255) break;
                this.log.error(pos, "limit.dimensions", new Object[0]);
                ++this.nerrs;
                break;
            }
        }
    }

    Items.LocalItem makeTemp(Type type) {
        Symbol.VarSymbol v = new Symbol.VarSymbol(4096L, this.names.empty, type, this.env.enclMethod.sym);
        this.code.newLocal(v);
        return this.items.makeLocalItem(v);
    }

    void callMethod(int pos, Type site, Name name, List<Type> argtypes, boolean isStatic) {
        Symbol.MethodSymbol msym = this.rs.resolveInternalMethod(pos, this.attrEnv, site, name, argtypes, null);
        if (isStatic) {
            this.items.makeStaticItem(msym).invoke();
        } else {
            this.items.makeMemberItem(msym, name == this.names.init).invoke();
        }
    }

    private boolean isAccessSuper(Tree.MethodDef enclMethod) {
        return (enclMethod.mods.flags & 0x1000L) != 0L && this.isOddAccessName(enclMethod.name);
    }

    private boolean isOddAccessName(Name name) {
        return name.startsWith(this.accessDollar) && (name.byteAt(name.len - 1) & 1) == 1;
    }

    void genFinalizer(Env<GenContext> env) {
        if (this.code.isAlive() && ((GenContext)env.info).finalize != null) {
            ((GenContext)env.info).finalize.gen();
        }
    }

    Env<GenContext> unwind(Tree target, Env<GenContext> env) {
        Env<GenContext> env1 = env;
        while (true) {
            this.genFinalizer(env1);
            if (env1.tree == target) break;
            env1 = env1.next;
        }
        return env1;
    }

    void endFinalizerGap(Env<GenContext> env) {
        if (((GenContext)env.info).gaps != null && ((GenContext)env.info).gaps.length() % 2 == 1) {
            ((GenContext)env.info).gaps.append(this.code.curPc());
        }
    }

    void endFinalizerGaps(Env<GenContext> from, Env<GenContext> to) {
        Env<GenContext> last = null;
        while (last != to) {
            this.endFinalizerGap(from);
            last = from;
            from = from.next;
        }
    }

    boolean hasFinally(Tree target, Env<GenContext> env) {
        while (env.tree != target) {
            if (env.tree.tag == 17 && ((GenContext)env.info).finalize.hasFinalizer()) {
                return true;
            }
            env = env.next;
        }
        return false;
    }

    List<Tree> normalizeDefs(List<Tree> defs, Symbol.ClassSymbol c) {
        Tree.Block block;
        ListBuffer<Tree> initCode = new ListBuffer<Tree>();
        ListBuffer<Tree> clinitCode = new ListBuffer<Tree>();
        ListBuffer<Tree> methodDefs = new ListBuffer<Tree>();
        List<Tree> l = defs;
        while (l.nonEmpty()) {
            Tree def = (Tree)l.head;
            switch (def.tag) {
                case 8: {
                    block = (Tree.Block)def;
                    if ((block.flags & 8L) != 0L) {
                        clinitCode.append(def);
                        break;
                    }
                    initCode.append(def);
                    break;
                }
                case 5: {
                    methodDefs.append(def);
                    break;
                }
                case 6: {
                    Integer endPos;
                    Tree init;
                    Tree.VarDef vdef = (Tree.VarDef)def;
                    Symbol.VarSymbol sym = vdef.sym;
                    this.checkDimension(vdef.pos, sym.type);
                    if (vdef.init == null) break;
                    if ((sym.flags() & 8L) == 0L) {
                        init = this.make.at(vdef.pos).Assignment(sym, vdef.init);
                        initCode.append(init);
                        if (this.endPositions == null || (endPos = this.endPositions.remove(vdef)) == null) break;
                        this.endPositions.put(init, endPos);
                        break;
                    }
                    if (sym.constValue == null) {
                        init = this.make.at(vdef.pos).Assignment(sym, vdef.init);
                        clinitCode.append(init);
                        if (this.endPositions == null || (endPos = this.endPositions.remove(vdef)) == null) break;
                        this.endPositions.put(init, endPos);
                        break;
                    }
                    this.checkStringConstant(vdef.init.pos, sym.constValue);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            l = l.tail;
        }
        if (initCode.length() != 0) {
            List<Tree> inits = initCode.toList();
            for (Tree t : methodDefs) {
                this.normalizeMethod((Tree.MethodDef)t, inits);
            }
        }
        if (clinitCode.length() != 0) {
            Symbol.MethodSymbol clinit = new Symbol.MethodSymbol(8L, this.names.clinit, new Type.MethodType(Type.emptyList, this.syms.voidType, Type.emptyList, this.syms.methodClass), c);
            c.members().enter(clinit);
            List<Tree> clinitStats = clinitCode.toList();
            block = this.make.at(((Tree)clinitStats.head).pos).Block(0L, clinitStats);
            block.endpos = TreeInfo.endPos(clinitStats.last());
            methodDefs.append(this.make.MethodDef(clinit, block));
        }
        return methodDefs.toList();
    }

    private void checkStringConstant(int pos, Object constValue) {
        if (this.nerrs != 0 || constValue == null || !(constValue instanceof String) || ((String)constValue).length() < 65535) {
            return;
        }
        this.log.error(pos, "limit.string", new Object[0]);
        ++this.nerrs;
    }

    void normalizeMethod(Tree.MethodDef md, List<Tree> initCode) {
        if (md.name == this.names.init && TreeInfo.isInitialConstructor(md)) {
            List<Tree> stats = md.body.stats;
            ListBuffer newstats = new ListBuffer();
            if (stats.nonEmpty()) {
                while (TreeInfo.isSyntheticInit((Tree)stats.head)) {
                    newstats.append(stats.head);
                    stats = stats.tail;
                }
                newstats.append(stats.head);
                stats = stats.tail;
                while (stats.nonEmpty() && TreeInfo.isSyntheticInit((Tree)stats.head)) {
                    newstats.append(stats.head);
                    stats = stats.tail;
                }
                newstats.appendList(initCode);
                while (stats.nonEmpty()) {
                    newstats.append(stats.head);
                    stats = stats.tail;
                }
            }
            md.body.stats = newstats.toList();
            if (md.body.endpos == 0) {
                md.body.endpos = TreeInfo.endPos(md.body.stats.last());
            }
        }
    }

    void implementInterfaceMethods(Symbol.ClassSymbol c) {
        this.implementInterfaceMethods(c, c);
    }

    void implementInterfaceMethods(Symbol.ClassSymbol c, Symbol.ClassSymbol site) {
        List<Type> l = this.types.interfaces(c.type);
        while (l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)((Type)l.head).tsym;
            Scope.Entry e = i.members().elems;
            while (e != null) {
                if (e.sym.kind == 16 && (e.sym.flags() & 8L) == 0L) {
                    Symbol.MethodSymbol absMeth = (Symbol.MethodSymbol)e.sym;
                    Symbol.MethodSymbol implMeth = absMeth.binaryImplementation(site, this.types);
                    if (implMeth == null) {
                        this.addAbstractMethod(site, absMeth);
                    } else if ((implMeth.flags() & 0x200000L) != 0L) {
                        this.adjustAbstractMethod(site, implMeth, absMeth);
                    }
                }
                e = e.sibling;
            }
            this.implementInterfaceMethods(i, site);
            l = l.tail;
        }
    }

    private void addAbstractMethod(Symbol.ClassSymbol c, Symbol.MethodSymbol m) {
        Symbol.MethodSymbol absMeth = new Symbol.MethodSymbol(m.flags() | 0x200000L | 0x1000L, m.name, m.type, c);
        c.members().enter(absMeth);
    }

    private void adjustAbstractMethod(Symbol.ClassSymbol c, Symbol.MethodSymbol pm, Symbol.MethodSymbol im) {
        Type.MethodType pmt = (Type.MethodType)pm.type;
        Type imt = this.types.memberType(c.type, im);
        pmt.thrown = this.chk.intersect(pmt.thrown(), imt.thrown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genDef(Tree tree, Env<GenContext> env) {
        Env<GenContext> prevEnv = this.env;
        try {
            try {
                this.env = env;
                tree.accept(this);
            }
            catch (Symbol.CompletionFailure ex) {
                this.chk.completionError(tree.pos, ex);
                Object var6_5 = null;
                this.env = prevEnv;
            }
            Object var6_4 = null;
            this.env = prevEnv;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.env = prevEnv;
            throw throwable;
        }
    }

    public void genStat(Tree tree, Env<GenContext> env, int crtFlags) {
        if (!this.genCrt) {
            this.genStat(tree, env);
            return;
        }
        int startpc = this.code.curPc();
        this.genStat(tree, env);
        if (tree.tag == 8) {
            crtFlags |= 2;
        }
        this.code.crt.put(tree, crtFlags, startpc, this.code.curPc());
    }

    public void genStat(Tree tree, Env<GenContext> env) {
        if (this.code.isAlive()) {
            this.code.statBegin(tree.pos);
            this.genDef(tree, env);
        } else if (((GenContext)env.info).isSwitch && tree.tag == 6) {
            this.code.newLocal(((Tree.VarDef)tree).sym);
        }
    }

    public void genStats(List<Tree> trees, Env<GenContext> env, int crtFlags) {
        if (!this.genCrt) {
            this.genStats(trees, env);
            return;
        }
        if (trees.length() == 1) {
            this.genStat((Tree)trees.head, env, crtFlags | 1);
        } else {
            int startpc = this.code.curPc();
            this.genStats(trees, env);
            this.code.crt.put(trees, crtFlags, startpc, this.code.curPc());
        }
    }

    public void genStats(List<? extends Tree> trees, Env<GenContext> env) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.genStat((Tree)l.head, env, 1);
            l = l.tail;
        }
    }

    public Items.CondItem genCond(Tree tree, int crtFlags) {
        if (!this.genCrt) {
            return this.genCond(tree, false);
        }
        int startpc = this.code.curPc();
        Items.CondItem item = this.genCond(tree, (crtFlags & 8) != 0);
        this.code.crt.put(tree, crtFlags, startpc, this.code.curPc());
        return item;
    }

    public Items.CondItem genCond(Tree _tree, boolean markBranches) {
        Tree inner_tree = TreeInfo.skipParens(_tree);
        if (inner_tree.tag == 19) {
            Tree.Conditional tree = (Tree.Conditional)inner_tree;
            Items.CondItem cond = this.genCond(tree.cond, 8);
            if (cond.isTrue()) {
                this.code.resolve(cond.trueJumps);
                Items.CondItem result = this.genCond(tree.truepart, 16);
                if (markBranches) {
                    result.tree = tree.truepart;
                }
                return result;
            }
            if (cond.isFalse()) {
                this.code.resolve(cond.falseJumps);
                Items.CondItem result = this.genCond(tree.falsepart, 16);
                if (markBranches) {
                    result.tree = tree.falsepart;
                }
                return result;
            }
            Code.Chain secondJumps = cond.jumpFalse();
            this.code.resolve(cond.trueJumps);
            Items.CondItem first = this.genCond(tree.truepart, 16);
            if (markBranches) {
                first.tree = tree.truepart;
            }
            Code.Chain falseJumps = first.jumpFalse();
            this.code.resolve(first.trueJumps);
            Code.Chain trueJumps = this.code.branch(167);
            this.code.resolve(secondJumps);
            Items.CondItem second = this.genCond(tree.falsepart, 16);
            Items.CondItem result = this.items.makeCondItem(second.opcode, Code.mergeChains(trueJumps, second.trueJumps), Code.mergeChains(falseJumps, second.falseJumps));
            if (markBranches) {
                result.tree = tree.falsepart;
            }
            return result;
        }
        Items.CondItem result = this.genExpr(_tree, this.syms.booleanType).mkCond();
        if (markBranches) {
            result.tree = _tree;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Items.Item genExpr(Tree tree, Type pt) {
        Type prevPt = this.pt;
        try {
            if (tree.type.constValue != null) {
                this.checkStringConstant(tree.pos, tree.type.constValue);
                this.result = this.items.makeImmediateItem(tree.type, tree.type.constValue);
            } else {
                this.pt = pt;
                tree.accept(this);
            }
            Items.Item item = this.result.coerce(pt);
            Object var7_6 = null;
            this.pt = prevPt;
            return item;
        }
        catch (Symbol.CompletionFailure ex) {
            try {
                this.chk.completionError(tree.pos, ex);
                Items.Item item = this.items.makeStackItem(pt);
                Object var7_7 = null;
                this.pt = prevPt;
                return item;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.pt = prevPt;
                throw throwable;
            }
        }
    }

    public void genArgs(List<Tree> trees, List<Type> pts) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.genExpr((Tree)l.head, (Type)pts.head).load();
            pts = pts.tail;
            l = l.tail;
        }
        assert (pts.isEmpty());
    }

    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        Env<GenContext> localEnv = this.env.dup(tree);
        localEnv.enclMethod = tree;
        this.pt = tree.sym.erasure(this.types).restype();
        this.checkDimension(tree.pos, tree.sym.erasure(this.types));
        this.genMethod(tree, localEnv, false);
    }

    void genMethod(Tree.MethodDef tree, Env<GenContext> env, boolean fatcode) {
        Symbol.MethodSymbol meth = tree.sym;
        if (Code.width(this.types.erasure(env.enclMethod.sym.type).argtypes()) + ((tree.mods.flags & 8L) == 0L || meth.isConstructor() ? 1 : 0) > 255) {
            this.log.error(tree.pos, "limit.parameters", new Object[0]);
            ++this.nerrs;
        } else if (tree.body != null) {
            meth.code = this.code = new Code(meth, fatcode, this.lineDebugInfo, this.varDebugInfo, this.stackMap, this.debugCode, this.genCrt ? new CRTable(tree, env.toplevel.endPositions) : null, this.syms, this.types, this.pool);
            this.items = new Items(this.pool, this.code, this.syms, this.types);
            if (this.code.debugCode) {
                System.err.println(meth + " for body " + tree);
            }
            if ((tree.mods.flags & 8L) == 0L) {
                Type selfType = meth.owner.type;
                if (meth.isConstructor() && selfType != this.syms.objectType) {
                    selfType = UninitializedType.uninitializedThis(selfType);
                }
                this.code.setDefined(this.code.newLocal(new Symbol.VarSymbol(16L, this.names._this, selfType, meth.owner)));
            }
            List<Tree.VarDef> l = tree.params;
            while (l.nonEmpty()) {
                this.checkDimension(((Tree.VarDef)l.head).pos, ((Tree.VarDef)l.head).sym.type);
                this.code.setDefined(this.code.newLocal(((Tree.VarDef)l.head).sym));
                l = l.tail;
            }
            int startpcCrt = this.genCrt ? this.code.curPc() : 0;
            this.code.entryPoint();
            this.code.pendingStackMap = false;
            this.genStat(tree.body, env);
            if (this.code.state.stacksize != 0) {
                this.log.error(tree.body.pos, "stack.sim.error", tree);
                throw new AssertionError();
            }
            if (this.code.isAlive()) {
                this.code.statBegin(TreeInfo.endPos(tree.body));
                if (env.enclMethod == null || env.enclMethod.sym.type.restype().tag == 9) {
                    this.code.emitop0(177);
                } else {
                    int startpc = this.code.entryPoint();
                    Items.CondItem c = this.items.makeCondItem(167);
                    this.code.resolve(c.jumpTrue(), startpc);
                }
            }
            if (this.genCrt) {
                this.code.crt.put(tree.body, 2, startpcCrt, this.code.curPc());
            }
            this.code.endScopes(0);
            if (this.code.checkLimits(tree.pos, this.log)) {
                ++this.nerrs;
                return;
            }
            if (!fatcode && this.code.fatcode) {
                this.genMethod(tree, env, true);
            }
        }
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        Symbol.VarSymbol v = tree.sym;
        this.code.newLocal(v);
        if (tree.init != null) {
            this.checkStringConstant(tree.init.pos, v.constValue);
            if (v.constValue == null || this.varDebugInfo) {
                this.genExpr(tree.init, v.erasure(this.types)).load();
                this.items.makeLocalItem(v).store();
            }
        }
        this.checkDimension(tree.pos, v.type);
    }

    @Override
    public void visitSkip(Tree.Skip tree) {
    }

    @Override
    public void visitBlock(Tree.Block tree) {
        int limit = this.code.nextreg;
        Env<GenContext> localEnv = this.env.dup(tree, new GenContext());
        this.genStats(tree.stats, localEnv);
        this.code.statBegin(tree.endpos);
        if (this.env.tree.tag != 5) {
            this.code.endScopes(limit);
        }
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        this.genLoop(tree, tree.body, tree.cond, Tree.emptyList, false);
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        this.genLoop(tree, tree.body, tree.cond, Tree.emptyList, true);
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        int limit = this.code.nextreg;
        this.genStats(tree.init, this.env);
        this.genLoop(tree, tree.body, tree.cond, tree.step, true);
        this.code.endScopes(limit);
    }

    private void genLoop(Tree loop, Tree body, Tree cond, List<Tree> step, boolean testFirst) {
        Env<GenContext> loopEnv = this.env.dup(loop, new GenContext());
        int startpc = this.code.entryPoint();
        if (testFirst) {
            Items.CondItem c;
            if (cond != null) {
                this.code.statBegin(cond.pos);
                c = this.genCond(TreeInfo.skipParens(cond), 8);
            } else {
                c = this.items.makeCondItem(167);
            }
            Code.Chain loopDone = c.jumpFalse();
            this.code.resolve(c.trueJumps);
            this.genStat(body, loopEnv, 17);
            this.code.resolve(((GenContext)loopEnv.info).cont);
            this.genStats(step, loopEnv);
            this.code.resolve(this.code.branch(167), startpc);
            this.code.resolve(loopDone);
        } else {
            Items.CondItem c;
            this.genStat(body, loopEnv, 17);
            this.code.resolve(((GenContext)loopEnv.info).cont);
            this.genStats(step, loopEnv);
            if (cond != null) {
                this.code.statBegin(cond.pos);
                c = this.genCond(TreeInfo.skipParens(cond), 8);
            } else {
                c = this.items.makeCondItem(167);
            }
            this.code.resolve(c.jumpTrue(), startpc);
            this.code.resolve(c.falseJumps);
        }
        this.code.resolve(((GenContext)loopEnv.info).exit);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        throw new AssertionError();
    }

    @Override
    public void visitLabelled(Tree.Labelled tree) {
        Env<GenContext> localEnv = this.env.dup(tree, new GenContext());
        this.genStat(tree.body, localEnv, 1);
        this.code.resolve(((GenContext)localEnv.info).exit);
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        int limit = this.code.nextreg;
        assert (tree.selector.type.tag != 10);
        int startpcCrt = this.genCrt ? this.code.curPc() : 0;
        Items.Item sel = this.genExpr(tree.selector, this.syms.intType);
        List<Tree.Case> cases = tree.cases;
        if (cases.isEmpty()) {
            sel.load().drop();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(tree.selector), 8, startpcCrt, this.code.curPc());
            }
        } else {
            int i;
            sel.load();
            if (this.genCrt) {
                this.code.crt.put(TreeInfo.skipParens(tree.selector), 8, startpcCrt, this.code.curPc());
            }
            Env<GenContext> switchEnv = this.env.dup(tree, new GenContext());
            ((GenContext)switchEnv.info).isSwitch = true;
            int lo = Integer.MAX_VALUE;
            int hi = Integer.MIN_VALUE;
            int nlabels = 0;
            int[] labels = new int[cases.length()];
            int defaultIndex = -1;
            List<Tree.Case> l = cases;
            for (int i2 = 0; i2 < labels.length; ++i2) {
                if (((Tree.Case)l.head).pat != null) {
                    int val;
                    labels[i2] = val = ((Number)((Tree.Case)l.head).pat.type.constValue).intValue();
                    if (val < lo) {
                        lo = val;
                    }
                    if (hi < val) {
                        hi = val;
                    }
                    ++nlabels;
                } else {
                    assert (defaultIndex == -1);
                    defaultIndex = i2;
                }
                l = l.tail;
            }
            long table_space_cost = 4L + ((long)hi - (long)lo + 1L);
            long table_time_cost = 3L;
            long lookup_space_cost = 3L + 2L * (long)nlabels;
            long lookup_time_cost = nlabels;
            int opcode = nlabels > 0 && table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost ? 170 : 171;
            int startpc = this.code.curPc();
            this.code.emitop0(opcode);
            this.code.align(4);
            int tableBase = this.code.curPc();
            int[] offsets = null;
            this.code.emit4(-1);
            if (opcode == 170) {
                this.code.emit4(lo);
                this.code.emit4(hi);
                for (long i3 = (long)lo; i3 <= (long)hi; ++i3) {
                    this.code.emit4(-1);
                }
            } else {
                this.code.emit4(nlabels);
                for (int i4 = 0; i4 < nlabels; ++i4) {
                    this.code.emit4(-1);
                    this.code.emit4(-1);
                }
                offsets = new int[labels.length];
            }
            Code.State stateSwitch = this.code.state.dup();
            this.code.markDead();
            l = cases;
            for (i = 0; i < labels.length; ++i) {
                Tree.Case c = (Tree.Case)l.head;
                l = l.tail;
                int pc = this.code.entryPoint(stateSwitch);
                if (i != defaultIndex) {
                    if (opcode == 170) {
                        this.code.put4(tableBase + 4 * (labels[i] - lo + 3), pc - startpc);
                    } else {
                        offsets[i] = pc - startpc;
                    }
                } else {
                    this.code.put4(tableBase, pc - startpc);
                }
                this.genStats(c.stats, switchEnv, 16);
            }
            this.code.resolve(((GenContext)switchEnv.info).exit);
            if (this.code.get4(tableBase) == -1) {
                this.code.put4(tableBase, this.code.entryPoint(stateSwitch) - startpc);
            }
            if (opcode == 170) {
                int defaultOffset = this.code.get4(tableBase);
                for (long i5 = (long)lo; i5 <= (long)hi; ++i5) {
                    int t = (int)((long)tableBase + 4L * (i5 - (long)lo + 3L));
                    if (this.code.get4(t) != -1) continue;
                    this.code.put4(t, defaultOffset);
                }
            } else {
                if (defaultIndex >= 0) {
                    for (i = defaultIndex; i < labels.length - 1; ++i) {
                        labels[i] = labels[i + 1];
                        offsets[i] = offsets[i + 1];
                    }
                }
                if (nlabels > 0) {
                    Gen.qsort2(labels, offsets, 0, nlabels - 1);
                }
                for (i = 0; i < nlabels; ++i) {
                    int caseidx = tableBase + 8 * (i + 1);
                    this.code.put4(caseidx, labels[i]);
                    this.code.put4(caseidx + 4, offsets[i]);
                }
            }
        }
        this.code.endScopes(limit);
    }

    static void qsort2(int[] keys, int[] values, int lo, int hi) {
        int i = lo;
        int j = hi;
        int pivot = keys[(i + j) / 2];
        while (true) {
            if (keys[i] < pivot) {
                ++i;
                continue;
            }
            while (pivot < keys[j]) {
                --j;
            }
            if (i <= j) {
                int temp1 = keys[i];
                keys[i] = keys[j];
                keys[j] = temp1;
                int temp2 = values[i];
                values[i] = values[j];
                values[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            Gen.qsort2(keys, values, lo, j);
        }
        if (i < hi) {
            Gen.qsort2(keys, values, i, hi);
        }
    }

    @Override
    public void visitSynchronized(Tree.Synchronized tree) {
        int limit = this.code.nextreg;
        final Items.LocalItem lockVar = this.makeTemp(this.syms.objectType);
        this.genExpr(tree.lock, tree.lock.type).load().duplicate();
        lockVar.store();
        this.code.emitop0(194);
        this.code.state.lock(lockVar.reg);
        final Env<GenContext> syncEnv = this.env.dup(tree, new GenContext());
        ((GenContext)syncEnv.info).finalize = new GenFinalizer(){

            void gen() {
                this.genLast();
                assert (((GenContext)syncEnv.info).gaps.length() % 2 == 0);
                ((GenContext)syncEnv.info).gaps.append(Gen.this.code.curPc());
            }

            void genLast() {
                if (Gen.this.code.isAlive()) {
                    lockVar.load();
                    Gen.this.code.emitop0(195);
                    ((Gen)Gen.this).code.state.unlock(lockVar.reg);
                }
            }
        };
        ((GenContext)syncEnv.info).gaps = new ListBuffer();
        this.genTry(tree.body, Tree.Catch.emptyList, syncEnv);
        this.code.endScopes(limit);
    }

    @Override
    public void visitTry(final Tree.Try tree) {
        final Env<GenContext> tryEnv = this.env.dup(tree, new GenContext());
        final Env<GenContext> oldEnv = this.env;
        final boolean useJsrLocally = !this.stackMap && (this.jsrlimit <= 0 || this.jsrlimit < 100 && this.estimateCodeComplexity(tree.finalizer) > this.jsrlimit);
        ((GenContext)tryEnv.info).finalize = new GenFinalizer(){

            void gen() {
                if (useJsrLocally) {
                    if (tree.finalizer != null) {
                        Code.State jsrState = ((Gen)Gen.this).code.state.dup();
                        Gen.this.code;
                        jsrState.push(Code.jsrReturnValue);
                        ((GenContext)tryEnv.info).cont = new Code.Chain(Gen.this.code.emitJump(168), ((GenContext)tryEnv.info).cont, jsrState);
                    }
                    assert (((GenContext)tryEnv.info).gaps.length() % 2 == 0);
                    ((GenContext)tryEnv.info).gaps.append(Gen.this.code.curPc());
                } else {
                    assert (((GenContext)tryEnv.info).gaps.length() % 2 == 0);
                    ((GenContext)tryEnv.info).gaps.append(Gen.this.code.curPc());
                    this.genLast();
                }
            }

            void genLast() {
                if (tree.finalizer != null) {
                    Gen.this.genStat(tree.finalizer, oldEnv, 2);
                }
            }

            boolean hasFinalizer() {
                return tree.finalizer != null;
            }
        };
        ((GenContext)tryEnv.info).gaps = new ListBuffer();
        this.genTry(tree.body, tree.catchers, tryEnv);
    }

    void genTry(Tree body, List<Tree.Catch> catchers, Env<GenContext> env) {
        int limit = this.code.nextreg;
        int startpc = this.code.curPc();
        Code.State stateTry = this.code.state.dup();
        this.genStat(body, env, 2);
        int endpc = this.code.curPc();
        boolean hasFinalizer = ((GenContext)env.info).finalize != null && ((GenContext)env.info).finalize.hasFinalizer();
        List<Integer> gaps = ((GenContext)env.info).gaps.toList();
        this.code.statBegin(TreeInfo.endPos(body));
        this.genFinalizer(env);
        this.code.statBegin(TreeInfo.endPos(env.tree));
        Code.Chain exitChain = this.code.branch(167);
        this.endFinalizerGap(env);
        if (startpc != endpc) {
            List<Tree.Catch> l = catchers;
            while (l.nonEmpty()) {
                this.code.entryPoint(stateTry, ((Tree.Catch)l.head).param.sym.type);
                this.genCatch((Tree.Catch)l.head, env, startpc, endpc, gaps);
                this.genFinalizer(env);
                if (hasFinalizer || l.tail.nonEmpty()) {
                    this.code.statBegin(TreeInfo.endPos(env.tree));
                    exitChain = Code.mergeChains(exitChain, this.code.branch(167));
                }
                this.endFinalizerGap(env);
                l = l.tail;
            }
        }
        if (hasFinalizer) {
            this.code.newRegSegment();
            int catchallpc = this.code.entryPoint(stateTry, this.syms.throwableType);
            int startseg = startpc;
            while (((GenContext)env.info).gaps.nonEmpty()) {
                int endseg = ((GenContext)env.info).gaps.next();
                this.registerCatch(body.pos, startseg, endseg, catchallpc, 0);
                startseg = ((GenContext)env.info).gaps.next();
            }
            this.code.statBegin(TreeInfo.finalizerPos(env.tree));
            this.code.markStatBegin();
            Items.LocalItem excVar = this.makeTemp(this.syms.throwableType);
            ((Items.Item)excVar).store();
            this.genFinalizer(env);
            ((Items.Item)excVar).load();
            this.registerCatch(body.pos, startseg, ((GenContext)env.info).gaps.next(), catchallpc, 0);
            this.code.emitop0(191);
            this.code.markDead();
            if (((GenContext)env.info).cont != null) {
                this.code.resolve(((GenContext)env.info).cont);
                this.code.statBegin(TreeInfo.finalizerPos(env.tree));
                this.code.markStatBegin();
                Items.LocalItem retVar = this.makeTemp(this.syms.throwableType);
                retVar.store();
                ((GenContext)env.info).finalize.genLast();
                this.code.emitop1w(169, retVar.reg);
                this.code.markDead();
            }
        }
        this.code.resolve(exitChain);
        this.code.endScopes(limit);
    }

    void genCatch(Tree.Catch tree, Env<GenContext> env, int startpc, int endpc, List<Integer> gaps) {
        if (startpc != endpc) {
            int catchType = this.makeRef(tree.pos, tree.param.type);
            while (gaps.nonEmpty()) {
                int end = (Integer)gaps.head;
                this.registerCatch(tree.pos, startpc, end, this.code.curPc(), catchType);
                gaps = gaps.tail;
                startpc = (Integer)gaps.head;
                gaps = gaps.tail;
            }
            if (startpc < endpc) {
                this.registerCatch(tree.pos, startpc, endpc, this.code.curPc(), catchType);
            }
            Symbol.VarSymbol exparam = tree.param.sym;
            this.code.statBegin(tree.pos);
            this.code.markStatBegin();
            int limit = this.code.nextreg;
            int exlocal = this.code.newLocal(exparam);
            this.items.makeLocalItem(exparam).store();
            this.code.statBegin(TreeInfo.firstStatPos(tree.body));
            this.genStat(tree.body, env, 2);
            this.code.endScopes(limit);
            this.code.statBegin(TreeInfo.endPos(tree.body));
        }
    }

    void registerCatch(int pos, int startpc, int endpc, int handler_pc, int catch_type) {
        if (startpc != endpc) {
            char startpc1 = (char)startpc;
            char endpc1 = (char)endpc;
            char handler_pc1 = (char)handler_pc;
            if (startpc1 == startpc && endpc1 == endpc && handler_pc1 == handler_pc) {
                this.code.addCatch(startpc1, endpc1, handler_pc1, (char)catch_type);
            } else {
                this.log.error(pos, "limit.code.too.large.for.try.stmt", new Object[0]);
                ++this.nerrs;
            }
        }
    }

    int estimateCodeComplexity(Tree tree) {
        if (tree == null) {
            return 0;
        }
        class ComplexityScanner
        extends TreeScanner {
            int complexity = 0;

            ComplexityScanner() {
            }

            public void scan(Tree tree) {
                if (this.complexity > Gen.this.jsrlimit) {
                    return;
                }
                super.scan(tree);
            }

            public void visitClassDef(Tree.ClassDef tree) {
            }

            public void visitDoLoop(Tree.DoLoop tree) {
                super.visitDoLoop(tree);
                ++this.complexity;
            }

            public void visitWhileLoop(Tree.WhileLoop tree) {
                super.visitWhileLoop(tree);
                ++this.complexity;
            }

            public void visitForLoop(Tree.ForLoop tree) {
                super.visitForLoop(tree);
                ++this.complexity;
            }

            public void visitSwitch(Tree.Switch tree) {
                super.visitSwitch(tree);
                this.complexity += 5;
            }

            public void visitCase(Tree.Case tree) {
                super.visitCase(tree);
                ++this.complexity;
            }

            public void visitSynchronized(Tree.Synchronized tree) {
                super.visitSynchronized(tree);
                this.complexity += 6;
            }

            public void visitTry(Tree.Try tree) {
                super.visitTry(tree);
                if (tree.finalizer != null) {
                    this.complexity += 6;
                }
            }

            public void visitCatch(Tree.Catch tree) {
                super.visitCatch(tree);
                this.complexity += 2;
            }

            public void visitConditional(Tree.Conditional tree) {
                super.visitConditional(tree);
                this.complexity += 2;
            }

            public void visitIf(Tree.If tree) {
                super.visitIf(tree);
                this.complexity += 2;
            }

            public void visitBreak(Tree.Break tree) {
                super.visitBreak(tree);
                ++this.complexity;
            }

            public void visitContinue(Tree.Continue tree) {
                super.visitContinue(tree);
                ++this.complexity;
            }

            public void visitReturn(Tree.Return tree) {
                super.visitReturn(tree);
                ++this.complexity;
            }

            public void visitThrow(Tree.Throw tree) {
                super.visitThrow(tree);
                ++this.complexity;
            }

            public void visitAssert(Tree.Assert tree) {
                super.visitAssert(tree);
                this.complexity += 5;
            }

            public void visitApply(Tree.Apply tree) {
                super.visitApply(tree);
                this.complexity += 2;
            }

            public void visitNewClass(Tree.NewClass tree) {
                this.scan(tree.encl);
                this.scan(tree.args);
                this.complexity += 2;
            }

            public void visitNewArray(Tree.NewArray tree) {
                super.visitNewArray(tree);
                this.complexity += 5;
            }

            public void visitAssign(Tree.Assign tree) {
                super.visitAssign(tree);
                ++this.complexity;
            }

            public void visitAssignop(Tree.Assignop tree) {
                super.visitAssignop(tree);
                this.complexity += 2;
            }

            public void visitUnary(Tree.Unary tree) {
                ++this.complexity;
                if (tree.type.constValue == null) {
                    super.visitUnary(tree);
                }
            }

            public void visitBinary(Tree.Binary tree) {
                ++this.complexity;
                if (tree.type.constValue == null) {
                    super.visitBinary(tree);
                }
            }

            public void visitTypeTest(Tree.TypeTest tree) {
                super.visitTypeTest(tree);
                ++this.complexity;
            }

            public void visitIndexed(Tree.Indexed tree) {
                super.visitIndexed(tree);
                ++this.complexity;
            }

            public void visitSelect(Tree.Select tree) {
                super.visitSelect(tree);
                if (tree.sym.kind == 4) {
                    ++this.complexity;
                }
            }

            public void visitIdent(Tree.Ident tree) {
                if (tree.sym.kind == 4) {
                    ++this.complexity;
                    if (tree.type.constValue == null && tree.sym.owner.kind == 2) {
                        ++this.complexity;
                    }
                }
            }

            public void visitLiteral(Tree.Literal tree) {
                ++this.complexity;
            }

            public void visitTree(Tree tree) {
            }

            public void visitTypeArgument(Tree.TypeArgument tree) {
                throw new AssertionError((Object)this.getClass().getName());
            }
        }
        ComplexityScanner scanner = new ComplexityScanner();
        tree.accept(scanner);
        return scanner.complexity;
    }

    @Override
    public void visitIf(Tree.If tree) {
        int limit = this.code.nextreg;
        Code.Chain thenExit = null;
        Items.CondItem c = this.genCond(TreeInfo.skipParens(tree.cond), 8);
        Code.Chain elseChain = c.jumpFalse();
        if (!c.isFalse()) {
            this.code.resolve(c.trueJumps);
            this.genStat(tree.thenpart, this.env, 17);
            thenExit = this.code.branch(167);
        }
        if (elseChain != null) {
            this.code.resolve(elseChain);
            if (tree.elsepart != null) {
                this.genStat(tree.elsepart, this.env, 17);
            }
        }
        this.code.resolve(thenExit);
        this.code.endScopes(limit);
    }

    @Override
    public void visitExec(Tree.Exec tree) {
        if (tree.expr.tag == 53) {
            tree.expr.tag = 51;
        } else if (tree.expr.tag == 54) {
            tree.expr.tag = 52;
        }
        this.genExpr(tree.expr, tree.expr.type).drop();
    }

    @Override
    public void visitBreak(Tree.Break tree) {
        Env<GenContext> targetEnv = this.unwind(tree.target, this.env);
        assert (this.code.state.stacksize == 0);
        ((GenContext)targetEnv.info).addExit(this.code.branch(167));
        this.endFinalizerGaps(this.env, targetEnv);
    }

    @Override
    public void visitContinue(Tree.Continue tree) {
        Env<GenContext> targetEnv = this.unwind(tree.target, this.env);
        assert (this.code.state.stacksize == 0);
        ((GenContext)targetEnv.info).addCont(this.code.branch(167));
        this.endFinalizerGaps(this.env, targetEnv);
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        Env<GenContext> targetEnv;
        int limit = this.code.nextreg;
        if (tree.expr != null) {
            Items.Item r = this.genExpr(tree.expr, this.pt).load();
            if (this.hasFinally(this.env.enclMethod, this.env)) {
                r = this.makeTemp(this.pt);
                r.store();
            }
            targetEnv = this.unwind(this.env.enclMethod, this.env);
            r.load();
            this.code.emitop0(172 + Code.truncate(Code.typecode(this.pt)));
        } else {
            targetEnv = this.unwind(this.env.enclMethod, this.env);
            this.code.emitop0(177);
        }
        this.endFinalizerGaps(this.env, targetEnv);
        this.code.endScopes(limit);
    }

    @Override
    public void visitThrow(Tree.Throw tree) {
        this.genExpr(tree.expr, tree.expr.type).load();
        this.code.emitop0(191);
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        Items.Item m = this.genExpr(tree.meth, this.methodType);
        this.genArgs(tree.args, TreeInfo.symbol(tree.meth).externalType(this.types).argtypes());
        this.result = m.invoke();
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        int startpc;
        Code.Chain thenExit = null;
        Items.CondItem c = this.genCond(tree.cond, 8);
        Code.Chain elseChain = c.jumpFalse();
        if (!c.isFalse()) {
            this.code.resolve(c.trueJumps);
            startpc = this.genCrt ? this.code.curPc() : 0;
            this.genExpr(tree.truepart, this.pt).load();
            this.code.state.forceStackTop(tree.type);
            if (this.genCrt) {
                this.code.crt.put(tree.truepart, 16, startpc, this.code.curPc());
            }
            thenExit = this.code.branch(167);
        }
        if (elseChain != null) {
            this.code.resolve(elseChain);
            startpc = this.genCrt ? this.code.curPc() : 0;
            this.genExpr(tree.falsepart, this.pt).load();
            this.code.state.forceStackTop(tree.type);
            if (this.genCrt) {
                this.code.crt.put(tree.falsepart, 16, startpc, this.code.curPc());
            }
        }
        this.code.resolve(thenExit);
        this.result = this.items.makeStackItem(this.pt);
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        assert (tree.encl == null && tree.def == null);
        this.code.emitop2(187, this.makeRef(tree.pos, tree.type));
        this.code.emitop0(89);
        this.genArgs(tree.args, tree.constructor.externalType(this.types).argtypes());
        this.items.makeMemberItem(tree.constructor, true).invoke();
        this.result = this.items.makeStackItem(tree.type);
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        if (tree.elems != null) {
            Type elemtype = this.types.elemtype(tree.type);
            this.loadIntConst(tree.elems.length());
            Items.Item arr = this.makeNewArray(tree.pos, tree.type, 1);
            int i = 0;
            List<Tree> l = tree.elems;
            while (l.nonEmpty()) {
                arr.duplicate();
                this.loadIntConst(i);
                ++i;
                this.genExpr((Tree)l.head, elemtype).load();
                this.items.makeIndexedItem(elemtype).store();
                l = l.tail;
            }
            this.result = arr;
        } else {
            List<Tree> l = tree.dims;
            while (l.nonEmpty()) {
                this.genExpr((Tree)l.head, this.syms.intType).load();
                l = l.tail;
            }
            this.result = this.makeNewArray(tree.pos, tree.type, tree.dims.length());
        }
    }

    Items.Item makeNewArray(int pos, Type type, int ndims) {
        int elemcode;
        Type elemtype = this.types.elemtype(type);
        if (this.types.dimensions(elemtype) + ndims > 255) {
            this.log.error(pos, "limit.dimensions", new Object[0]);
            ++this.nerrs;
        }
        if ((elemcode = Code.arraycode(elemtype)) == 0 || elemcode == 1 && ndims == 1) {
            this.code.emitAnewarray(this.makeRef(pos, elemtype), type);
        } else if (elemcode == 1) {
            this.code.emitMultianewarray(ndims, this.makeRef(pos, type), type);
        } else {
            this.code.emitNewarray(elemcode, type);
        }
        return this.items.makeStackItem(type);
    }

    @Override
    public void visitParens(Tree.Parens tree) {
        this.result = this.genExpr(tree.expr, tree.expr.type);
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        Items.Item l = this.genExpr(tree.lhs, tree.lhs.type);
        this.genExpr(tree.rhs, tree.lhs.type).load();
        this.result = this.items.makeAssignItem(l);
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        Items.Item l;
        Symbol.OperatorSymbol operator = (Symbol.OperatorSymbol)tree.operator;
        if (operator.opcode == 256) {
            this.makeStringBuffer(tree.pos);
            l = this.genExpr(tree.lhs, tree.lhs.type);
            if (l.width() > 0) {
                this.code.emitop0(90 + 3 * (l.width() - 1));
            }
            l.load();
            this.appendString(tree.lhs);
            this.appendStrings(tree.rhs);
            this.bufferToString(tree.pos);
        } else {
            l = this.genExpr(tree.lhs, tree.lhs.type);
            if ((tree.tag == 87 || tree.tag == 88) && l instanceof Items.LocalItem && tree.lhs.type.tag <= 4 && tree.rhs.type.tag <= 4 && tree.rhs.type.constValue != null) {
                int ival = ((Number)tree.rhs.type.constValue).intValue();
                if (tree.tag == 88) {
                    ival = -ival;
                }
                ((Items.LocalItem)l).incr(ival);
                this.result = l;
                return;
            }
            l.duplicate();
            l.coerce((Type)operator.type.argtypes().head).load();
            this.completeBinop(tree.lhs, tree.rhs, operator).coerce(tree.lhs.type);
        }
        this.result = this.items.makeAssignItem(l);
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        Symbol.OperatorSymbol operator = (Symbol.OperatorSymbol)tree.operator;
        if (tree.tag == 49) {
            Items.CondItem od = this.genCond(tree.arg, false);
            this.result = od.negate();
        } else {
            Items.Item od = this.genExpr(tree.arg, (Type)operator.type.argtypes().head);
            switch (tree.tag) {
                case 47: {
                    this.result = od.load();
                    break;
                }
                case 48: {
                    this.result = od.load();
                    this.code.emitop0(operator.opcode);
                    break;
                }
                case 50: {
                    this.result = od.load();
                    this.emitMinusOne(od.typecode);
                    this.code.emitop0(operator.opcode);
                    break;
                }
                case 51: 
                case 52: {
                    od.duplicate();
                    if (od instanceof Items.LocalItem && (operator.opcode == 96 || operator.opcode == 100)) {
                        ((Items.LocalItem)od).incr(tree.tag == 51 ? 1 : -1);
                        this.result = od;
                        break;
                    }
                    od.load();
                    this.code.emitop0(Gen.one(od.typecode));
                    this.code.emitop0(operator.opcode);
                    if (od.typecode != 0 && Code.truncate(od.typecode) == 0) {
                        this.code.emitop0(145 + od.typecode - 5);
                    }
                    this.result = this.items.makeAssignItem(od);
                    break;
                }
                case 53: 
                case 54: {
                    od.duplicate();
                    if (od instanceof Items.LocalItem && operator.opcode == 96) {
                        Items.Item res = od.load();
                        ((Items.LocalItem)od).incr(tree.tag == 53 ? 1 : -1);
                        this.result = res;
                        break;
                    }
                    Items.Item res = od.load();
                    od.stash(od.typecode);
                    this.code.emitop0(Gen.one(od.typecode));
                    this.code.emitop0(operator.opcode);
                    if (od.typecode != 0 && Code.truncate(od.typecode) == 0) {
                        this.code.emitop0(145 + od.typecode - 5);
                    }
                    od.store();
                    this.result = res;
                    break;
                }
                case 55: {
                    this.result = od.load();
                    this.code.emitop0(89);
                    this.genNullCheck(tree.pos);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void genNullCheck(int pos) {
        this.callMethod(pos, this.syms.objectType, this.names.getClass, Type.emptyList, false);
        this.code.emitop0(87);
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        Symbol.OperatorSymbol operator = (Symbol.OperatorSymbol)tree.operator;
        if (operator.opcode == 256) {
            this.makeStringBuffer(tree.pos);
            this.appendStrings(tree);
            this.bufferToString(tree.pos);
            this.result = this.items.makeStackItem(this.syms.stringType);
        } else if (tree.tag == 57) {
            Items.CondItem lcond = this.genCond(tree.lhs, 8);
            if (!lcond.isFalse()) {
                Code.Chain falseJumps = lcond.jumpFalse();
                this.code.resolve(lcond.trueJumps);
                Items.CondItem rcond = this.genCond(tree.rhs, 16);
                this.result = this.items.makeCondItem(rcond.opcode, rcond.trueJumps, Code.mergeChains(falseJumps, rcond.falseJumps));
            } else {
                this.result = lcond;
            }
        } else if (tree.tag == 56) {
            Items.CondItem lcond = this.genCond(tree.lhs, 8);
            if (!lcond.isTrue()) {
                Code.Chain trueJumps = lcond.jumpTrue();
                this.code.resolve(lcond.falseJumps);
                Items.CondItem rcond = this.genCond(tree.rhs, 16);
                this.result = this.items.makeCondItem(rcond.opcode, Code.mergeChains(trueJumps, rcond.trueJumps), rcond.falseJumps);
            } else {
                this.result = lcond;
            }
        } else {
            Items.Item od = this.genExpr(tree.lhs, (Type)operator.type.argtypes().head);
            od.load();
            this.result = this.completeBinop(tree.lhs, tree.rhs, operator);
        }
    }

    void makeStringBuffer(int pos) {
        this.code.emitop2(187, this.makeRef(pos, this.stringBufferType));
        this.code.emitop0(89);
        this.callMethod(pos, this.stringBufferType, this.names.init, Type.emptyList, false);
    }

    void appendString(Tree tree) {
        Type t = tree.type;
        if (t.tag > 8 && t.tsym != this.syms.stringType.tsym) {
            t = this.syms.objectType;
        }
        this.callMethod(tree.pos, this.stringBufferType, this.names.append, Type.emptyList.prepend(t), false);
    }

    void appendStrings(Tree tree) {
        tree = TreeInfo.skipParens(tree);
        if (tree.tag == 70 && tree.type.constValue == null) {
            Tree.Binary op = (Tree.Binary)tree;
            if (op.operator.kind == 16 && ((Symbol.OperatorSymbol)op.operator).opcode == 256) {
                this.appendStrings(op.lhs);
                this.appendStrings(op.rhs);
                return;
            }
        }
        this.genExpr(tree, tree.type).load();
        this.appendString(tree);
    }

    void bufferToString(int pos) {
        this.callMethod(pos, this.stringBufferType, this.names.toString, Type.emptyList, false);
    }

    Items.Item completeBinop(Tree lhs, Tree rhs, Symbol.OperatorSymbol operator) {
        Type.MethodType optype = (Type.MethodType)operator.type;
        int opcode = operator.opcode;
        if (opcode >= 159 && opcode <= 164 && rhs.type.constValue instanceof Number && ((Number)rhs.type.constValue).intValue() == 0) {
            opcode += -6;
        } else if (opcode >= 165 && opcode <= 166 && TreeInfo.symbol(rhs) == this.syms.nullConst) {
            opcode += 33;
        } else {
            Type rtype = (Type)operator.erasure((Types)this.types).argtypes().tail.head;
            if (opcode >= 270 && opcode <= 275) {
                opcode += -150;
                rtype = this.syms.intType;
            }
            this.genExpr(rhs, rtype).load();
            if (opcode >= 512) {
                this.code.emitop0(opcode >> 9);
                opcode &= 0xFF;
            }
        }
        if (opcode >= 153 && opcode <= 166 || opcode == 198 || opcode == 199) {
            return this.items.makeCondItem(opcode);
        }
        this.code.emitop0(opcode);
        return this.items.makeStackItem(optype.restype);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        this.result = this.genExpr(tree.expr, tree.clazz.type).load();
        if (tree.clazz.type.tag > 8 && this.types.asSuper(tree.expr.type, tree.clazz.type.tsym) == null) {
            this.code.emitop2(192, this.makeRef(tree.pos, tree.clazz.type));
        }
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument tree) {
        throw new AssertionError((Object)this.getClass().getName());
    }

    @Override
    public void visitTypeTest(Tree.TypeTest tree) {
        this.genExpr(tree.expr, tree.expr.type).load();
        this.code.emitop2(193, this.makeRef(tree.pos, tree.clazz.type));
        this.result = this.items.makeStackItem(this.syms.booleanType);
    }

    @Override
    public void visitIndexed(Tree.Indexed tree) {
        this.genExpr(tree.indexed, tree.indexed.type).load();
        this.genExpr(tree.index, this.syms.intType).load();
        this.result = this.items.makeIndexedItem(tree.type);
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        Symbol sym = tree.sym;
        if (tree.name == this.names._this || tree.name == this.names._super) {
            Items.Item res;
            Items.Item item = res = tree.name == this.names._this ? this.items.makeThisItem() : this.items.makeSuperItem();
            if (sym.kind == 16) {
                res.load();
                res = this.items.makeMemberItem(sym, true);
            }
            this.result = res;
        } else if (tree.name == this.names._null) {
            this.code.emitop0(1);
            if (this.types.dimensions(this.pt) > 1) {
                this.code.emitop2(192, this.makeRef(tree.pos, this.pt));
                this.result = this.items.makeStackItem(this.pt);
            } else {
                this.result = this.items.makeStackItem(tree.type);
            }
        } else if (sym.kind == 4 && sym.owner.kind == 16) {
            this.result = this.items.makeLocalItem((Symbol.VarSymbol)sym);
        } else if ((sym.flags() & 8L) != 0L) {
            if (!this.isAccessSuper(this.env.enclMethod)) {
                sym = this.binaryQualifier(sym, this.env.enclClass.type);
            }
            this.result = this.items.makeStaticItem(sym);
        } else {
            this.items.makeThisItem().load();
            sym = this.binaryQualifier(sym, this.env.enclClass.type);
            this.result = this.items.makeMemberItem(sym, (sym.flags() & 2L) != 0L);
        }
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        Items.Item base;
        Symbol sym = tree.sym;
        if (tree.name == this.names._class) {
            assert (this.target.hasClassLiterals());
            this.code.emitop2(19, this.makeRef(tree.pos, tree.selected.type));
            this.result = this.items.makeStackItem(this.pt);
            return;
        }
        Symbol ssym = TreeInfo.symbol(tree.selected);
        boolean selectSuper = ssym != null && (ssym.kind == 2 || ssym.name == this.names._super);
        boolean accessSuper = this.isAccessSuper(this.env.enclMethod);
        Items.Item item = base = selectSuper ? this.items.makeSuperItem() : this.genExpr(tree.selected, tree.selected.type);
        if (sym.kind == 4 && ((Symbol.VarSymbol)sym).constValue != null) {
            if ((sym.flags() & 8L) != 0L) {
                if (!(selectSuper || ssym != null && ssym.kind == 2)) {
                    base = base.load();
                }
                base.drop();
            } else {
                base.load();
                this.genNullCheck(tree.selected.pos);
            }
            this.result = this.items.makeImmediateItem(sym.type, ((Symbol.VarSymbol)sym).constValue);
        } else {
            if (!accessSuper) {
                sym = this.binaryQualifier(sym, tree.selected.type);
            }
            if ((sym.flags() & 8L) != 0L) {
                if (!(selectSuper || ssym != null && ssym.kind == 2)) {
                    base = base.load();
                }
                base.drop();
                this.result = this.items.makeStaticItem(sym);
            } else {
                base.load();
                if (sym == this.syms.lengthVar) {
                    this.code.emitop0(190);
                    this.result = this.items.makeStackItem(this.syms.intType);
                } else {
                    this.result = this.items.makeMemberItem(sym, (sym.flags() & 2L) != 0L || selectSuper || accessSuper);
                }
            }
        }
    }

    @Override
    public void visitLiteral(Tree.Literal tree) {
        this.result = this.items.makeImmediateItem(tree.type, tree.value);
    }

    @Override
    public void visitLetExpr(Tree.LetExpr tree) {
        int limit = this.code.nextreg;
        this.genStats(tree.defs, this.env);
        this.result = this.genExpr(tree.expr, tree.expr.type).load();
        this.code.endScopes(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean genClass(Env<AttrContext> env, Tree.ClassDef cdef) {
        try {
            this.attrEnv = env;
            Symbol.ClassSymbol c = cdef.sym;
            this.toplevel = env.toplevel;
            this.endPositions = this.toplevel.endPositions;
            if (this.generateIproxies && (c.flags() & 0x600L) == 1024L && !this.allowGenerics) {
                this.implementInterfaceMethods(c);
            }
            cdef.defs = this.normalizeDefs(cdef.defs, c);
            c.pool = this.pool;
            this.pool.reset();
            Env<GenContext> localEnv = new Env<GenContext>(cdef, new GenContext());
            localEnv.toplevel = env.toplevel;
            localEnv.enclClass = cdef;
            List<Tree> l = cdef.defs;
            while (l.nonEmpty()) {
                this.genDef((Tree)l.head, localEnv);
                l = l.tail;
            }
            if (this.pool.numEntries() > 65535) {
                this.log.error(cdef.pos, "limit.pool", new Object[0]);
                ++this.nerrs;
            }
            if (this.nerrs != 0) {
                l = cdef.defs;
                while (l.nonEmpty()) {
                    if (((Tree)l.head).tag == 5) {
                        ((Tree.MethodDef)l.head).sym.code = null;
                    }
                    l = l.tail;
                }
            }
            cdef.defs = Tree.emptyList;
            boolean bl = this.nerrs == 0;
            Object var7_7 = null;
            this.attrEnv = null;
            this.env = null;
            this.toplevel = null;
            this.endPositions = null;
            this.nerrs = 0;
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.attrEnv = null;
            this.env = null;
            this.toplevel = null;
            this.endPositions = null;
            this.nerrs = 0;
            throw throwable;
        }
    }

    class GenContext {
        Code.Chain exit = null;
        Code.Chain cont = null;
        GenFinalizer finalize = null;
        boolean isSwitch = false;
        ListBuffer<Integer> gaps = null;

        GenContext() {
        }

        void addExit(Code.Chain c) {
            this.exit = Code.mergeChains(c, this.exit);
        }

        void addCont(Code.Chain c) {
            this.cont = Code.mergeChains(c, this.cont);
        }
    }

    abstract class GenFinalizer {
        GenFinalizer() {
        }

        abstract void gen();

        abstract void genLast();

        boolean hasFinalizer() {
            return true;
        }
    }
}

