/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.jvm;

import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import java.util.HashMap;

public class ModuleCompleter
implements Symbol.Completer {
    HashMap<Symbol.ClassSymbol, Symbol.ClassSymbol> classHash;
    HashMap<String, Symbol.ClassSymbol> moduleClasses;
    ClassReader std;
    TypeCopier copier;
    Types types;

    ModuleCompleter(ClassReader std) {
        this.std = std;
        this.types = std.types;
        this.classHash = new HashMap();
        this.moduleClasses = new HashMap();
        this.copier = new TypeCopier();
    }

    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == 2) {
            this.fillIn((Symbol.ClassSymbol)sym);
        } else if (sym.kind == 1) {
            this.fillIn((Symbol.PackageSymbol)sym);
        }
    }

    public Symbol.ClassSymbol enterClass(Symbol.ClassSymbol c0, Symbol.TypeSymbol owner) {
        String hashkey = owner.type.bound() + "." + c0;
        Symbol.ClassSymbol c = this.moduleClasses.get(hashkey);
        if (c != null) {
            return c;
        }
        if (c0.type != null && c0.type == this.std.syms.objectType) {
            return c0;
        }
        c = new Symbol.ClassSymbol(0L, c0.name, owner);
        this.classHash.put(c, c0);
        this.moduleClasses.put(hashkey, c);
        c.completer = this;
        return c;
    }

    public void fillIn(Symbol.ClassSymbol c) {
        Symbol.ClassSymbol c0 = this.classHash.get(c);
        if (c0 == null) {
            this.std.complete(c);
        } else {
            Symbol.PackageSymbol mod = c.packge();
            Symbol.PackageSymbol mod0 = (Symbol.PackageSymbol)((Type.TypeVar)mod.type).bound().tsym;
            this.fillIn(c, mod0, mod);
        }
    }

    public void fillIn(Symbol.ClassSymbol c, Symbol.PackageSymbol oldp, Symbol.PackageSymbol newp) {
        Symbol.ClassSymbol c0 = this.classHash.get(c);
        this.std.complete(c0);
        c.flags_field = c0.flags();
        c.members_field = new Scope(c);
        Scope.Entry e = c0.members().elems;
        while (e != null) {
            Symbol s = e.sym;
            if (s.kind == 16) {
                Symbol.MethodSymbol m = ((Symbol.MethodSymbol)s).clone(c);
                m.type = this.copier.copy(oldp, newp, m.type);
                c.members_field.enter(m);
            } else if (s.kind == 2) {
                Symbol.ClassSymbol c2 = (Symbol.ClassSymbol)e.sym;
                Symbol.ClassSymbol cnew = this.enterClass(c2, c);
                c.members_field.enter(cnew);
            } else if (s.kind == 4) {
                Symbol.VarSymbol f = ((Symbol.VarSymbol)s).clone(c);
                f.type = this.copier.copy(oldp, newp, f.type);
                c.members_field.enter(f);
            } else {
                System.out.println("MC: UNKNOWN kind:" + s.kind + " " + s);
            }
            e = e.sibling;
        }
        Symbol.ClassSymbol superSym = this.enterClass((Symbol.ClassSymbol)((Type.ClassType)c0.type).supertype_field.tsym, newp);
        ((Type.ClassType)c.type).supertype_field = superSym.type;
    }

    public void fillIn(final Symbol.PackageSymbol p) {
        Type b = ((Type.TypeVar)p.type).bound;
        final Symbol.PackageSymbol bound = (Symbol.PackageSymbol)b.tsym;
        Scope.Entry e2 = bound.members().lookup(bound.name);
        this.std.sigReader.readClassFile((Symbol.ClassSymbol)e2.sym);
        p.members_field = new Scope(p);
        Scope.Entry e = bound.members().elems;
        while (e != null) {
            Symbol.ClassSymbol c0 = (Symbol.ClassSymbol)e.sym;
            final Symbol.ClassSymbol c = this.enterClass(c0, p);
            final ModuleCompleter def = this;
            if (c.owner == p) {
                p.members_field.enter(c);
            }
            c.completer = new Symbol.Completer(){

                public void complete(Symbol sym) throws Symbol.CompletionFailure {
                    assert (c == sym);
                    def.fillIn(c, bound, p);
                }
            };
            e = e.sibling;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeCopier
    extends Type.Visitor {
        Type result;
        Symbol.PackageSymbol mod0;
        Symbol.PackageSymbol mod;
        HashMap<String, Type> chash = new HashMap();

        TypeCopier() {
        }

        public List<Type> copy(Symbol.PackageSymbol mod0, Symbol.PackageSymbol mod, List<Type> ts) {
            this.mod0 = mod0;
            this.mod = mod;
            return this.copy(ts);
        }

        private List<Type> copy(List<Type> ts) {
            if (ts == null) {
                return null;
            }
            ListBuffer<Type> res = new ListBuffer<Type>();
            List<Type> t = ts;
            while (t.nonEmpty()) {
                res.append(this.copy(this.mod0, this.mod, (Type)t.head));
                t = t.tail;
            }
            return res.toList();
        }

        public Type copy(Symbol.PackageSymbol mod0, Symbol.PackageSymbol mod, Type t) {
            this.mod0 = mod0;
            this.mod = mod;
            return this.copy(t);
        }

        private Type copy(Type t) {
            if (t == null) {
                return null;
            }
            this.result = null;
            t.accept(this);
            return this.result;
        }

        public Symbol.TypeSymbol findSymbol(Symbol.TypeSymbol s) {
            if (s == this.mod0) {
                return this.mod;
            }
            Symbol owner = s.owner;
            while (owner.kind != 1) {
                owner = owner.owner;
            }
            if (owner != this.mod0) {
                return s;
            }
            return ModuleCompleter.this.enterClass((Symbol.ClassSymbol)s, this.findSymbol((Symbol.TypeSymbol)s.owner));
        }

        @Override
        public void visitClassType(Type.ClassType that) {
            that.complete();
            Type res = this.chash.get(this.mod.hashCode() + that.toString());
            if (res != null) {
                this.result = res;
                return;
            }
            if (that.tsym.packge() != this.mod0) {
                this.result = that;
                return;
            }
            Type outer = null;
            if (that.outer_field != null) {
                outer = this.copy(that.outer_field);
            }
            Type.ClassType r = new Type.ClassType(outer, this.copy(that.typarams_field), this.findSymbol(that.tsym));
            r.tsym.type = r;
            r.supertype_field = this.copy(ModuleCompleter.this.types.supertype(that));
            r.interfaces_field = this.copy(ModuleCompleter.this.types.interfaces(that));
            r.allparams_field = this.copy(that.allparams_field);
            r.typarams_field = this.copy(that.typarams());
            this.result = r;
            this.chash.put(this.mod.hashCode() + that.toString(), this.result);
        }

        @Override
        public void visitArgumentType(Type.ArgumentType that) {
            this.visitType(that);
        }

        @Override
        public void visitPackageType(Type.PackageType that) {
            this.visitType(that);
        }

        @Override
        public void visitTypeVar(Type.TypeVar that) {
            this.visitType(that);
        }

        @Override
        public void visitCapturedType(Type.CapturedType that) {
            this.visitTypeVar(that);
        }

        @Override
        public void visitDelegatedType(Type.DelegatedType that) {
            this.visitType(that);
        }

        @Override
        public void visitMethodType(Type.MethodType that) {
            this.result = new Type.MethodType(this.copy(that.argtypes), this.copy(that.restype), this.copy(that.thrown), that.tsym);
        }

        @Override
        public void visitForAll(Type.ForAll that) {
            this.result = new Type.ForAll(this.copy(that.tvars), this.copy(that.qtype));
        }

        @Override
        public void visitUndetVar(Type.UndetVar that) {
            this.visitDelegatedType(that);
        }

        @Override
        public void visitErrorType(Type.ErrorType that) {
            this.visitType(that);
        }

        @Override
        public void visitType(Type that) {
            this.result = that;
        }
    }
}

