/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.jvm;

import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.code.Types;
import edu.rice.cs.nextgen2.compiler.jvm.ClassFile;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.jvm.Target;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.FileEntry;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Name;
import java.io.IOException;
import java.io.InputStream;

class SignatureReader
extends ClassFile {
    ClassReader reader;
    Types types;
    byte[] buf = new byte[65520];
    int bp;
    Object[] poolObj;
    int[] poolIdx;
    final Name.Table names;

    SignatureReader(Context c) {
        this.types = Types.instance(c);
        this.reader = ClassReader.instance(c);
        this.names = Name.Table.instance(c);
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int bp) {
        return (char)(((this.buf[bp] & 0xFF) << 8) + (this.buf[bp + 1] & 0xFF));
    }

    Name readName(int i) {
        return (Name)this.readPool(i);
    }

    void skipMember() {
        this.bp += 6;
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            this.bp += 2;
            int attrLen = this.nextInt();
            this.bp += attrLen;
        }
    }

    Object readPool(int i) {
        Object result = this.poolObj[i];
        if (result != null) {
            return result;
        }
        int index = this.poolIdx[i];
        if (index == 0) {
            return null;
        }
        byte tag = this.buf[index];
        switch (tag) {
            case 1: {
                this.poolObj[i] = this.names.fromUtf(this.buf, index + 3, this.getChar(index + 1));
                break;
            }
            case 8: {
                this.poolObj[i] = this.readName(this.getChar(index + 1)).toString();
                break;
            }
        }
        return this.poolObj[i];
    }

    public void readClassFile(Symbol.ClassSymbol c) throws RuntimeException {
        try {
            FileEntry classfile = c.classfile;
            InputStream s = classfile.open();
            int size = (int)classfile.length();
            if (this.buf.length < size) {
                this.buf = new byte[size];
            }
            for (int n = 0; n < size; n += s.read(this.buf, n, size - n)) {
            }
            s.close();
            this.bp = 0;
        }
        catch (IOException e) {
            throw new SignatureReaderException("could not open class file", new Object[0]);
        }
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw new SignatureReaderException("illegal.start.of.class.file", new Object[0]);
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion > Target.MAX().majorVersion || majorVersion * 1000 + minorVersion < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            throw new SignatureReaderException("wrong.version", Integer.toString(majorVersion), Integer.toString(minorVersion), Integer.toString(Target.MAX().majorVersion), Integer.toString(Target.MAX().minorVersion));
        }
        if (majorVersion != Target.MAX().majorVersion || minorVersion > Target.MAX().minorVersion) {
            // empty if block
        }
        this.indexPool();
        this.readClass(c);
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int i = 1;
        block6: while (i < this.poolIdx.length) {
            this.poolIdx[i++] = this.bp;
            byte tag = this.buf[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.bp += len;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block6;
                }
            }
            throw new SignatureReaderException("bad.const.pool.tag.at", Byte.toString(tag), Integer.toString(this.bp - 1));
        }
    }

    void readClass(Symbol.ClassSymbol c) {
        this.nextChar();
        this.nextChar();
        int startbp = this.bp;
        this.nextChar();
        char interfaceCount = this.nextChar();
        this.bp += interfaceCount * 2;
        int fieldCount = this.nextChar();
        for (int i = 0; i < fieldCount; ++i) {
            this.skipMember();
        }
        int methodCount = this.nextChar();
        for (int i = 0; i < methodCount; ++i) {
            this.skipMember();
        }
        this.readClassAttrs(c);
    }

    void readClassAttr(Symbol.ClassSymbol c, Name attrName, int attrLen) {
        if (attrName == this.names.SignatureClasses) {
            Name x = this.readName(this.nextChar());
            String[] cl = x.toString().split(",");
            ListBuffer<Name> ns = new ListBuffer<Name>();
            for (int i = 0; i < cl.length; ++i) {
                ns.append(this.names.fromString(cl[i]));
            }
            ((Symbol.PackageSymbol)c.owner).classes = ns.toList();
        } else if (attrName == this.names.SignatureParams) {
            Name x = this.readName(this.nextChar());
            String[] cl = x.toString().split(",");
            ListBuffer<Type> ns = new ListBuffer<Type>();
            for (int i = 0; i < cl.length; ++i) {
                Symbol.PackageSymbol pck = this.reader.enterModuleImport2(this.names.fromString("p" + i));
                Symbol.PackageSymbol sbound = this.reader.enterPackage(this.names.fromString(cl[i]));
                this.types.setBounds((Type.TypeVar)pck.type, List.make(sbound.type));
                ns.append(pck.type);
            }
            ((Type.PackageType)c.owner.packge().type).typarams_field = ns.toList();
        } else {
            this.bp += attrLen;
        }
    }

    void readClassAttrs(Symbol.ClassSymbol c) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            this.readClassAttr(c, attrName, attrLen);
        }
    }

    static class SignatureReaderException
    extends RuntimeException {
        SignatureReaderException(String s, Object ... args) {
            super(s);
        }
    }
}

