/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.main;

import edu.rice.cs.nextgen2.bytecode.SnippetProcessor;
import edu.rice.cs.nextgen2.compiler.code.Source;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Symtab;
import edu.rice.cs.nextgen2.compiler.comp.Annotate;
import edu.rice.cs.nextgen2.compiler.comp.Attr;
import edu.rice.cs.nextgen2.compiler.comp.AttrContext;
import edu.rice.cs.nextgen2.compiler.comp.Check;
import edu.rice.cs.nextgen2.compiler.comp.Enter;
import edu.rice.cs.nextgen2.compiler.comp.Env;
import edu.rice.cs.nextgen2.compiler.comp.Flow;
import edu.rice.cs.nextgen2.compiler.comp.Lower;
import edu.rice.cs.nextgen2.compiler.comp.Todo;
import edu.rice.cs.nextgen2.compiler.comp.TransTypes;
import edu.rice.cs.nextgen2.compiler.flatten.Flat;
import edu.rice.cs.nextgen2.compiler.flatten.ModuleAnalyzer;
import edu.rice.cs.nextgen2.compiler.flatten.VisitorEnv;
import edu.rice.cs.nextgen2.compiler.jvm.ClassReader;
import edu.rice.cs.nextgen2.compiler.jvm.ClassWriter;
import edu.rice.cs.nextgen2.compiler.jvm.Gen;
import edu.rice.cs.nextgen2.compiler.parser.Parser;
import edu.rice.cs.nextgen2.compiler.parser.Scanner;
import edu.rice.cs.nextgen2.compiler.tree.Pretty;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen2.compiler.tree.TreeScanner;
import edu.rice.cs.nextgen2.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen2.compiler.util.Abort;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.Convert;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.ListBuffer;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Options;
import edu.rice.cs.nextgen2.compiler.util.Paths;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    Log log;
    TreeMaker make;
    ClassReader reader;
    ClassWriter writer;
    Enter enter;
    Symtab syms;
    Source source;
    Gen gen;
    Name.Table names;
    Attr attr;
    Check chk;
    Flow flow;
    Flat flat;
    TransTypes transTypes;
    Lower lower;
    Annotate annotate;
    final Name completionFailureName;
    Scanner.Factory scannerFactory;
    Parser.Factory parserFactory;
    Context context;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public boolean printtree;
    public boolean deprecation;
    public boolean warnunchecked;
    public String encoding;
    public String destdir;
    private Todo todo;
    Set<File> inputFiles = new HashSet<File>();
    private boolean hasBeenUsed = false;

    public static JavaCompiler instance(Context context) {
        JavaCompiler instance = context.get(compilerKey);
        if (instance == null) {
            instance = new JavaCompiler(context);
        }
        return instance;
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    public JavaCompiler(Context context) {
        context.put(compilerKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.parserFactory = Parser.Factory.instance(context);
        this.scannerFactory = Scanner.Factory.instance(context);
        try {
            this.syms = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure ex) {
            this.log.error(0, ex.getMessage(), new Object[0]);
        }
        this.source = Source.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.flat = Flat.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.context = context;
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.stubOutput = options.get("-stubs") != null;
        this.relax = options.get("-relax") != null;
        this.printFlat = options.get("-printflat") != null;
        this.deprecation = options.lint("deprecation");
        this.warnunchecked = options.lint("unchecked");
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = (String)options.get("-encoding");
        this.destdir = (String)options.get("-d");
        this.printtree = options.get("-printtree") != null;
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public InputStream openSource(String filename) {
        try {
            File f = new File(filename);
            this.inputFiles.add(f);
            return new FileInputStream(f);
        }
        catch (IOException e) {
            this.log.error(0, "cant.read.file", filename);
            return null;
        }
    }

    public Tree.TopLevel parse(String filename, InputStream input) {
        long msec = System.currentTimeMillis();
        Name prev = this.log.useSource(this.names.fromString(filename));
        Tree.TopLevel tree = this.make.TopLevel(null, Tree.Annotation.emptyList, null, Tree.emptyList);
        if (input != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", filename);
            }
            try {
                Scanner scanner = this.scannerFactory.newScanner(input, this.encoding);
                input.close();
                Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
                tree = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - msec));
                }
            }
            catch (IOException e) {
                this.log.error(0, "error.reading.file", filename, e);
            }
        }
        this.log.useSource(prev);
        tree.sourcefile = this.names.fromString(filename);
        return tree;
    }

    protected boolean keepComments() {
        return this.sourceOutput || this.stubOutput;
    }

    public Tree.TopLevel parse(String filename) {
        return this.parse(filename, this.openSource(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef cdef) throws IOException {
        File outFile = this.writer.outputFile(cdef.sym, ".javasrc");
        if (this.inputFiles.contains(outFile)) {
            this.log.error(cdef.pos, "source.cant.overwrite.input.file", outFile);
        } else {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile))));
            try {
                new Pretty(out, true).printUnit(env.toplevel, cdef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", outFile.getPath());
                }
                Object var6_5 = null;
                out.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                out.close();
                throw throwable;
            }
        }
    }

    void printTree(Tree.ClassDef cdef) throws IOException {
        new TreePrinter().scan(cdef);
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef cdef) throws IOException {
        try {
            if (this.gen.genClass(env, cdef)) {
                this.writer.writeClass(cdef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow ex) {
            this.log.error(cdef.pos, "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow ex) {
            this.log.error(cdef.pos, "limit.string.overflow", ex.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure ex) {
            this.log.error(0, ex.getMessage(), new Object[0]);
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol c, String filename, InputStream f) throws Symbol.CompletionFailure {
        if (this.completionFailureName == c.fullname) {
            throw new Symbol.CompletionFailure(c, "user-selected completion failure by class name");
        }
        Tree.TopLevel tree = this.parse(filename, f);
        this.enter.complete(List.make(tree), c);
        if (this.enter.getEnv(c) == null) {
            throw new ClassReader.BadClassFile(c, filename, Log.getLocalizedString("file.doesnt.contain.class", c.fullname));
        }
    }

    private static void appendEnvs(ListBuffer<Env<AttrContext>> newDefs, List<Tree> classDefs, Env<AttrContext> env) {
        List<Tree> tail = classDefs;
        while (tail.nonEmpty()) {
            newDefs.append(env.dup((Tree)tail.head));
            tail = tail.tail;
        }
    }

    public List<Env<AttrContext>> flatten(ListBuffer<Env<AttrContext>> envs) throws IOException {
        ListBuffer<Env<AttrContext>> newdefs = new ListBuffer<Env<AttrContext>>();
        List<Env<AttrContext>> todo = envs.toList();
        if (this.errorCount() == 0) {
            while (todo.nonEmpty()) {
                Env env = (Env)todo.head;
                Name prev = this.log.useSource(env.enclClass.sym.sourcefile);
                VisitorEnv venv = VisitorEnv.newClassVisitorEnv(this.context, (Symbol.ClassSymbol)env.tree.type.tsym);
                env.tree = this.flat.translateTopLevelClass(env.tree, venv);
                JavaCompiler.appendEnvs(newdefs, venv.defs.toList(), env);
                ModuleAnalyzer m = new ModuleAnalyzer();
                m.init(this.context, env.toplevel.packge);
                m.translate(env.tree);
                m.translate(venv.defs.toList());
                todo = todo.tail;
            }
        }
        return newdefs.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Symbol.ClassSymbol> compile(List<String> filenames) throws Throwable {
        int errCount;
        assert (!this.hasBeenUsed) : "attempt to reuse JavaCompiler";
        this.hasBeenUsed = true;
        long msec = System.currentTimeMillis();
        ListBuffer<Symbol.ClassSymbol> classes = new ListBuffer<Symbol.ClassSymbol>();
        try {
            ListBuffer<String> files = new ListBuffer<String>();
            String od = this.destdir;
            ListBuffer<Tree.TopLevel> trees = new ListBuffer<Tree.TopLevel>();
            List<String> l = filenames;
            while (l.nonEmpty()) {
                trees.append(this.parse((String)l.head));
                l = l.tail;
            }
            List<Tree> roots = trees.toList();
            if (this.errorCount() == 0) {
                this.enter.main(roots);
            }
            List rootClasses = null;
            if (this.sourceOutput || this.stubOutput) {
                ListBuffer<Tree.ClassDef> cdefs = new ListBuffer<Tree.ClassDef>();
                List<Tree> l2 = roots;
                while (l2.nonEmpty()) {
                    List<Tree> defs = ((Tree.TopLevel)l2.head).defs;
                    while (defs.nonEmpty()) {
                        if (defs.head instanceof Tree.ClassDef) {
                            cdefs.append((Tree.ClassDef)defs.head);
                        }
                        defs = defs.tail;
                    }
                    l2 = l2.tail;
                }
                rootClasses = cdefs.toList();
            }
            ListBuffer<Env<AttrContext>> envs = new ListBuffer<Env<AttrContext>>();
            while (this.todo.nonEmpty()) {
                Env env;
                block47: {
                    Object var18_19;
                    Name prev;
                    block45: {
                        env = (Env)this.todo.next();
                        Tree untranslated = env.tree;
                        if (this.verbose) {
                            this.printVerbose("checking.attribution", env.enclClass.sym);
                        }
                        prev = this.log.useSource(env.enclClass.sym.sourcefile);
                        this.attr.attribClass(env.tree.pos, env.enclClass.sym);
                        if (this.attrParseOnly) continue;
                        this.make.at(1025);
                        TreeMaker localMake = this.make.forToplevel(env.toplevel);
                        if (this.errorCount() == 0 && !this.relax) {
                            this.flow.analyzeTree(env.tree, localMake);
                        }
                        Tree.ClassDef cdef = null;
                        try {
                            try {
                                if (this.errorCount() != 0) break block45;
                                if (env.tree instanceof Tree.TopLevel) {
                                    List<Tree> pdef = this.lower.translateTopLevelClass(env, env.tree, localMake);
                                    if (pdef.head != null) {
                                        assert (pdef.tail.isEmpty());
                                        this.genCode(env, (Tree.ClassDef)pdef.head);
                                    }
                                    var18_19 = null;
                                    this.log.useSource(prev);
                                    continue;
                                }
                                if (!this.stubOutput) break block45;
                                cdef = (Tree.ClassDef)env.tree;
                                if (untranslated instanceof Tree.ClassDef && rootClasses.contains((Tree.ClassDef)untranslated) && ((cdef.mods.flags & 5L) != 0L || cdef.sym.packge().fullName() == this.names.java_lang)) {
                                    this.printSource(env, this.removeMethodBodies(cdef));
                                }
                            }
                            catch (IOException ex) {
                                this.log.error(cdef.pos, "class.cant.write", cdef.sym, ex.getMessage());
                                var18_19 = null;
                                this.log.useSource(prev);
                                break block47;
                            }
                        }
                        catch (Throwable throwable) {
                            var18_19 = null;
                            this.log.useSource(prev);
                            throw throwable;
                        }
                        var18_19 = null;
                        this.log.useSource(prev);
                        continue;
                    }
                    var18_19 = null;
                    this.log.useSource(prev);
                }
                envs.append(env);
            }
            List<Env<AttrContext>> newdefs = this.flatten(envs);
            envs.appendList(newdefs);
            while (envs.nonEmpty()) {
                Object var22_25;
                Name prev;
                block48: {
                    block50: {
                        block49: {
                            Env<AttrContext> env = envs.next();
                            TreeMaker localMake = this.make.forToplevel(env.toplevel);
                            Tree.ClassDef cdef = null;
                            Tree untranslated = env.tree;
                            prev = this.log.useSource(env.enclClass.sym.sourcefile);
                            try {
                                try {
                                    if (this.errorCount() != 0) break block48;
                                    env.tree = this.transTypes.translateTopLevelClass(env.tree, localMake);
                                    if (this.errorCount() != 0) {
                                        var22_25 = null;
                                        this.log.useSource(prev);
                                        continue;
                                    }
                                    if (this.sourceOutput) {
                                        cdef = (Tree.ClassDef)env.tree;
                                        if (untranslated instanceof Tree.ClassDef && rootClasses.contains((Tree.ClassDef)untranslated)) {
                                            this.printSource(env, cdef);
                                        }
                                        break block49;
                                    }
                                    List<Tree> cdefs = this.lower.translateTopLevelClass(env, env.tree, localMake);
                                    if (this.errorCount() != 0) {
                                        break block50;
                                    }
                                    List<Tree> l3 = cdefs;
                                    while (this.errorCount() == 0 && l3.nonEmpty()) {
                                        cdef = (Tree.ClassDef)l3.head;
                                        if (this.printtree) {
                                            this.printTree(cdef);
                                            this.printSource(env, cdef);
                                        }
                                        if (this.printFlat) {
                                            this.printSource(env, cdef);
                                        } else {
                                            this.genCode(env, cdef);
                                        }
                                        classes.append(cdef.sym);
                                        String filename = Convert.shortName(cdef.sym.flatname) + "";
                                        String sourcedir = new File(cdef.sym.sourcefile.toString()).getParent();
                                        if (od != null) {
                                            files.append(cdef.sym.flatname.toString());
                                        } else if (sourcedir == null) {
                                            files.append(filename);
                                        } else {
                                            files.append("" + sourcedir + "/" + filename);
                                        }
                                        l3 = l3.tail;
                                    }
                                    break block48;
                                }
                                catch (IOException ex) {
                                    this.log.error(cdef.pos, "class.cant.write", cdef.sym, ex.getMessage());
                                    var22_25 = null;
                                    this.log.useSource(prev);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                var22_25 = null;
                                this.log.useSource(prev);
                                throw throwable;
                            }
                        }
                        var22_25 = null;
                        this.log.useSource(prev);
                        continue;
                    }
                    var22_25 = null;
                    this.log.useSource(prev);
                    continue;
                }
                var22_25 = null;
                this.log.useSource(prev);
            }
            Paths p = Paths.instance(this.context);
            if (od == null) {
                od = "";
            }
            if (this.errorCount() == 0) {
                SnippetProcessor c = new SnippetProcessor(od, p.userClassPath());
                String[] files0 = new String[files.length()];
                files.toArray(files0);
                c.process(files0);
            }
        }
        catch (Abort ex) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - msec));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource);
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.makeNotes(this.chk.uncheckedSource.toString());
        }
        if ((errCount = this.errorCount()) == 1) {
            this.printCount("error", errCount);
        } else {
            this.printCount("error.plural", errCount);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
            return classes.toList();
        }
        this.printCount("warn.plural", this.log.nwarnings);
        return classes.toList();
    }

    Tree.ClassDef removeMethodBodies(Tree.ClassDef cdef) {
        final boolean isInterface = (cdef.mods.flags & 0x200L) != 0L;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(Tree.MethodDef tree) {
                tree.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (Tree.VarDef vd : tree.params) {
                    vd.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                tree.body = null;
                super.visitMethodDef(tree);
            }

            @Override
            public void visitVarDef(Tree.VarDef tree) {
                if (tree.init != null && tree.init.type.constValue == null) {
                    tree.init = null;
                }
                super.visitVarDef(tree);
            }

            @Override
            public void visitClassDef(Tree.ClassDef tree) {
                ListBuffer<Tree> newdefs = new ListBuffer<Tree>();
                List<Tree> it = tree.defs;
                while (it.tail != null) {
                    Tree t = (Tree)it.head;
                    switch (t.tag) {
                        case 4: {
                            if (!isInterface && (((Tree.ClassDef)t).mods.flags & 5L) == 0L && ((((Tree.ClassDef)t).mods.flags & 2L) != 0L || ((Tree.ClassDef)t).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case 5: {
                            if (!isInterface && (((Tree.MethodDef)t).mods.flags & 5L) == 0L && ((Tree.MethodDef)t).sym.name != JavaCompiler.this.names.init && ((((Tree.MethodDef)t).mods.flags & 2L) != 0L || ((Tree.MethodDef)t).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                        case 6: {
                            if (!isInterface && (((Tree.VarDef)t).mods.flags & 5L) == 0L && ((((Tree.VarDef)t).mods.flags & 2L) != 0L || ((Tree.VarDef)t).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            newdefs.append(t);
                            break;
                        }
                    }
                    it = it.tail;
                }
                tree.defs = newdefs.toList();
                super.visitClassDef(tree);
            }
        }
        MethodBodyRemover r = new MethodBodyRemover();
        return (Tree.ClassDef)r.translate(cdef);
    }

    public void close() {
        this.log.flush();
        this.reader.close();
        this.names.dispose();
    }

    private void printVerbose(String key, Object arg) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + key, arg));
    }

    private void noteDeprecated(Object input) {
        if (input.equals("*")) {
            this.log.note("deprecated.plural", new Object[0]);
        } else {
            this.log.note("deprecated.filename", input);
        }
        this.log.note("deprecated.recompile", new Object[0]);
    }

    void makeNotes(Object input) {
        if (input.toString().equals("*")) {
            this.log.note("unchecked.plural", new Object[0]);
        } else {
            this.log.note("unchecked.filename", input);
        }
        this.log.note("unchecked.recompile", new Object[0]);
    }

    void printCount(String kind, int count) {
        if (count != 0) {
            Log.printLines(this.log.errWriter, Log.getLocalizedString("count." + kind, Integer.toString(count)));
            this.log.errWriter.flush();
        }
    }

    class TreePrinter
    extends TreeScanner {
        int indentlevel = 0;

        TreePrinter() {
        }

        public void scan(Tree tree) {
            if (tree != null) {
                ++this.indentlevel;
                String cname = this.simplename(tree.getClass().getName());
                String tname = tree.type == null ? "" : this.simplename(tree.type.getClass().getName());
                this.printspaces(this.indentlevel);
                if (tree.type != null) {
                    String sname = tree.type.tsym == null ? "" : this.simplename(tree.type.tsym.getClass().getName());
                }
                tree.accept(this);
                --this.indentlevel;
            }
        }

        void printspaces(int il) {
            for (int i = 0; i < il * 4; ++i) {
                System.out.print(' ');
            }
        }

        String simplename(String name) {
            int idx = Math.max(name.lastIndexOf(36), name.lastIndexOf(46)) + 1;
            return name.substring(idx);
        }
    }
}

