/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.parser;

import edu.rice.cs.nextgen2.compiler.code.Source;
import edu.rice.cs.nextgen2.compiler.parser.Keywords;
import edu.rice.cs.nextgen2.compiler.parser.Tokens;
import edu.rice.cs.nextgen2.compiler.util.Context;
import edu.rice.cs.nextgen2.compiler.util.LayoutCharacters;
import edu.rice.cs.nextgen2.compiler.util.Log;
import edu.rice.cs.nextgen2.compiler.util.Name;
import edu.rice.cs.nextgen2.compiler.util.Position;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Scanner
implements LayoutCharacters {
    private Tokens token;
    private boolean allowHexFloats;
    private int pos;
    private int endPos;
    private int prevEndPos;
    private int errPos = 0;
    private Name name;
    private int radix;
    private boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int bp;
    private int buflen;
    private char ch;
    private int line;
    private int col;
    private int unicodeConversionBp = 0;
    private final Log log;
    private final Name.Table names;
    private final Keywords keywords;
    private String docComment = null;
    private char[] docCommentBuffer;
    private int docCommentCount;
    private Source source;
    private static String defaultEncodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
    private static final boolean hexFloatsWork = Scanner.hexFloatsWork();
    private final ByteBufferCache byteBufferCache;
    static final boolean surrogatesSupported = Scanner.surrogatesSupported();

    private Scanner(Factory fac) {
        this.log = fac.log;
        this.names = fac.names;
        this.keywords = fac.keywords;
        this.byteBufferCache = fac.byteBufferCache;
        this.source = fac.source;
        this.allowHexFloats = fac.source.allowHexFloats();
    }

    private static boolean hexFloatsWork() {
        try {
            Float.valueOf("0x1.0p1");
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    protected Scanner(Factory fac, CharBuffer buffer) {
        this(fac, ((CharBuffer)buffer.compact().flip()).array(), buffer.limit());
    }

    protected Scanner(Factory fac, char[] input, int inputLength) {
        this(fac);
        assert (inputLength < input.length);
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.line = 1;
        this.col = 0;
        this.bp = -1;
        this.scanChar();
        this.nextToken();
    }

    protected Scanner(Factory fac, InputStream in, String encodingName) throws IOException {
        this(fac, Scanner.makeByteBuffer(fac, in), encodingName, true);
        in.close();
    }

    private static ByteBuffer makeByteBuffer(Factory fac, InputStream in) throws IOException {
        int limit = in.available();
        if (limit < 1024) {
            limit = 1024;
        }
        ByteBuffer result = fac.byteBufferCache.get(limit);
        int position = 0;
        while (in.available() != 0) {
            int count;
            if (position >= limit) {
                result = ByteBuffer.allocate(limit <<= 1).put((ByteBuffer)result.flip());
            }
            if ((count = in.read(result.array(), position, limit - position)) < 0) break;
            result.position(position += count);
        }
        return (ByteBuffer)result.flip();
    }

    private Scanner(Factory fac, ByteBuffer buffer, String encodingName, boolean dispose) {
        this(fac, Scanner.decode(fac, buffer, encodingName));
        if (dispose) {
            this.byteBufferCache.put(buffer);
        }
    }

    public Scanner(Factory fac, ByteBuffer buffer, String encodingName) {
        this(fac, buffer, encodingName, false);
    }

    private static CharBuffer decode(Factory fac, ByteBuffer inbuf, String encodingName) {
        CoderResult result;
        CharsetDecoder decoder;
        try {
            if (encodingName == null) {
                encodingName = defaultEncodingName;
            }
            Charset charset = Charset.forName(encodingName);
            decoder = charset.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        catch (IllegalCharsetNameException e) {
            Scanner.lexError(fac.log, 0, "unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        catch (UnsupportedCharsetException e) {
            Scanner.lexError(fac.log, 0, "unsupported.encoding", encodingName);
            return (CharBuffer)CharBuffer.allocate(1).flip();
        }
        float factor = decoder.averageCharsPerByte() * 0.8f + decoder.maxCharsPerByte() * 0.2f;
        CharBuffer dest = CharBuffer.allocate(10 + (int)((float)inbuf.remaining() * factor));
        while (true) {
            result = decoder.decode(inbuf, dest, true);
            dest.flip();
            if (result.isUnderflow()) {
                if (dest.limit() == dest.capacity()) {
                    dest = CharBuffer.allocate(dest.capacity() + 1).put(dest);
                    dest.flip();
                }
                return dest;
            }
            if (result.isOverflow()) {
                int newCapacity = 10 + dest.capacity() + (int)((float)inbuf.remaining() * decoder.maxCharsPerByte());
                dest = CharBuffer.allocate(newCapacity).put(dest);
                continue;
            }
            if (!result.isMalformed() && !result.isUnmappable()) break;
            int line = 0;
            int lastLineStart = 0;
            Pattern linePattern = Pattern.compile("^.*$", 8);
            Matcher m = linePattern.matcher(dest);
            while (m.find()) {
                ++line;
                lastLineStart = m.start();
            }
            int column = 0;
            for (int i = lastLineStart; i < dest.limit(); ++i) {
                if (dest.get(i) == '\t') {
                    column = column / 8 * 8 + 8;
                    continue;
                }
                ++column;
            }
            ++column;
            if (!fac.source.allowEncodingErrors()) {
                Scanner.lexError(fac.log, Position.make(line, column), "illegal.char.for.encoding", encodingName);
            } else {
                Scanner.lexWarning(fac.log, Position.make(line, column), "illegal.char.for.encoding", encodingName);
            }
            inbuf.position(inbuf.position() + result.length());
            dest.position(dest.limit());
            dest.limit(dest.capacity());
            dest.put('\ufffd');
        }
        throw new AssertionError(result);
    }

    private static void lexWarning(Log log, int pos, String key, Object arg) {
        log.warning(pos, key, arg);
    }

    private static void lexError(Log log, int pos, String key, Object arg) {
        log.error(pos, key, arg);
    }

    private static void lexError(Log log, int pos, String key) {
        Scanner.lexError(log, pos, key, null);
    }

    private void lexError(int pos, String key, Object arg) {
        this.log.error(pos, key, arg);
        this.token = Tokens.ERROR;
        this.errPos = pos;
    }

    private void lexError(int pos, String key) {
        this.lexError(pos, key, null);
    }

    private void lexError(String key) {
        this.lexError(this.pos, key, null);
    }

    private void lexError(String key, Object arg) {
        this.lexError(this.pos, key, arg);
    }

    private void lexWarning(int pos, String key) {
        this.log.warning(pos, key, new Object[0]);
    }

    private int digit(int base) {
        char c = this.ch;
        int result = Character.digit(c, base);
        if (result >= 0 && c > '\u007f') {
            this.lexWarning(this.pos + 1, "illegal.nonascii.digit");
            this.ch = "0123456789abcdef".charAt(result);
        }
        return result;
    }

    private void convertUnicode() {
        int startcol = this.col++;
        if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
            ++this.bp;
            this.ch = this.buf[this.bp];
            if (this.ch == 'u') {
                do {
                    ++this.bp;
                    this.ch = this.buf[this.bp];
                    ++this.col;
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.buflen) {
                    int d;
                    int code = d = this.digit(16);
                    while (this.bp < limit && d >= 0) {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                        ++this.col;
                        d = this.digit(16);
                        code = (code << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)code;
                        this.unicodeConversionBp = this.bp;
                        return;
                    }
                }
                this.lexError(Position.make(this.line, startcol), "illegal.unicode.esc");
            } else {
                --this.bp;
                this.ch = (char)92;
                --this.col;
            }
        }
    }

    private void scanChar() {
        ++this.bp;
        this.ch = this.buf[this.bp];
        switch (this.ch) {
            case '\r': {
                this.col = 0;
                ++this.line;
                break;
            }
            case '\n': {
                if (this.bp != 0 && this.buf[this.bp - 1] == '\r') break;
                this.col = 0;
                ++this.line;
                break;
            }
            case '\t': {
                this.col = this.col / 8 * 8 + 8;
                break;
            }
            case '\\': {
                ++this.col;
                this.convertUnicode();
                break;
            }
            default: {
                ++this.col;
            }
        }
    }

    private void scanCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void expandCommentBuffer() {
        char[] newBuffer = new char[this.docCommentBuffer.length * 2];
        System.arraycopy(this.docCommentBuffer, 0, newBuffer, 0, this.docCommentBuffer.length);
        this.docCommentBuffer = newBuffer;
    }

    private void scanDocCommentChar() {
        this.scanChar();
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                if (this.docCommentCount == this.docCommentBuffer.length) {
                    this.expandCommentBuffer();
                }
                this.docCommentBuffer[this.docCommentCount++] = this.ch;
                ++this.bp;
                ++this.col;
            } else {
                this.convertUnicode();
            }
        }
    }

    private void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                ++this.col;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.ch;
                        int oct = this.digit(8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            oct = oct * 8 + this.digit(8);
                            this.scanChar();
                            if (leadch <= '3' && '0' <= this.ch && this.ch <= '7') {
                                oct = oct * 8 + this.digit(8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)oct);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    case '\\': {
                        this.putChar('\\');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(Position.make(this.line, this.col), "illegal.esc.char");
                        break;
                    }
                }
            }
        } else if (this.bp != this.buflen) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanHexExponentAndSuffix() {
        if (this.ch == 'p' || this.ch == 'P') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                if (!this.allowHexFloats) {
                    this.lexError("unsupported.fp.lit");
                    this.allowHexFloats = true;
                } else if (!hexFloatsWork) {
                    this.lexError("unsupported.cross.fp.lit");
                }
            } else {
                this.lexError("malformed.fp.lit");
            }
        } else {
            this.lexError("malformed.fp.lit");
        }
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Tokens.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Tokens.DOUBLELITERAL;
        }
    }

    private void scanFraction() {
        while (this.digit(10) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        int sp1 = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.lexError("malformed.fp.lit");
            this.sp = sp1;
        }
    }

    private void scanFractionAndSuffix() {
        this.radix = 10;
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.putChar(this.ch);
            this.scanChar();
            this.token = Tokens.FLOATLITERAL;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.putChar(this.ch);
                this.scanChar();
            }
            this.token = Tokens.DOUBLELITERAL;
        }
    }

    private void scanHexFractionAndSuffix(boolean seendigit) {
        this.radix = 16;
        assert (this.ch == '.');
        this.putChar(this.ch);
        this.scanChar();
        while (this.digit(16) >= 0) {
            seendigit = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (!seendigit) {
            this.lexError("invalid.hex.number");
        } else {
            this.scanHexExponentAndSuffix();
        }
    }

    private void scanNumber(int radix) {
        this.radix = radix;
        int digitRadix = radix <= 10 ? 10 : 16;
        boolean seendigit = false;
        while (this.digit(digitRadix) >= 0) {
            seendigit = true;
            this.putChar(this.ch);
            this.scanChar();
        }
        if (radix == 16 && this.ch == '.') {
            this.scanHexFractionAndSuffix(seendigit);
        } else if (seendigit && radix == 16 && (this.ch == 'p' || this.ch == 'P')) {
            this.scanHexExponentAndSuffix();
        } else if (radix <= 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (radix <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = Tokens.LONGLITERAL;
        } else {
            this.token = Tokens.INTLITERAL;
        }
    }

    private void scanIdent() {
        block4: while (true) {
            boolean isJavaIdentifierPart;
            if (this.sp == this.sbuf.length) {
                this.putChar(this.ch);
            } else {
                this.sbuf[this.sp++] = this.ch;
            }
            this.scanChar();
            switch (this.ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001b': 
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': 
                case '\u007f': {
                    continue block4;
                }
                case '\u001a': {
                    if (this.bp < this.buflen) continue block4;
                    this.name = this.names.fromChars(this.sbuf, 0, this.sp);
                    this.token = this.keywords.key(this.name);
                    return;
                }
            }
            if (this.ch < '\u0080') {
                isJavaIdentifierPart = false;
            } else {
                char high = this.scanSurrogates();
                if (high != '\u0000') {
                    if (this.sp == this.sbuf.length) {
                        this.putChar(high);
                    } else {
                        this.sbuf[this.sp++] = high;
                    }
                    isJavaIdentifierPart = Character.isJavaIdentifierPart(Character.toCodePoint(high, this.ch));
                } else {
                    isJavaIdentifierPart = Character.isJavaIdentifierPart(this.ch);
                }
            }
            if (!isJavaIdentifierPart) break;
        }
        this.name = this.names.fromChars(this.sbuf, 0, this.sp);
        this.token = this.keywords.key(this.name);
    }

    private static boolean surrogatesSupported() {
        try {
            boolean b = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    private char scanSurrogates() {
        if (surrogatesSupported && Character.isHighSurrogate(this.ch)) {
            char high = this.ch;
            this.scanChar();
            if (Character.isLowSurrogate(this.ch)) {
                return high;
            }
            this.ch = high;
        }
        return '\u0000';
    }

    private boolean isSpecial(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name newname = this.names.fromChars(this.sbuf, 0, this.sp);
            if (this.keywords.key(newname) == Tokens.IDENTIFIER) {
                --this.sp;
                break;
            }
            this.name = newname;
            this.token = this.keywords.key(newname);
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocCommentTag() {
        int start = this.bp + 1;
        do {
            this.scanDocCommentChar();
        } while ('a' <= this.ch && this.ch <= 'z');
        if (this.names.fromChars(this.buf, start, this.bp - start) == this.names.deprecated) {
            this.deprecatedFlag = true;
        }
    }

    private void skipComment() {
        block3: while (this.bp < this.buflen) {
            switch (this.ch) {
                case '*': {
                    this.scanChar();
                    if (this.ch != '/') continue block3;
                    return;
                }
            }
            this.scanCommentChar();
        }
    }

    private String scanDocComment() {
        int i;
        if (this.docCommentBuffer == null) {
            this.docCommentBuffer = new char[1024];
        }
        this.docCommentCount = 0;
        boolean linestart = false;
        boolean firstLine = true;
        while (this.bp < this.buflen && this.ch == '*') {
            this.scanDocCommentChar();
        }
        if (this.bp < this.buflen && this.ch == '/') {
            return "";
        }
        if (this.bp < this.buflen) {
            if (this.ch == '\n') {
                this.scanDocCommentChar();
                firstLine = false;
            } else if (this.ch == '\r') {
                this.scanDocCommentChar();
                if (this.ch == '\n') {
                    this.scanDocCommentChar();
                    firstLine = false;
                }
            }
        }
        block16: while (this.bp < this.buflen) {
            block17: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case ' ': {
                        this.scanDocCommentChar();
                        continue block17;
                    }
                    case '\t': {
                        this.col = (this.col - 1) / 8 * 8 + 8;
                        this.scanDocCommentChar();
                        continue block17;
                    }
                    case '\f': {
                        this.col = 0;
                        this.scanDocCommentChar();
                        continue block17;
                    }
                }
            }
            if (this.ch == '*') {
                do {
                    this.scanDocCommentChar();
                } while (this.ch == '*');
                if (this.ch == '/') {
                    break;
                }
            } else if (!firstLine) {
                for (i = 1; i < this.col; ++i) {
                    if (this.docCommentCount == this.docCommentBuffer.length) {
                        this.expandCommentBuffer();
                    }
                    this.docCommentBuffer[this.docCommentCount++] = 32;
                }
            }
            linestart = true;
            block20: while (this.bp < this.buflen) {
                switch (this.ch) {
                    case '*': {
                        linestart = false;
                        this.scanDocCommentChar();
                        if (this.ch == '/') break block16;
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = 42;
                        continue block20;
                    }
                    case '\t': 
                    case ' ': {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        continue block20;
                    }
                    case '\f': {
                        this.scanDocCommentChar();
                        break block20;
                    }
                    case '\r': {
                        this.scanDocCommentChar();
                        if (this.ch != '\n') {
                            if (this.docCommentCount == this.docCommentBuffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.docCommentBuffer[this.docCommentCount++] = 10;
                            break block20;
                        }
                    }
                    case '\n': {
                        if (this.docCommentCount == this.docCommentBuffer.length) {
                            this.expandCommentBuffer();
                        }
                        this.docCommentBuffer[this.docCommentCount++] = this.ch;
                        this.scanDocCommentChar();
                        break block20;
                    }
                    default: {
                        if (this.ch == '@' && linestart) {
                            int start = this.bp + 1;
                            do {
                                if (this.docCommentCount == this.docCommentBuffer.length) {
                                    this.expandCommentBuffer();
                                }
                                this.docCommentBuffer[this.docCommentCount++] = this.ch;
                                this.scanDocCommentChar();
                            } while ('a' <= this.ch && this.ch <= 'z');
                            if (this.names.fromChars(this.buf, start, this.bp - start) == this.names.deprecated) {
                                this.deprecatedFlag = true;
                            }
                        } else {
                            if (this.docCommentCount == this.docCommentBuffer.length) {
                                this.expandCommentBuffer();
                            }
                            this.docCommentBuffer[this.docCommentCount++] = this.ch;
                            this.scanDocCommentChar();
                        }
                        linestart = false;
                        continue block20;
                    }
                }
            }
            firstLine = false;
        }
        if (this.docCommentCount > 0) {
            block22: for (i = this.docCommentCount - 1; i > -1; --i) {
                switch (this.docCommentBuffer[i]) {
                    case '*': {
                        continue block22;
                    }
                }
            }
            this.docCommentCount = i + 1;
            return new String(this.docCommentBuffer, 0, this.docCommentCount);
        }
        return "";
    }

    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nextToken() {
        block69: {
            block68: {
                block67: {
                    block66: {
                        block65: {
                            block64: {
                                block63: {
                                    block62: {
                                        block61: {
                                            block60: {
                                                block59: {
                                                    block58: {
                                                        block57: {
                                                            block56: {
                                                                block55: {
                                                                    block54: {
                                                                        try {
                                                                            this.prevEndPos = this.endPos;
                                                                            this.sp = 0;
                                                                            this.docComment = null;
                                                                            block20: while (true) {
                                                                                this.pos = (this.line << 10) + this.col;
                                                                                int start = this.bp;
                                                                                switch (this.ch) {
                                                                                    case '\t': 
                                                                                    case '\n': 
                                                                                    case '\f': 
                                                                                    case '\r': 
                                                                                    case ' ': {
                                                                                        this.scanChar();
                                                                                        break;
                                                                                    }
                                                                                    case '$': 
                                                                                    case 'A': 
                                                                                    case 'B': 
                                                                                    case 'C': 
                                                                                    case 'D': 
                                                                                    case 'E': 
                                                                                    case 'F': 
                                                                                    case 'G': 
                                                                                    case 'H': 
                                                                                    case 'I': 
                                                                                    case 'J': 
                                                                                    case 'K': 
                                                                                    case 'L': 
                                                                                    case 'M': 
                                                                                    case 'N': 
                                                                                    case 'O': 
                                                                                    case 'P': 
                                                                                    case 'Q': 
                                                                                    case 'R': 
                                                                                    case 'S': 
                                                                                    case 'T': 
                                                                                    case 'U': 
                                                                                    case 'V': 
                                                                                    case 'W': 
                                                                                    case 'X': 
                                                                                    case 'Y': 
                                                                                    case 'Z': 
                                                                                    case '_': 
                                                                                    case 'a': 
                                                                                    case 'b': 
                                                                                    case 'c': 
                                                                                    case 'd': 
                                                                                    case 'e': 
                                                                                    case 'f': 
                                                                                    case 'g': 
                                                                                    case 'h': 
                                                                                    case 'i': 
                                                                                    case 'j': 
                                                                                    case 'k': 
                                                                                    case 'l': 
                                                                                    case 'm': 
                                                                                    case 'n': 
                                                                                    case 'o': 
                                                                                    case 'p': 
                                                                                    case 'q': 
                                                                                    case 'r': 
                                                                                    case 's': 
                                                                                    case 't': 
                                                                                    case 'u': 
                                                                                    case 'v': 
                                                                                    case 'w': 
                                                                                    case 'x': 
                                                                                    case 'y': 
                                                                                    case 'z': {
                                                                                        this.scanIdent();
                                                                                        Object var5_2 = null;
                                                                                        this.endPos = (this.line << 10) + this.col - 1;
                                                                                        return;
                                                                                    }
                                                                                    case '0': {
                                                                                        this.scanChar();
                                                                                        if (this.ch == 'x' || this.ch == 'X') {
                                                                                            this.scanChar();
                                                                                            if (this.ch == '.') {
                                                                                                this.scanHexFractionAndSuffix(false);
                                                                                                break block54;
                                                                                            }
                                                                                            if (this.digit(16) < 0) {
                                                                                                this.lexError("invalid.hex.number");
                                                                                                break block54;
                                                                                            } else {
                                                                                                this.scanNumber(16);
                                                                                            }
                                                                                            break block54;
                                                                                        }
                                                                                        this.putChar('0');
                                                                                        this.scanNumber(8);
                                                                                        break block54;
                                                                                    }
                                                                                    case '1': 
                                                                                    case '2': 
                                                                                    case '3': 
                                                                                    case '4': 
                                                                                    case '5': 
                                                                                    case '6': 
                                                                                    case '7': 
                                                                                    case '8': 
                                                                                    case '9': {
                                                                                        this.scanNumber(10);
                                                                                        break block55;
                                                                                    }
                                                                                    case '.': {
                                                                                        this.scanChar();
                                                                                        if ('0' <= this.ch && this.ch <= '9') {
                                                                                            this.putChar('.');
                                                                                            this.scanFractionAndSuffix();
                                                                                            break block56;
                                                                                        }
                                                                                        if (this.ch == '.') {
                                                                                            this.putChar('.');
                                                                                            this.putChar('.');
                                                                                            this.scanChar();
                                                                                            if (this.ch == '.') {
                                                                                                this.scanChar();
                                                                                                this.putChar('.');
                                                                                                this.token = Tokens.ELLIPSIS;
                                                                                                break block56;
                                                                                            } else {
                                                                                                this.lexError("malformed.fp.lit");
                                                                                            }
                                                                                            break block56;
                                                                                        }
                                                                                        this.token = Tokens.DOT;
                                                                                        break block56;
                                                                                    }
                                                                                    case ',': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.COMMA;
                                                                                        break block57;
                                                                                    }
                                                                                    case ';': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.SEMI;
                                                                                        break block58;
                                                                                    }
                                                                                    case '(': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.LPAREN;
                                                                                        break block59;
                                                                                    }
                                                                                    case ')': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.RPAREN;
                                                                                        break block60;
                                                                                    }
                                                                                    case '[': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.LBRACKET;
                                                                                        break block61;
                                                                                    }
                                                                                    case ']': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.RBRACKET;
                                                                                        break block62;
                                                                                    }
                                                                                    case '{': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.LBRACE;
                                                                                        break block63;
                                                                                    }
                                                                                    case '}': {
                                                                                        this.scanChar();
                                                                                        this.token = Tokens.RBRACE;
                                                                                        break block64;
                                                                                    }
                                                                                    case '/': {
                                                                                        this.scanChar();
                                                                                        if (this.ch == '/') {
                                                                                            do {
                                                                                                this.scanCommentChar();
                                                                                                if (this.ch == '\r' || this.ch == '\n') continue block20;
                                                                                            } while (this.bp < this.buflen);
                                                                                            break;
                                                                                        }
                                                                                        if (this.ch == '*') {
                                                                                            this.scanChar();
                                                                                            if (this.ch == '*') {
                                                                                                this.docComment = this.scanDocComment();
                                                                                            } else {
                                                                                                this.skipComment();
                                                                                            }
                                                                                            if (this.ch == '/') {
                                                                                                this.scanChar();
                                                                                                break;
                                                                                            }
                                                                                            this.lexError("unclosed.comment");
                                                                                            break block65;
                                                                                        }
                                                                                        if (this.ch == '=') {
                                                                                            this.name = this.names.slashequals;
                                                                                            this.token = Tokens.SLASHEQ;
                                                                                            this.scanChar();
                                                                                            break block66;
                                                                                        } else {
                                                                                            this.name = this.names.slash;
                                                                                            this.token = Tokens.SLASH;
                                                                                        }
                                                                                        break block66;
                                                                                    }
                                                                                    case '\'': {
                                                                                        this.scanChar();
                                                                                        if (this.ch == '\'') {
                                                                                            this.lexError("empty.char.lit");
                                                                                            break block67;
                                                                                        }
                                                                                        if (this.ch == '\r' || this.ch == '\n') {
                                                                                            this.lexError(this.pos, "illegal.line.end.in.char.lit");
                                                                                        }
                                                                                        this.scanLitChar();
                                                                                        if (this.ch == '\'') {
                                                                                            this.scanChar();
                                                                                            this.token = Tokens.CHARLITERAL;
                                                                                            break block67;
                                                                                        } else {
                                                                                            this.lexError(this.pos, "unclosed.char.lit");
                                                                                        }
                                                                                        break block67;
                                                                                    }
                                                                                    case '\"': {
                                                                                        this.scanChar();
                                                                                        while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.buflen) {
                                                                                            this.scanLitChar();
                                                                                        }
                                                                                        if (this.ch == '\"') {
                                                                                            this.token = Tokens.STRINGLITERAL;
                                                                                            this.scanChar();
                                                                                            break block68;
                                                                                        } else {
                                                                                            this.lexError(this.pos, "unclosed.str.lit");
                                                                                        }
                                                                                        break block68;
                                                                                    }
                                                                                    default: {
                                                                                        boolean isJavaIdentifierStart;
                                                                                        if (this.isSpecial(this.ch)) {
                                                                                            this.scanOperator();
                                                                                            break block69;
                                                                                        }
                                                                                        if (this.ch < '\u0080') {
                                                                                            isJavaIdentifierStart = false;
                                                                                        } else {
                                                                                            char high = this.scanSurrogates();
                                                                                            if (high != '\u0000') {
                                                                                                if (this.sp == this.sbuf.length) {
                                                                                                    this.putChar(high);
                                                                                                } else {
                                                                                                    this.sbuf[this.sp++] = high;
                                                                                                }
                                                                                                isJavaIdentifierStart = Character.isJavaIdentifierStart(Character.toCodePoint(high, this.ch));
                                                                                            } else {
                                                                                                isJavaIdentifierStart = Character.isJavaIdentifierStart(this.ch);
                                                                                            }
                                                                                        }
                                                                                        if (isJavaIdentifierStart) {
                                                                                            this.scanIdent();
                                                                                            break block69;
                                                                                        }
                                                                                        if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
                                                                                            this.token = Tokens.EOF;
                                                                                            break block69;
                                                                                        } else {
                                                                                            this.lexError("illegal.char", (Object)String.valueOf((int)this.ch));
                                                                                            this.scanChar();
                                                                                        }
                                                                                        break block69;
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                        catch (Throwable throwable) {
                                                                            Object var5_19 = null;
                                                                            this.endPos = (this.line << 10) + this.col - 1;
                                                                            throw throwable;
                                                                        }
                                                                    }
                                                                    Object var5_3 = null;
                                                                    this.endPos = (this.line << 10) + this.col - 1;
                                                                    return;
                                                                }
                                                                Object var5_4 = null;
                                                                this.endPos = (this.line << 10) + this.col - 1;
                                                                return;
                                                            }
                                                            Object var5_5 = null;
                                                            this.endPos = (this.line << 10) + this.col - 1;
                                                            return;
                                                        }
                                                        Object var5_6 = null;
                                                        this.endPos = (this.line << 10) + this.col - 1;
                                                        return;
                                                    }
                                                    Object var5_7 = null;
                                                    this.endPos = (this.line << 10) + this.col - 1;
                                                    return;
                                                }
                                                Object var5_8 = null;
                                                this.endPos = (this.line << 10) + this.col - 1;
                                                return;
                                            }
                                            Object var5_9 = null;
                                            this.endPos = (this.line << 10) + this.col - 1;
                                            return;
                                        }
                                        Object var5_10 = null;
                                        this.endPos = (this.line << 10) + this.col - 1;
                                        return;
                                    }
                                    Object var5_11 = null;
                                    this.endPos = (this.line << 10) + this.col - 1;
                                    return;
                                }
                                Object var5_12 = null;
                                this.endPos = (this.line << 10) + this.col - 1;
                                return;
                            }
                            Object var5_13 = null;
                            this.endPos = (this.line << 10) + this.col - 1;
                            return;
                        }
                        Object var5_14 = null;
                        this.endPos = (this.line << 10) + this.col - 1;
                        return;
                    }
                    Object var5_15 = null;
                    this.endPos = (this.line << 10) + this.col - 1;
                    return;
                }
                Object var5_16 = null;
                this.endPos = (this.line << 10) + this.col - 1;
                return;
            }
            Object var5_17 = null;
            this.endPos = (this.line << 10) + this.col - 1;
            return;
        }
        Object var5_18 = null;
        this.endPos = (this.line << 10) + this.col - 1;
    }

    public Tokens token() {
        return this.token;
    }

    public void token(Tokens token) {
        this.token = token;
    }

    public int pos() {
        return this.pos;
    }

    public int endPos() {
        return this.endPos;
    }

    public int prevEndPos() {
        return this.prevEndPos;
    }

    public int errPos() {
        return this.errPos;
    }

    public void errPos(int pos) {
        this.errPos = pos;
    }

    public Name name() {
        return this.name;
    }

    public int radix() {
        return this.radix;
    }

    public boolean deprecatedFlag() {
        return this.deprecatedFlag;
    }

    public void resetDeprecatedFlag() {
        this.deprecatedFlag = false;
    }

    public String docComment() {
        return this.docComment;
    }

    private static class ByteBufferCache {
        private ByteBuffer cached;
        protected static final Context.Key<ByteBufferCache> key = new Context.Key();

        ByteBuffer get(int capacity) {
            if (capacity < 20480) {
                capacity = 20480;
            }
            ByteBuffer result = this.cached != null && this.cached.capacity() >= capacity ? (ByteBuffer)this.cached.clear() : ByteBuffer.allocate(capacity + capacity >> 1);
            this.cached = null;
            return result;
        }

        void put(ByteBuffer x) {
            this.cached = x;
        }

        protected ByteBufferCache(Context context) {
            context.put(key, this);
        }

        static ByteBufferCache instance(Context context) {
            ByteBufferCache instance = context.get(key);
            if (instance == null) {
                instance = new ByteBufferCache(context);
            }
            return instance;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> scannerFactoryKey = new Context.Key();
        final Log log;
        final Name.Table names;
        final Source source;
        final Keywords keywords;
        final ByteBufferCache byteBufferCache;

        public static Factory instance(Context context) {
            Factory instance = context.get(scannerFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            context.put(scannerFactoryKey, this);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.source = Source.instance(context);
            this.keywords = Keywords.instance(context);
            this.byteBufferCache = ByteBufferCache.instance(context);
        }

        public Scanner newScanner(InputStream input, String encoding) throws IOException {
            return new Scanner(this, input, encoding);
        }

        public Scanner newScanner(CharBuffer buffer) {
            return new Scanner(this, buffer);
        }

        public Scanner newScanner(char[] input, int inputLength) {
            return new Scanner(this, input, inputLength);
        }
    }
}

