/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.tree;

import edu.rice.cs.nextgen2.compiler.code.BoundKind;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.tree.Tree;
import edu.rice.cs.nextgen2.compiler.tree.TreeInfo;
import edu.rice.cs.nextgen2.compiler.tree.TreeScanner;
import edu.rice.cs.nextgen2.compiler.util.Convert;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import java.io.PrintWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pretty
extends Tree.Visitor {
    private final boolean sourceOutput;
    PrintWriter out;
    public int width = 4;
    int lmargin = 0;
    Name enclClassName;
    Map<Tree, String> docComments = null;
    int prec;

    public Pretty(PrintWriter out, boolean sourceOutput) {
        this.out = out;
        this.sourceOutput = sourceOutput;
    }

    void align() {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.print(" ");
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(int contextPrec, int ownPrec) {
        if (ownPrec < contextPrec) {
            this.out.print("(");
        }
    }

    void close(int contextPrec, int ownPrec) {
        if (ownPrec < contextPrec) {
            this.out.print(")");
        }
    }

    public void print(Object s) {
        this.out.print(Convert.escapeUnicode(s.toString()));
    }

    public void println() {
        this.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printExpr(Tree tree, int prec) {
        int prevPrec = this.prec;
        try {
            this.prec = prec;
            if (tree == null) {
                this.print("/*missing*/");
            } else {
                tree.accept(this);
            }
            Object var5_4 = null;
            this.prec = prevPrec;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.prec = prevPrec;
            throw throwable;
        }
    }

    public void printExpr(Tree tree) {
        this.printExpr(tree, 0);
    }

    public void printStat(Tree tree) {
        this.printExpr(tree, -1);
    }

    public <T extends Tree> void printExprs(List<T> trees, String sep) {
        if (trees.nonEmpty()) {
            this.printExpr((Tree)trees.head);
            List l = trees.tail;
            while (l.nonEmpty()) {
                this.print(sep);
                this.printExpr((Tree)l.head);
                l = l.tail;
            }
        }
    }

    public <T extends Tree> void printExprs(List<T> trees) {
        this.printExprs(trees, ", ");
    }

    public <T extends Tree> void printStats(List<T> trees) {
        List<Object> l = trees;
        while (l.nonEmpty()) {
            this.align();
            this.printStat((Tree)l.head);
            this.println();
            l = l.tail;
        }
    }

    public void printFlags(long flags) {
        if ((flags & 0x1000L) != 0L) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(flags));
        if ((flags & 0xFFFL) != 0L) {
            this.print(" ");
        }
        if ((flags & 0x2000L) != 0L) {
            this.print("@");
        }
    }

    public void printAnnotations(List<Tree.Annotation> trees) {
        List<Tree.Annotation> l = trees;
        while (l.nonEmpty()) {
            this.printStat((Tree)l.head);
            this.println();
            this.align();
            l = l.tail;
        }
    }

    public void printDocComment(Tree tree) {
        String dc;
        if (this.docComments != null && (dc = this.docComments.get(tree)) != null) {
            this.print("/**");
            this.println();
            int pos = 0;
            int endpos = Pretty.lineEndPos(dc, pos);
            while (pos < dc.length()) {
                this.align();
                this.print(" *");
                if (pos < dc.length() && dc.charAt(pos) > ' ') {
                    this.print(" ");
                }
                this.print(dc.substring(pos, endpos));
                this.println();
                pos = endpos + 1;
                endpos = Pretty.lineEndPos(dc, pos);
            }
            this.align();
            this.print(" */");
            this.println();
            this.align();
        }
    }

    static int lineEndPos(String s, int start) {
        int pos = s.indexOf(10, start);
        if (pos < 0) {
            pos = s.length();
        }
        return pos;
    }

    public void printTypeParameters(List<Tree.TypeParameter> trees) {
        if (trees.nonEmpty()) {
            this.print("<");
            this.printExprs(trees);
            this.print(">");
        }
    }

    public void printBlock(List<Tree> stats) {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(stats);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printEnumBody(List<Tree> stats) {
        this.print("{");
        this.println();
        this.indent();
        boolean first = true;
        List<Tree> l = stats;
        while (l.nonEmpty()) {
            if (this.isEnumerator((Tree)l.head)) {
                if (!first) {
                    this.print(",");
                    this.println();
                }
                this.align();
                this.printStat((Tree)l.head);
                first = false;
            }
            l = l.tail;
        }
        this.print(";");
        this.println();
        l = stats;
        while (l.nonEmpty()) {
            if (!this.isEnumerator((Tree)l.head)) {
                this.align();
                this.printStat((Tree)l.head);
                this.println();
            }
            l = l.tail;
        }
        this.undent();
        this.align();
        this.print("}");
    }

    boolean isEnumerator(Tree t) {
        return t.tag == 6 && (((Tree.VarDef)t).mods.flags & 0x4000L) != 0L;
    }

    public void printUnit(Tree.TopLevel tree, Tree.ClassDef cdef) {
        this.docComments = tree.docComments;
        this.printDocComment(tree);
        if (tree.module != null) {
            this.print("module ");
            this.printExpr(tree.module);
            this.print(";");
            this.println();
        }
        if (tree.pid != null) {
            this.print("package ");
            this.printExpr(tree.pid);
            this.print(";");
            this.println();
        }
        boolean firstImport = true;
        List<Tree> l = tree.defs;
        while (l.nonEmpty() && (cdef == null || ((Tree)l.head).tag == 3)) {
            if (((Tree)l.head).tag == 3) {
                Tree.Import imp = (Tree.Import)l.head;
                Name name = TreeInfo.name(imp.qualid);
                if (name == name.table.asterisk || cdef == null || this.isUsed(TreeInfo.symbol(imp.qualid), cdef)) {
                    if (firstImport) {
                        firstImport = false;
                        this.println();
                    }
                    this.printStat(imp);
                }
            } else {
                this.printStat((Tree)l.head);
            }
            l = l.tail;
        }
        if (cdef != null) {
            this.printStat(cdef);
            this.println();
        }
    }

    boolean isUsed(final Symbol t, Tree cdef) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class UsedVisitor
        extends TreeScanner {
            boolean result = false;

            UsedVisitor() {
            }

            @Override
            public void scan(Tree tree) {
                if (tree != null && !this.result) {
                    tree.accept(this);
                }
            }

            @Override
            public void visitIdent(Tree.Ident tree) {
                if (tree.sym == t) {
                    this.result = true;
                }
            }
        }
        UsedVisitor v = new UsedVisitor();
        v.scan(cdef);
        return v.result;
    }

    @Override
    public void visitTopLevel(Tree.TopLevel tree) {
        this.printUnit(tree, null);
    }

    @Override
    public void visitModule(Tree.Module tree) {
        this.print("module ");
        this.printExpr(tree.id);
        this.printTypeParameters(tree.typarams);
        if (tree.implementing.nonEmpty()) {
            this.print(" implements ");
            this.printExprs(tree.implementing);
        }
        this.print(";");
        this.println();
    }

    @Override
    public void visitImport(Tree.Import tree) {
        this.print("import ");
        if (tree.staticImport) {
            this.print("static ");
        }
        this.printExpr(tree.qualid);
        this.print(";");
        this.println();
    }

    @Override
    public void visitAlias(Tree.Alias tree) {
        this.print("alias ");
        this.printExpr(tree.alias);
        this.printTypeParameters(tree.typarams);
        this.print(" = ");
        this.printExpr(tree.qualid);
        this.print(";");
        this.println();
    }

    @Override
    public void visitBind(Tree.Bind tree) {
        this.print("bind ");
        if (tree.isModule) {
            this.print("module ");
        } else {
            this.print("class ");
        }
        this.printExpr(tree.alias);
        this.printTypeParameters(tree.typarams);
        this.print(" = ");
        this.printExpr(tree.qualid);
        this.print(";");
        this.println();
    }

    @Override
    public void visitClassDef(Tree.ClassDef tree) {
        this.println();
        this.align();
        this.printDocComment(tree);
        this.printAnnotations(tree.mods.annotations);
        this.printFlags(tree.mods.flags & 0xFFFFFFFFFFFFFDFFL);
        Name enclClassNamePrev = this.enclClassName;
        this.enclClassName = tree.name;
        if ((tree.mods.flags & 0x8000L) != 0L) {
            this.print("signature " + tree.name);
            this.printTypeParameters(tree.typarams);
            if (tree.implementing.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(tree.implementing);
            }
        } else if ((tree.mods.flags & 0x200L) != 0L) {
            this.print("interface " + tree.name);
            this.printTypeParameters(tree.typarams);
            if (tree.implementing.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(tree.implementing);
            }
        } else {
            if ((tree.mods.flags & 0x4000L) != 0L) {
                this.print("enum " + tree.name);
            } else {
                this.print("class " + tree.name);
            }
            this.printTypeParameters(tree.typarams);
            if (tree.extending != null) {
                this.print(" extends ");
                this.printExpr(tree.extending);
            }
            if (tree.implementing.nonEmpty()) {
                this.print(" implements ");
                this.printExprs(tree.implementing);
            }
        }
        this.print(" ");
        if ((tree.mods.flags & 0x4000L) != 0L) {
            this.printEnumBody(tree.defs);
        } else {
            this.printBlock(tree.defs);
        }
        this.enclClassName = enclClassNamePrev;
    }

    @Override
    public void visitMethodDef(Tree.MethodDef tree) {
        if (tree.name == tree.name.table.init && this.enclClassName == null && this.sourceOutput) {
            return;
        }
        this.println();
        this.align();
        this.printDocComment(tree);
        this.printExpr(tree.mods);
        this.printTypeParameters(tree.typarams);
        if (tree.name == tree.name.table.init) {
            this.print(this.enclClassName != null ? this.enclClassName : tree.name);
        } else {
            this.printExpr(tree.restype);
            this.print(" " + tree.name);
        }
        this.print("(");
        this.printExprs(tree.params);
        this.print(")");
        if (tree.thrown.nonEmpty()) {
            this.print(" throws ");
            this.printExprs(tree.thrown);
        }
        if (tree.body != null) {
            this.print(" ");
            this.printStat(tree.body);
        } else {
            this.print(";");
        }
    }

    @Override
    public void visitVarDef(Tree.VarDef tree) {
        if (this.docComments != null && this.docComments.get(tree) != null) {
            this.println();
            this.align();
        }
        this.printDocComment(tree);
        if ((tree.mods.flags & 0x4000L) != 0L) {
            this.print("/*public static final*/ ");
            this.print(tree.name);
            if (tree.init != null) {
                this.print(" /* = ");
                this.printExpr(tree.init);
                this.print(" */");
            }
        } else {
            this.printExpr(tree.mods);
            if ((tree.mods.flags & 0x400000000L) != 0L) {
                this.printExpr(((Tree.TypeArray)tree.vartype).elemtype);
                this.print("... " + tree.name);
            } else {
                this.printExpr(tree.vartype);
                this.print(" " + tree.name);
            }
            if (tree.init != null) {
                this.print(" = ");
                this.printExpr(tree.init);
            }
            if (this.prec == -1) {
                this.print(";");
            }
        }
    }

    @Override
    public void visitSkip(Tree.Skip tree) {
        this.print(";");
    }

    @Override
    public void visitBlock(Tree.Block tree) {
        this.printFlags(tree.flags);
        this.printBlock(tree.stats);
    }

    @Override
    public void visitDoLoop(Tree.DoLoop tree) {
        this.print("do ");
        this.printStat(tree.body);
        this.align();
        this.print(" while ");
        if (tree.cond.tag == 30) {
            this.printExpr(tree.cond);
        } else {
            this.print("(");
            this.printExpr(tree.cond);
            this.print(")");
        }
        this.print(";");
    }

    @Override
    public void visitWhileLoop(Tree.WhileLoop tree) {
        this.print("while ");
        if (tree.cond.tag == 30) {
            this.printExpr(tree.cond);
        } else {
            this.print("(");
            this.printExpr(tree.cond);
            this.print(")");
        }
        this.print(" ");
        this.printStat(tree.body);
    }

    @Override
    public void visitForLoop(Tree.ForLoop tree) {
        this.print("for (");
        if (tree.init.nonEmpty()) {
            if (((Tree)tree.init.head).tag == 6) {
                this.printExpr((Tree)tree.init.head);
                List l = tree.init.tail;
                while (l.nonEmpty()) {
                    Tree.VarDef vdef = (Tree.VarDef)l.head;
                    this.print(", " + vdef.name + " = ");
                    this.printExpr(vdef.init);
                    l = l.tail;
                }
            } else {
                this.printExprs(tree.init);
            }
        }
        this.print("; ");
        if (tree.cond != null) {
            this.printExpr(tree.cond);
        }
        this.print("; ");
        this.printExprs(tree.step);
        this.print(") ");
        this.printStat(tree.body);
    }

    @Override
    public void visitForeachLoop(Tree.ForeachLoop tree) {
        this.print("for (");
        this.printExpr(tree.var);
        this.print(" : ");
        this.printExpr(tree.expr);
        this.print(") ");
        this.printStat(tree.body);
    }

    @Override
    public void visitLabelled(Tree.Labelled tree) {
        this.print(tree.label + ": ");
        this.printStat(tree.body);
    }

    @Override
    public void visitSwitch(Tree.Switch tree) {
        this.print("switch ");
        if (tree.selector.tag == 30) {
            this.printExpr(tree.selector);
        } else {
            this.print("(");
            this.printExpr(tree.selector);
            this.print(")");
        }
        this.print(" {");
        this.println();
        this.printStats(tree.cases);
        this.align();
        this.print("}");
    }

    @Override
    public void visitCase(Tree.Case tree) {
        if (tree.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printExpr(tree.pat);
        }
        this.print(": ");
        this.println();
        this.indent();
        this.printStats(tree.stats);
        this.undent();
        this.align();
    }

    @Override
    public void visitSynchronized(Tree.Synchronized tree) {
        this.print("synchronized ");
        if (tree.lock.tag == 30) {
            this.printExpr(tree.lock);
        } else {
            this.print("(");
            this.printExpr(tree.lock);
            this.print(")");
        }
        this.print(" ");
        this.printStat(tree.body);
    }

    @Override
    public void visitTry(Tree.Try tree) {
        this.print("try ");
        this.printStat(tree.body);
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            this.printStat((Tree)l.head);
            l = l.tail;
        }
        if (tree.finalizer != null) {
            this.print(" finally ");
            this.printStat(tree.finalizer);
        }
    }

    @Override
    public void visitCatch(Tree.Catch tree) {
        this.print(" catch (");
        this.printExpr(tree.param);
        this.print(") ");
        this.printStat(tree.body);
    }

    @Override
    public void visitConditional(Tree.Conditional tree) {
        this.open(this.prec, 3);
        this.printExpr(tree.cond, 3);
        this.print(" ? ");
        this.printExpr(tree.truepart, 3);
        this.print(" : ");
        this.printExpr(tree.falsepart, 3);
        this.close(this.prec, 3);
    }

    @Override
    public void visitIf(Tree.If tree) {
        this.print("if ");
        if (tree.cond.tag == 30) {
            this.printExpr(tree.cond);
        } else {
            this.print("(");
            this.printExpr(tree.cond);
            this.print(")");
        }
        this.print(" ");
        this.printStat(tree.thenpart);
        if (tree.elsepart != null) {
            this.print(" else ");
            this.printStat(tree.elsepart);
        }
    }

    @Override
    public void visitExec(Tree.Exec tree) {
        this.printExpr(tree.expr);
        if (this.prec == -1) {
            this.print(";");
        }
    }

    @Override
    public void visitBreak(Tree.Break tree) {
        this.print("break");
        if (tree.label != null) {
            this.print(" " + tree.label);
        }
        this.print(";");
    }

    @Override
    public void visitContinue(Tree.Continue tree) {
        this.print("continue");
        if (tree.label != null) {
            this.print(" " + tree.label);
        }
        this.print(";");
    }

    @Override
    public void visitReturn(Tree.Return tree) {
        this.print("return");
        if (tree.expr != null) {
            this.print(" ");
            this.printExpr(tree.expr);
        }
        this.print(";");
    }

    @Override
    public void visitThrow(Tree.Throw tree) {
        this.print("throw ");
        this.printExpr(tree.expr);
        this.print(";");
    }

    @Override
    public void visitAssert(Tree.Assert tree) {
        this.print("assert ");
        this.printExpr(tree.cond);
        if (tree.detail != null) {
            this.print(" : ");
            this.printExpr(tree.detail);
        }
        this.print(";");
    }

    @Override
    public void visitApply(Tree.Apply tree) {
        if (tree.typeargs != null) {
            if (tree.meth.tag == 35) {
                Tree.Select left = (Tree.Select)tree.meth;
                this.printExpr(left.selected);
                this.print(".<");
                this.printExprs(tree.typeargs);
                this.print(">" + left.name);
            } else {
                this.print("<");
                this.printExprs(tree.typeargs);
                this.print(">");
                this.printExpr(tree.meth);
            }
        } else {
            this.printExpr(tree.meth);
        }
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
    }

    @Override
    public void visitNewClass(Tree.NewClass tree) {
        if (tree.encl != null) {
            this.printExpr(tree.encl);
            this.print(".");
        }
        this.print("new ");
        if (tree.typeargs != null) {
            this.print("<");
            this.printExprs(tree.typeargs);
            this.print(">");
        }
        this.printExpr(tree.clazz);
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
        if (tree.def != null) {
            Name enclClassNamePrev = this.enclClassName;
            Name name = tree.def.name != null ? tree.def.name : (this.enclClassName = tree.type != null && tree.type.tsym.name != tree.type.tsym.name.table.empty ? tree.type.tsym.name : null);
            if ((tree.def.mods.flags & 0x4000L) != 0L) {
                this.print("/*enum*/");
            }
            this.printBlock(tree.def.defs);
            this.enclClassName = enclClassNamePrev;
        }
    }

    @Override
    public void visitNewArray(Tree.NewArray tree) {
        if (tree.elemtype != null) {
            this.print("new ");
            Tree elem = tree.elemtype;
            if (elem instanceof Tree.TypeArray) {
                this.printBaseElementType((Tree.TypeArray)elem);
            } else {
                this.printExpr(elem);
            }
            List<Tree> l = tree.dims;
            while (l.nonEmpty()) {
                this.print("[");
                this.printExpr((Tree)l.head);
                this.print("]");
                l = l.tail;
            }
            if (elem instanceof Tree.TypeArray) {
                this.printBrackets((Tree.TypeArray)elem);
            }
        }
        if (tree.elems != null) {
            if (tree.elemtype != null) {
                this.print("[]");
            }
            this.print("{");
            this.printExprs(tree.elems);
            this.print("}");
        }
    }

    @Override
    public void visitParens(Tree.Parens tree) {
        this.print("(");
        this.printExpr(tree.expr);
        this.print(")");
    }

    @Override
    public void visitAssign(Tree.Assign tree) {
        this.open(this.prec, 1);
        this.printExpr(tree.lhs, 2);
        this.print(" = ");
        this.printExpr(tree.rhs, 1);
        this.close(this.prec, 1);
    }

    public String operatorName(int tag) {
        switch (tag) {
            case 47: {
                return "+";
            }
            case 48: {
                return "-";
            }
            case 49: {
                return "!";
            }
            case 50: {
                return "~";
            }
            case 51: {
                return "++";
            }
            case 52: {
                return "--";
            }
            case 53: {
                return "++";
            }
            case 54: {
                return "--";
            }
            case 55: {
                return "<*nullchk*>";
            }
            case 56: {
                return "||";
            }
            case 57: {
                return "&&";
            }
            case 61: {
                return "==";
            }
            case 62: {
                return "!=";
            }
            case 63: {
                return "<";
            }
            case 64: {
                return ">";
            }
            case 65: {
                return "<=";
            }
            case 66: {
                return ">=";
            }
            case 58: {
                return "|";
            }
            case 59: {
                return "^";
            }
            case 60: {
                return "&";
            }
            case 67: {
                return "<<";
            }
            case 68: {
                return ">>";
            }
            case 69: {
                return ">>>";
            }
            case 70: {
                return "+";
            }
            case 71: {
                return "-";
            }
            case 72: {
                return "*";
            }
            case 73: {
                return "/";
            }
            case 74: {
                return "%";
            }
        }
        throw new Error();
    }

    @Override
    public void visitAssignop(Tree.Assignop tree) {
        this.open(this.prec, 2);
        this.printExpr(tree.lhs, 3);
        this.print(" " + this.operatorName(tree.tag - 17) + "= ");
        this.printExpr(tree.rhs, 2);
        this.close(this.prec, 2);
    }

    @Override
    public void visitUnary(Tree.Unary tree) {
        int ownprec = TreeInfo.opPrec(tree.tag);
        String opname = this.operatorName(tree.tag).toString();
        this.open(this.prec, ownprec);
        if (tree.tag <= 52) {
            this.print(opname);
            this.printExpr(tree.arg, ownprec);
        } else {
            this.printExpr(tree.arg, ownprec);
            this.print(opname);
        }
        this.close(this.prec, ownprec);
    }

    @Override
    public void visitBinary(Tree.Binary tree) {
        int ownprec = TreeInfo.opPrec(tree.tag);
        String opname = this.operatorName(tree.tag).toString();
        this.open(this.prec, ownprec);
        this.printExpr(tree.lhs, ownprec);
        this.print(" " + opname + " ");
        this.printExpr(tree.rhs, ownprec + 1);
        this.close(this.prec, ownprec);
    }

    @Override
    public void visitTypeCast(Tree.TypeCast tree) {
        this.open(this.prec, 14);
        this.print("(");
        this.printExpr(tree.clazz);
        this.print(")");
        this.printExpr(tree.expr, 14);
        this.close(this.prec, 14);
    }

    @Override
    public void visitTypeTest(Tree.TypeTest tree) {
        this.open(this.prec, 10);
        this.printExpr(tree.expr, 10);
        this.print(" instanceof ");
        this.printExpr(tree.clazz, 11);
        this.close(this.prec, 10);
    }

    @Override
    public void visitIndexed(Tree.Indexed tree) {
        this.printExpr(tree.indexed, 15);
        this.print("[");
        this.printExpr(tree.index);
        this.print("]");
    }

    @Override
    public void visitSelect(Tree.Select tree) {
        this.printExpr(tree.selected, 15);
        this.print("." + tree.name);
    }

    @Override
    public void visitIdent(Tree.Ident tree) {
        this.print(tree.name);
    }

    @Override
    public void visitLiteral(Tree.Literal tree) {
        switch (tree.typetag) {
            case 4: {
                this.print(tree.value.toString());
                break;
            }
            case 5: {
                this.print(tree.value + "L");
                break;
            }
            case 6: {
                this.print(tree.value + "F");
                break;
            }
            case 7: {
                this.print(tree.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote(String.valueOf((char)((Number)tree.value).intValue())) + "'");
                break;
            }
            default: {
                this.print("\"" + Convert.quote(tree.value.toString()) + "\"");
            }
        }
    }

    @Override
    public void visitTypeIdent(Tree.TypeIdent tree) {
        switch (tree.typetag) {
            case 1: {
                this.print("byte");
                break;
            }
            case 2: {
                this.print("char");
                break;
            }
            case 3: {
                this.print("short");
                break;
            }
            case 4: {
                this.print("int");
                break;
            }
            case 5: {
                this.print("long");
                break;
            }
            case 6: {
                this.print("float");
                break;
            }
            case 7: {
                this.print("double");
                break;
            }
            case 8: {
                this.print("boolean");
                break;
            }
            case 9: {
                this.print("void");
                break;
            }
            default: {
                this.print("error");
            }
        }
    }

    @Override
    public void visitTypeArray(Tree.TypeArray tree) {
        this.printBaseElementType(tree);
        this.printBrackets(tree);
    }

    private void printBaseElementType(Tree.TypeArray tree) {
        Tree elem = tree.elemtype;
        while (elem instanceof Tree.TypeArgument) {
            elem = ((Tree.TypeArgument)elem).inner;
        }
        if (elem instanceof Tree.TypeArray) {
            this.printBaseElementType((Tree.TypeArray)elem);
        } else {
            this.printExpr(elem);
        }
    }

    private void printBrackets(Tree.TypeArray tree) {
        while (true) {
            Tree elem = tree.elemtype;
            this.print("[]");
            if (!(elem instanceof Tree.TypeArray)) break;
            tree = (Tree.TypeArray)elem;
        }
    }

    @Override
    public void visitTypeApply(Tree.TypeApply tree) {
        this.printExpr(tree.clazz);
        this.print("<");
        this.printExprs(tree.arguments);
        this.print(">");
    }

    @Override
    public void visitTypeParameter(Tree.TypeParameter tree) {
        this.print(tree.name);
        if (tree.bounds.nonEmpty()) {
            this.print(" extends ");
            this.printExprs(tree.bounds, " & ");
        }
    }

    @Override
    public void visitTypeArgument(Tree.TypeArgument tree) {
        this.print("" + (Object)((Object)tree.kind));
        if (tree.kind != BoundKind.UNBOUND) {
            this.printExpr(tree.inner);
        }
    }

    @Override
    public void visitErroneous(Tree.Erroneous tree) {
        this.print("(ERROR)");
    }

    @Override
    public void visitLetExpr(Tree.LetExpr tree) {
        this.print("(let " + tree.defs + " in " + tree.expr + ")");
    }

    @Override
    public void visitModifiers(Tree.Modifiers mods) {
        this.printAnnotations(mods.annotations);
        this.printFlags(mods.flags);
    }

    @Override
    public void visitAnnotation(Tree.Annotation tree) {
        this.print("@");
        this.printExpr(tree.annotationType);
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
    }

    @Override
    public void visitTree(Tree tree) {
        this.print("(UNKNOWN: " + tree + ")");
        this.println();
    }
}

