/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.tree;

import edu.rice.cs.nextgen2.compiler.code.BoundKind;
import edu.rice.cs.nextgen2.compiler.code.Scope;
import edu.rice.cs.nextgen2.compiler.code.Symbol;
import edu.rice.cs.nextgen2.compiler.code.Type;
import edu.rice.cs.nextgen2.compiler.tree.Pretty;
import edu.rice.cs.nextgen2.compiler.util.List;
import edu.rice.cs.nextgen2.compiler.util.Name;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public abstract class Tree {
    public static final int TOPLEVEL = 1;
    public static final int MODULE = 2;
    public static final int IMPORT = 3;
    public static final int ALIAS = 4;
    public static final int BIND = 5;
    public static final int CLASSDEF = 4;
    public static final int METHODDEF = 5;
    public static final int VARDEF = 6;
    public static final int SKIP = 7;
    public static final int BLOCK = 8;
    public static final int DOLOOP = 9;
    public static final int WHILELOOP = 10;
    public static final int FORLOOP = 11;
    public static final int FOREACHLOOP = 12;
    public static final int LABELLED = 13;
    public static final int SWITCH = 14;
    public static final int CASE = 15;
    public static final int SYNCHRONIZED = 16;
    public static final int TRY = 17;
    public static final int CATCH = 18;
    public static final int CONDEXPR = 19;
    public static final int IF = 20;
    public static final int EXEC = 21;
    public static final int BREAK = 22;
    public static final int CONTINUE = 23;
    public static final int RETURN = 24;
    public static final int THROW = 25;
    public static final int ASSERT = 26;
    public static final int APPLY = 27;
    public static final int NEWCLASS = 28;
    public static final int NEWARRAY = 29;
    public static final int PARENS = 30;
    public static final int ASSIGN = 31;
    public static final int TYPECAST = 32;
    public static final int TYPETEST = 33;
    public static final int INDEXED = 34;
    public static final int SELECT = 35;
    public static final int IDENT = 36;
    public static final int LITERAL = 37;
    public static final int TYPEIDENT = 38;
    public static final int TYPEARRAY = 39;
    public static final int TYPEAPPLY = 40;
    public static final int TYPEPARAMETER = 41;
    public static final int TYPEARGUMENT = 42;
    public static final int TYPEBOUNDKIND = 43;
    public static final int ANNOTATION = 44;
    public static final int MODIFIERS = 45;
    public static final int ERRONEOUS = 46;
    public static final int POS = 47;
    public static final int NEG = 48;
    public static final int NOT = 49;
    public static final int COMPL = 50;
    public static final int PREINC = 51;
    public static final int PREDEC = 52;
    public static final int POSTINC = 53;
    public static final int POSTDEC = 54;
    public static final int NULLCHK = 55;
    public static final int OR = 56;
    public static final int AND = 57;
    public static final int BITOR = 58;
    public static final int BITXOR = 59;
    public static final int BITAND = 60;
    public static final int EQ = 61;
    public static final int NE = 62;
    public static final int LT = 63;
    public static final int GT = 64;
    public static final int LE = 65;
    public static final int GE = 66;
    public static final int SL = 67;
    public static final int SR = 68;
    public static final int USR = 69;
    public static final int PLUS = 70;
    public static final int MINUS = 71;
    public static final int MUL = 72;
    public static final int DIV = 73;
    public static final int MOD = 74;
    public static final int BITOR_ASG = 75;
    public static final int BITXOR_ASG = 76;
    public static final int BITAND_ASG = 77;
    public static final int SL_ASG = 84;
    public static final int SR_ASG = 85;
    public static final int USR_ASG = 86;
    public static final int PLUS_ASG = 87;
    public static final int MINUS_ASG = 88;
    public static final int MUL_ASG = 89;
    public static final int DIV_ASG = 90;
    public static final int MOD_ASG = 91;
    public static final int LETEXPR = 92;
    public static final int ASGOffset = 17;
    public int pos;
    public Type type;
    public int tag;
    public static final List<Tree> emptyList = new List();

    public Tree(int tag) {
        this.tag = tag;
    }

    public String toString() {
        StringWriter s = new StringWriter();
        new Pretty(new PrintWriter(s), false).printExpr(this);
        return s.toString();
    }

    public Tree setPos(int pos) {
        this.pos = pos;
        return this;
    }

    public Tree setType(Type type) {
        this.type = type;
        return this;
    }

    public abstract void accept(Visitor var1);

    public static abstract class Visitor {
        public void visitTopLevel(TopLevel that) {
            this.visitTree(that);
        }

        public void visitModule(Module that) {
            this.visitTree(that);
        }

        public void visitImport(Import that) {
            this.visitTree(that);
        }

        public void visitAlias(Alias that) {
            this.visitTree(that);
        }

        public void visitBind(Bind that) {
            this.visitTree(that);
        }

        public void visitClassDef(ClassDef that) {
            this.visitTree(that);
        }

        public void visitMethodDef(MethodDef that) {
            this.visitTree(that);
        }

        public void visitVarDef(VarDef that) {
            this.visitTree(that);
        }

        public void visitSkip(Skip that) {
            this.visitTree(that);
        }

        public void visitBlock(Block that) {
            this.visitTree(that);
        }

        public void visitDoLoop(DoLoop that) {
            this.visitTree(that);
        }

        public void visitWhileLoop(WhileLoop that) {
            this.visitTree(that);
        }

        public void visitForLoop(ForLoop that) {
            this.visitTree(that);
        }

        public void visitForeachLoop(ForeachLoop that) {
            this.visitTree(that);
        }

        public void visitLabelled(Labelled that) {
            this.visitTree(that);
        }

        public void visitSwitch(Switch that) {
            this.visitTree(that);
        }

        public void visitCase(Case that) {
            this.visitTree(that);
        }

        public void visitSynchronized(Synchronized that) {
            this.visitTree(that);
        }

        public void visitTry(Try that) {
            this.visitTree(that);
        }

        public void visitCatch(Catch that) {
            this.visitTree(that);
        }

        public void visitConditional(Conditional that) {
            this.visitTree(that);
        }

        public void visitIf(If that) {
            this.visitTree(that);
        }

        public void visitExec(Exec that) {
            this.visitTree(that);
        }

        public void visitBreak(Break that) {
            this.visitTree(that);
        }

        public void visitContinue(Continue that) {
            this.visitTree(that);
        }

        public void visitReturn(Return that) {
            this.visitTree(that);
        }

        public void visitThrow(Throw that) {
            this.visitTree(that);
        }

        public void visitAssert(Assert that) {
            this.visitTree(that);
        }

        public void visitApply(Apply that) {
            this.visitTree(that);
        }

        public void visitNewClass(NewClass that) {
            this.visitTree(that);
        }

        public void visitNewArray(NewArray that) {
            this.visitTree(that);
        }

        public void visitParens(Parens that) {
            this.visitTree(that);
        }

        public void visitAssign(Assign that) {
            this.visitTree(that);
        }

        public void visitAssignop(Assignop that) {
            this.visitTree(that);
        }

        public void visitUnary(Unary that) {
            this.visitTree(that);
        }

        public void visitBinary(Binary that) {
            this.visitTree(that);
        }

        public void visitTypeCast(TypeCast that) {
            this.visitTree(that);
        }

        public void visitTypeTest(TypeTest that) {
            this.visitTree(that);
        }

        public void visitIndexed(Indexed that) {
            this.visitTree(that);
        }

        public void visitSelect(Select that) {
            this.visitTree(that);
        }

        public void visitIdent(Ident that) {
            this.visitTree(that);
        }

        public void visitLiteral(Literal that) {
            this.visitTree(that);
        }

        public void visitTypeIdent(TypeIdent that) {
            this.visitTree(that);
        }

        public void visitTypeArray(TypeArray that) {
            this.visitTree(that);
        }

        public void visitTypeApply(TypeApply that) {
            this.visitTree(that);
        }

        public void visitTypeParameter(TypeParameter that) {
            this.visitTree(that);
        }

        public void visitTypeArgument(TypeArgument that) {
            this.visitTree(that);
        }

        public void visitAnnotation(Annotation that) {
            this.visitTree(that);
        }

        public void visitModifiers(Modifiers that) {
            this.visitTree(that);
        }

        public void visitErroneous(Erroneous that) {
            this.visitTree(that);
        }

        public void visitLetExpr(LetExpr that) {
            this.visitTree(that);
        }

        public void visitTree(Tree that) {
            assert (false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public TopLevel TopLevel(Module var1, List<Annotation> var2, Tree var3, List<Tree> var4);

        public Import Import(Tree var1, boolean var2);

        public ClassDef ClassDef(Modifiers var1, Name var2, List<TypeParameter> var3, Tree var4, List<Tree> var5, List<Tree> var6);

        public MethodDef MethodDef(Modifiers var1, Name var2, Tree var3, List<TypeParameter> var4, List<VarDef> var5, List<Tree> var6, Block var7, Tree var8);

        public VarDef VarDef(Modifiers var1, Name var2, Tree var3, Tree var4);

        public Skip Skip();

        public Block Block(long var1, List<Tree> var3);

        public DoLoop DoLoop(Tree var1, Tree var2);

        public WhileLoop WhileLoop(Tree var1, Tree var2);

        public ForLoop ForLoop(List<Tree> var1, Tree var2, List<Tree> var3, Tree var4);

        public ForeachLoop ForeachLoop(VarDef var1, Tree var2, Tree var3);

        public Labelled Labelled(Name var1, Tree var2);

        public Switch Switch(Tree var1, List<Case> var2);

        public Case Case(Tree var1, List<Tree> var2);

        public Synchronized Synchronized(Tree var1, Tree var2);

        public Try Try(Tree var1, List<Catch> var2, Tree var3);

        public Catch Catch(VarDef var1, Tree var2);

        public Conditional Conditional(Tree var1, Tree var2, Tree var3);

        public If If(Tree var1, Tree var2, Tree var3);

        public Exec Exec(Tree var1);

        public Break Break(Name var1);

        public Continue Continue(Name var1);

        public Return Return(Tree var1);

        public Throw Throw(Tree var1);

        public Apply Apply(List<Tree> var1, Tree var2, List<Tree> var3);

        public NewClass NewClass(Tree var1, List<Tree> var2, Tree var3, List<Tree> var4, ClassDef var5);

        public NewArray NewArray(Tree var1, List<Tree> var2, List<Tree> var3);

        public Parens Parens(Tree var1);

        public Assign Assign(Tree var1, Tree var2);

        public Assignop Assignop(int var1, Tree var2, Tree var3);

        public Unary Unary(int var1, Tree var2);

        public Binary Binary(int var1, Tree var2, Tree var3);

        public TypeCast TypeCast(Tree var1, Tree var2);

        public TypeTest TypeTest(Tree var1, Tree var2);

        public Indexed Indexed(Tree var1, Tree var2);

        public Select Select(Tree var1, Name var2);

        public Ident Ident(Name var1);

        public Literal Literal(int var1, Object var2);

        public TypeIdent TypeIdent(int var1);

        public TypeArray TypeArray(Tree var1);

        public TypeApply TypeApply(Tree var1, List<Tree> var2);

        public TypeParameter TypeParameter(Name var1, List<Tree> var2);

        public TypeArgument TypeArgument(TypeBoundKind var1, Tree var2);

        public TypeBoundKind TypeBoundKind(BoundKind var1);

        public Annotation Annotation(Tree var1, List<Tree> var2);

        public Modifiers Modifiers(long var1, List<Annotation> var3);

        public Erroneous Erroneous();

        public LetExpr LetExpr(List<VarDef> var1, Tree var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LetExpr
    extends Tree {
        public List<VarDef> defs;
        public Tree expr;

        public LetExpr(List<VarDef> defs, Tree expr) {
            super(92);
            this.defs = defs;
            this.expr = expr;
        }

        @Override
        public void accept(Visitor v) {
            v.visitLetExpr(this);
        }
    }

    public static class Erroneous
    extends Tree {
        public Erroneous() {
            super(46);
        }

        public void accept(Visitor v) {
            v.visitErroneous(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Modifiers
    extends Tree {
        public long flags;
        public List<Annotation> annotations;

        public Modifiers(long flags, List<Annotation> annotations) {
            super(45);
            this.flags = flags;
            this.annotations = annotations;
        }

        @Override
        public void accept(Visitor v) {
            v.visitModifiers(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Annotation
    extends Tree {
        public static final List<Annotation> emptyList = new List();
        public Tree annotationType;
        public List<Tree> args;

        public Annotation(Tree annotationType, List<Tree> args) {
            super(44);
            this.annotationType = annotationType;
            this.args = args;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAnnotation(this);
        }
    }

    public static class TypeBoundKind
    extends Tree {
        public BoundKind kind;

        public TypeBoundKind(BoundKind kind) {
            super(43);
            this.kind = kind;
        }

        public void accept(Visitor v) {
            v.visitTree(this);
        }
    }

    public static class TypeArgument
    extends Tree {
        public BoundKind kind;
        public Tree inner;

        public TypeArgument(TypeBoundKind kind, Tree inner) {
            super(42);
            this.kind = kind.kind;
            this.inner = inner;
        }

        public void accept(Visitor v) {
            v.visitTypeArgument(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeParameter
    extends Tree {
        public Name name;
        public List<Tree> bounds;
        public static final List<TypeParameter> emptyList = new List();

        public TypeParameter(Name name, List<Tree> bounds) {
            super(41);
            this.name = name;
            this.bounds = bounds;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeParameter(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeApply
    extends Tree {
        public Tree clazz;
        public List<Tree> arguments;

        public TypeApply(Tree clazz, List<Tree> arguments) {
            super(40);
            this.clazz = clazz;
            this.arguments = arguments;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTypeApply(this);
        }
    }

    public static class TypeArray
    extends Tree {
        public Tree elemtype;

        public TypeArray(Tree elemtype) {
            super(39);
            this.elemtype = elemtype;
        }

        public void accept(Visitor v) {
            v.visitTypeArray(this);
        }
    }

    public static class TypeIdent
    extends Tree {
        public int typetag;

        public TypeIdent(int typetag) {
            super(38);
            this.typetag = typetag;
        }

        public void accept(Visitor v) {
            v.visitTypeIdent(this);
        }
    }

    public static class Literal
    extends Tree {
        public int typetag;
        public Object value;

        public Literal(int typetag, Object value) {
            super(37);
            this.typetag = typetag;
            this.value = value;
        }

        public void accept(Visitor v) {
            v.visitLiteral(this);
        }
    }

    public static class Ident
    extends Tree {
        public Name name;
        public Symbol sym;

        public Ident(Name name, Symbol sym) {
            super(36);
            this.name = name;
            this.sym = sym;
        }

        public void accept(Visitor v) {
            v.visitIdent(this);
        }
    }

    public static class Select
    extends Tree {
        public Tree selected;
        public Name name;
        public Symbol sym;

        public Select(Tree selected, Name name, Symbol sym) {
            super(35);
            this.selected = selected;
            this.name = name;
            this.sym = sym;
        }

        public void accept(Visitor v) {
            v.visitSelect(this);
        }
    }

    public static class Indexed
    extends Tree {
        public Tree indexed;
        public Tree index;

        public Indexed(Tree indexed, Tree index) {
            super(34);
            this.indexed = indexed;
            this.index = index;
        }

        public void accept(Visitor v) {
            v.visitIndexed(this);
        }
    }

    public static class TypeTest
    extends Tree {
        public Tree expr;
        public Tree clazz;

        public TypeTest(Tree expr, Tree clazz) {
            super(33);
            this.expr = expr;
            this.clazz = clazz;
        }

        public void accept(Visitor v) {
            v.visitTypeTest(this);
        }
    }

    public static class TypeCast
    extends Tree {
        public Tree clazz;
        public Tree expr;

        public TypeCast(Tree clazz, Tree expr) {
            super(32);
            this.clazz = clazz;
            this.expr = expr;
        }

        public void accept(Visitor v) {
            v.visitTypeCast(this);
        }
    }

    public static class Binary
    extends Tree {
        public Tree lhs;
        public Tree rhs;
        public Symbol operator;

        public Binary(int opcode, Tree lhs, Tree rhs, Symbol operator) {
            super(opcode);
            this.lhs = lhs;
            this.rhs = rhs;
            this.operator = operator;
        }

        public void accept(Visitor v) {
            v.visitBinary(this);
        }
    }

    public static class Unary
    extends Tree {
        public Tree arg;
        public Symbol operator;

        public Unary(int opcode, Tree arg) {
            super(opcode);
            this.arg = arg;
        }

        public void accept(Visitor v) {
            v.visitUnary(this);
        }
    }

    public static class Assignop
    extends Tree {
        public Tree lhs;
        public Tree rhs;
        public Symbol operator;

        public Assignop(int opcode, Tree lhs, Tree rhs, Symbol operator) {
            super(opcode);
            this.lhs = lhs;
            this.rhs = rhs;
            this.operator = operator;
        }

        public void accept(Visitor v) {
            v.visitAssignop(this);
        }
    }

    public static class Assign
    extends Tree {
        public Tree lhs;
        public Tree rhs;

        public Assign(Tree lhs, Tree rhs) {
            super(31);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public void accept(Visitor v) {
            v.visitAssign(this);
        }
    }

    public static class Parens
    extends Tree {
        public Tree expr;

        public Parens(Tree expr) {
            super(30);
            this.expr = expr;
        }

        public void accept(Visitor v) {
            v.visitParens(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewArray
    extends Tree {
        public Tree elemtype;
        public List<Tree> dims;
        public List<Tree> elems;

        public NewArray(Tree elemtype, List<Tree> dims, List<Tree> elems) {
            super(29);
            this.elemtype = elemtype;
            this.dims = dims;
            this.elems = elems;
        }

        @Override
        public void accept(Visitor v) {
            v.visitNewArray(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewClass
    extends Tree {
        public Tree encl;
        public List<Tree> typeargs;
        public Tree clazz;
        public List<Tree> args;
        public ClassDef def;
        public Symbol constructor;
        public Type varargsElement;

        public NewClass(Tree encl, List<Tree> typeargs, Tree clazz, List<Tree> args, ClassDef def) {
            super(28);
            this.encl = encl;
            this.typeargs = typeargs;
            this.clazz = clazz;
            this.args = args;
            this.def = def;
        }

        @Override
        public void accept(Visitor v) {
            v.visitNewClass(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Apply
    extends Tree {
        public List<Tree> typeargs;
        public Tree meth;
        public List<Tree> args;
        public Type varargsElement;

        public Apply(List<Tree> typeargs, Tree meth, List<Tree> args) {
            super(27);
            this.typeargs = typeargs;
            this.meth = meth;
            this.args = args;
        }

        @Override
        public void accept(Visitor v) {
            v.visitApply(this);
        }
    }

    public static class Assert
    extends Tree {
        public Tree cond;
        public Tree detail;

        public Assert(Tree cond, Tree detail) {
            super(26);
            this.cond = cond;
            this.detail = detail;
        }

        public void accept(Visitor v) {
            v.visitAssert(this);
        }
    }

    public static class Throw
    extends Tree {
        public Tree expr;

        public Throw(Tree expr) {
            super(25);
            this.expr = expr;
        }

        public void accept(Visitor v) {
            v.visitThrow(this);
        }
    }

    public static class Return
    extends Tree {
        public Tree expr;

        public Return(Tree expr) {
            super(24);
            this.expr = expr;
        }

        public void accept(Visitor v) {
            v.visitReturn(this);
        }
    }

    public static class Continue
    extends Tree {
        public Name label;
        public Tree target;

        public Continue(Name label, Tree target) {
            super(23);
            this.label = label;
            this.target = target;
        }

        public void accept(Visitor v) {
            v.visitContinue(this);
        }
    }

    public static class Break
    extends Tree {
        public Name label;
        public Tree target;

        public Break(Name label, Tree target) {
            super(22);
            this.label = label;
            this.target = target;
        }

        public void accept(Visitor v) {
            v.visitBreak(this);
        }
    }

    public static class Exec
    extends Tree {
        public Tree expr;

        public Exec(Tree expr) {
            super(21);
            this.expr = expr;
        }

        public void accept(Visitor v) {
            v.visitExec(this);
        }
    }

    public static class If
    extends Tree {
        public Tree cond;
        public Tree thenpart;
        public Tree elsepart;

        public If(Tree cond, Tree thenpart, Tree elsepart) {
            super(20);
            this.cond = cond;
            this.thenpart = thenpart;
            this.elsepart = elsepart;
        }

        public void accept(Visitor v) {
            v.visitIf(this);
        }
    }

    public static class Conditional
    extends Tree {
        public Tree cond;
        public Tree truepart;
        public Tree falsepart;

        public Conditional(Tree cond, Tree truepart, Tree falsepart) {
            super(19);
            this.cond = cond;
            this.truepart = truepart;
            this.falsepart = falsepart;
        }

        public void accept(Visitor v) {
            v.visitConditional(this);
        }
    }

    public static class Catch
    extends Tree {
        public VarDef param;
        public Tree body;
        public static List<Catch> emptyList = new List();

        public Catch(VarDef param, Tree body) {
            super(18);
            this.param = param;
            this.body = body;
        }

        public void accept(Visitor v) {
            v.visitCatch(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Try
    extends Tree {
        public Tree body;
        public List<Catch> catchers;
        public Tree finalizer;

        public Try(Tree body, List<Catch> catchers, Tree finalizer) {
            super(17);
            this.body = body;
            this.catchers = catchers;
            this.finalizer = finalizer;
        }

        @Override
        public void accept(Visitor v) {
            v.visitTry(this);
        }
    }

    public static class Synchronized
    extends Tree {
        public Tree lock;
        public Tree body;

        public Synchronized(Tree lock, Tree body) {
            super(16);
            this.lock = lock;
            this.body = body;
        }

        public void accept(Visitor v) {
            v.visitSynchronized(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Case
    extends Tree {
        public Tree pat;
        public List<Tree> stats;

        public Case(Tree pat, List<Tree> stats) {
            super(15);
            this.pat = pat;
            this.stats = stats;
        }

        @Override
        public void accept(Visitor v) {
            v.visitCase(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Switch
    extends Tree {
        public Tree selector;
        public List<Case> cases;

        public Switch(Tree selector, List<Case> cases) {
            super(14);
            this.selector = selector;
            this.cases = cases;
        }

        @Override
        public void accept(Visitor v) {
            v.visitSwitch(this);
        }
    }

    public static class Labelled
    extends Tree {
        public Name label;
        public Tree body;

        public Labelled(Name label, Tree body) {
            super(13);
            this.label = label;
            this.body = body;
        }

        public void accept(Visitor v) {
            v.visitLabelled(this);
        }
    }

    public static class ForeachLoop
    extends Tree {
        public VarDef var;
        public Tree expr;
        public Tree body;

        public ForeachLoop(VarDef var, Tree expr, Tree body) {
            super(11);
            this.var = var;
            this.expr = expr;
            this.body = body;
        }

        public void accept(Visitor v) {
            v.visitForeachLoop(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoop
    extends Tree {
        public List<Tree> init;
        public Tree cond;
        public List<Tree> step;
        public Tree body;

        public ForLoop(List<Tree> init, Tree cond, List<Tree> step, Tree body) {
            super(11);
            this.init = init;
            this.cond = cond;
            this.step = step;
            this.body = body;
        }

        @Override
        public void accept(Visitor v) {
            v.visitForLoop(this);
        }
    }

    public static class WhileLoop
    extends Tree {
        public Tree cond;
        public Tree body;

        public WhileLoop(Tree cond, Tree body) {
            super(10);
            this.cond = cond;
            this.body = body;
        }

        public void accept(Visitor v) {
            v.visitWhileLoop(this);
        }
    }

    public static class DoLoop
    extends Tree {
        public Tree body;
        public Tree cond;

        public DoLoop(Tree body, Tree cond) {
            super(9);
            this.body = body;
            this.cond = cond;
        }

        public void accept(Visitor v) {
            v.visitDoLoop(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Block
    extends Tree {
        public long flags;
        public List<Tree> stats;
        public int endpos = 0;

        public Block(long flags, List<Tree> stats) {
            super(8);
            this.stats = stats;
            this.flags = flags;
        }

        @Override
        public void accept(Visitor v) {
            v.visitBlock(this);
        }
    }

    public static class Skip
    extends Tree {
        public Skip() {
            super(7);
        }

        public void accept(Visitor v) {
            v.visitSkip(this);
        }
    }

    public static class VarDef
    extends Tree {
        public Modifiers mods;
        public Name name;
        public Tree vartype;
        public Tree init;
        public Symbol.VarSymbol sym;
        public static final List<VarDef> emptyList = new List();

        public VarDef(Modifiers mods, Name name, Tree vartype, Tree init, Symbol.VarSymbol sym) {
            super(6);
            this.mods = mods;
            this.name = name;
            this.vartype = vartype;
            this.init = init;
            this.sym = sym;
        }

        public void accept(Visitor v) {
            v.visitVarDef(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodDef
    extends Tree {
        public Modifiers mods;
        public Name name;
        public Tree restype;
        public List<TypeParameter> typarams;
        public List<VarDef> params;
        public List<Tree> thrown;
        public Block body;
        public Tree defaultValue;
        public Symbol.MethodSymbol sym;

        public MethodDef(Modifiers mods, Name name, Tree restype, List<TypeParameter> typarams, List<VarDef> params, List<Tree> thrown, Block body, Tree defaultValue, Symbol.MethodSymbol sym) {
            super(5);
            this.mods = mods;
            this.name = name;
            this.restype = restype;
            this.typarams = typarams;
            this.params = params;
            this.thrown = thrown;
            this.body = body;
            this.defaultValue = defaultValue;
            this.sym = sym;
        }

        @Override
        public void accept(Visitor v) {
            v.visitMethodDef(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDef
    extends Tree {
        public Modifiers mods;
        public Name name;
        public List<TypeParameter> typarams;
        public Tree extending;
        public List<Tree> implementing;
        public List<Tree> defs;
        public Symbol.ClassSymbol sym;

        public ClassDef(Modifiers mods, Name name, List<TypeParameter> typarams, Tree extending, List<Tree> implementing, List<Tree> defs, Symbol.ClassSymbol sym) {
            super(4);
            this.mods = mods;
            this.name = name;
            this.typarams = typarams;
            this.extending = extending;
            this.implementing = implementing;
            this.defs = defs;
            this.sym = sym;
        }

        @Override
        public void accept(Visitor v) {
            v.visitClassDef(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Alias
    extends Tree {
        public Ident alias;
        public List<TypeParameter> typarams;
        public Tree qualid;

        public Alias(Ident alias, List<TypeParameter> typarams, Tree qualid) {
            super(4);
            this.alias = alias;
            this.typarams = typarams;
            this.qualid = qualid;
        }

        @Override
        public void accept(Visitor v) {
            v.visitAlias(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Bind
    extends Tree {
        public Tree typ;
        public boolean isModule;
        public Ident alias;
        public List<TypeParameter> typarams;
        public Tree qualid;

        public Bind(Tree typ, Ident alias, List<TypeParameter> typarams, Tree qualid) {
            super(5);
            this.typ = typ;
            this.alias = alias;
            this.typarams = typarams;
            this.qualid = qualid;
        }

        @Override
        public void accept(Visitor v) {
            v.visitBind(this);
        }
    }

    public static class Import
    extends Tree {
        public boolean staticImport;
        public Tree qualid;

        public Import(Tree qualid, boolean importStatic) {
            super(3);
            this.qualid = qualid;
            this.staticImport = importStatic;
        }

        public void accept(Visitor v) {
            v.visitImport(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Module
    extends Tree {
        public Tree id;
        public List<TypeParameter> typarams;
        public List<Tree> implementing;
        public boolean isSignature;

        public Module(Tree id, List<TypeParameter> typarams, List<Tree> implementing, boolean isSignature) {
            super(2);
            this.id = id;
            this.typarams = typarams;
            this.implementing = implementing;
            this.isSignature = isSignature;
        }

        @Override
        public void accept(Visitor v) {
            v.visitModule(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopLevel
    extends Tree {
        public Module module;
        public List<Annotation> packageAnnotations;
        public Tree pid;
        public List<Tree> defs;
        public Name sourcefile;
        public Symbol.PackageSymbol packge;
        public Scope namedImportScope;
        public Scope starImportScope;
        public List<Symbol.AliasSymbol> binds;
        public long flags;
        public Map<Tree, String> docComments = null;
        public Map<Tree, Integer> endPositions = null;

        public TopLevel(Module m, List<Annotation> packageAnnotations, Tree pid, List<Tree> defs, Name sourcefile, Symbol.PackageSymbol packge, Scope namedImportScope, Scope starImportScope) {
            super(1);
            this.module = m;
            this.packageAnnotations = packageAnnotations;
            this.pid = pid;
            this.defs = defs;
            this.sourcefile = sourcefile;
            this.packge = packge;
            this.namedImportScope = namedImportScope;
            this.starImportScope = starImportScope;
            this.binds = new List();
        }

        @Override
        public void accept(Visitor v) {
            v.visitTopLevel(this);
        }
    }
}

