/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen2.compiler.util;

import edu.rice.cs.nextgen2.compiler.util.List;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBuffer<A>
implements Collection<A> {
    public List<A> elems = new List();
    public List<A> last = this.elems;
    public int count = 0;
    public boolean shared = false;

    public int length() {
        return this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count != 0;
    }

    private void copy() {
        List tail;
        this.elems = new List(this.elems.head, this.elems.tail);
        List p = this.elems;
        while ((tail = p.tail) != null) {
            p.tail = new List(tail.head, tail.tail);
            p = p.tail;
        }
        this.last = p;
        this.shared = false;
    }

    public ListBuffer<A> prepend(A x) {
        this.elems = this.elems.prepend(x);
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(A x) {
        if (this.shared) {
            this.copy();
        }
        this.last.head = x;
        this.last.tail = new List();
        this.last = this.last.tail;
        ++this.count;
        return this;
    }

    public ListBuffer<A> appendList(List<A> xs) {
        while (xs.nonEmpty()) {
            this.append(xs.head);
            xs = xs.tail;
        }
        return this;
    }

    public ListBuffer<A> appendArray(A[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            this.append(xs[i]);
        }
        return this;
    }

    public List<A> toList() {
        this.shared = true;
        return this.elems;
    }

    @Override
    public boolean contains(Object x) {
        return this.elems.contains(x);
    }

    @Override
    public <T> T[] toArray(T[] vec) {
        return this.elems.toArray(vec);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public A first() {
        return this.elems.head;
    }

    public void remove() {
        if (this.elems != this.last) {
            this.elems = this.elems.tail;
            --this.count;
        }
    }

    public A next() {
        Object x = this.elems.head;
        this.remove();
        return x;
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            List<A> elems;
            {
                this.elems = ListBuffer.this.elems;
            }

            @Override
            public boolean hasNext() {
                return this.elems != ListBuffer.this.last;
            }

            @Override
            public A next() {
                Object elem = this.elems.head;
                this.elems = this.elems.tail;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

