#include <us.h>

#define LogP     6
#define PARITIES 2

typedef enum {False,True} boolean;

typedef struct {
	boolean answers[PARITIES][LogP];
	boolean *intended[PARITIES][LogP];
} localnode;

localnode **shared_barrier_array; 
short vpid;

int log_nodes;
localnode *mynode;
boolean **myfirst_intended[PARITIES];
boolean *myfirst_answer[PARITIES];
boolean *mylast_answer[PARITIES];
boolean parity, sense;

void dissemination_barrier_init_internal(); /* forward declaration */
int *count;

dissemination_barrier_init(nodes)
int nodes;
{
	int i;

	count = (int*) UsAlloc(sizeof(int));
	*count = 0;
	ShareBlk(&count,sizeof(nodes));

	shared_barrier_array = (localnode **) malloc(nodes * sizeof(localnode));

	for(i=0;i<nodes;i++) {
		shared_barrier_array[i] = 
			(localnode *) UsAllocOnUsProc(i,sizeof(localnode));
	}


	SharePtrAndBlk(&shared_barrier_array, 
		nodes * sizeof(shared_barrier_array));
	GenTaskForEachProc(dissemination_barrier_init_internal,nodes);

	while (*count < nodes);
}

void dissemination_barrier_init_internal(nodes)
{
	short power,instance,k;
	vpid = UsProc_Node;

	for(log_nodes=0,power=1;power < nodes; power<<=1,log_nodes++);
	mynode = shared_barrier_array[vpid];
	for(k=0;k<PARITIES;k++) {
		myfirst_intended[k] = &mynode->intended[k][0]; 
		myfirst_answer[k] = &mynode->answers[k][0];
		mylast_answer[k] =  &mynode->answers[k][log_nodes-1];
	}
    power = 1;
    for(instance = 0; instance <= log_nodes -1; instance++) {
		for(k=0;k<PARITIES;k++) {
			mynode->intended[k][instance] = 
				&(shared_barrier_array[(power + vpid) % nodes]->answers[k][instance]);
			mynode->answers[k][instance] = False;
		}
        power = power * 2;
    }
	parity = False;
	sense = True;
	atomadd32(count,1);
}

void dissemination_barrier()
{
	register boolean **intended = myfirst_intended[parity];
	register boolean *answer = myfirst_answer[parity];
	register boolean *answer_last = mylast_answer[parity];
	do {
		**intended++ =  sense;
		while (*answer != sense);
	} while (++answer <= answer_last);
	sense ^= parity;
	parity ^= True;
}
