#include "fair_queue.h"

#define NONE 0
#define READER 1
#define WRITER 2

#define BLOCKED 1
#define UNBLOCKED 0
#define SBLOCKED  (BLOCKED << 16)

#define state ustate.whole
#define blocked ustate.parts.ublocked
#define successor_class ustate.parts.usuccessor_class

FQ_lock_init(L)
FQlock *L;
{
	L->next_writer = nil;
	L->tail = nil;
	L->reader_count = 0;
}

char *
FQ_printname()
{
	return "FQ";
}

void 
FQ_start_write(L, I)
FQlock *L;
FQqnode *I;
{
	FQqnode *pred;
	I->class = writing;
	I->next = nil;
	I->state = (BLOCKED << 16) | NONE;
	pred = (FQqnode *) xmemul(&L->tail, I);
	if (pred == nil) {
		L->next_writer = I;
		if ((L->reader_count == 0) && 
				(((FQqnode *) xmemul(&L->next_writer, nil)) == I)) {
			I->blocked = UNBLOCKED;
		}
	} else {
		pred->successor_class = WRITER;
		pred->next = I;
	}
	while (I->blocked != UNBLOCKED);
}

void
FQ_start_read(L, I)
FQlock *L;
FQqnode *I;
{
	FQqnode *pred;
	I->class = reading;
	I->next = nil;
	I->state = (BLOCKED << 16) | NONE;
	pred = (FQqnode *) xmemul(&L->tail, I);
	if (pred == nil) {
		atomadd32(&L->reader_count, 1);
		I->blocked = UNBLOCKED;
	} else {
		if (pred->class == writing) {
			pred->successor_class = READER;
			pred->next = I;
			while (I->blocked != False);
		} else {
			if (atomcas32(&pred->state, SBLOCKED | NONE, SBLOCKED | READER) ==
					(SBLOCKED | NONE)) {
				pred->next = I;
				while (I->blocked != False);
			} else {
					atomadd32(&L->reader_count, 1);
					pred->next = I;
					I->blocked = False;
			}
		}
	} 
	if (I->successor_class == READER) {
		while (I->next == nil);
		atomadd32(&L->reader_count, 1);
		I->next->blocked = UNBLOCKED;
	}
}

void
FQ_end_write(L, I)
FQlock *L;
FQqnode *I;
{
	if (I->next == nil) {
		if (((FQqnode *) atomcas32(&L->tail, I, nil)) == I) return;
	}
	while (I->next == nil);
	if (I->successor_class == READER) atomadd32(&L->reader_count, 1);
	I->next->blocked = UNBLOCKED;
}

void
FQ_end_read(L, I)
FQlock *L;
FQqnode *I;
{
	if ((I->next != nil) || 
			(((FQqnode *) atomcas32(&L->tail, I, nil)) != I)) {
		while (I->next == nil);
		if (I->successor_class == WRITER) {
			L->next_writer = I->next;
		}
	}
	if (atomadd32(&L->reader_count, -1) == 1) { /* I'm last */
		FQqnode *w = (FQqnode *) xmemul(&L->next_writer, nil);
		if (w != nil) w->blocked = UNBLOCKED;
	}
}
