#include "fair_tas.h"

#define RDRCOUNT_INCR   0x10000 /* used to increment the reader count */
#define WTRCOUNT_INCR   0x1     /* used to increment the writer count */
#define WTR_TOPMASK   0x8000    /* mask to clear top bit of writer count */
#define RDR_TOPMASK   0x8000000 /* mask to clear top bit of reader count */

FT_lock_init(L)
FTlock *L;
{
	L->requests = RDRCOUNT_INCR + WTRCOUNT_INCR;
	L->completions = RDRCOUNT_INCR + WTRCOUNT_INCR;
}

char *
FT_printname()
{
	return "FT";
}

FT_start_read (L)
FTlock *L;
{
	unsigned long prev_writers = 
		atomcta32(&L->requests, RDR_TOPMASK, RDRCOUNT_INCR) & 0xffff;
    while ((L->completions & 0xffff) !=  prev_writers);
}

FT_end_read(L)
FTlock *L;
{
	atomcta32(&L->completions, RDR_TOPMASK, RDRCOUNT_INCR);
}

FT_start_write(L)
FTlock *L;
{
	unsigned long prev_processes = 
		atomcta32(&L->requests, WTR_TOPMASK, WTRCOUNT_INCR);
    while (L->completions !=  prev_processes);
}

FT_end_write(L)
FTlock *L;
{
	atomcta32(&L->completions, WTR_TOPMASK, WTRCOUNT_INCR);
}
