#include <us.h>

#include "read_pref_tas.h"
#include "fair_tas.h"

#include "read_pref_queue.h"
#include "write_pref_queue.h"
#include "fair_queue.h"

LTYPE/**/lock *LOCK;

int iterations = 1;
int nodes;
long *times;

usage()
{
	printf("usage: main [-i iterations]\n");
	exit(1);
}

void synchtest(); /* forward declaration */

main(argc,argv)
int argc;
char **argv;
{
	int i;

	while (--argc > 0) {
		switch((*++argv)[1]) {
		case 'i':
			if (--argc < 0) usage();
			iterations = atoi(*++argv);
			break;
		default:
			usage();
		}
	}

	InitializeUs();

	nodes = TotalProcsAvailable();
	if (nodes < 2) {
		printf("Must have at least 2 nodes to run latency test\n");
		exit(1);
	}
	ShareBlk(&nodes,sizeof(nodes));

	if (nodes > 1) dissemination_barrier_init(nodes);

#ifdef REMOTE
	LOCK = (LTYPE/**/lock*) UsAllocOnUsProc(nodes-1,sizeof(LTYPE/**/lock));
#else
	LOCK = (LTYPE/**/lock*) UsAlloc(sizeof(LTYPE/**/lock));
#endif
	LTYPE/**/_lock_init(LOCK);
	ShareBlk(&LOCK,sizeof(LTYPE/**/lock*));

	times = (long*) UsAlloc(nodes * sizeof(long));
	ShareBlk(&times,sizeof(long*));

	GenTaskForEachProc(synchtest,0);
	return 0;
}

extern char *LTYPE/**/_printname(); 

void readlatency()
{
	long start,end,time;
	int i,j;
#if QUEUE
	LTYPE/**/qnode *mylink = 
		(LTYPE/**/qnode *) UsAllocLocal(sizeof(LTYPE/**/qnode));
#endif

	if (nodes > 1) dissemination_barrier();

	if (UsProc_Node < 1) {
			start = getusecclock();
			for(i=iterations;i>0;i--) {
#if QUEUE
				LTYPE/**/_start_read(LOCK,mylink);
#else
				LTYPE/**/_start_read(LOCK);
#endif
#ifdef DEBUG
				printf("reader %d has lock\n",UsProc_Node);
				sleep(1);
				printf("reader %d releasing lock\n",UsProc_Node);
#endif
#if QUEUE
				LTYPE/**/_end_read(LOCK,mylink);
#else
				LTYPE/**/_end_read(LOCK);
#endif
			}
			end = getusecclock();
			time = end - start;
	}
	if (nodes > 1) dissemination_barrier();

	if (UsProc_Node == 0) {
		printf("%s read lock latency: %d iterations, %d usec elapsed\n",
			LTYPE/**/_printname(), iterations,  time);
	}
}

void writelatency()
{
	long start,end,time;
	int i,j;
#if QUEUE
	LTYPE/**/qnode *mylink = 
		(LTYPE/**/qnode *) UsAllocLocal(sizeof(LTYPE/**/qnode));
#endif

	if (nodes > 1) dissemination_barrier();

	if (UsProc_Node < 1) {
			start = getusecclock();
			for(i=iterations;i>0;i--) {
#if QUEUE
				LTYPE/**/_start_write(LOCK,mylink);
#else
				LTYPE/**/_start_write(LOCK);
#endif
#ifdef DEBUG
				printf("writer %d has lock\n",UsProc_Node);
				sleep(1);
				printf("writer %d releasing lock\n",UsProc_Node);
#endif
#if QUEUE
				LTYPE/**/_end_write(LOCK,mylink);
#else
				LTYPE/**/_end_write(LOCK);
#endif
			}
			end = getusecclock();
			time = end - start;
	}
	if (nodes > 1) dissemination_barrier();

	if (UsProc_Node == 0) {
		printf("%s write lock latency: %d iterations, %d usec elapsed\n",
			LTYPE/**/_printname(), iterations,  time);
	}
}

void synchtest()
{
	readlatency();	
	writelatency();	
}
