#include "types.h"

typedef struct qnode_s {
    struct qnode_s *next;
    Boolean blocked;
    Boolean queued;
} RPQqnode;

/* type definition for reader preference queue-based reader/writer (RPQ) lock */

typedef struct {
    RPQqnode *reader_head;  /* head of LIFO queue of readers */
    RPQqnode *writer_tail;  /* tail of FIFO queue of writers */
    RPQqnode *writer_head;  /* head of FIFO queue of writers */
    unsigned long rdr_cnt_and_flags; 
	/* layout of rdr_cnt_and_flags:
	 *  31      ...             2           1               0
	 * +-------------------------+----------------+--------------------+
	 * | interested reader count | active writer? | interested writer? |
	 * +-------------------------+----------------+--------------------+
	 */
} RPQlock;


