#include "read_pref_tas.h"

#define WAFLAG 1        /* writer active flag */
#define RDRCOUNT_INCR 2 /* constant used to adjust the reader count */

RPT_lock_init(L)
RPTlock *L;
{
	*L = 0;
}

char *
RPT_printname()
{
	return "RPT";
}

RPT_start_read (L)
RPTlock *L;
{
    atomaddu32(L, RDRCOUNT_INCR);
    while (*L & WAFLAG);
}

RPT_end_read(L)
RPTlock *L;
{
    atomaddu32(L, -RDRCOUNT_INCR);
}

RPT_start_write(L)
RPTlock *L;
{
    while (atomcas32(L, 0, WAFLAG) != 0);
}

RPT_end_write(L)
RPTlock *L;
{
    atomaddu32(L, -WAFLAG);
}
