#include <us.h>

#include "read_pref_tas.h"
#include "fair_tas.h"

#include "read_pref_queue.h"
#include "write_pref_queue.h"
#include "fair_queue.h"

LTYPE/**/lock *LOCK;

int iterations = 1;
int nodes;
long *times;

usage()
{
	printf("usage: main [-i iterations]\n");
	exit(1);
}

void synchtest(); /* forward declaration */

main(argc,argv)
int argc;
char **argv;
{
	int i;

	while (--argc > 0) {
		switch((*++argv)[1]) {
		case 'i':
			if (--argc < 0) usage();
			iterations = atoi(*++argv);
			break;
		default:
			usage();
		}
	}

	InitializeUs();

	nodes = TotalProcsAvailable();
	ShareBlk(&nodes,sizeof(nodes));

	if (nodes > 1) dissemination_barrier_init(nodes);

#ifdef REMOTE
	LOCK = (LTYPE/**/lock*) UsAllocOnUsProc(nodes-1,sizeof(LTYPE/**/lock));
#else
	LOCK = (LTYPE/**/lock*) UsAlloc(sizeof(LTYPE/**/lock));
#endif
	LTYPE/**/_lock_init(LOCK);
	ShareBlk(&LOCK,sizeof(LTYPE/**/lock*));

	times = (long*) UsAlloc(nodes * sizeof(long));
	ShareBlk(&times,sizeof(long*));

	GenTaskForEachProc(synchtest,0);
	return 0;
}

#define RAND_WRITE 1
#define RAND_READ 0

void synchtest()
{
	long start,end,maxtime;
	int i,j;
#ifdef QUEUE
	LTYPE/**/qnode *mylink = (LTYPE/**/qnode *) 
		UsAllocLocal(sizeof(LTYPE/**/qnode));
#endif
	short *locktype = (short *) UsAllocLocal(sizeof(short) * iterations);

	for (j = 1; j < nodes; j++) {
		int iter = iterations / j;
		for(i=0; i<iter; i++) {
			/* assign a random sequence of reads and writes.
						   probability of read is 3 x probability of write 
						*/
			locktype[i] = ((random() & 0x3) == 3) ? RAND_WRITE : RAND_READ;
		}

		if (nodes > 1) dissemination_barrier();

		if (UsProc_Node < j) {
			start = getusecclock();
			for(i=iter;i>0;i--) {
				if (locktype[i] == RAND_READ) {
#ifdef QUEUE
					LTYPE/**/_start_read(LOCK,mylink);
#else
					LTYPE/**/_start_read(LOCK);
#endif
#ifdef DEBUG
					printf("reader %d has lock\n",UsProc_Node);
					sleep(1);
					printf("reader %d releasing lock\n",UsProc_Node);
#endif
#ifdef QUEUE
					LTYPE/**/_end_read(LOCK,mylink);
#else
					LTYPE/**/_end_read(LOCK);
#endif
				} 
				else {
#ifdef QUEUE
					LTYPE/**/_start_write(LOCK,mylink);
#else
					LTYPE/**/_start_write(LOCK);
#endif
#ifdef DEBUG
					printf("writer %d has lock\n",UsProc_Node);
					sleep(1);
					printf("writer %d releasing lock\n",UsProc_Node);
#endif
#ifdef QUEUE
					LTYPE/**/_end_write(LOCK,mylink);
#else
					LTYPE/**/_end_write(LOCK);
#endif
				}
			}
			end = getusecclock();
			times[UsProc_Node] = end - start;
		}
		if (nodes > 1) dissemination_barrier();

		for(maxtime = times[0],i=1;i<j;i++) 
			if(times[i] > maxtime) maxtime = times[i];

		if (UsProc_Node == 0) {
			printf("%s %d processors (read:write = 3:1) lock latency %d iterations \
(%d each), %d usec elapsed\n",
			LTYPE/**/_printname(), j, iterations, iter, maxtime);
		}
	}
}
