
#include "write_pref_queue.h"

#define nil 0

#define WFLAG1 0x1
#define WFLAG2 0x2
#define RFLAG 0x4 /* reader interested but not active */
#define RC_INCR    0x8 /* increment for reader count */


WPQ_lock_init(L)
WPQlock *L;
{
	L->reader_head = nil;
	L->writer_tail = nil;
	L->writer_head = nil;
	L->rdr_cnt_and_flags = 0;
}

char *
WPQ_printname()
{
	return "WPQ";
}

#if 0
void set_next_writer(L, W)
WPQlock *L;
WPQqnode *W;
{
	L->writer_head = W;
	if (! (atomior32(&L->rdr_cnt_and_flags, WFLAG1) & (WFLAG1 + RFLAG)) ) {
		/*  I flipped WFLAG1 and no reader is in the window */
		if (! (atomior32 (&L->rdr_cnt_and_flags, WFLAG2) >= RC_INCR) ) {
			/* no readers active */
			W->blocked = False;
		}
	}
}
#endif 

#define set_next_writer(L, W) \
{\
	L->writer_head = W;\
	if (! (atomior32(&L->rdr_cnt_and_flags, WFLAG1) & (WFLAG1 + RFLAG)) ) {\
		/*  I flipped WFLAG1 and no reader is in the window */\
		if (! (atomior32 (&L->rdr_cnt_and_flags, WFLAG2) >= RC_INCR) ) {\
			/* no readers active */\
			W->blocked = False;\
		}\
	}\
}


void
WPQ_start_write(L, I)
WPQlock *L;
WPQqnode *I;
{
	WPQqnode *pred;
	I->blocked = True;
	I->next = nil;
	pred = (WPQqnode *) xmemul(&L->writer_tail, I);
	if (pred == nil) {
		/* optimistic case -- reduces single processor latency */
		if (atomcas32(&L->rdr_cnt_and_flags, 0, WFLAG1 + WFLAG2) == 0) return;
		set_next_writer(L,I);
	}
	else pred->next = I;
	while (I->blocked != False);
}

#if 0
void
unblock_readers(L)
WPQlock *L;
{
	WPQqnode *head;
	/* clear reader interest flag, increment reader count */
	atomadd32(&L->rdr_cnt_and_flags, RC_INCR - RFLAG);
	/* indicate clear of window */
	if ((L->rdr_cnt_and_flags & WFLAG1) && (!(L->rdr_cnt_and_flags & WFLAG2))) {
		atomior32(&L->rdr_cnt_and_flags, WFLAG2);
	}
	head = (WPQqnode *) xmemul(&L->reader_head, nil);
	head->blocked = False;
}
#endif

#define unblock_readers(L) \
{\
	WPQqnode *head;\
	/* clear reader interest flag, increment reader count */\
	atomadd32(&L->rdr_cnt_and_flags, RC_INCR - RFLAG);\
	/* indicate clear of window */\
	if ((L->rdr_cnt_and_flags & WFLAG1) && \
			(!(L->rdr_cnt_and_flags & WFLAG2))) {\
		atomior32(&L->rdr_cnt_and_flags, WFLAG2);\
	}\
	head = (WPQqnode *) xmemul(&L->reader_head, nil);\
	head->blocked = False;\
}

void
WPQ_start_read(L, I)
WPQlock *L;
WPQqnode *I;
{
	/* optimistic case -- reduces single processor latency */
	if (atomcas32(&L->rdr_cnt_and_flags, 0, RC_INCR) == 0) return;

	I->blocked = True;
	I->next = (WPQqnode *) xmemul(&L->reader_head, I);
	if (I->next == nil) {
		/* first arriving reader in my group 
		   set reader interest flag, test writer flag */
		if (!(atomior32(&L->rdr_cnt_and_flags, RFLAG) & (WFLAG1 + WFLAG2))){
			/* no writer active or interested --> proceed */
			unblock_readers(L);
		}
	}
	while (I->blocked != False);
	if (I->next != nil) {
		atomadd32(&L->rdr_cnt_and_flags, RC_INCR);
		I->next->blocked = False;
	}
}


void
WPQ_end_read(L, I)
WPQlock *L;
WPQqnode *I;
{
	/* a new reader could be between setting RIFLAG and incrementing the
	   count. then a writer comes along and sets WIFLAG. now with both
	   flags set we can't tell where the reader is. whether we should
	   wake the writer or not.
    */
	if ( (atomadd32(&L->rdr_cnt_and_flags, -RC_INCR)  & ~RFLAG) ==  
			(RC_INCR + WFLAG1 + WFLAG2))
		L->writer_head->blocked = False;
}
	

void
WPQ_end_write(L, I)
WPQlock *L;
WPQqnode *I;
{
	if (I->next != nil) I->next->blocked = False;
	else {
		if ( atomand32(&L->rdr_cnt_and_flags, ~(WFLAG1 + WFLAG2)) & RFLAG) {
			unblock_readers(L);
		}
		if (((WPQqnode *) atomcas32(&L->writer_tail, I, nil)) == I) return;
		else {
			while (I->next == nil);
			set_next_writer(L,I->next);
		}
	}
}
