#include "types.h"

typedef struct wpq_qnode_t {
    struct wpq_qnode_t *next;
    Boolean blocked;
} WPQqnode;

/* type definition for writer preference queue-based reader/writer (WPQ) lock */

typedef struct {
    WPQqnode *reader_head;  /* head of LIFO queue of readers */
    WPQqnode *writer_tail;  /* tail of FIFO queue of writers */
    WPQqnode *writer_head;  /* head of FIFO queue of writers */
    unsigned long rdr_cnt_and_flags; 
	/* layout of rdr_cnt_and_flags:
	 *  31      ...             2           1                   0
	 * +-------------------------+--------------------+--------------------+
	 * | interested reader count | interested reader? | interested writer? |
	 * +-------------------------+--------------------+--------------------+
	 */
} WPQlock;


