% function BehavAnalysis_FaceMorphSim

NumSurveys = 3;
PercCorr = nan(12,4);
RTbyCond = nan(12,4);

for s=1:12
    sNum = s+1;
    survey = mod(sNum,NumSurveys);
    if ~survey, survey = NumSurveys; end
    load l0norm.mat
%     load EuclDist.mat
    eucldist = d(:,survey);
    
    FileName = ['FaceMorphSim_' num2str(sNum) '.txt'];
    [~,~,~,~,CorrResp,RT] = textread(FileName,'%d%d%d%d%d%f');
    if s == 8
        CorrResp = ~CorrResp;
    end
    MaxRT = median(RT)+(3*std(RT));
    UsableRT = (RT < MaxRT) & (RT > 0.3);
    
    TotalDs = unique(eucldist);
    NumConds = length(TotalDs);
    for c=1:NumConds
        ind = (eucldist == TotalDs(c));
        PercCorr(s,c) = sum(CorrResp(ind))/length(CorrResp(ind));
        RTbyCond(s,c) = median(RT(UsableRT & ind & CorrResp));
    end
end

AvgPercCorr = nanmean(PercCorr); AvgRTbyCond = nanmean(RTbyCond);
SemPercCorr = nanstd(PercCorr)./sqrt(length(PercCorr));
SemRTbyCond = nanstd(RTbyCond)./sqrt(length(RTbyCond));

figure; hold on;
errorbar(1:5,AvgPercCorr,SemPercCorr,'k.');
plot(1,AvgPercCorr(1),'bo','MarkerSize',10,'MarkerFaceColor','b');
plot(2:5,AvgPercCorr(2:5),'rs-','MarkerSize',10,'MarkerFaceColor','r');
h = gca; set(h,'XTick',1:5,'XTickLabel',TotalDs);
ylim([0 1]);
legend({'','Same','Different'},'Location','Best');

figure; hold on;
errorbar(1:5,AvgRTbyCond,SemRTbyCond,'k.');
plot(1,AvgRTbyCond(1),'bo','MarkerSize',10,'MarkerFaceColor','b');
plot(2:5,AvgRTbyCond(2:end),'rs-','MarkerSize',10,'MarkerFaceColor','r');
h = gca; set(h,'XTick',1:5,'XTickLabel',TotalDs);
ylim([0 2.5]);
legend({'','Same','Different'},'Location','Best');
