function FaceMorphSim(SubjectID)
% Screen('Preference', 'SkipSyncTests', 1)
% Similarity ratings for face morphs

% Set up directories
RootDir = '/Users/aparna/Documents/MATLAB';
ImageDir = 'Images/';
cd(RootDir);

% Get subject information
if ~nargin
    SubjectID = input('Enter subject number:   ');
end
DataFile = ['FaceMorphSim_' num2str(SubjectID) '.txt'];
fid = fopen([RootDir DataFile],'w');

% Set up screen
BackColor = 0;
TextColor = 255;
PresentScreen = max(Screen('Screens'));
ScreenRect = Screen('Rect',PresentScreen);
Window = Screen(PresentScreen,'OpenWindow',BackColor);
[centerX, centerY] = RectCenter(ScreenRect);

% Load the experiment design file
NumSurveys = 9;
SurveyID = mod(SubjectID,NumSurveys);
if ~SurveyID, SurveyID = NumSurveys; end
[LeftIndex,RightIndex] = textread(['surveys/survey_' num2str(SurveyID) '.txt'],'%d%d');
NumTrials = length(LeftIndex);

% Load images
cd(ImageDir);
d = dir('*.jpg');
NumPics = length(d); filenames = {};
[filenames{1:NumPics,1}] = deal(d.name);
for pic=1:NumPics
    Img = imread(filenames{pic});
    ImagePtr(pic) = Screen('MakeTexture',Window,Img);
end
[StimSizeX,StimSizeY,~] = size(Img);
SourceRect = [0 0 StimSizeY StimSizeX];
Offset = 20;
DestRect = CenterRectOnPointd(SourceRect,centerX,centerY);
LeftRect = OffsetRect(DestRect,-(StimSizeX/2)-Offset,0);
RightRect = OffsetRect(DestRect,(StimSizeX/2)+Offset,0);

% Set up keys
KeySet = {'f','j'};
if mod(SubjectID,2)
    Keys = KeySet;
else
    Keys = fliplr(KeySet);
end
SameKey = Keys(1); DiffKey = Keys(2);
KeyInstrux = ['Same = ' SameKey ', Different = ' DiffKey];

% Instructions

% Actual experiment
HideCursor;
for TheTrial=1:NumTrials
    % Self-initiate trials?
    
    % Get the left and right images from the design file
    LeftImgInd = LeftIndex(TheTrial); RightImgInd = RightIndex(TheTrial);
    LeftPtr = ImagePtr(LeftImgInd); RightPtr = ImagePtr(RightImgInd);
    SameTrial = isequal(LeftImgInd,RightImgInd);
    % Put images on the screen
    Screen('DrawTextures',Window,[LeftPtr;RightPtr],[],[LeftRect; RightRect]');
    Screen('Flip',Window);
    StimOnset = GetSecs;
    % Record key press response
    WaitForAnswer = 1;
    while WaitForAnswer
        [keyIsDown,secs,keyCode] = KbCheck;
        if keyIsDown
            Response = KbName(keyCode);
            Response = Response(1);
            RT = secs-StimOnset;
            [~,~,ResponseOut] = intersect(Response,Keys);
            if ~isempty(ResponseOut)
                WaitForAnswer = 0;
                Choice = ismember(Response,SameKey);
                Correct = Choice && SameTrial;
            end
        end
    end
    Screen('Flip',Window);
    WaitSecs(1);
    % Write output to data file
    fprintf(fid,'%d\t%d\t%d\t%f\n',[SameTrial,Choice,Correct,RT]);
end
% Close screen and wrap up
Screen('CloseAll');
fclose(fid);
cd(RootDir);
