function [ output_args ] = silhouettes(X)
%Run k-means for a range of k
for k=2:6
    IDX=kmeans(X,k);  %The data with two groups
    [S,H] = silhouette(X, IDX);
    silA(k)=mean(S); %The mean silhoette value for two groups
end
clf
hold on
plot(1:6, silA,'ok-','MarkerFaceColor','k') %2 groups
set(gca,'XTick',1:6)
xlabel('k')
ylabel('mean silhouette value')
hold off
end

