Zscore=[];
for s=1:12
    sNum = s+1;
    FileName = ['FaceMorphSim_' num2str(sNum) '.txt'];
    [im1,im2,~,~,~,RT] = textread(FileName,'%d%d%d%d%d%f');
    MaxRT = median(RT)+(3*std(RT));
    UsableRT = (RT < MaxRT) & (RT > 0.3);
    P=[im1,im2,RT];
    V = P(UsableRT==1,:);
    Zscore=[Zscore;V(:,1:2),zscore(V(:,3))];
end

Demean=[];
for s=1:12
    sNum = s+1;
    FileName = ['FaceMorphSim_' num2str(sNum) '.txt'];
    [im1,im2,~,~,~,RT] = textread(FileName,'%d%d%d%d%d%f');
    MaxRT = median(RT)+(3*std(RT));
    UsableRT = (RT < MaxRT) & (RT > 0.3);
    P=[im1,im2,RT];
    V = P(UsableRT==1,:);
    Demean=[Demean;V(:,1:2),V(:,3)-mean(V(:,3))];
end

Xavg=nan(35,35);
for i=1:35
    for j=1:35
            temp=0;
            count=0;
        for row=1:length(Zscore)
            if (Zscore(row,1)==i && Zscore(row,2)==j) || (Zscore(row,1)==j && Zscore(row,2)==i)
            temp = temp + Zscore(row,3);
            count = count +1;
            end
        end
        Xavg(i,j)=temp/count;
    end
end

Xmed=nan(35,35);
for i=1:35
    for j=1:35
        temp=[];
        for row=1:length(Zscore)
            if (Zscore(row,1)==i && Zscore(row,2)==j) || (Zscore(row,1)==j && Zscore(row,2)==i)
            temp = [temp;Zscore(row,3)];
            end
        end
        Xmed(i,j)=median(temp);
    end
end

X2avg=nan(35,35);
for i=1:35
    for j=1:35
            temp=0;
            count=0;
        for row=1:length(Demean)
            if (Demean(row,1)==i && Demean(row,2)==j) || (Demean(row,1)==j && Demean(row,2)==i)
            temp = temp + Demean(row,3);
            count = count +1;
            end
        end
        X2avg(i,j)=temp/count;
    end
end

X2med=nan(35,35);
for i=1:35
    for j=1:35
        temp=[];
        for row=1:length(Demean)
            if (Demean(row,1)==i && Demean(row,2)==j) || (Demean(row,1)==j && Demean(row,2)==i)
            temp = [temp;Demean(row,3)];
            end
        end
        X2med(i,j)=median(temp);
    end
end

